/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.util.MapToDictionary;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;

class ServiceRegistrationImpl
implements ServiceRegistration {
    private final ServiceRegistry m_registry;
    private final Bundle m_bundle;
    private final String[] m_classes;
    private final Long m_serviceId;
    private volatile Object m_svcObj;
    private volatile ServiceFactory m_factory;
    private volatile Map<String, Object> m_propMap = new StringMap();
    private final ServiceReferenceImpl m_ref;
    private volatile boolean m_isUnregistering = false;
    private final ThreadLocal<Boolean> m_threadLoopDetection = new ThreadLocal();
    private final Object syncObject = new Object();

    public ServiceRegistrationImpl(ServiceRegistry serviceRegistry, Bundle bundle, String[] stringArray, Long l, Object object, Dictionary dictionary) {
        this.m_registry = serviceRegistry;
        this.m_bundle = bundle;
        this.m_classes = stringArray;
        this.m_serviceId = l;
        this.m_svcObj = object;
        this.m_factory = this.m_svcObj instanceof ServiceFactory ? (ServiceFactory)this.m_svcObj : null;
        this.initializeProperties(dictionary);
        this.m_ref = new ServiceReferenceImpl();
    }

    protected boolean isValid() {
        return this.m_svcObj != null;
    }

    protected synchronized void invalidate() {
        this.m_svcObj = null;
    }

    public synchronized ServiceReference getReference() {
        if (!this.isValid()) {
            throw new IllegalStateException("The service registration is no longer valid.");
        }
        return this.m_ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary dictionary) {
        Map<String, Object> map;
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (!this.isValid()) {
                throw new IllegalStateException("The service registration is no longer valid.");
            }
            map = this.m_propMap;
            this.initializeProperties(dictionary);
        }
        this.m_registry.servicePropertiesModified(this, new MapToDictionary(map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (!this.isValid() || this.m_isUnregistering) {
                throw new IllegalStateException("Service already unregistered.");
            }
            this.m_isUnregistering = true;
        }
        this.m_registry.unregisterService(this.m_bundle, this);
        serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            this.m_svcObj = null;
            this.m_factory = null;
        }
    }

    private boolean isClassAccessible(Class clazz) {
        Class<?> clazz2;
        if (this.m_factory != null && Felix.m_secureAction.getClassLoader(this.m_factory.getClass()) instanceof BundleReference && !((BundleReference)((Object)Felix.m_secureAction.getClassLoader(this.m_factory.getClass()))).getBundle().equals(this.m_bundle)) {
            try {
                Class<?> clazz3 = this.m_bundle.loadClass(clazz.getName());
                if (clazz3 != null) {
                    return clazz3 == clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            return true;
        }
        Class<?> clazz4 = clazz2 = this.m_factory != null ? this.m_factory.getClass() : this.m_svcObj.getClass();
        return Util.loadClassUsingClass(clazz2, clazz.getName(), Felix.m_secureAction) == clazz;
    }

    Object getProperty(String string) {
        return this.m_propMap.get(string);
    }

    private String[] getPropertyKeys() {
        Set<String> set = this.m_propMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    private Bundle[] getUsingBundles() {
        return this.m_registry.getUsingBundles(this.m_ref);
    }

    Object getService() {
        return this.m_svcObj;
    }

    Object getService(Bundle bundle) {
        if (this.m_factory != null) {
            Object object = null;
            try {
                object = System.getSecurityManager() != null ? AccessController.doPrivileged(new ServiceFactoryPrivileged(bundle, null)) : this.getFactoryUnchecked(bundle);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof ServiceException) {
                    throw (ServiceException)privilegedActionException.getException();
                }
                throw new ServiceException("Service factory exception: " + privilegedActionException.getException().getMessage(), 3, privilegedActionException.getException());
            }
            return object;
        }
        return this.m_svcObj;
    }

    void ungetService(Bundle bundle, Object object) {
        if (this.m_factory != null) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new ServiceFactoryPrivileged(bundle, object));
                } else {
                    this.ungetFactoryUnchecked(bundle, object);
                }
            }
            catch (Exception exception) {
                this.m_registry.getLogger().log(this.m_bundle, 1, "ServiceRegistrationImpl: Error ungetting service.", (Throwable)exception);
            }
        }
    }

    private void initializeProperties(Dictionary<String, Object> dictionary) {
        StringMap stringMap = new StringMap();
        if (dictionary != null) {
            Enumeration<String> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (stringMap.get(string) == null) {
                    stringMap.put(string, dictionary.get(string));
                    continue;
                }
                throw new IllegalArgumentException("Duplicate service property: " + string);
            }
        }
        stringMap.put("objectClass", this.m_classes);
        stringMap.put("service.id", this.m_serviceId);
        stringMap.put("service.bundleid", this.m_bundle.getBundleId());
        if (this.m_factory != null) {
            stringMap.put("service.scope", this.m_factory instanceof PrototypeServiceFactory ? "prototype" : "bundle");
        } else {
            stringMap.put("service.scope", "singleton");
        }
        this.m_propMap = stringMap;
    }

    private Object getFactoryUnchecked(Bundle bundle) {
        Object object = null;
        try {
            object = this.m_factory.getService(bundle, this);
        }
        catch (Throwable throwable) {
            throw new ServiceException("Service factory exception: " + throwable.getMessage(), 3, throwable);
        }
        if (object != null) {
            int n = 0;
            while (n < this.m_classes.length) {
                Class clazz = Util.loadClassUsingClass(object.getClass(), this.m_classes[n], Felix.m_secureAction);
                if (clazz == null || !clazz.isAssignableFrom(object.getClass())) {
                    if (clazz == null) {
                        throw new ServiceException("Service cannot be cast due to missing class: " + this.m_classes[n], 2);
                    }
                    throw new ServiceException("Service cannot be cast: " + this.m_classes[n], 2);
                }
                ++n;
            }
        } else {
            throw new ServiceException("Service factory returned null. (" + this.m_factory + ")", 2);
        }
        return object;
    }

    private void ungetFactoryUnchecked(Bundle bundle, Object object) {
        this.m_factory.ungetService(bundle, this, object);
    }

    boolean currentThreadMarked() {
        return this.m_threadLoopDetection.get() != null;
    }

    void markCurrentThread() {
        this.m_threadLoopDetection.set(Boolean.TRUE);
    }

    void unmarkCurrentThread() {
        this.m_threadLoopDetection.set(null);
    }

    private class ServiceFactoryPrivileged
    implements PrivilegedExceptionAction {
        private Bundle m_bundle = null;
        private Object m_svcObj = null;

        public ServiceFactoryPrivileged(Bundle bundle, Object object) {
            this.m_bundle = bundle;
            this.m_svcObj = object;
        }

        public Object run() throws Exception {
            if (this.m_svcObj == null) {
                return ServiceRegistrationImpl.this.getFactoryUnchecked(this.m_bundle);
            }
            ServiceRegistrationImpl.this.ungetFactoryUnchecked(this.m_bundle, this.m_svcObj);
            return null;
        }
    }

    class ServiceReferenceImpl
    extends BundleCapabilityImpl
    implements ServiceReference {
        private final ServiceReferenceMap m_map;

        private ServiceReferenceImpl() {
            super(null, null, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
            this.m_map = new ServiceReferenceMap();
        }

        ServiceRegistrationImpl getRegistration() {
            return ServiceRegistrationImpl.this;
        }

        @Override
        public BundleRevision getRevision() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getNamespace() {
            return "service-reference";
        }

        @Override
        public Map<String, String> getDirectives() {
            return Collections.EMPTY_MAP;
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.m_map;
        }

        @Override
        public List<String> getUses() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Object getProperty(String string) {
            return ServiceRegistrationImpl.this.getProperty(string);
        }

        @Override
        public String[] getPropertyKeys() {
            return ServiceRegistrationImpl.this.getPropertyKeys();
        }

        @Override
        public Bundle getBundle() {
            return ServiceRegistrationImpl.this.isValid() ? ServiceRegistrationImpl.this.m_bundle : null;
        }

        @Override
        public Bundle[] getUsingBundles() {
            return ServiceRegistrationImpl.this.getUsingBundles();
        }

        @Override
        public String toString() {
            String[] stringArray = (String[])this.getProperty("objectClass");
            String string = "[";
            int n = 0;
            while (n < stringArray.length) {
                string = String.valueOf(string) + stringArray[n];
                if (n < stringArray.length - 1) {
                    string = String.valueOf(string) + ", ";
                }
                ++n;
            }
            string = String.valueOf(string) + "]";
            return string;
        }

        @Override
        public boolean isAssignableTo(Bundle bundle, String string) {
            if (bundle == ServiceRegistrationImpl.this.m_bundle) {
                return true;
            }
            boolean bl = true;
            String string2 = Util.getClassPackage(string);
            BundleRevision bundleRevision = bundle.adapt(BundleRevision.class);
            BundleWire bundleWire = Util.getWire(bundleRevision, string2);
            BundleCapability bundleCapability = Util.getPackageCapability(bundleRevision, string2);
            BundleRevision bundleRevision2 = ServiceRegistrationImpl.this.m_bundle.adapt(BundleRevision.class);
            BundleWire bundleWire2 = Util.getWire(bundleRevision2, string2);
            BundleCapability bundleCapability2 = Util.getPackageCapability(bundleRevision2, string2);
            if (bundleWire == null && bundleWire2 == null) {
                try {
                    Class clazz = ((BundleWiringImpl)bundleRevision.getWiring()).getClassByDelegation(string);
                    bl = this.getRegistration().isClassAccessible(clazz);
                }
                catch (Exception exception) {
                    bl = true;
                }
            } else if (bundleWire == null && bundleWire2 != null) {
                if (bundleCapability != null) {
                    bl = bundleWire2.getProviderWiring().getRevision().equals(bundleRevision);
                } else {
                    try {
                        Class clazz = ((BundleWiringImpl)bundleRevision.getWiring()).getClassByDelegation(string);
                        try {
                            bl = ((BundleWiringImpl)bundleRevision2.getWiring()).getClassByDelegation(string) == clazz;
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                }
            } else if (bundleWire != null && bundleWire2 == null) {
                if (bundleCapability2 != null) {
                    bl = bundleWire.getProviderWiring().getRevision().equals(bundleRevision2);
                } else {
                    try {
                        Class clazz = ((BundleWiringImpl)bundleRevision.getWiring()).getClassByDelegation(string);
                        bl = this.getRegistration().isClassAccessible(clazz);
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                }
            } else {
                bl = bundleWire2.getProviderWiring().getRevision().equals(bundleWire.getProviderWiring().getRevision());
            }
            return bl;
        }

        @Override
        public int compareTo(Object object) {
            Integer n;
            Long l;
            ServiceReference serviceReference = (ServiceReference)object;
            Long l2 = (Long)this.getProperty("service.id");
            if (l2.equals(l = (Long)serviceReference.getProperty("service.id"))) {
                return 0;
            }
            Object object2 = this.getProperty("service.ranking");
            Object object3 = serviceReference.getProperty("service.ranking");
            object2 = object2 == null ? new Integer(0) : object2;
            object3 = object3 == null ? new Integer(0) : object3;
            Integer n2 = object2 instanceof Integer ? (Integer)object2 : new Integer(0);
            Integer n3 = n = object3 instanceof Integer ? (Integer)object3 : new Integer(0);
            if (n2.compareTo(n) < 0) {
                return -1;
            }
            if (n2.compareTo(n) > 0) {
                return 1;
            }
            return l2.compareTo(l) < 0 ? 1 : -1;
        }
    }

    private class ServiceReferenceMap
    implements Map {
        private ServiceReferenceMap() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object get(Object object) {
            return ServiceRegistrationImpl.this.getProperty((String)object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<Object> keySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Collection<Object> values() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.EMPTY_SET;
        }
    }
}

