/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.StatefulResolver;
import org.apache.felix.framework.resolver.CandidateComparator;
import org.apache.felix.resolver.FelixResolveContext;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolveContext;

public class ResolveContextImpl
extends ResolveContext
implements FelixResolveContext {
    private final StatefulResolver m_state;
    private final Map<Resource, Wiring> m_wirings;
    private final StatefulResolver.ResolverHookRecord m_resolverHookrecord;
    private final Collection<BundleRevision> m_mandatory;
    private final Collection<BundleRevision> m_optional;
    private final Collection<BundleRevision> m_ondemand;

    ResolveContextImpl(StatefulResolver statefulResolver, Map<Resource, Wiring> map, StatefulResolver.ResolverHookRecord resolverHookRecord, Collection<BundleRevision> collection, Collection<BundleRevision> collection2, Collection<BundleRevision> collection3) {
        this.m_state = statefulResolver;
        this.m_wirings = map;
        this.m_resolverHookrecord = resolverHookRecord;
        this.m_mandatory = collection;
        this.m_optional = collection2;
        this.m_ondemand = collection3;
    }

    @Override
    public Collection<Resource> getMandatoryResources() {
        return new ArrayList<Resource>(this.m_mandatory);
    }

    @Override
    public Collection<Resource> getOptionalResources() {
        return new ArrayList<Resource>(this.m_optional);
    }

    @Override
    public Collection<Resource> getOndemandResources(Resource resource) {
        return new ArrayList<Resource>(this.m_ondemand);
    }

    @Override
    public List<Capability> findProviders(Requirement requirement) {
        List<Capability> list;
        if (!(requirement instanceof BundleRequirement)) {
            throw new IllegalStateException("Expected a BundleRequirement");
        }
        List<Capability> list2 = list = this.m_state.findProvidersInternal(this.m_resolverHookrecord, requirement, true, true);
        return list2;
    }

    @Override
    public int insertHostedCapability(List<Capability> list, HostedCapability hostedCapability) {
        int n = Collections.binarySearch(list, hostedCapability, new CandidateComparator());
        if (n < 0) {
            n = Math.abs(n + 1);
        }
        list.add(n, hostedCapability);
        return n;
    }

    @Override
    public boolean isEffective(Requirement requirement) {
        return this.m_state.isEffective(requirement);
    }

    @Override
    public Map<Resource, Wiring> getWirings() {
        return this.m_wirings;
    }
}

