/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.RequiredBundleImpl;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((ExportedPackage)object2).getVersion().compareTo(((ExportedPackage)object).getVersion());
        }
    };
    private Felix m_felix = null;

    PackageAdminImpl(Felix felix) {
        this.m_felix = felix;
    }

    @Override
    public Bundle getBundle(Class clazz) {
        return this.m_felix.getBundle(clazz);
    }

    @Override
    public Bundle[] getBundles(String string, String string2) {
        VersionRange versionRange = string2 == null ? null : VersionRange.parse(string2);
        Bundle[] bundleArray = this.m_felix.getBundles();
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        int n = 0;
        while (bundleArray != null && n < bundleArray.length) {
            String string3 = bundleArray[n].getSymbolicName();
            if (string3 != null && string3.equals(string)) {
                Version version = bundleArray[n].adapt(BundleRevision.class).getVersion();
                if (versionRange == null || versionRange.isInRange(version)) {
                    arrayList.add(bundleArray[n]);
                }
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        bundleArray = arrayList.toArray(new Bundle[arrayList.size()]);
        Arrays.sort(bundleArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Version version = ((Bundle)object).adapt(BundleRevision.class).getVersion();
                Version version2 = ((Bundle)object2).adapt(BundleRevision.class).getVersion();
                return version2.compareTo(version);
            }
        });
        return bundleArray;
    }

    @Override
    public int getBundleType(Bundle bundle) {
        Map map = bundle.adapt(BundleRevisionImpl.class).getHeaders();
        if (map.containsKey("Fragment-Host")) {
            return 1;
        }
        return 0;
    }

    @Override
    public ExportedPackage getExportedPackage(String string) {
        ExportedPackage[] exportedPackageArray = this.m_felix.getExportedPackages(string);
        if (exportedPackageArray == null || exportedPackageArray.length == 0) {
            return null;
        }
        Arrays.sort(exportedPackageArray, COMPARATOR);
        return exportedPackageArray[0];
    }

    @Override
    public ExportedPackage[] getExportedPackages(String string) {
        ExportedPackage[] exportedPackageArray = this.m_felix.getExportedPackages(string);
        return exportedPackageArray == null || exportedPackageArray.length == 0 ? null : exportedPackageArray;
    }

    @Override
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        ExportedPackage[] exportedPackageArray = this.m_felix.getExportedPackages(bundle);
        return exportedPackageArray == null || exportedPackageArray.length == 0 ? null : exportedPackageArray;
    }

    @Override
    public Bundle[] getFragments(Bundle bundle) {
        if ((this.getBundleType(bundle) & 1) == 0) {
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
            for (BundleRevision bundleRevision : bundle.adapt(BundleRevisions.class).getRevisions()) {
                if (bundleRevision.getWiring() == null) continue;
                List<BundleRevision> list = Util.getFragments(bundleRevision.getWiring());
                int n = 0;
                while (n < list.size()) {
                    Bundle bundle2 = list.get(n).getBundle();
                    if (bundle2 != null) {
                        arrayList.add(bundle2);
                    }
                    ++n;
                }
            }
            return arrayList.isEmpty() ? null : arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    @Override
    public Bundle[] getHosts(Bundle bundle) {
        if ((this.getBundleType(bundle) & 1) != 0) {
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
            for (BundleRevision bundleRevision : bundle.adapt(BundleRevisions.class).getRevisions()) {
                if (bundleRevision.getWiring() == null) continue;
                List<BundleWire> list = bundleRevision.getWiring().getRequiredWires(null);
                int n = 0;
                while (list != null && n < list.size()) {
                    Bundle bundle2 = list.get(n).getProviderWiring().getBundle();
                    if (bundle2 != null) {
                        arrayList.add(bundle2);
                    }
                    ++n;
                }
            }
            return arrayList.isEmpty() ? null : arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    @Override
    public RequiredBundle[] getRequiredBundles(String string) {
        ArrayList<RequiredBundleImpl> arrayList = new ArrayList<RequiredBundleImpl>();
        Bundle[] bundleArray = this.m_felix.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (string == null || string.equals(bundle.getSymbolicName())) {
                arrayList.add(new RequiredBundleImpl(this.m_felix, (BundleImpl)bundle));
            }
            ++n2;
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new RequiredBundle[arrayList.size()]);
    }

    @Override
    public void refreshPackages(Bundle[] bundleArray) throws SecurityException {
        List<Bundle> list = bundleArray == null ? null : Arrays.asList(bundleArray);
        this.m_felix.adapt(FrameworkWiring.class).refreshBundles(list, new FrameworkListener[0]);
    }

    @Override
    public boolean resolveBundles(Bundle[] bundleArray) {
        List<Bundle> list = bundleArray == null ? null : Arrays.asList(bundleArray);
        return this.m_felix.adapt(FrameworkWiring.class).resolveBundles(list);
    }
}

