/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.net.ContentHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.framework.ServiceRegistrationImpl;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.service.url.URLStreamHandlerService;

public class HookRegistry {
    private static final Map<String, Class<?>> HOOK_CLASSES = new HashMap();
    private final Map<String, SortedSet<ServiceReference<?>>> m_allHooks = new ConcurrentHashMap();
    private final WeakHashMap<ServiceReference<?>, ServiceReference<?>> m_blackList = new WeakHashMap();

    static {
        HookRegistry.addHookClass(CollisionHook.class);
        HookRegistry.addHookClass(org.osgi.framework.hooks.bundle.FindHook.class);
        HookRegistry.addHookClass(org.osgi.framework.hooks.bundle.EventHook.class);
        HookRegistry.addHookClass(EventHook.class);
        HookRegistry.addHookClass(EventListenerHook.class);
        HookRegistry.addHookClass(FindHook.class);
        HookRegistry.addHookClass(ListenerHook.class);
        HookRegistry.addHookClass(WeavingHook.class);
        HookRegistry.addHookClass(WovenClassListener.class);
        HookRegistry.addHookClass(ResolverHookFactory.class);
        HookRegistry.addHookClass(URLStreamHandlerService.class);
        HookRegistry.addHookClass(ContentHandler.class);
    }

    private static void addHookClass(Class<?> clazz) {
        HOOK_CLASSES.put(clazz.getName(), clazz);
    }

    static boolean isHook(String[] stringArray, Class<?> clazz, Object object) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.equals(clazz.getName())) {
                if (object instanceof ServiceFactory) {
                    return true;
                }
                if (clazz.isAssignableFrom(object.getClass())) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean isHook(String string, Object object) {
        Class<?> clazz = HOOK_CLASSES.get(string);
        if (clazz != null) {
            if (object instanceof ServiceFactory) {
                return true;
            }
            if (clazz.isAssignableFrom(object.getClass())) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHooks(String[] stringArray, Object object, ServiceReference<?> serviceReference) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (this.isHook(string, object)) {
                Map<String, SortedSet<ServiceReference<?>>> map = this.m_allHooks;
                synchronized (map) {
                    SortedSet<ServiceReference<?>> sortedSet = this.m_allHooks.get(string);
                    sortedSet = sortedSet == null ? new TreeSet(Collections.reverseOrder()) : new TreeSet(sortedSet);
                    sortedSet.add(serviceReference);
                    this.m_allHooks.put(string, sortedSet);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHooks(ServiceReference<?> serviceReference) {
        String[] stringArray;
        Object object = ((ServiceRegistrationImpl.ServiceReferenceImpl)serviceReference).getRegistration().getService();
        String[] stringArray2 = stringArray = (String[])serviceReference.getProperty("objectClass");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (this.isHook(string, object)) {
                Map<String, SortedSet<ServiceReference<?>>> map = this.m_allHooks;
                synchronized (map) {
                    SortedSet<ServiceReference<?>> sortedSet = this.m_allHooks.get(string);
                    if (sortedSet != null) {
                        TreeSet treeSet = new TreeSet(Collections.reverseOrder());
                        for (ServiceReference serviceReference2 : sortedSet) {
                            treeSet.add(serviceReference2);
                        }
                        this.m_allHooks.put(string, treeSet);
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHooks(ServiceReference<?> serviceReference) {
        Object object;
        String[] stringArray;
        Object object2 = ((ServiceRegistrationImpl.ServiceReferenceImpl)serviceReference).getRegistration().getService();
        String[] stringArray2 = stringArray = (String[])serviceReference.getProperty("objectClass");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            if (this.isHook((String)object, object2)) {
                Map<String, SortedSet<ServiceReference<?>>> map = this.m_allHooks;
                synchronized (map) {
                    SortedSet<ServiceReference<?>> sortedSet = this.m_allHooks.get(object);
                    if (sortedSet != null) {
                        sortedSet = new TreeSet(sortedSet);
                        sortedSet.remove(serviceReference);
                        this.m_allHooks.put((String)object, sortedSet);
                    }
                }
            }
            ++n2;
        }
        object = this.m_blackList;
        synchronized (object) {
            this.m_blackList.remove(serviceReference);
        }
    }

    public <S> Set<ServiceReference<S>> getHooks(Class<S> clazz) {
        Set set = this.m_allHooks.get(clazz.getName());
        if (set != null) {
            return set;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHookBlackListed(ServiceReference<?> serviceReference) {
        WeakHashMap<ServiceReference<?>, ServiceReference<?>> weakHashMap = this.m_blackList;
        synchronized (weakHashMap) {
            return this.m_blackList.containsKey(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blackListHook(ServiceReference<?> serviceReference) {
        WeakHashMap<ServiceReference<?>, ServiceReference<?>> weakHashMap = this.m_blackList;
        synchronized (weakHashMap) {
            this.m_blackList.put(serviceReference, serviceReference);
        }
    }
}

