/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.StartLevelImpl;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.startlevel.StartLevel;

class FrameworkStartLevelImpl
implements FrameworkStartLevel,
Runnable {
    static final String THREAD_NAME = "FelixStartLevel";
    private static final int BUNDLE_IDX = 0;
    private static final int STARTLEVEL_IDX = 1;
    private final Felix m_felix;
    private final ServiceRegistry m_registry;
    private final List m_requests = new ArrayList();
    private final List<FrameworkListener[]> m_requestListeners = new ArrayList<FrameworkListener[]>();
    private ServiceRegistration<StartLevel> m_slReg;
    private Thread m_thread = null;

    FrameworkStartLevelImpl(Felix felix, ServiceRegistry serviceRegistry) {
        this.m_felix = felix;
        this.m_registry = serviceRegistry;
    }

    void start() {
        this.m_slReg = this.m_registry.registerService(this.m_felix, new String[]{StartLevel.class.getName()}, new StartLevelImpl(this.m_felix), null);
    }

    private void startThread() {
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, THREAD_NAME);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        List list = this.m_requests;
        synchronized (list) {
            if (this.m_thread != null) {
                this.m_thread = null;
                this.m_requests.notifyAll();
            }
        }
    }

    @Override
    public Bundle getBundle() {
        return this.m_felix;
    }

    @Override
    public int getStartLevel() {
        return this.m_felix.getActiveStartLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStartLevel(int n, FrameworkListener ... frameworkListenerArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_felix, "startlevel"));
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Start level must be greater than zero.");
        }
        List list = this.m_requests;
        synchronized (list) {
            if (this.m_thread == null) {
                throw new IllegalStateException("No inital startlevel yet");
            }
            this.m_requestListeners.add(frameworkListenerArray);
            this.m_requests.add(new Integer(n));
            this.m_requests.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStartLevelAndWait(int n) {
        Integer n2;
        Integer n3 = n2 = new Integer(n);
        synchronized (n3) {
            List list = this.m_requests;
            synchronized (list) {
                this.startThread();
                this.m_requestListeners.add(null);
                this.m_requests.add(n2);
                this.m_requests.notifyAll();
            }
            try {
                n2.wait();
            }
            catch (InterruptedException interruptedException) {
                this.m_felix.getLogger().log(2, "Wait for start level change during shutdown interrupted.", interruptedException);
            }
        }
    }

    @Override
    public int getInitialBundleStartLevel() {
        return this.m_felix.getInitialBundleStartLevel();
    }

    @Override
    public void setInitialBundleStartLevel(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_felix, "startlevel"));
        }
        this.m_felix.setInitialBundleStartLevel(n);
    }

    BundleStartLevel createBundleStartLevel(BundleImpl bundleImpl) {
        return new BundleStartLevelImpl(bundleImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object = null;
        while (true) {
            Object object2 = null;
            FrameworkListener[] frameworkListenerArray = null;
            Object object3 = this.m_requests;
            synchronized (object3) {
                while (true) {
                    if (!this.m_requests.isEmpty()) {
                        object2 = this.m_requests.remove(0);
                        frameworkListenerArray = this.m_requestListeners.remove(0);
                        break;
                    }
                    if (this.m_thread == null) {
                        return;
                    }
                    try {
                        this.m_requests.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (object2 instanceof Integer) {
                try {
                    this.m_felix.setActiveStartLevel((Integer)object2, frameworkListenerArray);
                }
                catch (IllegalStateException illegalStateException) {
                    if (object == object2) {
                        this.m_felix.getLogger().log(1, "Unexpected problem setting active start level to " + object2, illegalStateException);
                    }
                    List list = this.m_requests;
                    synchronized (list) {
                        this.m_requests.add(0, object2);
                        object = object2;
                    }
                }
                catch (Exception exception) {
                    this.m_felix.getLogger().log(1, "Unexpected problem setting active start level to " + object2, exception);
                }
            } else {
                object3 = (Bundle)((Object[])object2)[0];
                int n = (Integer)((Object[])object2)[1];
                this.m_felix.setBundleStartLevel((Bundle)object3, n);
            }
            object3 = object2;
            synchronized (object3) {
                object2.notifyAll();
            }
        }
    }

    class BundleStartLevelImpl
    implements BundleStartLevel {
        private BundleImpl m_bundle;

        private BundleStartLevelImpl(BundleImpl bundleImpl) {
            this.m_bundle = bundleImpl;
        }

        @Override
        public Bundle getBundle() {
            return this.m_bundle;
        }

        @Override
        public int getStartLevel() {
            return FrameworkStartLevelImpl.this.m_felix.getBundleStartLevel(this.m_bundle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStartLevel(int n) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new AdminPermission(this.m_bundle, "execute"));
            }
            if (this.m_bundle.getBundleId() == 0L) {
                throw new IllegalArgumentException("Cannot change system bundle start level.");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("Start level must be greater than zero.");
            }
            List list = FrameworkStartLevelImpl.this.m_requests;
            synchronized (list) {
                FrameworkStartLevelImpl.this.startThread();
                this.m_bundle.setStartLevel(n);
                FrameworkStartLevelImpl.this.m_requestListeners.add(null);
                FrameworkStartLevelImpl.this.m_requests.add(new Object[]{this.m_bundle, new Integer(n)});
                FrameworkStartLevelImpl.this.m_requests.notifyAll();
            }
        }

        @Override
        public boolean isPersistentlyStarted() {
            return FrameworkStartLevelImpl.this.m_felix.isBundlePersistentlyStarted(this.m_bundle);
        }

        @Override
        public boolean isActivationPolicyUsed() {
            return FrameworkStartLevelImpl.this.m_felix.isBundleActivationPolicyUsed(this.m_bundle);
        }
    }
}

