/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.ServiceRegistrationImpl;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;

public class FilterImpl
implements Filter {
    private final SimpleFilter m_filter;

    public FilterImpl(String string) throws InvalidSyntaxException {
        try {
            this.m_filter = SimpleFilter.parse(string);
        }
        catch (Throwable throwable) {
            throw new InvalidSyntaxException(throwable.getMessage(), string);
        }
    }

    public boolean match(ServiceReference serviceReference) {
        if (serviceReference instanceof ServiceRegistrationImpl.ServiceReferenceImpl) {
            return CapabilitySet.matches((ServiceRegistrationImpl.ServiceReferenceImpl)serviceReference, this.m_filter);
        }
        return CapabilitySet.matches(new WrapperCapability(serviceReference), this.m_filter);
    }

    @Override
    public boolean match(Dictionary<String, ?> dictionary) {
        return CapabilitySet.matches(new WrapperCapability(dictionary, false), this.m_filter);
    }

    @Override
    public boolean matchCase(Dictionary<String, ?> dictionary) {
        return CapabilitySet.matches(new WrapperCapability(dictionary, true), this.m_filter);
    }

    @Override
    public boolean matches(Map<String, ?> map) {
        return CapabilitySet.matches(new WrapperCapability(map), this.m_filter);
    }

    @Override
    public boolean equals(Object object) {
        return this.toString().equals(object.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.m_filter.toString();
    }

    private static class DictionaryToMap
    implements Map {
        private final Map m_map;
        private final Dictionary m_dict;

        public DictionaryToMap(Dictionary dictionary, boolean bl) {
            if (!bl) {
                this.m_dict = null;
                this.m_map = new StringMap();
                if (dictionary != null) {
                    Enumeration enumeration = dictionary.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        if (this.m_map.get(k) == null) {
                            this.m_map.put(k, dictionary.get(k));
                            continue;
                        }
                        throw new IllegalArgumentException("Duplicate attribute: " + k.toString());
                    }
                }
            } else {
                this.m_dict = dictionary;
                this.m_map = null;
            }
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object get(Object object) {
            if (this.m_dict != null) {
                return this.m_dict.get(object);
            }
            if (this.m_map != null) {
                return this.m_map.get(object);
            }
            return null;
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<Object> keySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Collection<Object> values() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.EMPTY_SET;
        }
    }

    static class WrapperCapability
    extends BundleCapabilityImpl {
        private final Map m_map;

        public WrapperCapability(Map map) {
            super(null, null, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
            this.m_map = map == null ? Collections.EMPTY_MAP : map;
        }

        public WrapperCapability(Dictionary dictionary, boolean bl) {
            super(null, null, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
            this.m_map = new DictionaryToMap(dictionary, bl);
        }

        public WrapperCapability(ServiceReference serviceReference) {
            super(null, null, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
            this.m_map = new StringMap();
            String[] stringArray = serviceReference.getPropertyKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                this.m_map.put(string, serviceReference.getProperty(string));
                ++n2;
            }
        }

        @Override
        public BundleRevision getRevision() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getNamespace() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Map<String, String> getDirectives() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.m_map;
        }

        @Override
        public List<String> getUses() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

