/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.cert.Certificate;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.felix.framework.BundleContextImpl;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.BundleRevisionDependencies;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.felix.framework.EntryFilterEnumeration;
import org.apache.felix.framework.ExportedPackageImpl;
import org.apache.felix.framework.ExtensionManager;
import org.apache.felix.framework.FrameworkStartLevelImpl;
import org.apache.felix.framework.FrameworkWiringImpl;
import org.apache.felix.framework.HookRegistry;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.StatefulResolver;
import org.apache.felix.framework.URLHandlersActivator;
import org.apache.felix.framework.URLHandlersBundleStreamHandler;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.ext.SecurityProvider;
import org.apache.felix.framework.util.EventDispatcher;
import org.apache.felix.framework.util.ListenerInfo;
import org.apache.felix.framework.util.MapToDictionary;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.ShrinkableCollection;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.ThreadGate;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.NativeLibraryClause;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.resolver.ResolutionException;

public class Felix
extends BundleImpl
implements Framework {
    static final SecureAction m_secureAction = new SecureAction();
    private final ExtensionManager m_extensionManager;
    private final FrameworkWiringImpl m_fwkWiring;
    private final FrameworkStartLevelImpl m_fwkStartLevel;
    private final Logger m_logger;
    private final Map<String, Object> m_configMap;
    private final Map<String, Object> m_configMutableMap;
    private final StatefulResolver m_resolver;
    private final Object[] m_bundleLock = new Object[0];
    private final List<Thread> m_globalLockWaitersList = new ArrayList<Thread>();
    private Thread m_globalLockThread = null;
    private int m_globalLockCount = 0;
    private final Map<String, String> m_installRequestMap = new HashMap<String, String>();
    private final Object[] m_installRequestLock_Priority1 = new Object[0];
    private volatile Map[] m_installedBundles;
    private static final int LOCATION_MAP_IDX = 0;
    private static final int IDENTIFIER_MAP_IDX = 1;
    private volatile List<BundleImpl> m_uninstalledBundles;
    private final BundleRevisionDependencies m_dependencies = new BundleRevisionDependencies();
    private volatile int m_activeStartLevel = 0;
    private volatile int m_targetStartLevel = 0;
    private final SortedSet<StartLevelTuple> m_startLevelBundles = new TreeSet<StartLevelTuple>();
    private BundleCache m_cache = null;
    List m_activatorList = null;
    private long m_nextId = 1L;
    private final Object m_nextIdLock = new Object[0];
    private final ServiceRegistry m_registry;
    private final EventDispatcher m_dispatcher;
    private final URLStreamHandler m_bundleStreamHandler;
    private final String[] m_bootPkgs;
    private final boolean[] m_bootPkgWildcards;
    private volatile ThreadGate m_shutdownGate = null;
    private SecurityManager m_securityManager = null;
    private volatile boolean m_securityDefaultPolicy;
    private final Map<Class, Boolean> m_systemBundleClassCache = new WeakHashMap<Class, Boolean>();
    private volatile SecurityProvider m_securityProvider;
    private volatile URLHandlersActivator m_urlHandlersActivator;

    public Felix(Map map) {
        this.m_configMutableMap = new StringMap();
        if (map != null) {
            for (Map.Entry object2 : map.entrySet()) {
                this.m_configMutableMap.put(object2.getKey().toString(), object2.getValue());
            }
        }
        this.m_configMap = this.createUnmodifiableMap(this.m_configMutableMap);
        this.m_logger = this.m_configMutableMap.get("felix.log.logger") != null ? (Logger)this.m_configMutableMap.get("felix.log.logger") : new Logger();
        try {
            this.m_logger.setLogLevel(Integer.parseInt((String)this.m_configMutableMap.get("felix.log.level")));
        }
        catch (NumberFormatException numberFormatException) {}
        this.initializeFrameworkProperties();
        Object object3 = this.m_configMap == null ? null : (String)this.m_configMap.get("org.osgi.framework.bootdelegation");
        object3 = object3 == null ? "java.*" : String.valueOf(object3) + ",java.*";
        StringTokenizer stringTokenizer = new StringTokenizer((String)object3, " ,");
        this.m_bootPkgs = new String[stringTokenizer.countTokens()];
        this.m_bootPkgWildcards = new boolean[this.m_bootPkgs.length];
        int exception = 0;
        while (exception < this.m_bootPkgs.length) {
            object3 = stringTokenizer.nextToken();
            if (((String)object3).equals("*") || ((String)object3).endsWith(".*")) {
                this.m_bootPkgWildcards[exception] = true;
                object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
            }
            this.m_bootPkgs[exception] = object3;
            ++exception;
        }
        NativeLibraryClause.initializeNativeAliases(this.m_configMap);
        this.m_securityDefaultPolicy = "true".equals(this.getProperty("felix.security.defaultpolicy"));
        this.m_bundleStreamHandler = new URLHandlersBundleStreamHandler(this);
        this.m_registry = new ServiceRegistry(this.m_logger, new ServiceRegistry.ServiceRegistryCallbacks(){

            public void serviceChanged(ServiceEvent serviceEvent, Dictionary dictionary) {
                Felix.this.fireServiceEvent(serviceEvent, dictionary);
            }
        });
        this.m_resolver = new StatefulResolver(this, this.m_registry);
        this.m_extensionManager = new ExtensionManager(this.m_logger, this.m_configMap, this);
        try {
            this.addRevision(this.m_extensionManager.getRevision());
        }
        catch (Exception exception2) {
            throw new RuntimeException(exception2.getMessage());
        }
        this.m_dispatcher = new EventDispatcher(this.m_logger, this.m_registry);
        this.m_fwkWiring = new FrameworkWiringImpl(this, this.m_registry);
        this.m_fwkStartLevel = new FrameworkStartLevelImpl(this, this.m_registry);
    }

    Logger getLogger() {
        return this.m_logger;
    }

    Map getConfig() {
        return this.m_configMap;
    }

    StatefulResolver getResolver() {
        return this.m_resolver;
    }

    BundleRevisionDependencies getDependencies() {
        return this.m_dependencies;
    }

    URLStreamHandler getBundleStreamHandler() {
        return this.m_bundleStreamHandler;
    }

    String[] getBootPackages() {
        return this.m_bootPkgs;
    }

    boolean[] getBootPackageWildcards() {
        return this.m_bootPkgWildcards;
    }

    private Map createUnmodifiableMap(Map map) {
        Map map2 = Collections.unmodifiableMap(map);
        try {
            map2.keySet().iterator();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return map;
        }
        return map2;
    }

    @Override
    void close() {
    }

    @Override
    Felix getFramework() {
        return this;
    }

    @Override
    public <A> A adapt(Class<A> clazz) {
        this.checkAdapt(clazz);
        if (clazz == Framework.class || clazz == Felix.class) {
            return (A)this;
        }
        if (clazz == FrameworkWiring.class || clazz == FrameworkWiringImpl.class) {
            return (A)this.m_fwkWiring;
        }
        if (clazz == FrameworkStartLevel.class || clazz == FrameworkStartLevelImpl.class) {
            return (A)this.m_fwkStartLevel;
        }
        return super.adapt(clazz);
    }

    @Override
    public long getBundleId() {
        return 0L;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    void setLastModified(long l) {
    }

    @Override
    String _getLocation() {
        return "System Bundle";
    }

    @Override
    public int getPersistentState() {
        return 32;
    }

    @Override
    public void setPersistentStateInactive() {
    }

    @Override
    public void setPersistentStateActive() {
    }

    @Override
    public void setPersistentStateUninstalled() {
    }

    @Override
    int getStartLevel(int n) {
        return 0;
    }

    @Override
    void setStartLevel(int n) {
        throw new IllegalArgumentException("Cannot set the system bundle's start level.");
    }

    @Override
    public boolean hasPermission(Object object) {
        return true;
    }

    @Override
    public void init() throws BundleException {
        this.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void init(FrameworkListener ... var1_1) throws BundleException {
        block44: {
            this.acquireBundleLock(this, 46);
            try {
                if (this.getState() == 2 || this.getState() == 4) {
                    var2_2 = (String)this.m_configMap.get("org.osgi.framework.security");
                    if (var2_2 != null) {
                        if (System.getSecurityManager() != null) {
                            throw new SecurityException("SecurityManager already installed");
                        }
                        if ("osgi".equalsIgnoreCase(var2_2 = var2_2.trim()) || var2_2.length() == 0) {
                            this.m_securityManager = new SecurityManager();
                            System.setSecurityManager(this.m_securityManager);
                        } else {
                            try {
                                this.m_securityManager = (SecurityManager)Class.forName(var2_2).newInstance();
                                System.setSecurityManager(this.m_securityManager);
                            }
                            catch (Throwable var3_3) {
                                var4_6 = new SecurityException("Unable to install custom SecurityManager: " + var2_2);
                                var4_6.initCause(var3_3);
                                throw var4_6;
                            }
                        }
                    }
                    this.m_configMutableMap.put("org.osgi.framework.uuid", Util.randomUUID());
                    this.m_activatorList = (List)this.m_configMutableMap.get("felix.systembundle.activators");
                    this.m_activatorList = this.m_activatorList == null ? new ArrayList<E>() : new ArrayList<E>(this.m_activatorList);
                    this.m_dispatcher.startDispatching();
                    this.m_cache = (BundleCache)this.m_configMutableMap.get("felix.bundlecache.impl");
                    if (this.m_cache == null) {
                        try {
                            this.m_cache = new BundleCache(this.m_logger, this.m_configMap);
                        }
                        catch (Exception var3_4) {
                            this.m_logger.log(1, "Error creating bundle cache.", var3_4);
                            throw new BundleException("Error creating bundle cache.", var3_4);
                        }
                    }
                    if (this.getState() == 2 && (var3_5 = (Map[])this.m_configMap.get("org.osgi.framework.storage.clean")) != null && var3_5.equalsIgnoreCase("onFirstInit")) {
                        try {
                            this.m_cache.delete();
                        }
                        catch (Exception var4_7) {
                            throw new BundleException("Unable to flush bundle cache.", var4_7);
                        }
                    }
                    var3_5 = new Map[]{new HashMap<K, V>(1), new TreeMap<K, V>()};
                    this.m_uninstalledBundles = new ArrayList<BundleImpl>(0);
                    var3_5[0].put(this._getLocation(), this);
                    var3_5[1].put(new Long(0L), this);
                    this.m_installedBundles = var3_5;
                    try {
                        this.m_resolver.resolve(Collections.singleton(this.adapt(BundleRevision.class)), Collections.EMPTY_SET);
                    }
                    catch (ResolutionException var4_8) {
                        throw new BundleException("Unresolved constraint in System Bundle:" + var4_8.getUnresolvedRequirements());
                    }
                    var4_9 = null;
                    try {
                        var4_9 = this.m_cache.getArchives();
                    }
                    catch (Exception var5_10) {
                        this.m_logger.log(1, "Unable to list saved bundles.", var5_10);
                        var4_9 = null;
                    }
                    this.setActivator(new SystemBundleActivator());
                    this.setBundleContext(new BundleContextImpl(this.m_logger, this, this));
                    var5_11 = 0;
                    while (var4_9 != null && var5_11 < var4_9.length) {
                        try {
                            this.m_nextId = Math.max(this.m_nextId, var4_9[var5_11].getId() + 1L);
                            if (var4_9[var5_11].getPersistentState() == 1) {
                                var4_9[var5_11].closeAndDelete();
                            } else {
                                this.reloadBundle(var4_9[var5_11]);
                            }
                        }
                        catch (Exception var6_15) {
                            this.fireFrameworkEvent(2, this, var6_15);
                            try {
                                this.m_logger.log(1, "Unable to re-install " + var4_9[var5_11].getLocation(), var6_15);
                            }
                            catch (Exception v0) {
                                this.m_logger.log(1, "Unable to re-install cached bundle.", var6_15);
                            }
                        }
                        ++var5_11;
                    }
                    this.m_nextId = Math.max(this.m_nextId, this.loadNextId());
                    this.setBundleStateAndNotify(this, 8);
                    this.m_shutdownGate = new ThreadGate();
                    if (var1_1 != null) {
                        var8_19 = var1_1;
                        var7_20 = var1_1.length;
                        var6_16 = 0;
                        while (var6_16 < var7_20) {
                            var5_12 = var8_19[var6_16];
                            this.addFrameworkListener(this, var5_12);
                            ++var6_16;
                        }
                    }
                    this.m_resolver.start();
                    this.m_fwkWiring.start();
                    this.m_fwkStartLevel.start();
                    try {
                        Felix.m_secureAction.startActivator(this.getActivator(), this._getBundleContext());
                    }
                    catch (Throwable var5_13) {
                        this.m_dispatcher.stopDispatching();
                        this.m_logger.log(1, "Unable to start system bundle.", var5_13);
                        throw new RuntimeException("Unable to start system bundle.");
                    }
                    var5_14 = this.getFramework().getSecurityProvider();
                    if (var5_14 != null && System.getSecurityManager() != null) {
                        var6_17 = this.acquireGlobalLock();
                        if (!var6_17) {
                            throw new BundleException("Unable to acquire the global lock to check the bundle.");
                        }
                        try {
                            for (E var7_21 : this.m_installedBundles[1].values()) {
                                try {
                                    if (var7_21 == this) continue;
                                    this.setBundleProtectionDomain((BundleImpl)var7_21, ((BundleImpl)var7_21).adapt(BundleRevisionImpl.class));
                                }
                                catch (Exception var9_22) {
                                    ((BundleImpl)var7_21).close();
                                    var3_5 = new Map[]{new HashMap<K, V>(this.m_installedBundles[0]), new TreeMap<K, V>(this.m_installedBundles[1])};
                                    var3_5[0].remove(((BundleImpl)var7_21)._getLocation());
                                    var3_5[1].remove(new Long(((BundleImpl)var7_21).getBundleId()));
                                    this.m_installedBundles = var3_5;
                                    this.m_logger.log(1, "Bundle in cache doesn't pass security check anymore.", var9_22);
                                }
                            }
                        }
                        finally {
                            this.releaseGlobalLock();
                        }
                    }
                    this.m_extensionManager.startPendingExtensionBundles(this);
                    this.m_fwkWiring.refreshBundles(null, new FrameworkListener[0]);
                    var6_18 = this.m_systemBundleClassCache;
                    synchronized (var6_18) {
                        this.m_systemBundleClassCache.clear();
                        // MONITOREXIT @DISABLED, blocks:[0, 42, 11, 12] lbl135 : MonitorExitStatement: MONITOREXIT : var6_18
                    }
                }
            }
            finally {
                this.releaseBundleLock(this);
                if (var1_1 == null) break block44;
                var15_26 = var1_1;
                var14_28 = var1_1.length;
                var13_30 = 0;
                if (true) ** GOTO lbl152
            }
            {
            }
            do {
                var12_32 = var15_26[var13_30];
                this.removeFrameworkListener(this, var12_32);
                ++var13_30;
lbl152:
                // 2 sources

            } while (var13_30 < var14_28);
        }
    }

    void setBundleProtectionDomain(BundleImpl bundleImpl, BundleRevisionImpl bundleRevisionImpl) throws Exception {
        Certificate[] certificateArray = null;
        SecurityProvider securityProvider = this.getFramework().getSecurityProvider();
        if (securityProvider != null && System.getSecurityManager() != null) {
            securityProvider.checkBundle(bundleImpl);
            Map map = (Map)securityProvider.getSignerMatcher(bundleImpl, 2);
            certificateArray = map.keySet().toArray(new Certificate[0]);
        }
        bundleRevisionImpl.setProtectionDomain(new BundleProtectionDomain(this, bundleImpl, certificateArray));
    }

    @Override
    public void start() throws BundleException {
        block7: {
            int n = 1;
            this.acquireBundleLock(this, 46);
            try {
                if (this.getState() == 2 || this.getState() == 4) {
                    this.init();
                }
                if (this.getState() != 8) break block7;
                String string = (String)this.m_configMap.get("org.osgi.framework.startlevel.beginning");
                if (string != null) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 1;
                    }
                }
                this.m_fwkStartLevel.setStartLevelAndWait(n);
                this.setBundleStateAndNotify(this, 32);
            }
            finally {
                this.releaseBundleLock(this);
            }
        }
        this.fireBundleEvent(2, this);
        this.fireFrameworkEvent(1, this, null);
    }

    @Override
    public void start(int n) throws BundleException {
        this.start();
    }

    @Override
    public void stop() throws BundleException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, "execute"));
        }
        if ((this.getState() & 6) == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Felix.this.stopBundle(Felix.this, true);
                    }
                    catch (BundleException bundleException) {
                        Felix.this.m_logger.log(1, "Exception trying to stop framework.", bundleException);
                    }
                }
            }, "FelixShutdown").start();
        }
    }

    @Override
    public void stop(int n) throws BundleException {
        this.stop();
    }

    @Override
    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative.");
        }
        ThreadGate threadGate = this.m_shutdownGate;
        boolean bl = false;
        if (threadGate != null) {
            bl = threadGate.await(l);
        }
        FrameworkEvent frameworkEvent = bl && threadGate.getMessage() != null ? (FrameworkEvent)threadGate.getMessage() : (!bl && threadGate != null ? new FrameworkEvent(512, this, null) : new FrameworkEvent(64, this, null));
        return frameworkEvent;
    }

    @Override
    public void uninstall() throws BundleException {
        throw new BundleException("Cannot uninstall the system bundle.");
    }

    @Override
    public void update() throws BundleException {
        this.update(null);
    }

    @Override
    public void update(InputStream inputStream) throws BundleException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, "execute"));
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            this.m_logger.log(2, "Exception closing input stream.", iOException);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int n;
                    block15: {
                        Felix.this.acquireBundleLock(Felix.this, 40);
                        Felix.this.m_shutdownGate.setMessage(new FrameworkEvent(128, Felix.this, null));
                        n = Felix.this.getState();
                        try {
                            try {
                                Felix.this.stop();
                            }
                            catch (BundleException bundleException) {
                                Felix.this.m_logger.log(2, "Exception stopping framework.", bundleException);
                                Felix.this.releaseBundleLock(Felix.this);
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            Felix.this.releaseBundleLock(Felix.this);
                            throw throwable;
                        }
                        Felix.this.releaseBundleLock(Felix.this);
                    }
                    try {
                        Felix.this.waitForStop(0L);
                    }
                    catch (InterruptedException interruptedException) {
                        Felix.this.m_logger.log(2, "Did not wait for framework to stop.", interruptedException);
                    }
                    try {
                        switch (n) {
                            case 8: {
                                Felix.this.init();
                                break;
                            }
                            case 32: {
                                Felix.this.start();
                            }
                        }
                    }
                    catch (BundleException bundleException) {
                        Felix.this.m_logger.log(2, "Exception restarting framework.", bundleException);
                    }
                }
                catch (Exception exception) {
                    Felix.this.m_logger.log(2, "Cannot update an inactive framework.");
                }
            }
        }).start();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getSymbolicName()) + " [" + this.getBundleId() + "]";
    }

    int getActiveStartLevel() {
        return this.m_activeStartLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActiveStartLevel(int n, FrameworkListener[] frameworkListenerArray) {
        int n2;
        int n3;
        this.m_targetStartLevel = n;
        if (this.m_targetStartLevel != this.m_activeStartLevel) {
            boolean bl;
            int n4;
            Object object;
            boolean bl2 = this.acquireGlobalLock();
            if (!bl2) {
                throw new IllegalStateException("Unable to acquire global lock to create bundle snapshot.");
            }
            try {
                SortedSet<StartLevelTuple> sortedSet = this.m_startLevelBundles;
                synchronized (sortedSet) {
                    Bundle[] bundleArray;
                    object = bundleArray = this.getBundles();
                    int n5 = bundleArray.length;
                    n4 = 0;
                    while (n4 < n5) {
                        Bundle bundle = object[n4];
                        this.m_startLevelBundles.add(new StartLevelTuple((BundleImpl)bundle, ((BundleImpl)bundle).getStartLevel(this.getInitialBundleStartLevel())));
                        ++n4;
                    }
                    bl = !this.m_startLevelBundles.isEmpty();
                }
            }
            finally {
                this.releaseGlobalLock();
            }
            n3 = this.m_targetStartLevel < this.m_activeStartLevel ? 1 : 0;
            n2 = n3 != 0 ? this.m_targetStartLevel + 1 : this.m_activeStartLevel + 1;
            n4 = n3 != 0 ? this.m_activeStartLevel : this.m_targetStartLevel;
            this.m_activeStartLevel = n3 != 0 ? n4 : n2;
            while (bl) {
                StartLevelTuple startLevelTuple;
                object = this.m_startLevelBundles;
                synchronized (object) {
                    startLevelTuple = n3 != 0 ? this.m_startLevelBundles.last() : this.m_startLevelBundles.first();
                    if (startLevelTuple.m_level >= n2 && startLevelTuple.m_level <= n4) {
                        this.m_activeStartLevel = startLevelTuple.m_level;
                    }
                }
                if (startLevelTuple.m_bundle.getBundleId() != 0L) {
                    try {
                        this.acquireBundleLock(startLevelTuple.m_bundle, 62);
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (startLevelTuple.m_bundle.getState() != 1) {
                            this.fireFrameworkEvent(2, startLevelTuple.m_bundle, illegalStateException);
                            this.m_logger.log(startLevelTuple.m_bundle, 1, "Error locking " + startLevelTuple.m_bundle._getLocation(), (Throwable)illegalStateException);
                            continue;
                        }
                        SortedSet<StartLevelTuple> sortedSet = this.m_startLevelBundles;
                        synchronized (sortedSet) {
                            this.m_startLevelBundles.remove(startLevelTuple);
                            bl = !this.m_startLevelBundles.isEmpty();
                            continue;
                        }
                    }
                    try {
                        if (n3 == 0 && (startLevelTuple.m_bundle.getPersistentState() == 32 || startLevelTuple.m_bundle.getPersistentState() == 8) && startLevelTuple.m_level == this.m_activeStartLevel) {
                            try {
                                int n6 = 1;
                                n6 = startLevelTuple.m_bundle.getPersistentState() == 8 ? n6 | 2 : n6;
                                this.startBundle(startLevelTuple.m_bundle, n6);
                            }
                            catch (Throwable throwable) {
                                this.fireFrameworkEvent(2, startLevelTuple.m_bundle, throwable);
                                this.m_logger.log(startLevelTuple.m_bundle, 1, "Error starting " + startLevelTuple.m_bundle._getLocation(), throwable);
                            }
                        } else if (n3 != 0 && (startLevelTuple.m_bundle.getState() == 32 || startLevelTuple.m_bundle.getState() == 8) && startLevelTuple.m_level == this.m_activeStartLevel) {
                            try {
                                this.stopBundle(startLevelTuple.m_bundle, false);
                            }
                            catch (Throwable throwable) {
                                this.fireFrameworkEvent(2, startLevelTuple.m_bundle, throwable);
                                this.m_logger.log(startLevelTuple.m_bundle, 1, "Error stopping " + startLevelTuple.m_bundle._getLocation(), throwable);
                            }
                        }
                    }
                    finally {
                        this.releaseBundleLock(startLevelTuple.m_bundle);
                    }
                }
                object = this.m_startLevelBundles;
                synchronized (object) {
                    this.m_startLevelBundles.remove(startLevelTuple);
                    bl = !this.m_startLevelBundles.isEmpty();
                }
            }
            this.m_activeStartLevel = this.m_targetStartLevel;
        }
        if (this.getState() == 32) {
            this.fireFrameworkEvent(8, this, null);
            if (frameworkListenerArray != null) {
                FrameworkEvent frameworkEvent = new FrameworkEvent(8, this, null);
                FrameworkListener[] frameworkListenerArray2 = frameworkListenerArray;
                n2 = frameworkListenerArray.length;
                n3 = 0;
                while (n3 < n2) {
                    FrameworkListener frameworkListener = frameworkListenerArray2[n3];
                    try {
                        frameworkListener.frameworkEvent(frameworkEvent);
                    }
                    catch (Throwable throwable) {
                        this.m_logger.log(1, "Framework listener delivery error.", throwable);
                    }
                    ++n3;
                }
            }
        }
    }

    int getInitialBundleStartLevel() {
        String string = (String)this.m_configMap.get("felix.startlevel.bundle");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                return n > 0 ? n : 1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 1;
    }

    void setInitialBundleStartLevel(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Initial start level must be greater than zero.");
        }
        this.m_configMutableMap.put("felix.startlevel.bundle", Integer.toString(n));
    }

    int getBundleStartLevel(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((BundleImpl)bundle).getStartLevel(this.getInitialBundleStartLevel());
    }

    void setBundleStartLevel(Bundle bundle, int n) {
        Throwable throwable;
        block12: {
            BundleImpl bundleImpl = (BundleImpl)bundle;
            try {
                this.acquireBundleLock(bundleImpl, 62);
            }
            catch (IllegalStateException illegalStateException) {
                this.fireFrameworkEvent(2, bundleImpl, illegalStateException);
                this.m_logger.log(bundleImpl, 1, "Error locking " + bundleImpl._getLocation(), (Throwable)illegalStateException);
                return;
            }
            throwable = null;
            try {
                if (n >= 1) {
                    try {
                        if ((bundleImpl.getPersistentState() == 32 || bundleImpl.getPersistentState() == 8) && n <= this.m_activeStartLevel) {
                            int n2 = 1;
                            n2 = bundleImpl.getPersistentState() == 8 ? n2 | 2 : n2;
                            this.startBundle(bundleImpl, n2);
                        } else if ((bundleImpl.getState() == 32 || bundleImpl.getState() == 8) && n > this.m_activeStartLevel) {
                            this.stopBundle(bundleImpl, false);
                        }
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        this.m_logger.log(bundleImpl, 1, "Error starting/stopping bundle.", throwable2);
                    }
                    break block12;
                }
                this.m_logger.log(bundleImpl, 2, "Bundle start level must be greater than zero.");
            }
            finally {
                this.releaseBundleLock(bundleImpl);
            }
        }
        if (throwable != null) {
            this.fireFrameworkEvent(2, bundle, throwable);
        }
    }

    boolean isBundlePersistentlyStarted(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((BundleImpl)bundle).getPersistentState() == 32 || ((BundleImpl)bundle).getPersistentState() == 8;
    }

    boolean isBundleActivationPolicyUsed(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((BundleImpl)bundle).isDeclaredActivationPolicyUsed();
    }

    Dictionary getBundleHeaders(BundleImpl bundleImpl, String string) {
        return new MapToDictionary(bundleImpl.getCurrentLocalizedHeader(string));
    }

    URL getBundleResource(BundleImpl bundleImpl, String string) {
        if (bundleImpl.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (Util.isFragment(bundleImpl.adapt(BundleRevision.class))) {
            return null;
        }
        if (bundleImpl.getState() == 2) {
            try {
                this.resolveBundleRevision(bundleImpl.adapt(BundleRevision.class));
            }
            catch (Exception exception) {}
        }
        if (bundleImpl.adapt(BundleRevision.class).getWiring() == null) {
            return ((BundleRevisionImpl)bundleImpl.adapt(BundleRevision.class)).getResourceLocal(string);
        }
        return ((BundleWiringImpl)bundleImpl.adapt(BundleRevision.class).getWiring()).getResourceByDelegation(string);
    }

    Enumeration getBundleResources(BundleImpl bundleImpl, String string) {
        if (bundleImpl.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (Util.isFragment(bundleImpl.adapt(BundleRevision.class))) {
            return null;
        }
        if (bundleImpl.getState() == 2) {
            try {
                this.resolveBundleRevision(bundleImpl.adapt(BundleRevision.class));
            }
            catch (Exception exception) {}
        }
        if (bundleImpl.adapt(BundleRevision.class).getWiring() == null) {
            return ((BundleRevisionImpl)bundleImpl.adapt(BundleRevision.class)).getResourcesLocal(string);
        }
        return ((BundleWiringImpl)bundleImpl.adapt(BundleRevision.class).getWiring()).getResourcesByDelegation(string);
    }

    URL getBundleEntry(BundleImpl bundleImpl, String string) {
        EntryFilterEnumeration entryFilterEnumeration;
        if (bundleImpl.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        URL uRL = ((BundleRevisionImpl)bundleImpl.adapt(BundleRevision.class)).getEntry(string);
        if (uRL == null && string.endsWith("/") && !string.equals("/") && (entryFilterEnumeration = new EntryFilterEnumeration(bundleImpl.adapt(BundleRevision.class), false, string, "*", true, true)).hasMoreElements()) {
            URL uRL2 = (URL)entryFilterEnumeration.nextElement();
            try {
                uRL = new URL(uRL2, string.charAt(0) == '/' ? string : "/" + string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
        }
        return uRL;
    }

    Enumeration getBundleEntryPaths(BundleImpl bundleImpl, String string) {
        if (bundleImpl.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        EntryFilterEnumeration entryFilterEnumeration = new EntryFilterEnumeration(bundleImpl.adapt(BundleRevision.class), false, string, "*", false, false);
        return !entryFilterEnumeration.hasMoreElements() ? null : entryFilterEnumeration;
    }

    Enumeration findBundleEntries(BundleImpl bundleImpl, String string, String string2, boolean bl) {
        if (bundleImpl.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (!Util.isFragment(bundleImpl.adapt(BundleRevision.class)) && bundleImpl.getState() == 2) {
            try {
                this.resolveBundleRevision(bundleImpl.adapt(BundleRevision.class));
            }
            catch (Exception exception) {}
        }
        return this.findBundleEntries(bundleImpl.adapt(BundleRevision.class), string, string2, bl);
    }

    Enumeration findBundleEntries(BundleRevision bundleRevision, String string, String string2, boolean bl) {
        EntryFilterEnumeration entryFilterEnumeration = new EntryFilterEnumeration(bundleRevision, true, string, string2, bl, true);
        return !entryFilterEnumeration.hasMoreElements() ? null : entryFilterEnumeration;
    }

    ServiceReference[] getBundleRegisteredServices(BundleImpl bundleImpl) {
        if (bundleImpl.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        ServiceReference[] serviceReferenceArray = this.m_registry.getRegisteredServices(bundleImpl);
        return serviceReferenceArray;
    }

    ServiceReference[] getBundleServicesInUse(Bundle bundle) {
        ServiceReference[] serviceReferenceArray = this.m_registry.getServicesInUse(bundle);
        return serviceReferenceArray;
    }

    boolean bundleHasPermission(BundleImpl bundleImpl, Object object) {
        if (bundleImpl.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (System.getSecurityManager() != null) {
            try {
                return object instanceof Permission ? this.impliesBundlePermission((BundleProtectionDomain)bundleImpl.getProtectionDomain(), (Permission)object, true) : false;
            }
            catch (Exception exception) {
                this.m_logger.log(bundleImpl, 2, "Exception while evaluating the permission.", (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    Class loadBundleClass(BundleImpl bundleImpl, String string) throws ClassNotFoundException {
        if (bundleImpl.getState() == 1) {
            throw new IllegalStateException("Bundle is uninstalled");
        }
        if (Util.isFragment(bundleImpl.adapt(BundleRevision.class))) {
            throw new ClassNotFoundException("Fragments cannot load classes.");
        }
        if (bundleImpl.getState() == 2) {
            try {
                this.resolveBundleRevision(bundleImpl.adapt(BundleRevision.class));
            }
            catch (BundleException bundleException) {
                this.fireFrameworkEvent(2, bundleImpl, bundleException);
                throw new ClassNotFoundException(string, bundleException);
            }
        }
        if (string != null && string.length() > 0 && string.charAt(0) == '[') {
            return Class.forName(string, false, ((BundleWiringImpl)bundleImpl.adapt(BundleWiring.class)).getClassLoader());
        }
        return ((BundleWiringImpl)bundleImpl.adapt(BundleWiring.class)).getClassLoader().loadClass(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startBundle(BundleImpl bundleImpl, int n) throws BundleException {
        int n2;
        boolean bl = (n & 1) != 0;
        try {
            this.acquireBundleLock(bundleImpl, 62);
        }
        catch (IllegalStateException illegalStateException) {
            if (bundleImpl.getState() != 1) throw new BundleException("Bundle " + bundleImpl + " cannot be started, since it is either starting or stopping.");
            throw new IllegalStateException("Cannot start an uninstalled bundle.");
        }
        boolean bl2 = bundleImpl.isDeclaredActivationPolicyUsed() && ((BundleRevisionImpl)bundleImpl.adapt(BundleRevision.class)).getDeclaredActivationPolicy() == 1;
        bundleImpl.setDeclaredActivationPolicyUsed((n & 2) != 0);
        BundleException bundleException = null;
        try {
            if (bundleImpl.isExtension()) {
                return;
            }
            if (Util.isFragment(bundleImpl.adapt(BundleRevision.class))) {
                throw new BundleException("Fragment bundles can not be started.");
            }
            if (!bl) {
                if ((n & 2) != 0) {
                    bundleImpl.setPersistentStateStarting();
                } else {
                    bundleImpl.setPersistentStateActive();
                }
            }
            int n3 = bundleImpl.getStartLevel(this.getInitialBundleStartLevel());
            if (bl && n3 > this.m_activeStartLevel) {
                throw new BundleException("Cannot start bundle " + bundleImpl + " because its start level is " + n3 + ", which is greater than the framework's start level of " + this.m_activeStartLevel + ".", 10);
            }
            if (n3 > this.m_targetStartLevel) {
                return;
            }
            if (!Thread.currentThread().getName().equals("FelixStartLevel")) {
                SortedSet<StartLevelTuple> sortedSet = this.m_startLevelBundles;
                synchronized (sortedSet) {
                    if (bl && n3 > this.m_activeStartLevel) {
                        throw new BundleException("Cannot start bundle " + bundleImpl + " because its start level is " + n3 + ", which is greater than the framework's start level of " + this.m_activeStartLevel + ".", 10);
                    }
                    if (!this.m_startLevelBundles.isEmpty() && n3 >= this.m_activeStartLevel) {
                        boolean bl3 = false;
                        for (StartLevelTuple startLevelTuple : this.m_startLevelBundles) {
                            if (startLevelTuple.m_bundle != bundleImpl) continue;
                            bl3 = true;
                        }
                        if (!bl3) {
                            this.m_startLevelBundles.add(new StartLevelTuple(bundleImpl, n3));
                        }
                        if (!bl) {
                            return;
                        }
                    }
                }
            }
            switch (bundleImpl.getState()) {
                case 1: {
                    throw new IllegalStateException("Cannot start an uninstalled bundle.");
                }
                case 8: {
                    if (bl2) break;
                    throw new BundleException("Bundle " + bundleImpl + " cannot be started, since it is starting.");
                }
                case 16: {
                    throw new BundleException("Bundle " + bundleImpl + " cannot be started, since it is stopping.");
                }
                case 32: {
                    return;
                }
                case 2: {
                    this.resolveBundleRevision(bundleImpl.adapt(BundleRevision.class));
                }
                case 4: {
                    bundleImpl.setBundleContext(new BundleContextImpl(this.m_logger, this, bundleImpl));
                    this.setBundleStateAndNotify(bundleImpl, 8);
                    break;
                }
            }
            if (!bundleImpl.isDeclaredActivationPolicyUsed() || ((BundleRevisionImpl)bundleImpl.adapt(BundleRevision.class)).getDeclaredActivationPolicy() != 1 || ((BundleWiringImpl.BundleClassLoader)bundleImpl.adapt(BundleWiring.class).getClassLoader()).isActivationTriggered()) {
                n2 = 2;
                try {
                    this.activateBundle(bundleImpl, false);
                }
                catch (BundleException bundleException2) {
                    bundleException = bundleException2;
                }
            } else {
                n2 = 512;
            }
        }
        finally {
            this.releaseBundleLock(bundleImpl);
        }
        if (bundleException == null) {
            this.fireBundleEvent(n2, bundleImpl);
            return;
        }
        this.fireBundleEvent(4, bundleImpl);
        throw bundleException;
    }

    void activateBundle(BundleImpl bundleImpl, boolean bl) throws BundleException {
        try {
            this.acquireBundleLock(bundleImpl, 40);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Activation only occurs for bundles in STARTING state.");
        }
        try {
            if (bundleImpl.getState() == 32 || bundleImpl.getStartLevel(this.getInitialBundleStartLevel()) > this.m_targetStartLevel) {
                return;
            }
            this.fireBundleEvent(128, bundleImpl);
            try {
                bundleImpl.setActivator(this.createBundleActivator(bundleImpl));
                if (bundleImpl.getActivator() != null) {
                    m_secureAction.startActivator(bundleImpl.getActivator(), bundleImpl._getBundleContext());
                }
                this.setBundleStateAndNotify(bundleImpl, 32);
            }
            catch (Throwable throwable) {
                Exception exception;
                this.fireBundleEvent(256, bundleImpl);
                this.setBundleStateAndNotify(bundleImpl, 4);
                bundleImpl.setActivator(null);
                BundleContextImpl bundleContextImpl = (BundleContextImpl)bundleImpl._getBundleContext();
                bundleContextImpl.invalidate();
                bundleImpl.setBundleContext(null);
                this.m_registry.unregisterServices(bundleImpl);
                this.m_registry.ungetServices(bundleImpl);
                this.m_dispatcher.removeListeners(bundleContextImpl);
                if (throwable instanceof BundleException) {
                    throw (BundleException)throwable;
                }
                if (System.getSecurityManager() != null && throwable instanceof PrivilegedActionException) {
                    exception = ((PrivilegedActionException)throwable).getException();
                }
                throw new BundleException("Activator start error in bundle " + bundleImpl + ".", 5, exception);
            }
        }
        finally {
            this.releaseBundleLock(bundleImpl);
        }
        if (bl) {
            this.fireBundleEvent(2, bundleImpl);
        }
    }

    void updateBundle(BundleImpl bundleImpl, InputStream inputStream) throws BundleException {
        try {
            this.acquireBundleLock(bundleImpl, 38);
        }
        catch (IllegalStateException illegalStateException) {
            if (bundleImpl.getState() == 1) {
                throw new IllegalStateException("Cannot update an uninstalled bundle.");
            }
            throw new BundleException("Bundle " + bundleImpl + " cannot be update, since it is either starting or stopping.");
        }
        try {
            Throwable throwable = null;
            int n = bundleImpl.getState();
            String string = (String)((BundleRevisionImpl)bundleImpl.adapt(BundleRevision.class)).getHeaders().get("Bundle-UpdateLocation");
            if (string == null) {
                string = bundleImpl._getLocation();
            }
            if (n == 32) {
                this.stopBundle(bundleImpl, false);
            }
            try {
                boolean bl = this.acquireGlobalLock();
                if (!bl) {
                    throw new BundleException("Cannot acquire global lock to update the bundle.");
                }
                try {
                    boolean bl2 = bundleImpl.isExtension();
                    bundleImpl.revise(string, inputStream);
                    try {
                        SecurityManager securityManager = System.getSecurityManager();
                        if (securityManager != null) {
                            securityManager.checkPermission(new AdminPermission(bundleImpl, "lifecycle"));
                        }
                        if (!bl2 && bundleImpl.isExtension()) {
                            this.m_extensionManager.addExtensionBundle(this, bundleImpl);
                            this.m_resolver.addRevision(this.m_extensionManager.getRevision());
                            this.setBundleStateAndNotify(bundleImpl, 4);
                        } else if (bl2) {
                            this.setBundleStateAndNotify(bundleImpl, 2);
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            bundleImpl.rollbackRevise();
                        }
                        catch (Exception exception) {
                            this.m_logger.log(bundleImpl, 1, "Unable to rollback.", (Throwable)exception);
                        }
                        throw throwable2;
                    }
                }
                finally {
                    this.releaseGlobalLock();
                }
            }
            catch (Throwable throwable3) {
                this.m_logger.log(bundleImpl, 1, "Unable to update the bundle.", throwable3);
                throwable = throwable3;
            }
            if (throwable == null) {
                bundleImpl.setLastModified(System.currentTimeMillis());
                if (!bundleImpl.isExtension()) {
                    this.setBundleStateAndNotify(bundleImpl, 2);
                } else {
                    this.m_extensionManager.startExtensionBundle(this, bundleImpl);
                }
                this.fireBundleEvent(64, bundleImpl);
                this.fireBundleEvent(8, bundleImpl);
                boolean bl = this.acquireGlobalLock();
                if (bl) {
                    try {
                        if (!this.m_dependencies.hasDependents(bundleImpl) && !bundleImpl.isExtension()) {
                            try {
                                ArrayList<Bundle> arrayList = new ArrayList<Bundle>(1);
                                arrayList.add(bundleImpl);
                                this.refreshPackages(arrayList, null);
                            }
                            catch (Exception exception) {
                                this.m_logger.log(bundleImpl, 1, "Unable to immediately purge the bundle revisions.", (Throwable)exception);
                            }
                        }
                    }
                    finally {
                        this.releaseGlobalLock();
                    }
                }
            }
            if (n == 32 && Util.isFragment(bundleImpl.adapt(BundleRevision.class))) {
                bundleImpl.setPersistentStateInactive();
                this.m_logger.log(bundleImpl, 2, "Previously active bundle was updated to a fragment, resetting state to inactive: " + bundleImpl);
            } else if (n == 32) {
                this.startBundle(bundleImpl, 1);
            }
            if (throwable != null) {
                if (throwable instanceof AccessControlException) {
                    throw (AccessControlException)throwable;
                }
                if (throwable instanceof BundleException) {
                    throw (BundleException)throwable;
                }
                throw new BundleException("Update of bundle " + bundleImpl + " failed.", throwable);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                this.m_logger.log(bundleImpl, 1, "Unable to close input stream.", (Throwable)exception);
            }
            this.releaseBundleLock(bundleImpl);
        }
    }

    void stopBundle(BundleImpl bundleImpl, boolean bl) throws BundleException {
        try {
            this.acquireBundleLock(bundleImpl, 62);
        }
        catch (IllegalStateException illegalStateException) {
            if (bundleImpl.getState() == 1) {
                throw new IllegalStateException("Cannot stop an uninstalled bundle.");
            }
            throw new BundleException("Bundle " + bundleImpl + " cannot be stopped since it is already stopping.");
        }
        try {
            Throwable throwable = null;
            if (bl) {
                bundleImpl.setPersistentStateInactive();
            }
            if (!this.isBundlePersistentlyStarted(bundleImpl)) {
                bundleImpl.setDeclaredActivationPolicyUsed(false);
            }
            if (Util.isFragment(bundleImpl.adapt(BundleRevision.class))) {
                throw new BundleException("Fragment bundles can not be stopped: " + bundleImpl);
            }
            boolean bl2 = false;
            switch (bundleImpl.getState()) {
                case 1: {
                    throw new IllegalStateException("Cannot stop an uninstalled bundle.");
                }
                case 8: {
                    if (!bundleImpl.isDeclaredActivationPolicyUsed() || ((BundleRevisionImpl)bundleImpl.adapt(BundleRevision.class)).getDeclaredActivationPolicy() == 1) break;
                    throw new BundleException("Stopping a starting or stopping bundle is currently not supported.");
                }
                case 16: {
                    throw new BundleException("Stopping a starting or stopping bundle is currently not supported.");
                }
                case 2: 
                case 4: {
                    return;
                }
                case 32: {
                    bl2 = true;
                }
            }
            this.setBundleStateAndNotify(bundleImpl, 16);
            this.fireBundleEvent(256, bundleImpl);
            if (bl2 || bundleImpl.getBundleId() == 0L) {
                try {
                    if (bundleImpl.getActivator() != null) {
                        m_secureAction.stopActivator(bundleImpl.getActivator(), bundleImpl._getBundleContext());
                    }
                }
                catch (Throwable throwable2) {
                    this.m_logger.log(bundleImpl, 1, "Error stopping bundle.", throwable2);
                    throwable = throwable2;
                }
            }
            if (bundleImpl.getBundleId() != 0L) {
                bundleImpl.setActivator(null);
                BundleContextImpl bundleContextImpl = (BundleContextImpl)bundleImpl._getBundleContext();
                bundleContextImpl.invalidate();
                bundleImpl.setBundleContext(null);
                this.m_registry.unregisterServices(bundleImpl);
                this.m_registry.ungetServices(bundleImpl);
                this.m_dispatcher.removeListeners(bundleContextImpl);
                this.setBundleStateAndNotify(bundleImpl, 4);
            }
            if (throwable != null) {
                if (throwable instanceof BundleException) {
                    throw (BundleException)throwable;
                }
                if (System.getSecurityManager() != null && throwable instanceof PrivilegedActionException) {
                    throwable = ((PrivilegedActionException)throwable).getException();
                }
                throw new BundleException("Activator stop error in bundle " + bundleImpl + ".", throwable);
            }
        }
        finally {
            this.releaseBundleLock(bundleImpl);
        }
        this.fireBundleEvent(4, bundleImpl);
    }

    void uninstallBundle(BundleImpl bundleImpl) throws BundleException {
        Object object;
        try {
            this.acquireBundleLock(bundleImpl, 62);
        }
        catch (IllegalStateException illegalStateException) {
            if (bundleImpl.getState() == 1) {
                throw new IllegalStateException("Cannot uninstall an uninstalled bundle.");
            }
            throw new BundleException("Bundle " + bundleImpl + " cannot be uninstalled since it is stopping.");
        }
        try {
            if (!bundleImpl.isExtension() && bundleImpl.getState() == 32) {
                try {
                    this.stopBundle(bundleImpl, true);
                }
                catch (BundleException bundleException) {
                    this.fireFrameworkEvent(2, bundleImpl, bundleException);
                }
            }
            BundleImpl bundleImpl2 = null;
            boolean bl = this.acquireGlobalLock();
            if (!bl) {
                throw new IllegalStateException("Unable to acquire global lock to remove bundle.");
            }
            try {
                object = new Map[]{new HashMap(this.m_installedBundles[0]), new TreeMap(this.m_installedBundles[1])};
                bundleImpl2 = (BundleImpl)object[0].remove(bundleImpl._getLocation());
                if (bundleImpl2 != null) {
                    object[1].remove(new Long(bundleImpl2.getBundleId()));
                    this.m_installedBundles = object;
                    bundleImpl.setPersistentStateUninstalled();
                    this.rememberUninstalledBundle(bundleImpl);
                }
            }
            finally {
                this.releaseGlobalLock();
            }
            if (bundleImpl2 == null) {
                this.m_logger.log(bundleImpl, 1, "Unable to remove bundle from installed map!");
            }
            this.setBundleStateAndNotify(bundleImpl, 2);
            this.fireBundleEvent(64, bundleImpl);
            this.setBundleStateAndNotify(bundleImpl, 1);
            bundleImpl.setLastModified(System.currentTimeMillis());
        }
        finally {
            this.releaseBundleLock(bundleImpl);
        }
        this.fireBundleEvent(16, bundleImpl);
        boolean bl = this.acquireGlobalLock();
        if (bl) {
            Object object2;
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
            arrayList.add(bundleImpl);
            object = bundleImpl.adapt(BundleRevisions.class);
            if (object != null) {
                for (BundleRevision object3 : object.getRevisions()) {
                    object2 = object3.getWiring();
                    if (object2 == null) continue;
                    for (BundleWire bundleWire : object2.getRequiredWires(null)) {
                        Bundle bundle = bundleWire.getProvider().getBundle();
                        if (1 != bundle.getState() || arrayList.contains(bundle)) continue;
                        arrayList.add(bundle);
                    }
                }
            }
            try {
                for (Bundle bundle : arrayList) {
                    if (this.m_dependencies.hasDependents(bundle)) continue;
                    try {
                        object2 = Collections.singletonList(bundle);
                        this.refreshPackages((Collection<Bundle>)object2, null);
                    }
                    catch (Exception exception) {
                        this.m_logger.log(bundle, 1, "Unable to immediately garbage collect the bundle.", (Throwable)exception);
                    }
                }
            }
            finally {
                this.releaseGlobalLock();
            }
        }
    }

    String getProperty(String string) {
        String string2 = (String)this.m_configMap.get(string);
        return string2 == null ? System.getProperty(string) : string2;
    }

    private Bundle reloadBundle(BundleArchive bundleArchive) throws BundleException {
        BundleImpl bundleImpl = null;
        try {
            if (bundleArchive.isRemovalPending()) {
                bundleArchive.purge();
            }
        }
        catch (Exception exception) {
            this.m_logger.log(1, "Could not purge bundle.", exception);
        }
        try {
            boolean bl = this.acquireGlobalLock();
            if (!bl) {
                throw new BundleException("Unable to acquire the global lock to install the bundle.");
            }
            try {
                bundleImpl = new BundleImpl(this, null, bundleArchive);
                if (bundleImpl.isExtension()) {
                    this.m_extensionManager.addExtensionBundle(this, bundleImpl);
                    this.m_resolver.addRevision(this.m_extensionManager.getRevision());
                }
                Map[] mapArray = new Map[]{new HashMap(this.m_installedBundles[0]), new TreeMap(this.m_installedBundles[1])};
                mapArray[0].put(bundleImpl._getLocation(), bundleImpl);
                mapArray[1].put(new Long(bundleImpl.getBundleId()), bundleImpl);
                this.m_installedBundles = mapArray;
            }
            finally {
                this.releaseGlobalLock();
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof BundleException) {
                throw (BundleException)throwable;
            }
            if (throwable instanceof AccessControlException) {
                throw (AccessControlException)throwable;
            }
            throw new BundleException("Could not create bundle object.", throwable);
        }
        if (bundleImpl.isExtension()) {
            this.m_extensionManager.startExtensionBundle(this, bundleImpl);
        }
        return bundleImpl;
    }

    Bundle installBundle(Bundle bundle, String string, InputStream inputStream) throws BundleException {
        BundleImpl bundleImpl;
        BundleImpl bundleImpl2;
        block47: {
            BundleArchive bundleArchive = null;
            bundleImpl2 = null;
            this.acquireInstallLock(string);
            try {
                Object object;
                boolean bl;
                if (this.getState() == 16 || this.getState() == 1) {
                    throw new BundleException("The framework has been shutdown.");
                }
                bundleImpl = (BundleImpl)this.getBundle(string);
                if (bundleImpl != null) break block47;
                long l = this.getNextId();
                try {
                    try {
                        bundleArchive = this.m_cache.create(l, this.getInitialBundleStartLevel(), string, inputStream);
                    }
                    catch (Exception exception) {
                        throw new BundleException("Unable to cache bundle: " + string, exception);
                    }
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        this.m_logger.log(1, "Unable to close input stream.", iOException);
                    }
                }
                try {
                    bl = this.acquireGlobalLock();
                    if (!bl) {
                        throw new BundleException("Unable to acquire the global lock to install the bundle.");
                    }
                    try {
                        bundleImpl2 = new BundleImpl(this, bundle, bundleArchive);
                    }
                    finally {
                        this.releaseGlobalLock();
                    }
                    if (!bundleImpl2.isExtension()) {
                        object = System.getSecurityManager();
                        if (object != null) {
                            ((SecurityManager)object).checkPermission(new AdminPermission(bundleImpl2, "lifecycle"));
                        }
                    } else {
                        this.m_extensionManager.addExtensionBundle(this, bundleImpl2);
                        this.m_resolver.addRevision(this.m_extensionManager.getRevision());
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bundleImpl2 != null) {
                            bundleImpl2.closeAndDelete();
                        } else if (bundleArchive != null) {
                            bundleArchive.closeAndDelete();
                        }
                    }
                    catch (Exception exception) {
                        this.m_logger.log(bundleImpl2, 1, "Could not remove from cache.", (Throwable)exception);
                    }
                    if (throwable instanceof BundleException) {
                        throw (BundleException)throwable;
                    }
                    if (throwable instanceof AccessControlException) {
                        throw (AccessControlException)throwable;
                    }
                    throw new BundleException("Could not create bundle object.", throwable);
                }
                if (!(bl = this.acquireGlobalLock())) {
                    throw new IllegalStateException("Unable to acquire global lock to add bundle.");
                }
                try {
                    object = new Map[]{new HashMap(this.m_installedBundles[0]), new TreeMap(this.m_installedBundles[1])};
                    object[0].put(string, bundleImpl2);
                    object[1].put(new Long(bundleImpl2.getBundleId()), bundleImpl2);
                    this.m_installedBundles = object;
                }
                finally {
                    this.releaseGlobalLock();
                }
                if (bundleImpl2.isExtension()) {
                    this.m_extensionManager.startExtensionBundle(this, bundleImpl2);
                }
            }
            finally {
                this.releaseInstallLock(string);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    this.m_logger.log(bundleImpl2, 1, "Unable to close input stream.", (Throwable)iOException);
                }
            }
        }
        if (bundleImpl != null) {
            Set<ServiceReference<FindHook>> set = this.getHookRegistry().getHooks(FindHook.class);
            if (!set.isEmpty()) {
                Collection<Bundle> collection = new ArrayList<BundleImpl>(1);
                collection.add(bundleImpl);
                collection = new ShrinkableCollection(collection);
                for (ServiceReference<FindHook> serviceReference : set) {
                    FindHook findHook = this.getService(this, serviceReference, false);
                    if (findHook == null) continue;
                    try {
                        m_secureAction.invokeBundleFindHook(findHook, bundle.getBundleContext(), collection);
                    }
                    catch (Throwable throwable) {
                        this.m_logger.doLog(serviceReference.getBundle(), serviceReference, 2, "Problem invoking bundle hook.", throwable);
                    }
                }
                if (bundle != this && collection.isEmpty()) {
                    throw new BundleException("Bundle installation rejected by hook.", 12);
                }
            }
        } else {
            this.fireBundleEvent(1, bundleImpl2, bundle);
        }
        return bundleImpl != null ? bundleImpl : bundleImpl2;
    }

    Bundle getBundle(String string) {
        return (Bundle)this.m_installedBundles[0].get(string);
    }

    Bundle getBundle(BundleContext bundleContext, long l) {
        Collection<Comparable<Bundle>> collection;
        BundleImpl bundleImpl = (BundleImpl)this.m_installedBundles[1].get(new Long(l));
        if (bundleImpl != null) {
            collection = this.m_uninstalledBundles;
            int n = 0;
            while (bundleImpl == null && collection != null && n < collection.size()) {
                if (((BundleImpl)collection.get(n)).getBundleId() == l) {
                    bundleImpl = (BundleImpl)collection.get(n);
                }
                ++n;
            }
        }
        if (!(collection = this.getHookRegistry().getHooks(FindHook.class)).isEmpty() && bundleImpl != null) {
            Collection<Bundle> collection2 = new ArrayList<BundleImpl>(1);
            collection2.add(bundleImpl);
            collection2 = new ShrinkableCollection(collection2);
            for (ServiceReference serviceReference : collection) {
                FindHook findHook = (FindHook)this.getService(this, serviceReference, false);
                if (findHook == null) continue;
                try {
                    m_secureAction.invokeBundleFindHook(findHook, bundleContext, collection2);
                }
                catch (Throwable throwable) {
                    this.m_logger.doLog(serviceReference.getBundle(), serviceReference, 2, "Problem invoking bundle hook.", throwable);
                }
            }
            if (bundleContext.getBundle() != this) {
                bundleImpl = collection2.isEmpty() ? null : bundleImpl;
            }
        }
        return bundleImpl;
    }

    Bundle getBundle(long l) {
        BundleImpl bundleImpl = (BundleImpl)this.m_installedBundles[1].get(new Long(l));
        if (bundleImpl != null) {
            return bundleImpl;
        }
        List<BundleImpl> list = this.m_uninstalledBundles;
        int n = 0;
        while (list != null && n < list.size()) {
            if (list.get(n).getBundleId() == l) {
                return list.get(n);
            }
            ++n;
        }
        return null;
    }

    Bundle[] getBundles(BundleContext bundleContext) {
        Set<ServiceReference<FindHook>> set;
        Collection collection = this.m_installedBundles[1].values();
        if (!collection.isEmpty() && !(set = this.getHookRegistry().getHooks(FindHook.class)).isEmpty()) {
            ShrinkableCollection<Bundle> shrinkableCollection = new ShrinkableCollection<Bundle>(new ArrayList(collection));
            for (ServiceReference<FindHook> serviceReference : set) {
                FindHook findHook = this.getService(this, serviceReference, false);
                if (findHook == null) continue;
                try {
                    m_secureAction.invokeBundleFindHook(findHook, bundleContext, shrinkableCollection);
                }
                catch (Throwable throwable) {
                    this.m_logger.doLog(serviceReference.getBundle(), serviceReference, 2, "Problem invoking bundle hook.", throwable);
                }
            }
            if (bundleContext.getBundle() != this) {
                collection = shrinkableCollection;
            }
        }
        return collection.toArray(new Bundle[collection.size()]);
    }

    Bundle[] getBundles() {
        Collection collection = this.m_installedBundles[1].values();
        return collection.toArray(new Bundle[collection.size()]);
    }

    void addBundleListener(BundleImpl bundleImpl, BundleListener bundleListener) {
        this.m_dispatcher.addListener(bundleImpl._getBundleContext(), BundleListener.class, bundleListener, null);
    }

    void removeBundleListener(BundleImpl bundleImpl, BundleListener bundleListener) {
        this.m_dispatcher.removeListener(bundleImpl._getBundleContext(), BundleListener.class, bundleListener);
    }

    void addServiceListener(BundleImpl bundleImpl, ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        ListenerHook listenerHook;
        Set<ListenerHook.ListenerInfo> set;
        Filter filter = string == null ? null : FrameworkUtil.createFilter(string);
        Filter filter2 = this.m_dispatcher.addListener(bundleImpl._getBundleContext(), ServiceListener.class, serviceListener, filter);
        Set<ServiceReference<ListenerHook>> set2 = this.getHookRegistry().getHooks(ListenerHook.class);
        if (filter2 != null) {
            set = Collections.singleton(new ListenerInfo(bundleImpl, bundleImpl._getBundleContext(), ServiceListener.class, serviceListener, filter2, null, true));
            for (ServiceReference<ListenerHook> serviceReference : set2) {
                listenerHook = this.getService(this, serviceReference, false);
                if (listenerHook == null) continue;
                try {
                    try {
                        m_secureAction.invokeServiceListenerHookRemoved(listenerHook, set);
                    }
                    catch (Throwable throwable) {
                        this.m_logger.log(serviceReference, 2, "Problem invoking service registry hook", throwable);
                        this.m_registry.ungetService(this, serviceReference, null);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.m_registry.ungetService(this, serviceReference, null);
                    throw throwable;
                }
                this.m_registry.ungetService(this, serviceReference, null);
            }
        }
        set = Collections.singleton(new ListenerInfo(bundleImpl, bundleImpl._getBundleContext(), ServiceListener.class, serviceListener, filter, null, false));
        for (ServiceReference<ListenerHook> serviceReference : set2) {
            listenerHook = this.getService(this, serviceReference, false);
            if (listenerHook == null) continue;
            try {
                try {
                    m_secureAction.invokeServiceListenerHookAdded(listenerHook, set);
                }
                catch (Throwable throwable) {
                    this.m_logger.log(serviceReference, 2, "Problem invoking service registry hook", throwable);
                    this.m_registry.ungetService(this, serviceReference, null);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.m_registry.ungetService(this, serviceReference, null);
                throw throwable;
            }
            this.m_registry.ungetService(this, serviceReference, null);
        }
    }

    void removeServiceListener(BundleImpl bundleImpl, ServiceListener serviceListener) {
        ListenerHook.ListenerInfo listenerInfo = this.m_dispatcher.removeListener(bundleImpl._getBundleContext(), ServiceListener.class, serviceListener);
        if (listenerInfo != null) {
            Set<ServiceReference<ListenerHook>> set = this.getHookRegistry().getHooks(ListenerHook.class);
            Set<ListenerHook.ListenerInfo> set2 = Collections.singleton(listenerInfo);
            for (ServiceReference<ListenerHook> serviceReference : set) {
                ListenerHook listenerHook = this.getService(this, serviceReference, false);
                if (listenerHook == null) continue;
                try {
                    try {
                        m_secureAction.invokeServiceListenerHookRemoved(listenerHook, set2);
                    }
                    catch (Throwable throwable) {
                        this.m_logger.log(serviceReference, 2, "Problem invoking service registry hook", throwable);
                        this.m_registry.ungetService(this, serviceReference, null);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.m_registry.ungetService(this, serviceReference, null);
                    throw throwable;
                }
                this.m_registry.ungetService(this, serviceReference, null);
            }
        }
    }

    void addFrameworkListener(BundleImpl bundleImpl, FrameworkListener frameworkListener) {
        this.m_dispatcher.addListener(bundleImpl._getBundleContext(), FrameworkListener.class, frameworkListener, null);
    }

    void removeFrameworkListener(BundleImpl bundleImpl, FrameworkListener frameworkListener) {
        this.m_dispatcher.removeListener(bundleImpl._getBundleContext(), FrameworkListener.class, frameworkListener);
    }

    ServiceRegistration registerService(BundleContextImpl bundleContextImpl, String[] stringArray, Object object, Dictionary dictionary) {
        ServiceRegistration<?> serviceRegistration;
        block12: {
            ListenerHook listenerHook;
            if (stringArray == null) {
                throw new NullPointerException("Service class names cannot be null.");
            }
            if (object == null) {
                throw new IllegalArgumentException("Service object cannot be null.");
            }
            serviceRegistration = null;
            if (!(object instanceof ServiceFactory)) {
                int n = 0;
                while (n < stringArray.length) {
                    Class clazz = Util.loadClassUsingClass(object.getClass(), stringArray[n], m_secureAction);
                    if (clazz == null) {
                        throw new IllegalArgumentException("Cannot cast service: " + stringArray[n]);
                    }
                    if (!clazz.isAssignableFrom(object.getClass())) {
                        throw new IllegalArgumentException("Service object is not an instance of \"" + stringArray[n] + "\".");
                    }
                    ++n;
                }
            }
            serviceRegistration = this.m_registry.registerService(bundleContextImpl.getBundle(), stringArray, object, dictionary);
            if (HookRegistry.isHook(stringArray, ListenerHook.class, object) && (listenerHook = (ListenerHook)this.getService(this, serviceRegistration.getReference(), false)) != null) {
                try {
                    try {
                        m_secureAction.invokeServiceListenerHookAdded(listenerHook, this.m_dispatcher.getAllServiceListeners());
                    }
                    catch (Throwable throwable) {
                        this.m_logger.log(serviceRegistration.getReference(), 2, "Problem invoking service registry hook", throwable);
                        this.ungetService(this, serviceRegistration.getReference(), null);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.ungetService(this, serviceRegistration.getReference(), null);
                    throw throwable;
                }
                this.ungetService(this, serviceRegistration.getReference(), null);
            }
        }
        this.fireServiceEvent(new ServiceEvent(1, serviceRegistration.getReference()), null);
        return serviceRegistration;
    }

    ServiceReference[] getServiceReferences(BundleImpl bundleImpl, String string, String string2, boolean bl) throws InvalidSyntaxException {
        Object object;
        Object object2;
        SimpleFilter simpleFilter = null;
        if (string2 != null) {
            try {
                simpleFilter = SimpleFilter.parse(string2);
            }
            catch (Exception exception) {
                throw new InvalidSyntaxException(exception.getMessage(), string2);
            }
        }
        ArrayList arrayList = this.m_registry.getServiceReferences(string, simpleFilter);
        if (bl) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (ServiceReference)object2.next();
                if (Util.isServiceAssignable(bundleImpl, (ServiceReference)object)) continue;
                object2.remove();
            }
        }
        object2 = bundleImpl == this ? new ArrayList(arrayList) : arrayList;
        object = this.getHookRegistry().getHooks(org.osgi.framework.hooks.service.FindHook.class);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ServiceReference serviceReference = (ServiceReference)iterator.next();
            org.osgi.framework.hooks.service.FindHook findHook = (org.osgi.framework.hooks.service.FindHook)this.getService(this, serviceReference, false);
            if (findHook == null) continue;
            try {
                try {
                    m_secureAction.invokeServiceFindHook(findHook, bundleImpl._getBundleContext(), string, string2, !bl, new ShrinkableCollection(arrayList));
                }
                catch (Throwable throwable) {
                    this.m_logger.log(serviceReference, 2, "Problem invoking service registry hook", throwable);
                    this.m_registry.ungetService(this, serviceReference, null);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.m_registry.ungetService(this, serviceReference, null);
                throw throwable;
            }
            this.m_registry.ungetService(this, serviceReference, null);
        }
        if (object2.size() > 0) {
            return object2.toArray(new ServiceReference[object2.size()]);
        }
        return null;
    }

    ServiceReference[] getAllowedServiceReferences(BundleImpl bundleImpl, String string, String string2, boolean bl) throws InvalidSyntaxException {
        ServiceReference[] serviceReferenceArray = this.getServiceReferences(bundleImpl, string, string2, bl);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null || serviceReferenceArray == null) {
            return serviceReferenceArray;
        }
        ArrayList<ServiceReference> arrayList = new ArrayList<ServiceReference>();
        int n = 0;
        while (n < serviceReferenceArray.length) {
            try {
                securityManager.checkPermission(new ServicePermission(serviceReferenceArray[n], "get"));
                arrayList.add(serviceReferenceArray[n]);
            }
            catch (Exception exception) {}
            ++n;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new ServiceReference[arrayList.size()]);
    }

    <S> S getService(Bundle bundle, ServiceReference<S> serviceReference, boolean bl) {
        try {
            return this.m_registry.getService(bundle, serviceReference, bl);
        }
        catch (ServiceException serviceException) {
            this.fireFrameworkEvent(2, bundle, serviceException);
            return null;
        }
    }

    boolean ungetService(Bundle bundle, ServiceReference serviceReference, Object object) {
        return this.m_registry.ungetService(bundle, serviceReference, object);
    }

    File getDataFile(BundleImpl bundleImpl, String string) {
        if (bundleImpl.getState() == 1) {
            throw new IllegalStateException("Bundle has been uninstalled");
        }
        if (Util.isFragment(this.adapt(BundleRevision.class))) {
            return null;
        }
        try {
            if (bundleImpl == this) {
                return this.m_cache.getSystemBundleDataFile(string);
            }
            return bundleImpl.getArchive().getDataFile(string);
        }
        catch (Exception exception) {
            this.m_logger.log(bundleImpl, 1, exception.getMessage());
            return null;
        }
    }

    HookRegistry getHookRegistry() {
        return this.m_registry.getHookRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle getBundle(Class clazz) {
        if (clazz.getClassLoader() instanceof BundleReference) {
            BundleReference bundleReference = (BundleReference)((Object)clazz.getClassLoader());
            return bundleReference.getBundle() instanceof BundleImpl && ((BundleImpl)bundleReference.getBundle()).getFramework() == this ? bundleReference.getBundle() : null;
        }
        if (!clazz.getName().startsWith("java.")) {
            Boolean bl;
            Object object = this.m_systemBundleClassCache;
            synchronized (object) {
                bl = this.m_systemBundleClassCache.get(clazz);
            }
            if (bl == null) {
                object = null;
                try {
                    object = ((BundleWiringImpl)this.m_extensionManager.getRevision().getWiring()).getClassByDelegation(clazz.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {}
                Map<Class, Boolean> map = this.m_systemBundleClassCache;
                synchronized (map) {
                    bl = object == clazz ? Boolean.TRUE : Boolean.FALSE;
                    this.m_systemBundleClassCache.put(clazz, bl);
                }
            }
            return bl != false ? this : null;
        }
        return null;
    }

    ExportedPackage[] getExportedPackages(String string) {
        Map<String, Object> map = Collections.singletonMap("osgi.wiring.package", string);
        BundleRequirementImpl bundleRequirementImpl = new BundleRequirementImpl(null, "osgi.wiring.package", Collections.EMPTY_MAP, map);
        List<BundleCapability> list = this.m_resolver.findProviders(bundleRequirementImpl, false);
        Object object = list.iterator();
        while (object.hasNext()) {
            if (object.next().getRevision().getWiring() != null) continue;
            object.remove();
        }
        if (list != null) {
            object = new ArrayList();
            Iterator<BundleCapability> iterator = list.iterator();
            while (iterator.hasNext()) {
                Bundle bundle = iterator.next().getRevision().getBundle();
                List<BundleRevision> list2 = bundle.adapt(BundleRevisions.class).getRevisions();
                int n = list2.size() - 1;
                while (n >= 0) {
                    BundleRevision bundleRevision = list2.get(n);
                    List<BundleRevision> list3 = Collections.singletonList(bundleRevision);
                    if ((bundleRevision.getTypes() & 1) != 0) {
                        list3 = new ArrayList<BundleRevision>();
                        for (BundleWire bundleWire : bundleRevision.getWiring().getRequiredWires("osgi.wiring.host")) {
                            list3.add(bundleWire.getProviderWiring().getRevision());
                        }
                    }
                    for (BundleRevision bundleRevision2 : list3) {
                        List<BundleCapability> list4 = bundleRevision2.getWiring() == null ? bundleRevision2.getDeclaredCapabilities(null) : bundleRevision2.getWiring().getCapabilities(null);
                        for (BundleCapability bundleCapability : list4) {
                            if (!bundleCapability.getNamespace().equals(bundleRequirementImpl.getNamespace()) || !CapabilitySet.matches(bundleCapability, bundleRequirementImpl.getFilter())) continue;
                            object.add(new ExportedPackageImpl(this, (BundleImpl)bundleRevision2.getBundle(), bundleRevision2, bundleCapability));
                        }
                    }
                    --n;
                }
            }
            return object.isEmpty() ? null : object.toArray(new ExportedPackage[object.size()]);
        }
        return null;
    }

    ExportedPackage[] getExportedPackages(Bundle bundle) {
        ArrayList arrayList = new ArrayList();
        if (bundle != null) {
            BundleImpl bundleImpl = (BundleImpl)bundle;
            this.getExportedPackages(bundleImpl, arrayList);
        } else {
            boolean bl = this.acquireGlobalLock();
            if (!bl) {
                throw new IllegalStateException("Unable to acquire global lock to retrieve exported packages.");
            }
            try {
                int n = 0;
                while (this.m_uninstalledBundles != null && n < this.m_uninstalledBundles.size()) {
                    BundleImpl bundleImpl = this.m_uninstalledBundles.get(n);
                    this.getExportedPackages(bundleImpl, arrayList);
                    ++n;
                }
                Bundle[] bundleArray = this.getBundles();
                int n2 = 0;
                while (n2 < bundleArray.length) {
                    BundleImpl bundleImpl = (BundleImpl)bundleArray[n2];
                    this.getExportedPackages(bundleImpl, arrayList);
                    ++n2;
                }
            }
            finally {
                this.releaseGlobalLock();
            }
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
    }

    private void getExportedPackages(Bundle bundle, List list) {
        for (BundleRevision bundleRevision : bundle.adapt(BundleRevisions.class).getRevisions()) {
            List<BundleCapability> list2;
            List<BundleCapability> list3 = list2 = bundleRevision.getWiring() == null ? bundleRevision.getDeclaredCapabilities(null) : bundleRevision.getWiring().getCapabilities(null);
            if (list2 == null || list2.size() <= 0) continue;
            for (BundleCapability bundleCapability : list2) {
                if (!bundleCapability.getNamespace().equals("osgi.wiring.package")) continue;
                String cfr_ignored_0 = (String)bundleCapability.getAttributes().get("osgi.wiring.package");
                list.add(new ExportedPackageImpl(this, (BundleImpl)bundle, bundleRevision, bundleCapability));
            }
        }
    }

    Set<Bundle> getImportingBundles(BundleImpl bundleImpl, BundleCapability bundleCapability) {
        return this.m_dependencies.getImportingBundles(bundleImpl, bundleCapability);
    }

    Set<Bundle> getRequiringBundles(BundleImpl bundleImpl) {
        return this.m_dependencies.getRequiringBundles(bundleImpl);
    }

    boolean resolveBundles(Collection<Bundle> collection) {
        boolean bl = this.acquireGlobalLock();
        if (!bl) {
            this.m_logger.log(2, "Unable to acquire global lock to perform resolve.", null);
            return false;
        }
        try {
            boolean bl2;
            block12: {
                Collection<Bundle> collection2 = collection;
                if (collection == null) {
                    collection = this.m_installedBundles[0].values();
                }
                bl2 = true;
                if (!collection.isEmpty()) {
                    HashSet<BundleRevision> hashSet = new HashSet<BundleRevision>(collection.size());
                    for (Bundle object : collection) {
                        if (object.getState() == 1) continue;
                        hashSet.add(object.adapt(BundleRevision.class));
                    }
                    if (collection2 != null && collection2.size() != hashSet.size()) {
                        bl2 = false;
                    }
                    try {
                        this.m_resolver.resolve(Collections.EMPTY_SET, hashSet);
                        if (!bl2) break block12;
                        for (BundleRevision bundleRevision : hashSet) {
                            if (bundleRevision.getWiring() != null) continue;
                            bl2 = false;
                            break;
                        }
                    }
                    catch (ResolutionException resolutionException) {
                        bl2 = false;
                    }
                    catch (BundleException bundleException) {
                        bl2 = false;
                    }
                }
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            this.releaseGlobalLock();
        }
    }

    private void resolveBundleRevision(BundleRevision bundleRevision) throws BundleException {
        try {
            this.m_resolver.resolve(Collections.singleton(bundleRevision), Collections.EMPTY_SET);
        }
        catch (ResolutionException resolutionException) {
            throw new BundleException(String.valueOf(resolutionException.getMessage()) + " Unresolved requirements: " + resolutionException.getUnresolvedRequirements(), 4);
        }
    }

    void refreshPackages(Collection<Bundle> abstractCollection, FrameworkListener[] frameworkListenerArray) {
        Object object;
        Object object22;
        AbstractCollection abstractCollection2;
        boolean bl = this.acquireGlobalLock();
        if (!bl) {
            throw new IllegalStateException("Unable to acquire global lock for refresh.");
        }
        AbstractCollection abstractCollection3 = abstractCollection;
        if (abstractCollection3 == null) {
            abstractCollection2 = new ArrayList();
            int n = 0;
            while (this.m_uninstalledBundles != null && n < this.m_uninstalledBundles.size()) {
                abstractCollection2.add((Bundle)this.m_uninstalledBundles.get(n));
                ++n;
            }
            for (Object object22 : this.m_installedBundles[0].values()) {
                if (!((BundleImpl)object22).isRemovalPending()) continue;
                abstractCollection2.add(object22);
            }
            if (!abstractCollection2.isEmpty()) {
                abstractCollection3 = abstractCollection2;
            }
        }
        abstractCollection2 = null;
        if (abstractCollection3 != null) {
            abstractCollection2 = new HashSet();
            for (Object object3 : abstractCollection3) {
                if (object3 == null) continue;
                abstractCollection2.add(object3);
                this.populateDependentGraph((BundleImpl)object3, (Set<Bundle>)((Object)abstractCollection2));
            }
        }
        try {
            boolean bl2 = false;
            object22 = this;
            if (abstractCollection2 != null) {
                for (Object object4 : abstractCollection2) {
                    if (object22 != object4 && !((BundleImpl)object4).isExtension()) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    Object object52;
                    Object object4;
                    object4 = new ArrayList(abstractCollection2.size());
                    for (Object object52 : abstractCollection2) {
                        this.forgetUninstalledBundle((BundleImpl)object52);
                        object4.add(new RefreshHelper((Bundle)object52));
                    }
                    object = object4.iterator();
                    while (object.hasNext()) {
                        object52 = (RefreshHelper)object.next();
                        if (object52 == null) continue;
                        ((RefreshHelper)object52).stop();
                    }
                    object = object4.iterator();
                    while (object.hasNext()) {
                        object52 = (RefreshHelper)object.next();
                        if (object52 == null) continue;
                        ((RefreshHelper)object52).refreshOrRemove();
                    }
                    object = object4.iterator();
                    while (object.hasNext()) {
                        object52 = (RefreshHelper)object.next();
                        if (object52 == null) continue;
                        ((RefreshHelper)object52).restart();
                    }
                } else {
                    try {
                        this.update();
                    }
                    catch (BundleException bundleException) {
                        this.m_logger.log(1, "Framework restart error.", bundleException);
                    }
                }
            }
        }
        finally {
            this.releaseGlobalLock();
        }
        this.fireFrameworkEvent(4, this, null);
        if (frameworkListenerArray != null) {
            FrameworkEvent frameworkEvent = new FrameworkEvent(4, this, null);
            object = frameworkListenerArray;
            int n = frameworkListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                object22 = object[n2];
                try {
                    object22.frameworkEvent(frameworkEvent);
                }
                catch (Throwable throwable) {
                    this.m_logger.log(1, "Framework listener delivery error.", throwable);
                }
                ++n2;
            }
        }
    }

    Collection<Bundle> getDependencyClosure(Collection<Bundle> collection) {
        boolean bl = this.acquireGlobalLock();
        if (!bl) {
            throw new IllegalStateException("Unable to acquire global lock for refresh.");
        }
        try {
            HashSet<Bundle> hashSet = Collections.EMPTY_SET;
            if (collection != null) {
                hashSet = new HashSet<Bundle>();
                for (Bundle bundle : collection) {
                    hashSet.add(bundle);
                    this.populateDependentGraph((BundleImpl)bundle, hashSet);
                }
            }
            HashSet<Bundle> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this.releaseGlobalLock();
        }
    }

    private void populateDependentGraph(BundleImpl bundleImpl, Set<Bundle> set) {
        Set<Bundle> set2 = this.m_dependencies.getDependentBundles(bundleImpl);
        if (set2 != null) {
            for (Bundle bundle : set2) {
                if (set.contains(bundle)) continue;
                set.add(bundle);
                this.populateDependentGraph((BundleImpl)bundle, set);
            }
        }
    }

    Collection<Bundle> getRemovalPendingBundles() {
        boolean bl = this.acquireGlobalLock();
        if (!bl) {
            throw new IllegalStateException("Unable to acquire global lock for refresh.");
        }
        try {
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
            if (this.m_uninstalledBundles != null) {
                for (Bundle bundle : this.m_uninstalledBundles) {
                    arrayList.add(bundle);
                }
            }
            Bundle[] bundleArray = this.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (((BundleImpl)bundle).isRemovalPending()) {
                    arrayList.add(bundle);
                }
                ++n2;
            }
            ArrayList<Bundle> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.releaseGlobalLock();
        }
    }

    SecurityProvider getSecurityProvider() {
        return this.m_securityProvider;
    }

    void setSecurityProvider(SecurityProvider securityProvider) {
        this.m_securityProvider = securityProvider;
    }

    Object getSignerMatcher(BundleImpl bundleImpl, int n) {
        if (bundleImpl != this && this.m_securityProvider != null) {
            return this.m_securityProvider.getSignerMatcher(bundleImpl, n);
        }
        return new HashMap();
    }

    boolean impliesBundlePermission(BundleProtectionDomain bundleProtectionDomain, Permission permission, boolean bl) {
        if (bl && permission instanceof PackagePermission && bundleProtectionDomain.impliesWoven(permission)) {
            return true;
        }
        if (this.m_securityProvider != null) {
            return this.m_securityProvider.hasBundlePermission(bundleProtectionDomain, permission, bl);
        }
        BundleImpl bundleImpl = bundleProtectionDomain.getBundle();
        return this.m_securityDefaultPolicy && (bundleImpl == null || bundleImpl.getBundleId() != 0L) ? bundleProtectionDomain.superImplies(permission) : true;
    }

    private BundleActivator createBundleActivator(Bundle bundle) throws Exception {
        BundleActivator bundleActivator = null;
        Map map = ((BundleRevisionImpl)bundle.adapt(BundleRevision.class)).getHeaders();
        String string = (String)map.get("Bundle-Activator");
        if (string != null) {
            Class clazz;
            string = string.trim();
            try {
                clazz = ((BundleWiringImpl)bundle.adapt(BundleRevision.class).getWiring()).getClassByDelegation(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new BundleException("Not found: " + string, classNotFoundException);
            }
            bundleActivator = (BundleActivator)clazz.newInstance();
        }
        return bundleActivator;
    }

    private void refreshBundle(BundleImpl bundleImpl) throws Exception {
        try {
            this.acquireBundleLock(bundleImpl, 6);
        }
        catch (IllegalStateException illegalStateException) {
            throw new BundleException("Bundle state has changed unexpectedly during refresh.");
        }
        try {
            try {
                boolean bl = bundleImpl.getState() != 2;
                this.m_dependencies.removeDependencies(bundleImpl);
                bundleImpl.refresh();
                if (bl) {
                    this.setBundleStateAndNotify(bundleImpl, 2);
                    this.fireBundleEvent(64, bundleImpl);
                }
            }
            catch (Exception exception) {
                this.fireFrameworkEvent(2, bundleImpl, exception);
                this.releaseBundleLock(bundleImpl);
            }
        }
        finally {
            this.releaseBundleLock(bundleImpl);
        }
    }

    void fireFrameworkEvent(int n, Bundle bundle, Throwable throwable) {
        this.m_dispatcher.fireFrameworkEvent(new FrameworkEvent(n, bundle, throwable));
    }

    void fireBundleEvent(int n, Bundle bundle) {
        this.m_dispatcher.fireBundleEvent(new BundleEvent(n, bundle), this);
    }

    void fireBundleEvent(int n, Bundle bundle, Bundle bundle2) {
        this.m_dispatcher.fireBundleEvent(new BundleEvent(n, bundle, bundle2), this);
    }

    private void fireServiceEvent(ServiceEvent serviceEvent, Dictionary dictionary) {
        this.m_dispatcher.fireServiceEvent(serviceEvent, dictionary, this);
    }

    private void initializeFrameworkProperties() {
        this.m_configMutableMap.put("org.osgi.framework.version", "1.8");
        this.m_configMutableMap.put("org.osgi.framework.vendor", "Apache Software Foundation");
        this.m_configMutableMap.put("org.osgi.framework.language", System.getProperty("user.language"));
        this.m_configMutableMap.put("org.osgi.framework.os.version", System.getProperty("os.version"));
        this.m_configMutableMap.put("org.osgi.supports.framework.extension", "true");
        this.m_configMutableMap.put("org.osgi.supports.framework.fragment", "true");
        this.m_configMutableMap.put("org.osgi.supports.framework.requirebundle", "true");
        this.m_configMutableMap.put("org.osgi.supports.bootclasspath.extension", "false");
        String string = null;
        string = NativeLibraryClause.normalizeOSName(System.getProperty("os.name"));
        this.m_configMutableMap.put("org.osgi.framework.os.name", string);
        string = NativeLibraryClause.normalizeProcessor(System.getProperty("os.arch"));
        this.m_configMutableMap.put("org.osgi.framework.processor", string);
        this.m_configMutableMap.put("felix.version", "2.0.2");
        Properties properties = Util.loadDefaultProperties(this.m_logger);
        this.loadFromDefaultIfNotDefined(properties, "org.osgi.framework.executionenvironment");
        this.loadPrefixFromDefaultIfNotDefined(this.m_configMutableMap, properties, "felix.native.osname.alias");
        this.loadPrefixFromDefaultIfNotDefined(this.m_configMutableMap, properties, "felix.native.processor.alias");
    }

    private void loadFromDefaultIfNotDefined(Properties properties, String string) {
        String string2;
        if (!this.getConfig().containsKey(string) && (string2 = Util.getDefaultProperty(this.m_logger, string)) != null) {
            this.m_configMutableMap.put(string, string2);
        }
    }

    private void loadPrefixFromDefaultIfNotDefined(Map map, Properties properties, String string) {
        Map<String, String> map2 = Util.getDefaultPropertiesWithPrefix(properties, string);
        for (String string2 : map2.keySet()) {
            if (map.containsKey(string2)) continue;
            map.put(string2, map2.get(string2));
        }
    }

    private static String cleanMavenVersion(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            switch (stringBuffer.charAt(n2)) {
                case '.': {
                    ++n;
                    break;
                }
                case '-': {
                    if (n >= 3) break;
                    stringBuffer.setCharAt(n2, '.');
                    int n3 = n;
                    while (n3 < 2) {
                        stringBuffer.insert(n2, ".0");
                        ++n3;
                    }
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long loadNextId() {
        Object object = this.m_nextIdLock;
        synchronized (object) {
            FileInputStream fileInputStream = null;
            BufferedReader bufferedReader = null;
            try {
                File file = this.m_cache.getSystemBundleDataFile("bundle.id");
                fileInputStream = m_secureAction.getFileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                long l = Long.parseLong(bufferedReader.readLine());
                return l;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                this.m_logger.log(2, "Unable to initialize next bundle identifier from persistent storage.", exception);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (Exception exception) {
                    this.m_logger.log(2, "Unable to close next bundle identifier file.", exception);
                }
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextId() {
        Object object = this.m_nextIdLock;
        synchronized (object) {
            long l;
            block20: {
                l = this.m_nextId++;
                OutputStream outputStream = null;
                BufferedWriter bufferedWriter = null;
                try {
                    try {
                        File file = this.m_cache.getSystemBundleDataFile("bundle.id");
                        outputStream = m_secureAction.getFileOutputStream(file);
                        bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                        String string = Long.toString(this.m_nextId);
                        bufferedWriter.write(string, 0, string.length());
                    }
                    catch (Exception exception) {
                        this.m_logger.log(2, "Unable to save next bundle identifier to persistent storage.", exception);
                        try {
                            if (bufferedWriter != null) {
                                bufferedWriter.close();
                            }
                            if (outputStream != null) {
                                outputStream.close();
                            }
                            break block20;
                        }
                        catch (Exception exception2) {
                            this.m_logger.log(2, "Unable to close next bundle identifier file.", exception2);
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        this.m_logger.log(2, "Unable to close next bundle identifier file.", exception);
                    }
                    throw throwable;
                }
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception exception) {
                    this.m_logger.log(2, "Unable to close next bundle identifier file.", exception);
                }
            }
            return l;
        }
    }

    private void rememberUninstalledBundle(BundleImpl bundleImpl) {
        boolean bl = this.acquireGlobalLock();
        if (!bl) {
            throw new IllegalStateException("Unable to acquire global lock to record uninstalled bundle.");
        }
        try {
            int n = 0;
            while (this.m_uninstalledBundles != null && n < this.m_uninstalledBundles.size()) {
                if (this.m_uninstalledBundles.get(n) == bundleImpl) {
                    return;
                }
                ++n;
            }
            ArrayList<BundleImpl> arrayList = new ArrayList<BundleImpl>(this.m_uninstalledBundles);
            arrayList.add(bundleImpl);
            this.m_uninstalledBundles = arrayList;
        }
        finally {
            this.releaseGlobalLock();
        }
    }

    private void forgetUninstalledBundle(BundleImpl bundleImpl) {
        boolean bl = this.acquireGlobalLock();
        if (!bl) {
            throw new IllegalStateException("Unable to acquire global lock to release uninstalled bundle.");
        }
        try {
            if (this.m_uninstalledBundles == null) {
                return;
            }
            ArrayList<BundleImpl> arrayList = new ArrayList<BundleImpl>(this.m_uninstalledBundles);
            arrayList.remove(bundleImpl);
            this.m_uninstalledBundles = arrayList;
        }
        finally {
            this.releaseGlobalLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireInstallLock(String string) throws BundleException {
        Object[] objectArray = this.m_installRequestLock_Priority1;
        synchronized (this.m_installRequestLock_Priority1) {
            while (this.m_installRequestMap.get(string) != null) {
                try {
                    this.m_installRequestLock_Priority1.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new BundleException("Unable to install, thread interrupted.");
                }
            }
            this.m_installRequestMap.put(string, string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseInstallLock(String string) {
        Object[] objectArray = this.m_installRequestLock_Priority1;
        synchronized (this.m_installRequestLock_Priority1) {
            this.m_installRequestMap.remove(string);
            this.m_installRequestLock_Priority1.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBundleStateAndNotify(BundleImpl bundleImpl, int n) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            bundleImpl.__setState(n);
            this.m_bundleLock.notifyAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireBundleLock(BundleImpl bundleImpl, int n) throws IllegalStateException {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            while (!bundleImpl.isLockable() || this.m_globalLockThread != null && this.m_globalLockThread != Thread.currentThread() && bundleImpl.getLockingThread() != Thread.currentThread()) {
                if ((n & bundleImpl.getState()) == 0) {
                    throw new IllegalStateException("Bundle in unexpected state.");
                }
                if (this.m_globalLockThread == Thread.currentThread() && bundleImpl.getLockingThread() != null && this.m_globalLockWaitersList.contains(bundleImpl.getLockingThread())) {
                    bundleImpl.getLockingThread().interrupt();
                }
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Unable to acquire bundle lock, thread interrupted.");
                }
            }
            if ((n & bundleImpl.getState()) == 0) {
                throw new IllegalStateException("Bundle in unexpected state.");
            }
            bundleImpl.lock();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseBundleLock(BundleImpl bundleImpl) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            bundleImpl.unlock();
            if (bundleImpl.getLockingThread() == null) {
                this.m_bundleLock.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean acquireGlobalLock() {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            boolean bl = false;
            while (!bl && this.m_globalLockThread != null && this.m_globalLockThread != Thread.currentThread()) {
                this.m_globalLockWaitersList.add(Thread.currentThread());
                this.m_bundleLock.notifyAll();
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
                this.m_globalLockWaitersList.remove(Thread.currentThread());
            }
            if (!bl) {
                ++this.m_globalLockCount;
                this.m_globalLockThread = Thread.currentThread();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseGlobalLock() {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            if (this.m_globalLockThread == Thread.currentThread()) {
                --this.m_globalLockCount;
                if (this.m_globalLockCount == 0) {
                    this.m_globalLockThread = null;
                    this.m_bundleLock.notifyAll();
                }
            } else {
                throw new IllegalStateException("The current thread doesn't own the global lock.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void setURLHandlersActivator(URLHandlersActivator uRLHandlersActivator) {
        this.m_urlHandlersActivator = uRLHandlersActivator;
    }

    Object getStreamHandlerService(String string) {
        return this.m_urlHandlersActivator.getStreamHandlerService(string);
    }

    Object getContentHandlerService(String string) {
        return this.m_urlHandlersActivator.getContentHandlerService(string);
    }

    Collection<BundleCapability> findProviders(Requirement requirement) {
        return this.m_resolver.findProvidersInternal(null, requirement, true, false);
    }

    private class RefreshHelper {
        private BundleImpl m_bundle = null;
        private int m_oldState = 2;

        public RefreshHelper(Bundle bundle) {
            this.m_bundle = (BundleImpl)bundle;
        }

        public void stop() {
            Felix.this.acquireBundleLock(this.m_bundle, 63);
            try {
                try {
                    this.m_oldState = this.m_bundle.getState();
                    if (this.m_oldState != 1 && !Util.isFragment(this.m_bundle.adapt(BundleRevision.class))) {
                        Felix.this.stopBundle(this.m_bundle, false);
                    }
                }
                catch (Throwable throwable) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, throwable);
                    Felix.this.releaseBundleLock(this.m_bundle);
                }
            }
            finally {
                Felix.this.releaseBundleLock(this.m_bundle);
            }
        }

        public void refreshOrRemove() {
            try {
                if (this.m_bundle.getState() == 1) {
                    Felix.this.m_dependencies.removeDependencies(this.m_bundle);
                    this.m_bundle.closeAndDelete();
                    this.m_bundle = null;
                } else {
                    Felix.this.refreshBundle(this.m_bundle);
                }
            }
            catch (Throwable throwable) {
                Felix.this.fireFrameworkEvent(2, this.m_bundle, throwable);
            }
        }

        public void restart() {
            if (this.m_bundle != null && this.m_oldState == 32) {
                try {
                    int n = 1;
                    n = this.m_bundle.getPersistentState() == 8 ? n | 2 : n;
                    Felix.this.startBundle(this.m_bundle, n);
                }
                catch (Throwable throwable) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, throwable);
                }
            }
        }
    }

    private static class StartLevelTuple
    implements Comparable<StartLevelTuple> {
        private final BundleImpl m_bundle;
        private int m_level;

        StartLevelTuple(BundleImpl bundleImpl, int n) {
            this.m_bundle = bundleImpl;
            this.m_level = n;
        }

        @Override
        public int compareTo(StartLevelTuple startLevelTuple) {
            int n = 1;
            if (this.m_level < startLevelTuple.m_level) {
                n = -1;
            } else if (this.m_level > startLevelTuple.m_level) {
                n = 1;
            } else if (this.m_bundle.getBundleId() < startLevelTuple.m_bundle.getBundleId()) {
                n = -1;
            } else if (this.m_bundle.getBundleId() == startLevelTuple.m_bundle.getBundleId()) {
                n = 0;
            }
            return n;
        }
    }

    class SystemBundleActivator
    implements BundleActivator {
        SystemBundleActivator() {
        }

        @Override
        public void start(BundleContext bundleContext) throws Exception {
            Felix.this.m_activatorList.add(0, new URLHandlersActivator(Felix.this.m_configMap, Felix.this));
            Iterator iterator = Felix.this.m_activatorList.iterator();
            while (iterator.hasNext()) {
                try {
                    m_secureAction.startActivator((BundleActivator)iterator.next(), bundleContext);
                }
                catch (Throwable throwable) {
                    iterator.remove();
                    Felix.this.fireFrameworkEvent(2, bundleContext.getBundle(), new BundleException("Unable to start Bundle", throwable));
                    Felix.this.m_logger.log(2, "Exception starting a system bundle activator.", throwable);
                }
            }
        }

        @Override
        public void stop(BundleContext bundleContext) {
            Felix.this.acquireBundleLock(Felix.this, 16);
            Felix.this.releaseBundleLock(Felix.this);
            Felix.this.m_fwkStartLevel.setStartLevelAndWait(0);
            Felix.this.m_fwkWiring.stop();
            Felix.this.m_fwkStartLevel.stop();
            Felix.this.m_dispatcher.stopDispatching();
            Bundle[] bundleArray = Felix.this.getBundles();
            int n = 0;
            while (n < bundleArray.length) {
                BundleImpl bundleImpl = (BundleImpl)bundleArray[n];
                if (bundleImpl.isRemovalPending()) {
                    try {
                        Felix.this.refreshBundle(bundleImpl);
                    }
                    catch (Exception exception) {
                        Felix.this.fireFrameworkEvent(2, bundleImpl, exception);
                        Felix.this.m_logger.log(bundleImpl, 1, "Unable to purge bundle " + bundleImpl._getLocation(), (Throwable)exception);
                    }
                }
                ++n;
            }
            n = 0;
            while (Felix.this.m_uninstalledBundles != null && n < Felix.this.m_uninstalledBundles.size()) {
                try {
                    ((BundleImpl)Felix.this.m_uninstalledBundles.get(n)).closeAndDelete();
                }
                catch (Exception exception) {
                    Felix.this.m_logger.log((Bundle)Felix.this.m_uninstalledBundles.get(n), 1, "Unable to remove " + ((BundleImpl)Felix.this.m_uninstalledBundles.get(n))._getLocation(), (Throwable)exception);
                }
                ++n;
            }
            bundleArray = Felix.this.getBundles();
            n = 0;
            while (n < bundleArray.length) {
                ((BundleImpl)bundleArray[n]).close();
                ++n;
            }
            Felix.this.m_extensionManager.stopExtensionBundles(Felix.this);
            n = 0;
            while (n < Felix.this.m_activatorList.size()) {
                try {
                    m_secureAction.stopActivator((BundleActivator)Felix.this.m_activatorList.get(n), Felix.this._getBundleContext());
                }
                catch (Throwable throwable) {
                    Felix.this.fireFrameworkEvent(2, bundleContext.getBundle(), new BundleException("Unable to stop Bundle", throwable));
                    Felix.this.m_logger.log(2, "Exception stopping a system bundle activator.", throwable);
                }
                ++n;
            }
            if (Felix.this.m_securityManager != null) {
                System.setSecurityManager(null);
                Felix.this.m_securityManager = null;
            }
            Felix.this.m_dependencies.removeDependents(Felix.this.adapt(BundleRevision.class));
            if (Felix.this.m_extensionManager != null) {
                Felix.this.m_extensionManager.removeExtensions(Felix.this);
            }
            Felix.this.m_cache.release();
            Felix.this.m_cache = null;
            Felix.this.acquireBundleLock(Felix.this, 16);
            try {
                ((BundleContextImpl)Felix.this._getBundleContext()).invalidate();
                Felix.this.setBundleContext(null);
                Felix.this.setBundleStateAndNotify(Felix.this, 4);
                Felix.this.m_shutdownGate.open();
                Felix.this.m_shutdownGate = null;
            }
            finally {
                Felix.this.releaseBundleLock(Felix.this);
            }
        }
    }
}

