/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.util.ImmutableList;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.NativeLibrary;
import org.apache.felix.framework.util.manifestparser.NativeLibraryClause;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.apache.felix.framework.wiring.BundleWireImpl;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

class ExtensionManager
extends URLStreamHandler
implements Content {
    static final ExtensionManager m_extensionManager;
    private final Logger m_logger;
    private final Map m_configMap;
    private final Map m_headerMap = new StringMap();
    private final BundleRevision m_systemBundleRevision;
    private volatile List<BundleCapability> m_capabilities = Collections.EMPTY_LIST;
    private volatile Set<String> m_exportNames = Collections.EMPTY_SET;
    private volatile Object m_securityContext = null;
    private final List m_extensions;
    private volatile Bundle[] m_extensionsCache;
    private final Set m_names;
    private final Map m_sourceToExtensions;
    private final List<ExtensionTuple> m_extensionTuples = Collections.synchronizedList(new ArrayList());

    static {
        ExtensionManager extensionManager = null;
        if (!"true".equalsIgnoreCase(Felix.m_secureAction.getSystemProperty("felix.extensions.disable", "false"))) {
            try {
                new URL("http://felix.extensions:9/").openConnection();
            }
            catch (Throwable throwable) {}
            try {
                extensionManager = new ExtensionManager();
                Felix.m_secureAction.addURLToURLClassLoader(Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "http:", extensionManager), "http://felix.extensions:9/", extensionManager), Felix.class.getClassLoader());
            }
            catch (Throwable throwable) {
                extensionManager = null;
            }
        }
        m_extensionManager = extensionManager;
    }

    private ExtensionManager() {
        this.m_logger = null;
        this.m_configMap = null;
        this.m_systemBundleRevision = null;
        this.m_extensions = new ArrayList();
        this.m_extensionsCache = new Bundle[0];
        this.m_names = new HashSet();
        this.m_sourceToExtensions = new HashMap();
    }

    ExtensionManager(Logger logger, Map map, Felix felix) {
        this.m_logger = logger;
        this.m_configMap = map;
        this.m_systemBundleRevision = new ExtensionManagerRevision(felix);
        this.m_extensions = null;
        this.m_extensionsCache = null;
        this.m_names = null;
        this.m_sourceToExtensions = null;
        this.m_headerMap.put("Bundle-Version", this.m_configMap.get("felix.version"));
        this.m_headerMap.put("Bundle-SymbolicName", "org.apache.felix.framework");
        this.m_headerMap.put("Bundle-Name", "System Bundle");
        this.m_headerMap.put("Bundle-Description", "This bundle is system specific; it implements various system services.");
        this.m_headerMap.put("Export-Service", "org.osgi.service.packageadmin.PackageAdmin,org.osgi.service.startlevel.StartLevel,org.osgi.service.url.URLHandlers");
        String string = (String)this.m_configMap.get("org.osgi.framework.system.packages");
        string = string == null ? Util.getDefaultProperty(logger, "org.osgi.framework.system.packages") : string;
        string = string == null ? "" : string;
        String string2 = (String)this.m_configMap.get("org.osgi.framework.system.packages.extra");
        string = string2 == null || string2.trim().length() == 0 ? string : String.valueOf(string) + "," + string2;
        this.m_headerMap.put("Bundle-ManifestVersion", "2");
        this.m_headerMap.put("Export-Package", string);
        String string3 = (String)this.m_configMap.get("org.osgi.framework.system.capabilities");
        string3 = string3 == null ? Util.getDefaultProperty(logger, "org.osgi.framework.system.capabilities") : string3;
        string3 = string3 == null ? "" : string3;
        String string4 = (String)this.m_configMap.get("org.osgi.framework.system.capabilities.extra");
        string3 = string4 == null || string4.trim().length() == 0 ? string3 : String.valueOf(string3) + "," + string4;
        this.m_headerMap.put("Provide-Capability", string3);
        try {
            ManifestParser manifestParser = new ManifestParser(this.m_logger, this.m_configMap, this.m_systemBundleRevision, this.m_headerMap);
            List<BundleCapability> list = ExtensionManager.aliasSymbolicName(manifestParser.getCapabilities());
            list.add(this.buildNativeCapabilites());
            this.appendCapabilities(list);
        }
        catch (Exception exception) {
            this.m_capabilities = Collections.EMPTY_LIST;
            this.m_logger.log(1, "Error parsing system bundle export statement: " + string, exception);
        }
    }

    protected BundleCapability buildNativeCapabilites() {
        String string = (String)this.m_configMap.get("org.osgi.framework.processor");
        String string2 = (String)this.m_configMap.get("org.osgi.framework.os.name");
        String string3 = (String)this.m_configMap.get("org.osgi.framework.os.version");
        String string4 = (String)this.m_configMap.get("org.osgi.framework.language");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this.m_configMap);
        if (string != null) {
            hashMap.put("osgi.native.processor", NativeLibraryClause.getProcessorWithAliases(string));
        }
        if (string2 != null) {
            hashMap.put("osgi.native.osname", NativeLibraryClause.getOsNameWithAliases(string2));
        }
        if (string3 != null) {
            string3 = NativeLibraryClause.formatOSVersion(string3);
            hashMap.put("osgi.native.osversion", Version.parseVersion(string3));
        }
        if (string4 != null) {
            hashMap.put("osgi.native.language", string4);
        }
        return new BundleCapabilityImpl(this.getRevision(), "osgi.native", Collections.<String, String>emptyMap(), hashMap);
    }

    private static List<BundleCapability> aliasSymbolicName(List<BundleCapability> list) {
        if (list == null) {
            return new ArrayList<BundleCapability>(0);
        }
        ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>(list);
        String[] stringArray = new String[]{"org.apache.felix.framework", "system.bundle"};
        int n = 0;
        while (n < arrayList.size()) {
            BundleCapability bundleCapability = (BundleCapability)arrayList.get(n);
            if (bundleCapability.getNamespace().equals("osgi.wiring.bundle") || bundleCapability.getNamespace().equals("osgi.wiring.host")) {
                Map.Entry<String, Object> entry = new HashMap<String, Object>(bundleCapability.getAttributes());
                entry.put(bundleCapability.getNamespace(), stringArray);
                bundleCapability = new BundleCapabilityImpl(bundleCapability.getRevision(), bundleCapability.getNamespace(), bundleCapability.getDirectives(), (Map<String, Object>)((Object)entry));
                arrayList.set(n, bundleCapability);
            }
            for (Map.Entry<String, Object> entry : bundleCapability.getAttributes().entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("bundle-symbolic-name")) continue;
                HashMap<String, Object> hashMap = new HashMap<String, Object>(bundleCapability.getAttributes());
                hashMap.put("bundle-symbolic-name", stringArray);
                arrayList.set(n, new BundleCapabilityImpl(bundleCapability.getRevision(), bundleCapability.getNamespace(), bundleCapability.getDirectives(), hashMap));
                break;
            }
            ++n;
        }
        return arrayList;
    }

    public BundleRevision getRevision() {
        return this.m_systemBundleRevision;
    }

    public Object getSecurityContext() {
        return this.m_securityContext;
    }

    public synchronized void setSecurityContext(Object object) {
        this.m_securityContext = object;
    }

    synchronized void addExtensionBundle(Felix felix, BundleImpl bundleImpl) throws SecurityException, BundleException, Exception {
        String string;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(bundleImpl, "extensionLifecycle"));
            if (!((BundleProtectionDomain)bundleImpl.getProtectionDomain()).impliesDirect(new AllPermission())) {
                throw new SecurityException("Extension Bundles must have AllPermission");
            }
        }
        if (!"framework".equals(string = ManifestParser.parseExtensionBundleHeader((String)((BundleRevisionImpl)bundleImpl.adapt(BundleRevision.class)).getHeaders().get("Fragment-Host")))) {
            throw new BundleException("Unsupported Extension Bundle type: " + string, new UnsupportedOperationException("Unsupported Extension Bundle type!"));
        }
        Object object = null;
        try {
            object = ManifestParser.parseExportHeader(this.m_logger, this.m_systemBundleRevision, (String)bundleImpl.adapt(BundleRevisionImpl.class).getHeaders().get("Export-Package"), this.m_systemBundleRevision.getSymbolicName(), this.m_systemBundleRevision.getVersion());
            object = ExtensionManager.aliasSymbolicName(object);
        }
        catch (Exception exception) {
            this.m_logger.log(bundleImpl, 1, "Error parsing extension bundle export statement: " + bundleImpl.adapt(BundleRevisionImpl.class).getHeaders().get("Export-Package"), (Throwable)exception);
            return;
        }
        if (m_extensionManager == null) {
            this.m_logger.log(bundleImpl, 2, "Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
            throw new UnsupportedOperationException("Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
        }
        m_extensionManager.addExtension(felix, bundleImpl);
        this.appendCapabilities((List<BundleCapability>)object);
        object = bundleImpl.adapt(BundleRevisionImpl.class);
        List<BundleRequirement> list = ((BundleRevisionImpl)object).getDeclaredRequirements("osgi.wiring.host");
        List<BundleCapability> list2 = this.getCapabilities("osgi.wiring.host");
        BundleWireImpl bundleWireImpl = new BundleWireImpl((BundleRevision)object, list.get(0), this.m_systemBundleRevision, list2.get(0));
        ((BundleRevisionImpl)object).resolve(new BundleWiringImpl(this.m_logger, this.m_configMap, null, (BundleRevisionImpl)object, null, Collections.singletonList(bundleWireImpl), Collections.EMPTY_MAP, Collections.EMPTY_MAP));
        felix.getDependencies().addDependent(bundleWireImpl);
        felix.setBundleStateAndNotify(bundleImpl, 4);
    }

    void startExtensionBundle(Felix felix, BundleImpl bundleImpl) {
        Map map = bundleImpl.adapt(BundleRevisionImpl.class).getHeaders();
        String string = (String)map.get("ExtensionBundle-Activator");
        boolean bl = false;
        if (string == null) {
            bl = true;
            string = (String)map.get("Felix-Activator");
        }
        if (string != null) {
            ExtensionTuple extensionTuple = null;
            try {
                BundleActivator bundleActivator = (BundleActivator)felix.getClass().getClassLoader().loadClass(string.trim()).newInstance();
                BundleContext bundleContext = felix._getBundleContext();
                bundleImpl.setBundleContext(bundleContext);
                if (!bl) {
                    extensionTuple = new ExtensionTuple(bundleActivator, bundleImpl);
                    this.m_extensionTuples.add(extensionTuple);
                } else {
                    felix.m_activatorList.add(bundleActivator);
                }
                if (felix.getState() == 32 || felix.getState() == 8) {
                    if (extensionTuple != null) {
                        extensionTuple.m_started = true;
                    }
                    Felix.m_secureAction.startActivator(bundleActivator, bundleContext);
                }
            }
            catch (Throwable throwable) {
                if (extensionTuple != null) {
                    extensionTuple.m_failed = true;
                }
                felix.fireFrameworkEvent(2, bundleImpl, new BundleException("Unable to start Bundle", throwable));
                this.m_logger.log(bundleImpl, 2, "Unable to start Extension Activator", throwable);
            }
        }
    }

    void startPendingExtensionBundles(Felix felix) {
        int n = 0;
        while (n < this.m_extensionTuples.size()) {
            if (!this.m_extensionTuples.get(n).m_started) {
                this.m_extensionTuples.get(n).m_started = true;
                try {
                    Felix.m_secureAction.startActivator(this.m_extensionTuples.get(n).m_activator, felix._getBundleContext());
                }
                catch (Throwable throwable) {
                    this.m_extensionTuples.get(n).m_failed = true;
                    felix.fireFrameworkEvent(2, this.m_extensionTuples.get(n).m_bundle, new BundleException("Unable to start Bundle", 5, throwable));
                    this.m_logger.log(this.m_extensionTuples.get(n).m_bundle, 2, "Unable to start Extension Activator", throwable);
                }
            }
            ++n;
        }
    }

    void stopExtensionBundles(Felix felix) {
        int n = this.m_extensionTuples.size() - 1;
        while (n >= 0) {
            if (this.m_extensionTuples.get(n).m_started && !this.m_extensionTuples.get(n).m_failed) {
                try {
                    Felix.m_secureAction.stopActivator(this.m_extensionTuples.get(n).m_activator, felix._getBundleContext());
                }
                catch (Throwable throwable) {
                    felix.fireFrameworkEvent(2, this.m_extensionTuples.get(n).m_bundle, new BundleException("Unable to stop Bundle", 5, throwable));
                    this.m_logger.log(this.m_extensionTuples.get(n).m_bundle, 2, "Unable to stop Extension Activator", throwable);
                }
            }
            --n;
        }
        this.m_extensionTuples.clear();
    }

    void removeExtensions(Felix felix) {
        if (m_extensionManager != null) {
            m_extensionManager._removeExtensions(felix);
        }
    }

    private List<BundleCapability> getCapabilities(String string) {
        List<BundleCapability> list;
        List<BundleCapability> list2 = list = this.m_capabilities;
        if (string != null) {
            list2 = new ArrayList<BundleCapability>();
            for (BundleCapability bundleCapability : list) {
                if (!bundleCapability.getNamespace().equals(string)) continue;
                list2.add(bundleCapability);
            }
        }
        return list2;
    }

    private synchronized void appendCapabilities(List<BundleCapability> list) {
        ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>(this.m_capabilities.size() + list.size());
        arrayList.addAll(this.m_capabilities);
        arrayList.addAll(list);
        this.m_capabilities = ImmutableList.newInstance(arrayList);
        this.m_headerMap.put("Export-Package", this.convertCapabilitiesToHeaders(this.m_headerMap));
    }

    private String convertCapabilitiesToHeaders(Map map) {
        StringBuffer stringBuffer = new StringBuffer("");
        HashSet<String> hashSet = new HashSet<String>();
        List<BundleCapability> list = this.m_capabilities;
        for (BundleCapability bundleCapability : list) {
            if (!bundleCapability.getNamespace().equals("osgi.wiring.package")) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(bundleCapability.getAttributes().get("osgi.wiring.package"));
            for (Map.Entry<String, String> entry : bundleCapability.getDirectives().entrySet()) {
                stringBuffer.append("; ");
                stringBuffer.append(entry.getKey());
                stringBuffer.append(":=\"");
                stringBuffer.append(entry.getValue());
                stringBuffer.append("\"");
            }
            for (Map.Entry<String, Object> entry : bundleCapability.getAttributes().entrySet()) {
                if (entry.getKey().equals("osgi.wiring.package") || entry.getKey().equals("bundle-symbolic-name") || entry.getKey().equals("bundle-version")) continue;
                stringBuffer.append("; ");
                stringBuffer.append(entry.getKey());
                stringBuffer.append("=\"");
                stringBuffer.append(entry.getValue());
                stringBuffer.append("\"");
            }
            hashSet.add((String)bundleCapability.getAttributes().get("osgi.wiring.package"));
        }
        this.m_exportNames = hashSet;
        return stringBuffer.toString();
    }

    @Override
    public URLConnection openConnection(URL uRL) throws IOException {
        String string = uRL.getPath();
        if (string.trim().equals("/")) {
            return new URLHandlersBundleURLConnection(uRL);
        }
        Bundle[] bundleArray = this.m_extensionsCache;
        URL uRL2 = null;
        Bundle[] bundleArray2 = bundleArray;
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray2[n2];
            try {
                BundleRevisionImpl bundleRevisionImpl = (BundleRevisionImpl)bundle.adapt(BundleRevision.class);
                if (bundleRevisionImpl != null) {
                    uRL2 = bundleRevisionImpl.getResourceLocal(string);
                }
            }
            catch (Exception exception) {}
            if (uRL2 != null) {
                return uRL2.openConnection();
            }
            ++n2;
        }
        return new URLConnection(uRL){

            @Override
            public void connect() throws IOException {
                throw new IOException("Resource not provided by any extension!");
            }
        };
    }

    @Override
    protected InetAddress getHostAddress(URL uRL) {
        return null;
    }

    private synchronized void addExtension(Object object, Bundle bundle) {
        ArrayList<Bundle> arrayList = (ArrayList<Bundle>)this.m_sourceToExtensions.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<Bundle>();
            this.m_sourceToExtensions.put(object, arrayList);
        }
        arrayList.add(bundle);
        this._add(bundle.getSymbolicName(), bundle);
        this.m_extensionsCache = this.m_extensions.toArray(new Bundle[this.m_extensions.size()]);
    }

    private synchronized void _removeExtensions(Object object) {
        if (this.m_sourceToExtensions.remove(object) == null) {
            return;
        }
        this.m_extensions.clear();
        this.m_names.clear();
        for (List list : this.m_sourceToExtensions.values()) {
            for (Bundle bundle : list) {
                this._add(bundle.getSymbolicName(), bundle);
            }
            this.m_extensionsCache = this.m_extensions.toArray(new Bundle[this.m_extensions.size()]);
        }
    }

    private void _add(String string, Bundle bundle) {
        if (!this.m_names.contains(string)) {
            this.m_names.add(string);
            this.m_extensions.add(bundle);
        }
    }

    @Override
    public void close() {
    }

    public Enumeration getEntries() {
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean hasEntry(String string) {
        return false;
    }

    @Override
    public byte[] getEntryAsBytes(String string) {
        return null;
    }

    @Override
    public InputStream getEntryAsStream(String string) throws IOException {
        return null;
    }

    @Override
    public Content getEntryAsContent(String string) {
        return null;
    }

    @Override
    public String getEntryAsNativeLibrary(String string) {
        return null;
    }

    @Override
    public URL getEntryAsURL(String string) {
        return null;
    }

    class ExtensionManagerRevision
    extends BundleRevisionImpl {
        private final Version m_version;
        private volatile BundleWiring m_wiring;

        ExtensionManagerRevision(Felix felix) {
            super(felix, "0");
            this.m_version = new Version((String)ExtensionManager.this.m_configMap.get("felix.version"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getHeaders() {
            ExtensionManager extensionManager = ExtensionManager.this;
            synchronized (extensionManager) {
                return ExtensionManager.this.m_headerMap;
            }
        }

        @Override
        public List<BundleCapability> getDeclaredCapabilities(String string) {
            return ExtensionManager.this.getCapabilities(string);
        }

        @Override
        public String getSymbolicName() {
            return "org.apache.felix.framework";
        }

        @Override
        public Version getVersion() {
            return this.m_version;
        }

        @Override
        public void close() {
        }

        @Override
        public Content getContent() {
            return ExtensionManager.this;
        }

        @Override
        public URL getEntry(String string) {
            return null;
        }

        @Override
        public boolean hasInputStream(int n, String string) {
            return this.getClass().getClassLoader().getResource(string) != null;
        }

        @Override
        public InputStream getInputStream(int n, String string) {
            return this.getClass().getClassLoader().getResourceAsStream(string);
        }

        @Override
        public URL getLocalURL(int n, String string) {
            return this.getClass().getClassLoader().getResource(string);
        }

        @Override
        public void resolve(BundleWiringImpl bundleWiringImpl) {
            try {
                this.m_wiring = new ExtensionManagerWiring(ExtensionManager.this.m_logger, ExtensionManager.this.m_configMap, this);
            }
            catch (Exception exception) {}
        }

        @Override
        public BundleWiring getWiring() {
            return this.m_wiring;
        }
    }

    class ExtensionManagerWiring
    extends BundleWiringImpl {
        ExtensionManagerWiring(Logger logger, Map map, BundleRevisionImpl bundleRevisionImpl) throws Exception {
            super(logger, map, null, bundleRevisionImpl, null, Collections.EMPTY_LIST, null, null);
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.getClass().getClassLoader();
        }

        @Override
        public List<BundleCapability> getCapabilities(String string) {
            return ExtensionManager.this.getCapabilities(string);
        }

        @Override
        public List<NativeLibrary> getNativeLibraries() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Class getClassByDelegation(String string) throws ClassNotFoundException {
            Class<?> clazz;
            block6: {
                clazz = null;
                String string2 = Util.getClassPackage(string);
                if (this.shouldBootDelegate(string2)) {
                    try {
                        ClassLoader classLoader = this.getBootDelegationClassLoader();
                        clazz = classLoader.loadClass(string);
                        if (string2.startsWith("java.") || clazz != null) {
                            return clazz;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!string2.startsWith("java.")) break block6;
                        throw classNotFoundException;
                    }
                }
            }
            if (clazz == null) {
                if (!ExtensionManager.this.m_exportNames.contains(Util.getClassPackage(string))) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.getClass().getClassLoader().loadClass(string);
            }
            return clazz;
        }

        @Override
        public URL getResourceByDelegation(String string) {
            return this.getClass().getClassLoader().getResource(string);
        }

        @Override
        public Enumeration getResourcesByDelegation(String string) {
            try {
                return this.getClass().getClassLoader().getResources(string);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public void dispose() {
        }
    }

    private static class ExtensionTuple {
        private final BundleActivator m_activator;
        private final Bundle m_bundle;
        private volatile boolean m_failed;
        private volatile boolean m_started;

        public ExtensionTuple(BundleActivator bundleActivator, Bundle bundle) {
            this.m_activator = bundleActivator;
            this.m_bundle = bundle;
        }
    }
}

