/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Felix;
import org.osgi.dto.DTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.FrameworkDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.startlevel.dto.BundleStartLevelDTO;
import org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.dto.BundleRevisionDTO;
import org.osgi.framework.wiring.dto.BundleWireDTO;
import org.osgi.framework.wiring.dto.BundleWiringDTO;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.resource.dto.CapabilityDTO;
import org.osgi.resource.dto.CapabilityRefDTO;
import org.osgi.resource.dto.RequirementDTO;
import org.osgi.resource.dto.RequirementRefDTO;

public class DTOFactory {
    private DTOFactory() {
    }

    static <T> T createDTO(Bundle bundle, Class<T> clazz) {
        if (1 == bundle.getState()) {
            return null;
        }
        if (clazz == BundleDTO.class) {
            return clazz.cast(DTOFactory.createBundleDTO(bundle));
        }
        if (clazz == BundleStartLevelDTO.class) {
            return clazz.cast(DTOFactory.createBundleStartLevelDTO(bundle));
        }
        if (clazz == BundleRevisionDTO.class) {
            return clazz.cast(DTOFactory.createBundleRevisionDTO(bundle));
        }
        if (clazz == BundleRevisionDTO[].class) {
            return clazz.cast(DTOFactory.createBundleRevisionDTOArray(bundle));
        }
        if (clazz == BundleWiringDTO.class) {
            return clazz.cast(DTOFactory.createBundleWiringDTO(bundle));
        }
        if (clazz == BundleWiringDTO[].class) {
            return clazz.cast(DTOFactory.createBundleWiringDTOArray(bundle));
        }
        if (clazz == ServiceReferenceDTO[].class) {
            return clazz.cast(DTOFactory.createServiceReferenceDTOArray(bundle));
        }
        if (clazz == FrameworkDTO.class && bundle instanceof Felix) {
            return clazz.cast(DTOFactory.createFrameworkDTO((Felix)bundle));
        }
        if (clazz == FrameworkStartLevelDTO.class && bundle instanceof Framework) {
            return clazz.cast(DTOFactory.createFrameworkStartLevelDTO((Framework)bundle));
        }
        return null;
    }

    private static BundleDTO createBundleDTO(Bundle bundle) {
        BundleDTO bundleDTO = new BundleDTO();
        bundleDTO.id = bundle.getBundleId();
        bundleDTO.lastModified = bundle.getLastModified();
        bundleDTO.state = bundle.getState();
        bundleDTO.symbolicName = bundle.getSymbolicName();
        bundleDTO.version = "" + bundle.getVersion();
        return bundleDTO;
    }

    private static BundleRevisionDTO createBundleRevisionDTO(Bundle bundle) {
        BundleRevision bundleRevision = bundle.adapt(BundleRevision.class);
        if (!(bundleRevision instanceof BundleRevisionImpl)) {
            return null;
        }
        return DTOFactory.createBundleRevisionDTO(bundle, (BundleRevisionImpl)bundleRevision, new HashSet<BundleRevisionDTO>());
    }

    private static BundleRevisionDTO[] createBundleRevisionDTOArray(Bundle bundle) {
        BundleRevisions bundleRevisions = bundle.adapt(BundleRevisions.class);
        if (bundleRevisions == null || bundleRevisions.getRevisions() == null) {
            return null;
        }
        List<BundleRevision> list = bundleRevisions.getRevisions();
        BundleRevisionDTO[] bundleRevisionDTOArray = new BundleRevisionDTO[list.size()];
        int n = 0;
        while (n < list.size()) {
            if (list.get(n) instanceof BundleRevisionImpl) {
                bundleRevisionDTOArray[n] = DTOFactory.createBundleRevisionDTO(bundle, (BundleRevisionImpl)list.get(n), new HashSet<BundleRevisionDTO>());
            }
            ++n;
        }
        return bundleRevisionDTOArray;
    }

    private static BundleRevisionDTO createBundleRevisionDTO(BundleRevision bundleRevision, Set<BundleRevisionDTO> set) {
        if (bundleRevision instanceof BundleRevisionImpl) {
            return DTOFactory.createBundleRevisionDTO(bundleRevision.getBundle(), (BundleRevisionImpl)bundleRevision, set);
        }
        return null;
    }

    private static BundleRevisionDTO createBundleRevisionDTO(Bundle bundle, BundleRevisionImpl bundleRevisionImpl, Set<BundleRevisionDTO> set) {
        DTO dTO;
        BundleRevisionDTO bundleRevisionDTO = new BundleRevisionDTO();
        bundleRevisionDTO.id = DTOFactory.getRevisionID(bundleRevisionImpl);
        DTOFactory.addBundleRevisionDTO(bundleRevisionDTO, set);
        bundleRevisionDTO.bundle = bundle.getBundleId();
        bundleRevisionDTO.symbolicName = bundleRevisionImpl.getSymbolicName();
        bundleRevisionDTO.type = bundleRevisionImpl.getTypes();
        bundleRevisionDTO.version = bundleRevisionImpl.getVersion().toString();
        bundleRevisionDTO.capabilities = new ArrayList();
        for (Capability object : bundleRevisionImpl.getCapabilities(null)) {
            dTO = new CapabilityDTO();
            dTO.id = DTOFactory.getCapabilityID(object);
            dTO.namespace = object.getNamespace();
            dTO.attributes = DTOFactory.convertAttrsToDTO(object.getAttributes());
            dTO.directives = new HashMap<String, String>(object.getDirectives());
            dTO.resource = DTOFactory.getResourceIDAndAdd(object.getResource(), set);
            bundleRevisionDTO.capabilities.add(dTO);
        }
        bundleRevisionDTO.requirements = new ArrayList();
        for (Requirement requirement : bundleRevisionImpl.getRequirements(null)) {
            dTO = new RequirementDTO();
            ((RequirementDTO)dTO).id = DTOFactory.getRequirementID(requirement);
            ((RequirementDTO)dTO).namespace = requirement.getNamespace();
            ((RequirementDTO)dTO).attributes = DTOFactory.convertAttrsToDTO(requirement.getAttributes());
            ((RequirementDTO)dTO).directives = new HashMap<String, String>(requirement.getDirectives());
            ((RequirementDTO)dTO).resource = DTOFactory.getResourceIDAndAdd(requirement.getResource(), set);
            bundleRevisionDTO.requirements.add(dTO);
        }
        return bundleRevisionDTO;
    }

    private static BundleWiringDTO createBundleWiringDTO(Bundle bundle) {
        BundleWiring bundleWiring = bundle.adapt(BundleWiring.class);
        return DTOFactory.createBundleWiringDTO(bundleWiring);
    }

    private static BundleWiringDTO createBundleWiringDTO(BundleWiring bundleWiring) {
        BundleWiringDTO bundleWiringDTO = new BundleWiringDTO();
        bundleWiringDTO.bundle = bundleWiring.getBundle().getBundleId();
        bundleWiringDTO.root = DTOFactory.getWiringID(bundleWiring);
        bundleWiringDTO.nodes = new HashSet<BundleWiringDTO.NodeDTO>();
        bundleWiringDTO.resources = new HashSet<BundleRevisionDTO>();
        DTOFactory.createBundleRevisionDTO(bundleWiring.getRevision(), bundleWiringDTO.resources);
        DTOFactory.createBundleWiringNodeDTO(bundleWiring, bundleWiringDTO.resources, bundleWiringDTO.nodes);
        return bundleWiringDTO;
    }

    private static BundleWiringDTO[] createBundleWiringDTOArray(Bundle bundle) {
        BundleRevisions bundleRevisions = bundle.adapt(BundleRevisions.class);
        if (bundleRevisions == null || bundleRevisions.getRevisions() == null) {
            return null;
        }
        List<BundleRevision> list = bundleRevisions.getRevisions();
        BundleWiringDTO[] bundleWiringDTOArray = new BundleWiringDTO[list.size()];
        int n = 0;
        while (n < list.size()) {
            BundleWiring bundleWiring = list.get(n).getWiring();
            bundleWiringDTOArray[n] = DTOFactory.createBundleWiringDTO(bundleWiring);
            ++n;
        }
        return bundleWiringDTOArray;
    }

    private static void createBundleWiringNodeDTO(BundleWiring bundleWiring, Set<BundleRevisionDTO> set, Set<BundleWiringDTO.NodeDTO> set2) {
        DTO dTO;
        BundleWiringDTO.NodeDTO nodeDTO = new BundleWiringDTO.NodeDTO();
        nodeDTO.id = DTOFactory.getWiringID(bundleWiring);
        set2.add(nodeDTO);
        nodeDTO.current = bundleWiring.isCurrent();
        nodeDTO.inUse = bundleWiring.isInUse();
        nodeDTO.resource = DTOFactory.getResourceIDAndAdd(bundleWiring.getResource(), set);
        nodeDTO.capabilities = new ArrayList();
        for (Capability object : bundleWiring.getCapabilities(null)) {
            dTO = new CapabilityRefDTO();
            dTO.capability = DTOFactory.getCapabilityID(object);
            dTO.resource = DTOFactory.getResourceIDAndAdd(object.getResource(), set);
            nodeDTO.capabilities.add(dTO);
        }
        nodeDTO.requirements = new ArrayList();
        for (Requirement requirement : bundleWiring.getRequirements(null)) {
            dTO = new RequirementRefDTO();
            ((RequirementRefDTO)dTO).requirement = DTOFactory.getRequirementID(requirement);
            ((RequirementRefDTO)dTO).resource = DTOFactory.getResourceIDAndAdd(requirement.getResource(), set);
            nodeDTO.requirements.add(dTO);
        }
        nodeDTO.providedWires = new ArrayList();
        for (Wire wire : bundleWiring.getProvidedWires(null)) {
            nodeDTO.providedWires.add(DTOFactory.createBundleWireDTO(wire, set, set2));
        }
        nodeDTO.requiredWires = new ArrayList();
        for (Wire wire : bundleWiring.getRequiredWires(null)) {
            nodeDTO.requiredWires.add(DTOFactory.createBundleWireDTO(wire, set, set2));
        }
    }

    private static BundleWireDTO createBundleWireDTO(Wire wire, Set<BundleRevisionDTO> set, Set<BundleWiringDTO.NodeDTO> set2) {
        BundleWireDTO bundleWireDTO = new BundleWireDTO();
        if (wire instanceof BundleWire) {
            BundleWire bundleWire = (BundleWire)wire;
            BundleWiring bundleWiring = bundleWire.getProviderWiring();
            DTOFactory.addWiringNodeIfNotPresent(bundleWiring, set, set2);
            bundleWireDTO.providerWiring = DTOFactory.getWiringID(bundleWiring);
            BundleWiring bundleWiring2 = bundleWire.getRequirerWiring();
            DTOFactory.addWiringNodeIfNotPresent(bundleWiring2, set, set2);
            bundleWireDTO.requirerWiring = DTOFactory.getWiringID(bundleWiring2);
        }
        bundleWireDTO.provider = DTOFactory.getResourceIDAndAdd(wire.getProvider(), set);
        bundleWireDTO.requirer = DTOFactory.getResourceIDAndAdd(wire.getRequirer(), set);
        bundleWireDTO.capability = new CapabilityRefDTO();
        bundleWireDTO.capability.capability = DTOFactory.getCapabilityID(wire.getCapability());
        bundleWireDTO.capability.resource = DTOFactory.getResourceIDAndAdd(wire.getCapability().getResource(), set);
        bundleWireDTO.requirement = new RequirementRefDTO();
        bundleWireDTO.requirement.requirement = DTOFactory.getRequirementID(wire.getRequirement());
        bundleWireDTO.requirement.resource = DTOFactory.getResourceIDAndAdd(wire.getRequirement().getResource(), set);
        return bundleWireDTO;
    }

    private static BundleStartLevelDTO createBundleStartLevelDTO(Bundle bundle) {
        BundleStartLevelDTO bundleStartLevelDTO = new BundleStartLevelDTO();
        bundleStartLevelDTO.bundle = bundle.getBundleId();
        BundleStartLevel bundleStartLevel = bundle.adapt(BundleStartLevel.class);
        bundleStartLevelDTO.activationPolicyUsed = bundleStartLevel.isActivationPolicyUsed();
        bundleStartLevelDTO.persistentlyStarted = bundleStartLevel.isPersistentlyStarted();
        bundleStartLevelDTO.startLevel = bundleStartLevel.getStartLevel();
        return bundleStartLevelDTO;
    }

    private static ServiceReferenceDTO[] createServiceReferenceDTOArray(Bundle bundle) {
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            return null;
        }
        ServiceReference<?>[] serviceReferenceArray = bundle.getRegisteredServices();
        if (serviceReferenceArray == null) {
            return new ServiceReferenceDTO[0];
        }
        ServiceReferenceDTO[] serviceReferenceDTOArray = new ServiceReferenceDTO[serviceReferenceArray.length];
        int n = 0;
        while (n < serviceReferenceArray.length) {
            serviceReferenceDTOArray[n] = DTOFactory.createServiceReferenceDTO(serviceReferenceArray[n]);
            ++n;
        }
        return serviceReferenceDTOArray;
    }

    private static ServiceReferenceDTO createServiceReferenceDTO(ServiceReference<?> serviceReference) {
        Bundle[] bundleArray;
        ServiceReferenceDTO serviceReferenceDTO = new ServiceReferenceDTO();
        serviceReferenceDTO.bundle = serviceReference.getBundle().getBundleId();
        serviceReferenceDTO.id = (Long)serviceReference.getProperty("service.id");
        HashMap<Bundle[], Object> hashMap = new HashMap<Bundle[], Object>();
        String[] stringArray = serviceReference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            bundleArray = stringArray[n2];
            hashMap.put(bundleArray, serviceReference.getProperty((String)bundleArray));
            ++n2;
        }
        serviceReferenceDTO.properties = new HashMap<String, Object>(hashMap);
        bundleArray = serviceReference.getUsingBundles();
        if (bundleArray == null) {
            serviceReferenceDTO.usingBundles = new long[0];
        } else {
            serviceReferenceDTO.usingBundles = new long[bundleArray.length];
            n2 = 0;
            while (n2 < bundleArray.length) {
                serviceReferenceDTO.usingBundles[n2] = bundleArray[n2].getBundleId();
                ++n2;
            }
        }
        return serviceReferenceDTO;
    }

    private static FrameworkDTO createFrameworkDTO(Felix felix) {
        ServiceReference<?>[] serviceReferenceArray;
        FrameworkDTO frameworkDTO = new FrameworkDTO();
        frameworkDTO.properties = DTOFactory.convertAttrsToDTO(felix.getConfig());
        frameworkDTO.bundles = new ArrayList<BundleDTO>();
        Bundle[] bundleArray = felix.getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            serviceReferenceArray = bundleArray[n2];
            frameworkDTO.bundles.add(DTOFactory.createDTO((Bundle)serviceReferenceArray, BundleDTO.class));
            ++n2;
        }
        frameworkDTO.services = new ArrayList<ServiceReferenceDTO>();
        serviceReferenceArray = null;
        try {
            serviceReferenceArray = felix.getBundleContext().getAllServiceReferences(null, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        ServiceReference<?>[] serviceReferenceArray2 = serviceReferenceArray;
        int n3 = serviceReferenceArray.length;
        n = 0;
        while (n < n3) {
            ServiceReference<?> serviceReference = serviceReferenceArray2[n];
            frameworkDTO.services.add(DTOFactory.createServiceReferenceDTO(serviceReference));
            ++n;
        }
        return frameworkDTO;
    }

    private static FrameworkStartLevelDTO createFrameworkStartLevelDTO(Framework framework) {
        FrameworkStartLevel frameworkStartLevel = framework.adapt(FrameworkStartLevel.class);
        FrameworkStartLevelDTO frameworkStartLevelDTO = new FrameworkStartLevelDTO();
        frameworkStartLevelDTO.initialBundleStartLevel = frameworkStartLevel.getInitialBundleStartLevel();
        frameworkStartLevelDTO.startLevel = frameworkStartLevel.getStartLevel();
        return frameworkStartLevelDTO;
    }

    private static void addBundleRevisionDTO(BundleRevisionDTO bundleRevisionDTO, Set<BundleRevisionDTO> set) {
        for (BundleRevisionDTO bundleRevisionDTO2 : set) {
            if (bundleRevisionDTO2.id != bundleRevisionDTO.id) continue;
            return;
        }
        set.add(bundleRevisionDTO);
    }

    private static void addWiringNodeIfNotPresent(BundleWiring bundleWiring, Set<BundleRevisionDTO> set, Set<BundleWiringDTO.NodeDTO> set2) {
        int n = DTOFactory.getWiringID(bundleWiring);
        for (BundleWiringDTO.NodeDTO nodeDTO : set2) {
            if (nodeDTO.id != n) continue;
            return;
        }
        DTOFactory.createBundleWiringNodeDTO(bundleWiring, set, set2);
    }

    private static Map<String, Object> convertAttrsToDTO(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = DTOFactory.convertAttrToDTO(entry.getValue());
            if (object == null) continue;
            hashMap.put(entry.getKey(), object);
        }
        return hashMap;
    }

    private static Object convertAttrToDTO(Object object) {
        if (object instanceof Version) {
            return object.toString();
        }
        if (DTOFactory.isPermissibleAttribute(object.getClass()) || object.getClass().isArray() && DTOFactory.isPermissibleAttribute(object.getClass().getComponentType())) {
            return object;
        }
        return null;
    }

    private static boolean isPermissibleAttribute(Class clazz) {
        return clazz == Boolean.class || clazz == String.class || DTO.class.isAssignableFrom(clazz);
    }

    private static int getWiringID(Wiring wiring) {
        return wiring.hashCode();
    }

    private static int getCapabilityID(Capability capability) {
        return capability.hashCode();
    }

    private static int getRequirementID(Requirement requirement) {
        return requirement.hashCode();
    }

    private static int getResourceIDAndAdd(Resource resource, Set<BundleRevisionDTO> set) {
        if (resource instanceof BundleRevisionImpl) {
            BundleRevisionImpl bundleRevisionImpl = (BundleRevisionImpl)resource;
            int n = bundleRevisionImpl.getId().hashCode();
            if (set == null) {
                return n;
            }
            for (BundleRevisionDTO bundleRevisionDTO : set) {
                if (bundleRevisionDTO.id != n) continue;
                return n;
            }
            DTOFactory.createBundleRevisionDTO(bundleRevisionImpl, set);
            return n;
        }
        return resource.hashCode();
    }

    private static int getRevisionID(BundleRevisionImpl bundleRevisionImpl) {
        return bundleRevisionImpl.getId().hashCode();
    }
}

