/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.StatefulResolver;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.WovenClassImpl;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.cache.JarContent;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.resolver.ResourceNotFoundException;
import org.apache.felix.framework.util.CompoundEnumeration;
import org.apache.felix.framework.util.ImmutableList;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.NativeLibrary;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;

public class BundleWiringImpl
implements BundleWiring {
    public static final int LISTRESOURCES_DEBUG = 0x100000;
    public static final int EAGER_ACTIVATION = 0;
    public static final int LAZY_ACTIVATION = 1;
    private final Logger m_logger;
    private final Map m_configMap;
    private final StatefulResolver m_resolver;
    private final BundleRevisionImpl m_revision;
    private final List<BundleRevision> m_fragments;
    private volatile List<BundleWire> m_wires;
    private volatile Map<String, BundleRevision> m_importedPkgs;
    private final Map<String, List<BundleRevision>> m_requiredPkgs;
    private final List<BundleCapability> m_resolvedCaps;
    private final Map<String, List<List<String>>> m_includedPkgFilters;
    private final Map<String, List<List<String>>> m_excludedPkgFilters;
    private final List<BundleRequirement> m_resolvedReqs;
    private final List<NativeLibrary> m_resolvedNativeLibs;
    private final List<Content> m_fragmentContents;
    private volatile List<BundleRequirement> m_wovenReqs = null;
    private BundleClassLoader m_classLoader;
    private final ClassLoader m_bootClassLoader;
    private static final ClassLoader m_defBootClassLoader;
    private final boolean m_implicitBootDelegation;
    private final boolean m_useLocalURLs;
    private static SecurityManagerEx m_sm;
    private final ThreadLocal m_cycleCheck = new ThreadLocal();
    private static final ThreadLocal m_deferredActivation;
    private static volatile boolean m_isPreJava5;
    private volatile boolean m_isDisposed = false;
    private final ThreadLocal m_listResourcesCycleCheck = new ThreadLocal();
    private static final Constructor m_dexFileClassConstructor;
    private static final Method m_dexFileClassLoadDex;
    private static final Method m_dexFileClassLoadClass;

    static {
        Executable executable;
        Object object = null;
        try {
            executable = BundleRevisionImpl.getSecureAction().getDeclaredConstructor(SecureClassLoader.class, new Class[]{ClassLoader.class});
            BundleRevisionImpl.getSecureAction().setAccesssible(executable);
            object = (ClassLoader)BundleRevisionImpl.getSecureAction().invoke((Constructor)executable, new Object[1]);
        }
        catch (Throwable throwable) {
            object = null;
            System.err.println("Problem creating boot delegation class loader: " + throwable);
        }
        m_defBootClassLoader = object;
        m_sm = new SecurityManagerEx();
        m_deferredActivation = new ThreadLocal();
        m_isPreJava5 = false;
        object = null;
        executable = null;
        Method method = null;
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("dalvik.system.DexFile");
            }
            catch (Exception exception) {
                clazz = Class.forName("android.dalvik.DexFile");
            }
            try {
                executable = clazz.getMethod("loadDex", String.class, String.class, Integer.TYPE);
            }
            catch (Exception exception) {}
            object = clazz.getConstructor(File.class);
            method = clazz.getMethod("loadClass", String.class, ClassLoader.class);
        }
        catch (Throwable throwable) {
            object = null;
            executable = null;
            method = null;
        }
        m_dexFileClassConstructor = object;
        m_dexFileClassLoadDex = executable;
        m_dexFileClassLoadClass = method;
    }

    BundleWiringImpl(Logger logger, Map map, StatefulResolver statefulResolver, BundleRevisionImpl bundleRevisionImpl, List<BundleRevision> list, List<BundleWire> list2, Map<String, BundleRevision> map2, Map<String, List<BundleRevision>> map3) throws Exception {
        Object v;
        Object v2;
        this.m_logger = logger;
        this.m_configMap = map;
        this.m_resolver = statefulResolver;
        this.m_revision = bundleRevisionImpl;
        this.m_importedPkgs = map2;
        this.m_requiredPkgs = map3;
        this.m_wires = ImmutableList.newInstance(list2);
        ArrayList<Content> arrayList = null;
        if (list != null) {
            if (list.size() > 1) {
                TreeMap<String, BundleRevision> treeMap = new TreeMap<String, BundleRevision>();
                for (BundleRevision bundleRevision : list) {
                    treeMap.put(((BundleRevisionImpl)bundleRevision).getId(), bundleRevision);
                }
                list = new ArrayList(treeMap.values());
            }
            arrayList = new ArrayList<Content>(list.size());
            int n = 0;
            while (list != null && n < list.size()) {
                arrayList.add(((BundleRevisionImpl)list.get(n)).getContent().getEntryAsContent("."));
                ++n;
            }
        }
        this.m_fragments = list;
        this.m_fragmentContents = arrayList;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<BundleRequirement> arrayList2 = new ArrayList<BundleRequirement>();
        for (BundleWire bundleWire : list2) {
            if (bundleWire.getRequirement().getNamespace().equals("osgi.wiring.host") && arrayList2.contains(bundleWire.getRequirement())) continue;
            arrayList2.add(bundleWire.getRequirement());
            if (!bundleWire.getRequirement().getNamespace().equals("osgi.wiring.package")) continue;
            hashSet.add((String)bundleWire.getCapability().getAttributes().get("osgi.wiring.package"));
        }
        for (BundleRequirement bundleRequirement : this.m_revision.getDeclaredRequirements(null)) {
            String string;
            if (!bundleRequirement.getNamespace().equals("osgi.wiring.package") || (string = bundleRequirement.getDirectives().get("resolution")) == null || !string.equals("dynamic")) continue;
            arrayList2.add(bundleRequirement);
        }
        if (this.m_fragments != null) {
            for (BundleRevision bundleRevision : this.m_fragments) {
                for (BundleRequirement bundleRequirement : bundleRevision.getDeclaredRequirements(null)) {
                    String string;
                    if (!bundleRequirement.getNamespace().equals("osgi.wiring.package") || (string = bundleRequirement.getDirectives().get("resolution")) == null || !string.equals("dynamic")) continue;
                    arrayList2.add(bundleRequirement);
                }
            }
        }
        this.m_resolvedReqs = ImmutableList.newInstance(arrayList2);
        boolean bl = Util.isFragment(bundleRevisionImpl);
        ArrayList arrayList3 = new ArrayList();
        HashMap<String, List<List<String>>> hashMap = new HashMap<String, List<List<String>>>();
        HashMap hashMap2 = new HashMap();
        if (bl) {
            for (BundleCapability bundleCapability : this.m_revision.getDeclaredCapabilities(null)) {
                String string;
                if (!"osgi.identity".equals(bundleCapability.getNamespace()) || (string = bundleCapability.getDirectives().get("effective")) != null && !string.equals("resolve")) continue;
                arrayList3.add(bundleCapability);
            }
        } else {
            for (BundleCapability bundleCapability : this.m_revision.getDeclaredCapabilities(null)) {
                String string;
                if (bundleCapability.getNamespace().equals("osgi.wiring.package") && (!bundleCapability.getNamespace().equals("osgi.wiring.package") || hashSet.contains(bundleCapability.getAttributes().get("osgi.wiring.package").toString())) || (string = bundleCapability.getDirectives().get("effective")) != null && !string.equals("resolve")) continue;
                arrayList3.add(bundleCapability);
                if (!bundleCapability.getNamespace().equals("osgi.wiring.package")) continue;
                List<List<String>> list3 = BundleWiringImpl.parsePkgFilters(bundleCapability, "include");
                if (list3 != null) {
                    hashMap.put((String)bundleCapability.getAttributes().get("osgi.wiring.package"), list3);
                }
                if ((list3 = BundleWiringImpl.parsePkgFilters(bundleCapability, "exclude")) == null) continue;
                hashMap2.put((String)bundleCapability.getAttributes().get("osgi.wiring.package"), list3);
            }
            if (this.m_fragments != null) {
                for (BundleRevision bundleRevision : this.m_fragments) {
                    for (BundleCapability bundleCapability : bundleRevision.getDeclaredCapabilities(null)) {
                        String string;
                        if ("osgi.identity".equals(bundleCapability.getNamespace()) || bundleCapability.getNamespace().equals("osgi.wiring.package") && (!bundleCapability.getNamespace().equals("osgi.wiring.package") || hashSet.contains(bundleCapability.getAttributes().get("osgi.wiring.package").toString())) || (string = bundleCapability.getDirectives().get("effective")) != null && !string.equals("resolve")) continue;
                        arrayList3.add(bundleCapability);
                        if (!bundleCapability.getNamespace().equals("osgi.wiring.package")) continue;
                        List<List<String>> list4 = BundleWiringImpl.parsePkgFilters(bundleCapability, "include");
                        if (list4 != null) {
                            hashMap.put((String)bundleCapability.getAttributes().get("osgi.wiring.package"), list4);
                        }
                        if ((list4 = BundleWiringImpl.parsePkgFilters(bundleCapability, "exclude")) == null) continue;
                        hashMap2.put((String)bundleCapability.getAttributes().get("osgi.wiring.package"), list4);
                    }
                }
            }
        }
        if (System.getSecurityManager() != null) {
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                BundleCapability bundleCapability = (BundleCapability)iterator.next();
                if (bundleCapability.getNamespace().equals("osgi.wiring.package")) {
                    if (((BundleProtectionDomain)((BundleRevisionImpl)bundleCapability.getRevision()).getProtectionDomain()).impliesDirect(new PackagePermission((String)bundleCapability.getAttributes().get("osgi.wiring.package"), "exportonly"))) continue;
                    iterator.remove();
                    continue;
                }
                if (bundleCapability.getNamespace().equals("osgi.wiring.host") || bundleCapability.getNamespace().equals("osgi.wiring.bundle") || bundleCapability.getNamespace().equals("osgi.ee") || ((BundleProtectionDomain)((BundleRevisionImpl)bundleCapability.getRevision()).getProtectionDomain()).impliesDirect(new CapabilityPermission(bundleCapability.getNamespace(), "provide"))) continue;
                iterator.remove();
            }
        }
        this.m_resolvedCaps = ImmutableList.newInstance(arrayList3);
        this.m_includedPkgFilters = hashMap.isEmpty() ? Collections.EMPTY_MAP : hashMap;
        this.m_excludedPkgFilters = hashMap2.isEmpty() ? Collections.EMPTY_MAP : hashMap2;
        ArrayList<NativeLibrary> arrayList4 = this.m_revision.getDeclaredNativeLibraries() == null ? new ArrayList<NativeLibrary>() : new ArrayList<NativeLibrary>(this.m_revision.getDeclaredNativeLibraries());
        int n = 0;
        while (this.m_fragments != null && n < this.m_fragments.size()) {
            List<NativeLibrary> list5 = ((BundleRevisionImpl)this.m_fragments.get(n)).getDeclaredNativeLibraries();
            int n2 = 0;
            while (list5 != null && n2 < list5.size()) {
                arrayList4.add(list5.get(n2));
                ++n2;
            }
            ++n;
        }
        this.m_resolvedNativeLibs = arrayList4.isEmpty() ? null : ImmutableList.newInstance(arrayList4);
        ClassLoader classLoader = m_defBootClassLoader;
        if (bundleRevisionImpl.getBundle().getBundleId() != 0L && (v2 = this.m_configMap.get("felix.bootdelegation.classloaders")) instanceof Map && (v = ((Map)v2).get(this.m_revision.getBundle())) instanceof ClassLoader) {
            classLoader = (ClassLoader)v;
        }
        this.m_bootClassLoader = classLoader;
        this.m_implicitBootDelegation = this.m_configMap.get("felix.bootdelegation.implicit") == null || Boolean.valueOf((String)this.m_configMap.get("felix.bootdelegation.implicit")) != false;
        this.m_useLocalURLs = this.m_configMap.get("felix.jarurls") != null;
    }

    private static List<List<String>> parsePkgFilters(BundleCapability bundleCapability, String string) {
        ArrayList<List<String>> arrayList = null;
        String string2 = bundleCapability.getDirectives().get(string);
        if (string2 != null) {
            List<String> list = ManifestParser.parseDelimitedString(string2, ",");
            arrayList = new ArrayList<List<String>>(list.size());
            int n = 0;
            while (n < list.size()) {
                List<String> list2 = SimpleFilter.parseSubstring(list.get(n));
                arrayList.add(list2);
                ++n;
            }
        }
        return arrayList;
    }

    public String toString() {
        return this.m_revision.getBundle().toString();
    }

    public synchronized void dispose() {
        if (this.m_fragmentContents != null) {
            for (Content content : this.m_fragmentContents) {
                content.close();
            }
        }
        this.m_classLoader = null;
        this.m_isDisposed = true;
    }

    public boolean hasPackageSource(String string) {
        return this.m_importedPkgs.containsKey(string) || this.m_requiredPkgs.containsKey(string);
    }

    public BundleRevision getImportedPackageSource(String string) {
        return this.m_importedPkgs.get(string);
    }

    List<BundleRevision> getFragments() {
        return this.m_fragments;
    }

    List<Content> getFragmentContents() {
        return this.m_fragmentContents;
    }

    @Override
    public boolean isCurrent() {
        BundleRevision bundleRevision = this.getBundle().adapt(BundleRevision.class);
        return bundleRevision != null && bundleRevision.getWiring() == this;
    }

    @Override
    public synchronized boolean isInUse() {
        return !this.m_isDisposed;
    }

    @Override
    public List<Capability> getResourceCapabilities(String string) {
        return BundleRevisionImpl.asCapabilityList(this.getCapabilities(string));
    }

    @Override
    public List<BundleCapability> getCapabilities(String string) {
        if (this.isInUse()) {
            List<BundleCapability> list = this.m_resolvedCaps;
            if (string != null) {
                list = new ArrayList<BundleCapability>();
                for (BundleCapability bundleCapability : this.m_resolvedCaps) {
                    if (!bundleCapability.getNamespace().equals(string)) continue;
                    list.add(bundleCapability);
                }
            }
            return list;
        }
        return null;
    }

    @Override
    public List<Requirement> getResourceRequirements(String string) {
        return BundleRevisionImpl.asRequirementList(this.getRequirements(string));
    }

    @Override
    public List<BundleRequirement> getRequirements(String string) {
        if (this.isInUse()) {
            List<BundleRequirement> list = this.m_resolvedReqs;
            List<BundleRequirement> list2 = this.m_wovenReqs;
            List<BundleRequirement> list3 = this.m_resolvedReqs;
            if (list2 != null) {
                list = new ArrayList<BundleRequirement>(this.m_resolvedReqs);
                list.addAll(list2);
                list3 = list;
            }
            if (string != null) {
                list3 = new ArrayList<BundleRequirement>();
                for (BundleRequirement bundleRequirement : list) {
                    if (!bundleRequirement.getNamespace().equals(string)) continue;
                    list3.add(bundleRequirement);
                }
            }
            return list3;
        }
        return null;
    }

    public List<NativeLibrary> getNativeLibraries() {
        return this.m_resolvedNativeLibs;
    }

    private static List<Wire> asWireList(List list) {
        return list;
    }

    @Override
    public List<Wire> getProvidedResourceWires(String string) {
        return BundleWiringImpl.asWireList(this.getProvidedWires(string));
    }

    @Override
    public List<BundleWire> getProvidedWires(String string) {
        if (this.isInUse()) {
            return ((BundleImpl)this.m_revision.getBundle()).getFramework().getDependencies().getProvidedWires(this.m_revision, string);
        }
        return null;
    }

    @Override
    public List<Wire> getRequiredResourceWires(String string) {
        return BundleWiringImpl.asWireList(this.getRequiredWires(string));
    }

    @Override
    public List<BundleWire> getRequiredWires(String string) {
        if (this.isInUse()) {
            List<BundleWire> list = this.m_wires;
            if (string != null) {
                list = new ArrayList<BundleWire>();
                for (BundleWire bundleWire : this.m_wires) {
                    if (!bundleWire.getRequirement().getNamespace().equals(string)) continue;
                    list.add(bundleWire);
                }
            }
            return list;
        }
        return null;
    }

    public synchronized void addDynamicWire(BundleWire bundleWire) {
        ArrayList<BundleWire> arrayList = new ArrayList<BundleWire>(this.m_wires);
        arrayList.add(bundleWire);
        HashMap<String, BundleRevision> hashMap = new HashMap<String, BundleRevision>(this.m_importedPkgs);
        hashMap.put((String)bundleWire.getCapability().getAttributes().get("osgi.wiring.package"), bundleWire.getProviderWiring().getRevision());
        this.m_wires = ImmutableList.newInstance(arrayList);
        this.m_importedPkgs = hashMap;
    }

    @Override
    public BundleRevision getResource() {
        return this.m_revision;
    }

    @Override
    public BundleRevision getRevision() {
        return this.m_revision;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.m_isDisposed) {
            return null;
        }
        return this.getClassLoaderInternal();
    }

    private synchronized ClassLoader getClassLoaderInternal() {
        if (!this.m_isDisposed && this.m_classLoader == null) {
            Class<BundleClassLoader> clazz;
            if (m_isPreJava5) {
                clazz = BundleClassLoader.class;
            } else {
                try {
                    clazz = BundleClassLoaderJava5.class;
                }
                catch (Throwable throwable) {
                    m_isPreJava5 = true;
                    clazz = BundleClassLoader.class;
                }
            }
            try {
                Constructor constructor = BundleRevisionImpl.getSecureAction().getConstructor(clazz, new Class[]{BundleWiringImpl.class, ClassLoader.class, Logger.class});
                this.m_classLoader = (BundleClassLoader)BundleRevisionImpl.getSecureAction().invoke(constructor, new Object[]{this, this.determineParentClassLoader(), this.m_logger});
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to create module class loader: " + exception.getMessage() + " [" + exception.getClass().getName() + "]");
            }
        }
        return this.m_classLoader;
    }

    @Override
    public List<URL> findEntries(String string, String string2, int n) {
        if (this.isInUse()) {
            if (!Util.isFragment(this.m_revision)) {
                Enumeration enumeration = ((BundleImpl)this.m_revision.getBundle()).getFramework().findBundleEntries(this.m_revision, string, string2, (n & 1) > 0);
                ArrayList<URL> arrayList = new ArrayList<URL>();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    arrayList.add((URL)enumeration.nextElement());
                }
                return ImmutableList.newInstance(arrayList);
            }
            return Collections.EMPTY_LIST;
        }
        return null;
    }

    @Override
    public synchronized Collection<String> listResources(String string, String string2, int n) {
        List<String> list;
        Collection<ResourceSource> collection;
        TreeSet<String> treeSet = null;
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) != '/') {
            string = String.valueOf(string) + '/';
        }
        if ((collection = this.listResourcesInternal(string, list = SimpleFilter.parseSubstring(string2 = string2 == null ? "*" : string2), n)) != null) {
            boolean bl = (n & 0x100000) > 0;
            treeSet = new TreeSet<String>();
            for (ResourceSource resourceSource : collection) {
                if (bl) {
                    treeSet.add(resourceSource.toString());
                    continue;
                }
                treeSet.add(resourceSource.m_resource);
            }
        }
        return treeSet;
    }

    private Collection<ResourceSource> listResourcesInternal(String string, List<String> list, int n) {
        if (this.isInUse()) {
            boolean bl = (n & 1) > 0;
            boolean bl2 = (n & 2) > 0;
            HashSet<String> hashSet = (HashSet<String>)this.m_listResourcesCycleCheck.get();
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.m_listResourcesCycleCheck.set(hashSet);
            }
            if (hashSet.contains(string)) {
                return Collections.EMPTY_LIST;
            }
            hashSet.add(string);
            try {
                String string2;
                List<BundleWire> list2;
                Object object;
                TreeSet<ResourceSource> treeSet = new TreeSet<ResourceSource>();
                HashSet<String> hashSet2 = new HashSet<String>();
                for (BundleWire object22 : this.m_wires) {
                    if (object22.getCapability().getNamespace().equals("osgi.wiring.package")) {
                        treeSet.addAll(this.calculateRemotePackageResources(object22, object22.getCapability(), bl, string, list, hashSet2));
                        continue;
                    }
                    if (!object22.getCapability().getNamespace().equals("osgi.wiring.bundle")) continue;
                    object = object22.getProviderWiring().getRevision().getDeclaredCapabilities("osgi.wiring.package");
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        list2 = (BundleCapability)iterator.next();
                        treeSet.addAll(this.calculateRemotePackageResources(object22, (BundleCapability)((Object)list2), bl, string, list, null));
                    }
                    list2 = object22.getProviderWiring().getRequiredWires("osgi.wiring.bundle");
                    for (BundleWire bundleWire : list2) {
                        string2 = bundleWire.getRequirement().getDirectives().get("visibility");
                        if (string2 == null || !string2.equals("reexport")) continue;
                        List<BundleCapability> list3 = bundleWire.getProviderWiring().getRevision().getDeclaredCapabilities("osgi.wiring.package");
                        for (BundleCapability bundleCapability : list3) {
                            treeSet.addAll(this.calculateRemotePackageResources(object22, bundleCapability, bl, string, list, null));
                        }
                    }
                }
                TreeSet<ResourceSource> treeSet2 = new TreeSet<ResourceSource>();
                List<Content> list4 = this.m_revision.getContentPath();
                list2 = list4.iterator();
                while (list2.hasNext()) {
                    object = (Content)list2.next();
                    Enumeration<String> enumeration = object.getEntries();
                    if (enumeration == null) continue;
                    while (enumeration.hasMoreElements()) {
                        String string3 = enumeration.nextElement();
                        string2 = BundleWiringImpl.getTrailingPath(string3);
                        if (hashSet2.contains(string2) || (bl || !string2.equals(string)) && (!bl || !string2.startsWith(string)) || !BundleWiringImpl.matchesPattern(list, BundleWiringImpl.getPathHead(string3))) continue;
                        treeSet2.add(new ResourceSource(string3, this.m_revision));
                    }
                }
                if (bl2) {
                    TreeSet<ResourceSource> treeSet3 = treeSet2;
                    return treeSet3;
                }
                treeSet.addAll(treeSet2);
                TreeSet<ResourceSource> treeSet4 = treeSet;
                return treeSet4;
            }
            finally {
                hashSet.remove(string);
                if (hashSet.isEmpty()) {
                    this.m_listResourcesCycleCheck.set(null);
                }
            }
        }
        return null;
    }

    private Collection<ResourceSource> calculateRemotePackageResources(BundleWire bundleWire, BundleCapability bundleCapability, boolean bl, String string, List<String> list, Set<String> set) {
        Collection<Object> collection = Collections.EMPTY_SET;
        String string2 = (String)bundleCapability.getAttributes().get("osgi.wiring.package");
        string2 = String.valueOf(string2.replace('.', '/')) + '/';
        if (set != null) {
            set.add(string2);
        }
        if (!bl && string2.equals(string) || bl && string2.startsWith(string)) {
            collection = ((BundleWiringImpl)bundleWire.getProviderWiring()).listResourcesInternal(string2, list, 0);
            Iterator<Object> iterator = collection.iterator();
            while (iterator.hasNext()) {
                ResourceSource resourceSource = (ResourceSource)iterator.next();
                if (resourceSource.m_resource.charAt(resourceSource.m_resource.length() - 1) != '/') continue;
                iterator.remove();
            }
        } else if (!bl && string2.startsWith(string)) {
            int n = string2.indexOf(47, string.length());
            if (n >= 0) {
                string2 = string2.substring(0, n + 1);
            }
            if (BundleWiringImpl.matchesPattern(list, BundleWiringImpl.getPathHead(string2))) {
                collection = Collections.singleton(new ResourceSource(string2, bundleWire.getProviderWiring().getRevision()));
            }
        }
        return collection;
    }

    private static String getPathHead(String string) {
        int n;
        if (string.length() == 0) {
            return string;
        }
        int n2 = n = string.charAt(string.length() - 1) == '/' ? string.lastIndexOf(47, string.length() - 2) : string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static String getTrailingPath(String string) {
        int n;
        if (string.length() == 0) {
            return null;
        }
        int n2 = n = string.charAt(string.length() - 1) == '/' ? string.lastIndexOf(47, string.length() - 2) : string.lastIndexOf(47);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n + 1);
    }

    private static boolean matchesPattern(List<String> list, String string) {
        if (string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        return SimpleFilter.compareSubstring(list, string);
    }

    @Override
    public Bundle getBundle() {
        return this.m_revision.getBundle();
    }

    private URL createURL(int n, String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        try {
            return BundleRevisionImpl.getSecureAction().createURL(null, "bundle://" + this.m_revision.getId() + ":" + n + string, ((BundleImpl)this.getBundle()).getFramework().getBundleStreamHandler());
        }
        catch (MalformedURLException malformedURLException) {
            this.m_logger.log(this.m_revision.getBundle(), 1, "Unable to create resource URL.", (Throwable)malformedURLException);
            return null;
        }
    }

    public Enumeration getResourcesByDelegation(String string) {
        HashSet<String> hashSet = (HashSet<String>)this.m_cycleCheck.get();
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.m_cycleCheck.set(hashSet);
        }
        if (!hashSet.contains(string)) {
            hashSet.add(string);
            try {
                Enumeration enumeration = this.findResourcesByDelegation(string);
                return enumeration;
            }
            finally {
                hashSet.remove(string);
            }
        }
        return null;
    }

    private Enumeration findResourcesByDelegation(String string) {
        Object object;
        Enumeration enumeration = null;
        ArrayList<Enumeration> arrayList = new ArrayList<Enumeration>();
        String string2 = Util.getResourcePackage(string);
        if (this.shouldBootDelegate(string2)) {
            try {
                object = this.getBootDelegationClassLoader();
                enumeration = ((ClassLoader)object).getResources(string);
            }
            catch (IOException iOException) {}
            if (string2.startsWith("java.")) {
                return enumeration;
            }
            arrayList.add(enumeration);
        }
        if ((object = this.m_importedPkgs.get(string2)) != null) {
            enumeration = ((BundleWiringImpl)object.getWiring()).getResourcesByDelegation(string);
            if (enumeration != null && enumeration.hasMoreElements()) {
                arrayList.add(enumeration);
            }
            return new CompoundEnumeration(arrayList.toArray(new Enumeration[arrayList.size()]));
        }
        List<BundleRevision> list = this.m_requiredPkgs.get(string2);
        if (list != null) {
            for (BundleRevision bundleRevision : list) {
                enumeration = ((BundleWiringImpl)bundleRevision.getWiring()).getResourcesByDelegation(string);
                if (enumeration == null || !enumeration.hasMoreElements()) continue;
                arrayList.add(enumeration);
            }
        }
        if ((enumeration = this.m_revision.getResourcesLocal(string)) != null && enumeration.hasMoreElements()) {
            arrayList.add(enumeration);
        } else {
            try {
                object = this.m_resolver.resolve(this.m_revision, string2);
            }
            catch (ResolutionException resolutionException) {
            }
            catch (BundleException bundleException) {}
            if (object != null && (enumeration = ((BundleWiringImpl)object.getWiring()).getResourcesByDelegation(string)) != null && enumeration.hasMoreElements()) {
                arrayList.add(enumeration);
            }
        }
        return new CompoundEnumeration(arrayList.toArray(new Enumeration[arrayList.size()]));
    }

    private ClassLoader determineParentClassLoader() {
        String string = (String)this.m_configMap.get("org.osgi.framework.bundle.parent");
        String string2 = string = string == null ? "boot" : string;
        ClassLoader classLoader = string.equalsIgnoreCase("app") ? BundleRevisionImpl.getSecureAction().getSystemClassLoader() : (string.equalsIgnoreCase("ext") ? BundleRevisionImpl.getSecureAction().getParentClassLoader(BundleRevisionImpl.getSecureAction().getSystemClassLoader()) : (string.equalsIgnoreCase("framework") ? BundleRevisionImpl.getSecureAction().getClassLoader(BundleRevisionImpl.class) : (this.m_bootClassLoader == null ? BundleRevisionImpl.getSecureAction().getSystemClassLoader() : null)));
        return classLoader;
    }

    boolean shouldBootDelegate(String string) {
        if (this.m_bootClassLoader != m_defBootClassLoader) {
            return true;
        }
        boolean bl = false;
        if (string.length() > 0) {
            int n = 0;
            while (!bl && n < ((BundleImpl)this.getBundle()).getFramework().getBootPackages().length) {
                if (((BundleImpl)this.getBundle()).getFramework().getBootPackageWildcards()[n] && string.startsWith(((BundleImpl)this.getBundle()).getFramework().getBootPackages()[n])) {
                    return true;
                }
                if (((BundleImpl)this.getBundle()).getFramework().getBootPackages()[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return bl;
    }

    synchronized ClassLoader getBootDelegationClassLoader() {
        ClassLoader classLoader = this.m_classLoader == null ? this.determineParentClassLoader() : BundleRevisionImpl.getSecureAction().getParentClassLoader(this.m_classLoader);
        return classLoader == null ? this.m_bootClassLoader : classLoader;
    }

    public Class getClassByDelegation(String string) throws ClassNotFoundException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[') {
            return Class.forName(string, false, this.getClassLoader());
        }
        if (this.isFiltered(string)) {
            throw new ClassNotFoundException(string);
        }
        ClassLoader classLoader = this.getClassLoaderInternal();
        if (classLoader == null) {
            throw new ClassNotFoundException("Unable to load class '" + string + "' because the bundle wiring for " + this.m_revision.getSymbolicName() + " is no longer valid.");
        }
        return classLoader.loadClass(string);
    }

    private boolean isFiltered(String string) {
        String string2 = Util.getClassPackage(string);
        List<List<String>> list = this.m_includedPkgFilters.get(string2);
        List<List<String>> list2 = this.m_excludedPkgFilters.get(string2);
        if (list == null && list2 == null) {
            return false;
        }
        String string3 = Util.getClassName(string);
        boolean bl = list == null;
        int n = 0;
        while (!bl && list != null && n < list.size()) {
            bl = SimpleFilter.compareSubstring(list.get(n), string3);
            ++n;
        }
        n = 0;
        int n2 = 0;
        while (n == 0 && list2 != null && n2 < list2.size()) {
            n = SimpleFilter.compareSubstring(list2.get(n2), string3) ? 1 : 0;
            ++n2;
        }
        return !bl || n != 0;
    }

    public URL getResourceByDelegation(String string) {
        try {
            return (URL)this.findClassOrResourceByDelegation(string, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.m_logger.log(this.m_revision.getBundle(), 4, resourceNotFoundException.getMessage());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object findClassOrResourceByDelegation(String var1_1, boolean var2_2) throws ClassNotFoundException, ResourceNotFoundException {
        block14: {
            var3_3 = null;
            var4_4 = (HashSet<String>)this.m_cycleCheck.get();
            if (var4_4 == null) {
                var4_4 = new HashSet<String>();
                this.m_cycleCheck.set(var4_4);
            }
            if (!var4_4.add(var1_1)) break block14;
            try {
                v0 = var5_5 = var2_2 != false ? Util.getClassPackage(var1_1) : Util.getResourcePackage(var1_1);
                if (!this.shouldBootDelegate(var5_5)) ** GOTO lbl21
                try {
                    var6_6 = this.getBootDelegationClassLoader();
                    v1 = var3_3 = var2_2 != false ? var6_6.loadClass(var1_1) : var6_6.getResource(var1_1);
                    if (var5_5.startsWith("java.") || var3_3 != null) {
                        var8_8 /* !! */  = var3_3;
                        return var8_8 /* !! */ ;
                    }
                    ** GOTO lbl21
                }
                catch (ClassNotFoundException var6_7) {
                    if (var5_5.startsWith("java.")) {
                        throw var6_7;
                    }
lbl21:
                    // 4 sources

                    if ((var3_3 = this.searchImports(var5_5, var1_1, var2_2)) != null) ** GOTO lbl40
                    if (var2_2) {
                        var6_6 = this.getClassLoaderInternal();
                        if (var6_6 == null) {
                            throw new ClassNotFoundException("Unable to load class '" + var1_1 + "' because the bundle wiring for " + this.m_revision.getSymbolicName() + " is no longer valid.");
                        }
                        var3_3 = ((BundleClassLoader)var6_6).findClass(var1_1);
                    } else {
                        var3_3 = this.m_revision.getResourceLocal(var1_1);
                    }
                    if (var3_3 != null) ** GOTO lbl40
                    var3_3 = this.searchDynamicImports(var5_5, var1_1, var2_2);
                }
            }
            finally {
                var4_4.remove(var1_1);
            }
        }
        return null;
lbl40:
        // 3 sources

        if (var3_3 == null) {
            if (var2_2) {
                throw new ClassNotFoundException(String.valueOf(var1_1) + " not found by " + this.getBundle());
            }
            throw new ResourceNotFoundException(String.valueOf(var1_1) + " not found by " + this.getBundle());
        }
        return var3_3;
    }

    private Object searchImports(String string, String string2, boolean bl) throws ClassNotFoundException, ResourceNotFoundException {
        BundleRevision bundleRevision = this.m_importedPkgs.get(string);
        if (bundleRevision != null) {
            Serializable serializable;
            Serializable serializable2 = serializable = bl ? ((BundleWiringImpl)bundleRevision.getWiring()).getClassByDelegation(string2) : ((BundleWiringImpl)bundleRevision.getWiring()).getResourceByDelegation(string2);
            if (serializable != null) {
                return serializable;
            }
            if (bl) {
                throw new ClassNotFoundException(string2);
            }
            throw new ResourceNotFoundException(string2);
        }
        List<BundleRevision> list = this.m_requiredPkgs.get(string);
        if (list != null) {
            for (BundleRevision bundleRevision2 : list) {
                try {
                    Serializable serializable;
                    Serializable serializable3 = serializable = bl ? ((BundleWiringImpl)bundleRevision2.getWiring()).getClassByDelegation(string2) : ((BundleWiringImpl)bundleRevision2.getWiring()).getResourceByDelegation(string2);
                    if (serializable == null) continue;
                    return serializable;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        return null;
    }

    private Object searchDynamicImports(String string, final String string2, final boolean bl) throws ClassNotFoundException, ResourceNotFoundException {
        BundleRevision bundleRevision = null;
        try {
            bundleRevision = this.m_resolver.resolve(this.m_revision, string);
        }
        catch (ResolutionException resolutionException) {
        }
        catch (BundleException bundleException) {}
        if (bundleRevision != null) {
            return bl ? ((BundleWiringImpl)bundleRevision.getWiring()).getClassByDelegation(string2) : ((BundleWiringImpl)bundleRevision.getWiring()).getResourceByDelegation(string2);
        }
        if (this.m_implicitBootDelegation) {
            final Class[] classArray = m_sm.getClassContext();
            try {
                if (System.getSecurityManager() != null) {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return BundleWiringImpl.this.doImplicitBootDelegation(classArray, string2, bl);
                        }
                    });
                }
                return this.doImplicitBootDelegation(classArray, string2, bl);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                throw (ResourceNotFoundException)exception;
            }
        }
        return null;
    }

    private Object doImplicitBootDelegation(Class[] classArray, String string, boolean bl) throws ClassNotFoundException, ResourceNotFoundException {
        int n = 1;
        while (n < classArray.length) {
            if (Thread.class.equals((Object)classArray[n]) || this.isClassLoadedFromBundleRevision(classArray[n]) || BundleImpl.class.equals((Object)classArray[n])) break;
            if (this.isClassExternal(classArray[n])) {
                try {
                    return bl ? BundleRevisionImpl.getSecureAction().getClassLoader(this.getClass()).loadClass(string) : BundleRevisionImpl.getSecureAction().getClassLoader(this.getClass()).getResource(string);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    break;
                }
            }
            ++n;
        }
        return null;
    }

    private boolean isClassLoadedFromBundleRevision(Class clazz) {
        if (BundleClassLoader.class.isInstance(BundleRevisionImpl.getSecureAction().getClassLoader(clazz))) {
            return true;
        }
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = BundleRevisionImpl.getSecureAction().getClassLoader(clazz);
        while (classLoader2 != null && classLoader != classLoader2) {
            classLoader = classLoader2;
            if (BundleClassLoader.class.isInstance(classLoader2)) {
                return true;
            }
            classLoader2 = BundleRevisionImpl.getSecureAction().getClassLoader(classLoader2.getClass());
        }
        return false;
    }

    private boolean isClassExternal(Class clazz) {
        if (clazz.getName().startsWith("org.apache.felix.framework.")) {
            return false;
        }
        if (clazz.getName().startsWith("org.osgi.framework.")) {
            return false;
        }
        if (ClassLoader.class.equals((Object)clazz)) {
            return false;
        }
        return !Class.class.equals((Object)clazz);
    }

    static URL convertToLocalUrl(URL uRL) {
        if (uRL.getProtocol().equals("bundle")) {
            try {
                uRL = ((URLHandlersBundleURLConnection)uRL.openConnection()).getLocalURL();
            }
            catch (IOException iOException) {}
        }
        return uRL;
    }

    private static String diagnoseClassLoadError(StatefulResolver statefulResolver, BundleRevision bundleRevision, String string) {
        String string2 = Util.getClassPackage(string);
        if (string2.length() == 0) {
            return null;
        }
        String string3 = bundleRevision.getBundle().toString();
        List<BundleWire> list = bundleRevision.getWiring() == null ? null : bundleRevision.getWiring().getProvidedWires(null);
        int n = 0;
        while (list != null && n < list.size()) {
            if (list.get(n).getCapability().getNamespace().equals("osgi.wiring.package") && list.get(n).getCapability().getAttributes().get("osgi.wiring.package").equals(string2)) {
                String string4 = list.get(n).getProviderWiring().getBundle().toString();
                StringBuffer stringBuffer = new StringBuffer("*** Package '");
                stringBuffer.append(string2);
                stringBuffer.append("' is imported by bundle ");
                stringBuffer.append(string3);
                stringBuffer.append(" from bundle ");
                stringBuffer.append(string4);
                stringBuffer.append(", but the exported package from bundle ");
                stringBuffer.append(string4);
                stringBuffer.append(" does not contain the requested class '");
                stringBuffer.append(string);
                stringBuffer.append("'. Please verify that the class name is correct in the importing bundle ");
                stringBuffer.append(string3);
                stringBuffer.append(" and/or that the exported package is correctly bundled in ");
                stringBuffer.append(string4);
                stringBuffer.append(". ***");
                return stringBuffer.toString();
            }
            ++n;
        }
        bundleRevision.getWiring().getRequirements(null);
        if (statefulResolver.isAllowedDynamicImport(bundleRevision, string2)) {
            Map map = Collections.EMPTY_MAP;
            Map<String, Object> map2 = Collections.singletonMap("osgi.wiring.package", string2);
            BundleRequirementImpl bundleRequirementImpl = new BundleRequirementImpl(bundleRevision, "osgi.wiring.package", map, map2);
            List<BundleCapability> list2 = statefulResolver.findProviders(bundleRequirementImpl, false);
            BundleRevision bundleRevision2 = null;
            try {
                bundleRevision2 = statefulResolver.resolve(bundleRevision, string2);
            }
            catch (Exception exception) {
                bundleRevision2 = null;
            }
            String string5 = list2.isEmpty() ? null : list2.iterator().next().toString();
            StringBuffer stringBuffer = new StringBuffer("*** Class '");
            stringBuffer.append(string);
            stringBuffer.append("' was not found, but this is likely normal since package '");
            stringBuffer.append(string2);
            stringBuffer.append("' is dynamically imported by bundle ");
            stringBuffer.append(string3);
            stringBuffer.append(".");
            if (list2.size() > 0 && bundleRevision2 == null) {
                stringBuffer.append(" However, bundle ");
                stringBuffer.append(string5);
                stringBuffer.append(" does export this package with attributes that do not match.");
            }
            stringBuffer.append(" ***");
            return stringBuffer.toString();
        }
        Map map = Collections.EMPTY_MAP;
        Map<String, Object> map3 = Collections.singletonMap("osgi.wiring.package", string2);
        BundleRequirementImpl bundleRequirementImpl = new BundleRequirementImpl(bundleRevision, "osgi.wiring.package", map, map3);
        List<BundleCapability> list3 = statefulResolver.findProviders(bundleRequirementImpl, false);
        if (list3.size() > 0) {
            boolean bl = false;
            try {
                BundleRevisionImpl.getSecureAction().getClassLoader(BundleClassLoader.class).loadClass(string);
                bl = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {}
            String string6 = list3.iterator().next().toString();
            StringBuffer stringBuffer = new StringBuffer("*** Class '");
            stringBuffer.append(string);
            stringBuffer.append("' was not found because bundle ");
            stringBuffer.append(string3);
            stringBuffer.append(" does not import '");
            stringBuffer.append(string2);
            stringBuffer.append("' even though bundle ");
            stringBuffer.append(string6);
            stringBuffer.append(" does export it.");
            if (bl) {
                stringBuffer.append(" Additionally, the class is also available from the system class loader. There are two fixes: 1) Add an import for '");
                stringBuffer.append(string2);
                stringBuffer.append("' to bundle ");
                stringBuffer.append(string3);
                stringBuffer.append("; imports are necessary for each class directly touched by bundle code or indirectly touched, such as super classes if their methods are used. ");
                stringBuffer.append("2) Add package '");
                stringBuffer.append(string2);
                stringBuffer.append("' to the '");
                stringBuffer.append("org.osgi.framework.bootdelegation");
                stringBuffer.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            } else {
                stringBuffer.append(" To resolve this issue, add an import for '");
                stringBuffer.append(string2);
                stringBuffer.append("' to bundle ");
                stringBuffer.append(string3);
                stringBuffer.append(".");
            }
            stringBuffer.append(" ***");
            return stringBuffer.toString();
        }
        try {
            BundleRevisionImpl.getSecureAction().getClassLoader(BundleClassLoader.class).loadClass(string);
            StringBuffer stringBuffer = new StringBuffer("*** Package '");
            stringBuffer.append(string2);
            stringBuffer.append("' is not imported by bundle ");
            stringBuffer.append(string3);
            stringBuffer.append(", nor is there any bundle that exports package '");
            stringBuffer.append(string2);
            stringBuffer.append("'. However, the class '");
            stringBuffer.append(string);
            stringBuffer.append("' is available from the system class loader. There are two fixes: 1) Add package '");
            stringBuffer.append(string2);
            stringBuffer.append("' to the '");
            stringBuffer.append("org.osgi.framework.system.packages.extra");
            stringBuffer.append("' property and modify bundle ");
            stringBuffer.append(string3);
            stringBuffer.append(" to import this package; this causes the system bundle to export class path packages. 2) Add package '");
            stringBuffer.append(string2);
            stringBuffer.append("' to the '");
            stringBuffer.append("org.osgi.framework.bootdelegation");
            stringBuffer.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            stringBuffer.append(" ***");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("*** Class '");
            stringBuffer.append(string);
            stringBuffer.append("' was not found. Bundle ");
            stringBuffer.append(string3);
            stringBuffer.append(" does not import package '");
            stringBuffer.append(string2);
            stringBuffer.append("', nor is the package exported by any other bundle or available from the system class loader.");
            stringBuffer.append(" ***");
            return stringBuffer.toString();
        }
    }

    public static class BundleClassLoader
    extends SecureClassLoader
    implements BundleReference {
        private volatile boolean m_isActivationTriggered = false;
        private final Map m_jarContentToDexFile;
        private Object[][] m_cachedLibs = new Object[0][];
        private static final int LIBNAME_IDX = 0;
        private static final int LIBPATH_IDX = 1;
        private final Map<String, Thread> m_classLocks = new HashMap<String, Thread>();
        private final BundleWiringImpl m_wiring;
        private final Logger m_logger;

        static {
            try {
                Method method = BundleRevisionImpl.getSecureAction().getDeclaredMethod(ClassLoader.class, "registerAsParallelCapable", null);
                BundleRevisionImpl.getSecureAction().setAccesssible(method);
                method.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {}
        }

        public BundleClassLoader(BundleWiringImpl bundleWiringImpl, ClassLoader classLoader, Logger logger) {
            super(classLoader);
            this.m_jarContentToDexFile = m_dexFileClassLoadClass != null ? new HashMap() : null;
            this.m_wiring = bundleWiringImpl;
            this.m_logger = logger;
        }

        protected boolean isParallel() {
            return false;
        }

        public boolean isActivationTriggered() {
            return this.m_isActivationTriggered;
        }

        @Override
        public Bundle getBundle() {
            return this.m_wiring.getBundle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class clazz;
            Object object;
            Object object2 = object = this.isParallel() ? this.m_classLocks : this;
            synchronized (object2) {
                clazz = this.findLoadedClass(string);
            }
            if (clazz == null) {
                try {
                    clazz = (Class)this.m_wiring.findClassOrResourceByDelegation(string, true);
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassNotFoundException classNotFoundException2 = classNotFoundException;
                    if (this.m_logger.getLogLevel() >= 4) {
                        String string2 = BundleWiringImpl.diagnoseClassLoadError(this.m_wiring.m_resolver, this.m_wiring.m_revision, string);
                        classNotFoundException2 = string2 != null ? new ClassNotFoundException(string2, classNotFoundException) : classNotFoundException2;
                    }
                    throw classNotFoundException2;
                }
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class findClass(String string) throws ClassNotFoundException {
            Class clazz = null;
            if (this.m_wiring.m_isDisposed) {
                throw new ClassNotFoundException("Unable to load class '" + string + "' because the bundle wiring for " + this.m_wiring.m_revision.getSymbolicName() + " is no longer valid.");
            }
            if (clazz == null) {
                String string2 = String.valueOf(string.replace('.', '/')) + ".class";
                byte[] byArray = null;
                List<Content> list = this.m_wiring.m_revision.getContentPath();
                Content content = null;
                int n = 0;
                while (byArray == null && n < list.size()) {
                    byArray = list.get(n).getEntryAsBytes(string2);
                    content = list.get(n);
                    ++n;
                }
                if (byArray != null) {
                    Object[] objectArray;
                    Object object;
                    String string3 = Util.getClassPackage(string);
                    Felix felix = ((BundleImpl)this.m_wiring.m_revision.getBundle()).getFramework();
                    Set<ServiceReference<WeavingHook>> set = felix.getHookRegistry().getHooks(WeavingHook.class);
                    Set<ServiceReference<WovenClassListener>> set2 = felix.getHookRegistry().getHooks(WovenClassListener.class);
                    WovenClassImpl wovenClassImpl = null;
                    if (!set.isEmpty()) {
                        wovenClassImpl = new WovenClassImpl(string, this.m_wiring, byArray);
                        try {
                            this.transformClass(felix, wovenClassImpl, set, set2, string, byArray);
                        }
                        catch (Error error) {
                            wovenClassImpl.complete(null, null, null);
                            wovenClassImpl.setState(8);
                            this.callWovenClassListeners(felix, set2, wovenClassImpl);
                            throw error;
                        }
                    }
                    Object object2 = object = this.isParallel() ? this.m_classLocks : this;
                    synchronized (object2) {
                        objectArray = Thread.currentThread();
                        while (this.m_classLocks.containsKey(string) && this.m_classLocks.get(string) != objectArray) {
                            try {
                                object.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                throw new RuntimeException(interruptedException);
                            }
                        }
                        clazz = this.findLoadedClass(string);
                        if (clazz == null) {
                            this.m_classLocks.put(string, (Thread)objectArray);
                        }
                    }
                    try {
                        clazz = this.defineClass(felix, set2, wovenClassImpl, string, clazz, byArray, content, string3, object);
                    }
                    catch (ClassFormatError classFormatError) {
                        if (wovenClassImpl != null) {
                            wovenClassImpl.setState(16);
                            this.callWovenClassListeners(felix, set2, wovenClassImpl);
                        }
                        throw classFormatError;
                    }
                    object2 = (List)m_deferredActivation.get();
                    if (object2 != null && object2.size() > 0 && ((Object[])object2.get(0))[0].equals(string)) {
                        m_deferredActivation.set(null);
                        while (!object2.isEmpty()) {
                            objectArray = (Object[])object2.remove(object2.size() - 1);
                            try {
                                felix.getFramework().activateBundle((BundleImpl)objectArray[1], true);
                            }
                            catch (Throwable throwable) {
                                this.m_logger.log((BundleImpl)objectArray[1], 2, "Unable to lazily start bundle.", throwable);
                            }
                        }
                    }
                }
            }
            return clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        Class defineClass(Felix felix, Set<ServiceReference<WovenClassListener>> set, WovenClassImpl wovenClassImpl, String string, Class clazz, byte[] byArray, Content content, String string2, Object object) throws ClassFormatError {
            block30: {
                try {
                    boolean bl;
                    if (clazz != null) break block30;
                    if (wovenClassImpl != null) {
                        Object object2;
                        byArray = wovenClassImpl._getBytes();
                        List<String> list = wovenClassImpl.getDynamicImportsInternal();
                        ArrayList<BundleRequirement> arrayList = new ArrayList<BundleRequirement>();
                        for (String object22 : list) {
                            try {
                                object2 = ManifestParser.parseDynamicImportHeader(this.m_logger, this.m_wiring.m_revision, object22);
                                arrayList.addAll((Collection<BundleRequirement>)object2);
                            }
                            catch (BundleException bundleException) {}
                        }
                        if (!arrayList.isEmpty()) {
                            HashSet<String> hashSet = new HashSet<String>();
                            if (this.m_wiring.m_wovenReqs != null) {
                                for (Object object4 : this.m_wiring.m_wovenReqs) {
                                    hashSet.add(((BundleRequirementImpl)object4).getFilter().toString());
                                }
                            }
                            int n = arrayList.size();
                            while (n < arrayList.size()) {
                                object2 = (BundleRequirement)arrayList.get(n);
                                String string3 = ((BundleRequirementImpl)object2).getFilter().toString();
                                if (!hashSet.contains(string3)) {
                                    hashSet.add(string3);
                                    ++n;
                                    continue;
                                }
                                arrayList.remove(n);
                            }
                            if (!arrayList.isEmpty()) {
                                if (this.m_wiring.m_wovenReqs != null) {
                                    arrayList.addAll(0, this.m_wiring.m_wovenReqs);
                                }
                                this.m_wiring.m_wovenReqs = arrayList;
                            }
                        }
                    }
                    int n = ((BundleImpl)this.getBundle()).isDeclaredActivationPolicyUsed() ? ((BundleRevisionImpl)this.getBundle().adapt(BundleRevision.class)).getDeclaredActivationPolicy() : 0;
                    boolean bl2 = bl = this.m_isActivationTriggered ? false : this.m_wiring.m_revision.isActivationTrigger(string2);
                    if (!this.m_isActivationTriggered && bl && n == 1 && this.getBundle().getState() == 8) {
                        void var12_21;
                        List list = (List)m_deferredActivation.get();
                        if (list == null) {
                            ArrayList arrayList = new ArrayList();
                            m_deferredActivation.set(arrayList);
                        }
                        var12_21.add(new Object[]{string, this.getBundle()});
                    }
                    if (string2.length() > 0 && this.getPackage(string2) == null) {
                        Object[] objectArray = this.definePackage(string2);
                        try {
                            this.definePackage(string2, (String)objectArray[0], (String)objectArray[1], (String)objectArray[2], (String)objectArray[3], (String)objectArray[4], (String)objectArray[5], null);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    if (content instanceof JarContent) {
                        try {
                            clazz = this.getDexFileClass((JarContent)content, string, this);
                        }
                        catch (Exception exception) {}
                    }
                    if (clazz == null) {
                        clazz = this.m_wiring.m_revision.getProtectionDomain() != null ? this.defineClass(string, byArray, 0, byArray.length, this.m_wiring.m_revision.getProtectionDomain()) : this.defineClass(string, byArray, 0, byArray.length);
                        if (wovenClassImpl != null) {
                            wovenClassImpl.completeDefine(clazz);
                            wovenClassImpl.setState(4);
                            this.callWovenClassListeners(felix, set, wovenClassImpl);
                        }
                    }
                    if (!this.m_isActivationTriggered && bl && clazz != null) {
                        this.m_isActivationTriggered = true;
                    }
                }
                catch (Throwable throwable) {
                    Object object3 = object;
                    synchronized (object3) {
                        this.m_classLocks.remove(string);
                        object.notifyAll();
                    }
                    throw throwable;
                }
            }
            Object object4 = object;
            synchronized (object4) {
                this.m_classLocks.remove(string);
                object.notifyAll();
            }
            return clazz;
        }

        void transformClass(Felix felix, WovenClassImpl wovenClassImpl, Set<ServiceReference<WeavingHook>> set, Set<ServiceReference<WovenClassListener>> set2, String string, byte[] byArray) throws Error {
            for (ServiceReference<WeavingHook> serviceReference : set) {
                WeavingHook weavingHook;
                if (felix.getHookRegistry().isHookBlackListed(serviceReference) || (weavingHook = felix.getService(felix, serviceReference, false)) == null) continue;
                try {
                    try {
                        BundleRevisionImpl.getSecureAction().invokeWeavingHook(weavingHook, wovenClassImpl);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof WeavingException)) {
                            felix.getHookRegistry().blackListHook(serviceReference);
                        }
                        felix.fireFrameworkEvent(2, serviceReference.getBundle(), throwable);
                        ClassFormatError classFormatError = new ClassFormatError("Weaving hook failed.");
                        classFormatError.initCause(throwable);
                        throw classFormatError;
                    }
                }
                finally {
                    felix.ungetService(felix, serviceReference, null);
                }
            }
            wovenClassImpl.setState(2);
            this.callWovenClassListeners(felix, set2, wovenClassImpl);
        }

        protected void callWovenClassListeners(Felix felix, Set<ServiceReference<WovenClassListener>> set, WovenClass wovenClass) {
            if (set != null) {
                for (ServiceReference<WovenClassListener> serviceReference : set) {
                    WovenClassListener wovenClassListener = felix.getService(felix, serviceReference, false);
                    try {
                        try {
                            BundleRevisionImpl.getSecureAction().invokeWovenClassListener(wovenClassListener, wovenClass);
                        }
                        catch (Exception exception) {
                            this.m_logger.log(1, "Woven Class Listner failed.", exception);
                            felix.ungetService(felix, serviceReference, null);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        felix.ungetService(felix, serviceReference, null);
                        throw throwable;
                    }
                    felix.ungetService(felix, serviceReference, null);
                }
            }
        }

        private Object[] definePackage(String string) {
            String string2 = (String)this.m_wiring.m_revision.getHeaders().get("Specification-Title");
            String string3 = (String)this.m_wiring.m_revision.getHeaders().get("Specification-Version");
            String string4 = (String)this.m_wiring.m_revision.getHeaders().get("Specification-Vendor");
            String string5 = (String)this.m_wiring.m_revision.getHeaders().get("Implementation-Title");
            String string6 = (String)this.m_wiring.m_revision.getHeaders().get("Implementation-Version");
            String string7 = (String)this.m_wiring.m_revision.getHeaders().get("Implementation-Vendor");
            if (string2 != null || string3 != null || string4 != null || string5 != null || string6 != null || string7 != null) {
                return new Object[]{string2, string3, string4, string5, string6, string7};
            }
            return new Object[6];
        }

        private Class getDexFileClass(JarContent jarContent, String string, ClassLoader classLoader) throws Exception {
            if (this.m_jarContentToDexFile == null) {
                return null;
            }
            Object object = null;
            if (!this.m_jarContentToDexFile.containsKey(jarContent)) {
                try {
                    if (m_dexFileClassLoadDex != null) {
                        object = m_dexFileClassLoadDex.invoke(null, jarContent.getFile().getAbsolutePath(), String.valueOf(jarContent.getFile().getAbsolutePath()) + ".dex", new Integer(0));
                    }
                    object = m_dexFileClassConstructor.newInstance(jarContent.getFile());
                }
                finally {
                    this.m_jarContentToDexFile.put(jarContent, object);
                }
            } else {
                object = this.m_jarContentToDexFile.get(jarContent);
            }
            if (object != null) {
                return (Class)m_dexFileClassLoadClass.invoke(object, string.replace('.', '/'), classLoader);
            }
            return null;
        }

        @Override
        public URL getResource(String string) {
            URL uRL = this.m_wiring.getResourceByDelegation(string);
            if (this.m_wiring.m_useLocalURLs) {
                uRL = BundleWiringImpl.convertToLocalUrl(uRL);
            }
            return uRL;
        }

        @Override
        protected URL findResource(String string) {
            return this.m_wiring.m_revision.getResourceLocal(string);
        }

        protected Enumeration findResources(String string) {
            Enumeration enumeration = this.m_wiring.getResourcesByDelegation(string);
            if (this.m_wiring.m_useLocalURLs) {
                enumeration = new ToLocalUrlEnumeration(enumeration);
            }
            return enumeration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String findLibrary(String string) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            String string2 = null;
            BundleClassLoader bundleClassLoader = this;
            synchronized (bundleClassLoader) {
                int n = 0;
                while (string2 == null && n < this.m_cachedLibs.length) {
                    if (this.m_cachedLibs[n][0].equals(string)) {
                        string2 = (String)this.m_cachedLibs[n][1];
                    }
                    ++n;
                }
                if (string2 == null) {
                    List<NativeLibrary> list = this.m_wiring.getNativeLibraries();
                    int n2 = 0;
                    while (list != null && n2 < list.size()) {
                        if (list.get(n2).match(this.m_wiring.m_configMap, string)) {
                            string2 = this.m_wiring.m_revision.getContent().getEntryAsNativeLibrary(list.get(n2).getEntryName());
                            int n3 = 0;
                            while (string2 == null && this.m_wiring.m_fragmentContents != null && n3 < this.m_wiring.m_fragmentContents.size()) {
                                string2 = ((Content)this.m_wiring.m_fragmentContents.get(n3)).getEntryAsNativeLibrary(list.get(n2).getEntryName());
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                    if (string2 != null) {
                        Object[][] objectArrayArray = new Object[this.m_cachedLibs.length + 1][];
                        System.arraycopy(this.m_cachedLibs, 0, objectArrayArray, 0, this.m_cachedLibs.length);
                        objectArrayArray[this.m_cachedLibs.length] = new Object[]{string, string2};
                        this.m_cachedLibs = objectArrayArray;
                    }
                }
            }
            return string2;
        }

        public String toString() {
            return this.m_wiring.toString();
        }
    }

    public static class BundleClassLoaderJava5
    extends BundleClassLoader {
        static final boolean m_isParallel;
        private final BundleWiringImpl m_wiring;

        static {
            boolean bl = false;
            try {
                Method method = BundleRevisionImpl.getSecureAction().getDeclaredMethod(ClassLoader.class, "registerAsParallelCapable", null);
                BundleRevisionImpl.getSecureAction().setAccesssible(method);
                bl = (Boolean)method.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {}
            m_isParallel = bl;
        }

        @Override
        protected boolean isParallel() {
            return m_isParallel;
        }

        public BundleClassLoaderJava5(BundleWiringImpl bundleWiringImpl, ClassLoader classLoader, Logger logger) {
            super(bundleWiringImpl, classLoader, logger);
            this.m_wiring = bundleWiringImpl;
        }

        public Enumeration getResources(String string) {
            Enumeration enumeration = this.m_wiring.getResourcesByDelegation(string);
            if (this.m_wiring.m_useLocalURLs) {
                enumeration = new ToLocalUrlEnumeration(enumeration);
            }
            return enumeration;
        }

        @Override
        protected Enumeration findResources(String string) {
            return this.m_wiring.m_revision.getResourcesLocal(string);
        }
    }

    private static class ResourceSource
    implements Comparable<ResourceSource> {
        public final String m_resource;
        public final BundleRevision m_revision;

        public ResourceSource(String string, BundleRevision bundleRevision) {
            this.m_resource = string;
            this.m_revision = bundleRevision;
        }

        public boolean equals(Object object) {
            if (object instanceof ResourceSource) {
                return this.m_resource.equals(((ResourceSource)object).m_resource);
            }
            return false;
        }

        public int hashCode() {
            return this.m_resource.hashCode();
        }

        @Override
        public int compareTo(ResourceSource resourceSource) {
            return this.m_resource.compareTo(resourceSource.m_resource);
        }

        public String toString() {
            return String.valueOf(this.m_resource) + " -> " + this.m_revision.getSymbolicName() + " [" + this.m_revision + "]";
        }
    }

    static class ToLocalUrlEnumeration
    implements Enumeration {
        final Enumeration m_enumeration;

        ToLocalUrlEnumeration(Enumeration enumeration) {
            this.m_enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_enumeration.hasMoreElements();
        }

        public Object nextElement() {
            return BundleWiringImpl.convertToLocalUrl((URL)this.m_enumeration.nextElement());
        }
    }
}

