/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.NativeLibrary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class BundleRevisionImpl
implements BundleRevision,
Resource {
    public static final int EAGER_ACTIVATION = 0;
    public static final int LAZY_ACTIVATION = 1;
    private final String m_id;
    private final Map m_headerMap;
    private final String m_manifestVersion;
    private final boolean m_isExtension;
    private final boolean m_isFragment;
    private final String m_symbolicName;
    private final Version m_version;
    private final List<BundleCapability> m_declaredCaps;
    private final List<BundleRequirement> m_declaredReqs;
    private final List<NativeLibrary> m_declaredNativeLibs;
    private final int m_declaredActivationPolicy;
    private final List<String> m_activationIncludes;
    private final List<String> m_activationExcludes;
    private final Bundle m_bundle;
    private Content m_content;
    private List<Content> m_contentPath;
    private ProtectionDomain m_protectionDomain = null;
    private static final SecureAction m_secureAction = new SecureAction();
    private volatile BundleWiringImpl m_wiring = null;

    public BundleRevisionImpl(Bundle bundle, String string) {
        this.m_bundle = bundle;
        this.m_id = string;
        this.m_headerMap = null;
        this.m_content = null;
        this.m_manifestVersion = "";
        this.m_symbolicName = null;
        this.m_isExtension = false;
        this.m_isFragment = false;
        this.m_version = null;
        this.m_declaredCaps = Collections.EMPTY_LIST;
        this.m_declaredReqs = Collections.EMPTY_LIST;
        this.m_declaredNativeLibs = null;
        this.m_declaredActivationPolicy = 0;
        this.m_activationExcludes = null;
        this.m_activationIncludes = null;
    }

    BundleRevisionImpl(Bundle bundle, String string, Map map, Content content) throws BundleException {
        this.m_bundle = bundle;
        this.m_id = string;
        this.m_headerMap = map;
        this.m_content = content;
        ManifestParser manifestParser = new ManifestParser(((BundleImpl)bundle).getFramework().getLogger(), ((BundleImpl)bundle).getFramework().getConfig(), this, this.m_headerMap);
        this.m_manifestVersion = manifestParser.getManifestVersion();
        this.m_version = manifestParser.getBundleVersion();
        this.m_declaredCaps = manifestParser.getCapabilities();
        this.m_declaredReqs = manifestParser.getRequirements();
        this.m_declaredNativeLibs = manifestParser.getLibraries();
        this.m_declaredActivationPolicy = manifestParser.getActivationPolicy();
        this.m_activationExcludes = manifestParser.getActivationExcludeDirective() == null ? null : ManifestParser.parseDelimitedString(manifestParser.getActivationExcludeDirective(), ",");
        this.m_activationIncludes = manifestParser.getActivationIncludeDirective() == null ? null : ManifestParser.parseDelimitedString(manifestParser.getActivationIncludeDirective(), ",");
        this.m_symbolicName = manifestParser.getSymbolicName();
        this.m_isExtension = manifestParser.isExtension();
        this.m_isFragment = this.m_headerMap.containsKey("Fragment-Host");
    }

    static SecureAction getSecureAction() {
        return m_secureAction;
    }

    int getDeclaredActivationPolicy() {
        return this.m_declaredActivationPolicy;
    }

    boolean isActivationTrigger(String string) {
        if (this.m_activationIncludes == null && this.m_activationExcludes == null) {
            return true;
        }
        boolean bl = this.m_activationIncludes == null;
        int n = 0;
        while (!bl && this.m_activationIncludes != null && n < this.m_activationIncludes.size()) {
            bl = this.m_activationIncludes.get(n).equals(string);
            ++n;
        }
        n = 0;
        int n2 = 0;
        while (n == 0 && this.m_activationExcludes != null && n2 < this.m_activationExcludes.size()) {
            n = this.m_activationExcludes.get(n2).equals(string) ? 1 : 0;
            ++n2;
        }
        return bl && n == 0;
    }

    @Override
    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.m_version;
    }

    @Override
    public List<Capability> getCapabilities(String string) {
        return BundleRevisionImpl.asCapabilityList(this.getDeclaredCapabilities(string));
    }

    static List<Capability> asCapabilityList(List list) {
        return list;
    }

    @Override
    public List<BundleCapability> getDeclaredCapabilities(String string) {
        List<BundleCapability> list = this.m_declaredCaps;
        if (string != null) {
            list = new ArrayList<BundleCapability>();
            for (BundleCapability bundleCapability : this.m_declaredCaps) {
                if (!bundleCapability.getNamespace().equals(string)) continue;
                list.add(bundleCapability);
            }
        }
        return list;
    }

    @Override
    public List<Requirement> getRequirements(String string) {
        return BundleRevisionImpl.asRequirementList(this.getDeclaredRequirements(string));
    }

    static List<Requirement> asRequirementList(List list) {
        return list;
    }

    @Override
    public List<BundleRequirement> getDeclaredRequirements(String string) {
        List<BundleRequirement> list = this.m_declaredReqs;
        if (string != null) {
            list = new ArrayList<BundleRequirement>();
            for (BundleRequirement bundleRequirement : this.m_declaredReqs) {
                if (!bundleRequirement.getNamespace().equals(string)) continue;
                list.add(bundleRequirement);
            }
        }
        return list;
    }

    @Override
    public int getTypes() {
        return this.getManifestVersion().equals("2") && this.m_isFragment ? 1 : 0;
    }

    @Override
    public BundleWiring getWiring() {
        return this.m_wiring;
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundle;
    }

    public Map getHeaders() {
        return this.m_headerMap;
    }

    public boolean isExtension() {
        return this.m_isExtension;
    }

    public String getManifestVersion() {
        return this.m_manifestVersion;
    }

    public List<NativeLibrary> getDeclaredNativeLibraries() {
        return this.m_declaredNativeLibs;
    }

    public String getId() {
        return this.m_id;
    }

    public synchronized void resolve(BundleWiringImpl bundleWiringImpl) {
        if (this.m_wiring != null) {
            this.m_wiring.dispose();
            this.m_wiring = null;
        }
        if (bundleWiringImpl != null) {
            if (!Util.getFragments(bundleWiringImpl).isEmpty()) {
                int n = 0;
                while (this.m_contentPath != null && n < this.m_contentPath.size()) {
                    if (this.m_content != this.m_contentPath.get(n)) {
                        this.m_contentPath.get(n).close();
                    }
                    ++n;
                }
                this.m_contentPath = null;
            }
            this.m_wiring = bundleWiringImpl;
        }
    }

    public synchronized void setProtectionDomain(ProtectionDomain protectionDomain) {
        this.m_protectionDomain = protectionDomain;
    }

    public synchronized ProtectionDomain getProtectionDomain() {
        return this.m_protectionDomain;
    }

    public synchronized Content getContent() {
        return this.m_content;
    }

    synchronized void resetContent(Content content) {
        this.m_content = content;
    }

    synchronized List<Content> getContentPath() {
        if (this.m_contentPath == null) {
            try {
                this.m_contentPath = this.initializeContentPath();
            }
            catch (Exception exception) {
                ((BundleImpl)this.m_bundle).getFramework().getLogger().log(this.m_bundle, 1, "Unable to get module class path.", (Throwable)exception);
            }
        }
        return this.m_contentPath;
    }

    private List<Content> initializeContentPath() throws Exception {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        this.calculateContentPath(this, this.getContent(), arrayList, true);
        List<BundleRevision> list = null;
        List<Content> list2 = null;
        if (this.m_wiring != null) {
            list = this.m_wiring.getFragments();
            list2 = this.m_wiring.getFragmentContents();
        }
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                this.calculateContentPath(list.get(n), list2.get(n), arrayList, false);
                ++n;
            }
        }
        return arrayList;
    }

    private List calculateContentPath(BundleRevision bundleRevision, Content content, List<Content> list, boolean bl) throws Exception {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        String string = (String)((BundleRevisionImpl)bundleRevision).getHeaders().get("Bundle-ClassPath");
        List<String> list2 = ManifestParser.parseDelimitedString(string, ",");
        if (list2 == null) {
            list2 = new ArrayList<String>(0);
        }
        int n = 0;
        while (n < list2.size()) {
            list2.set(n, list2.get(n).startsWith("/") ? list2.get(n).substring(1) : list2.get(n));
            if (list2.get(n).equals(".")) {
                arrayList.add(content);
            } else {
                Content content2 = content.getEntryAsContent(list2.get(n));
                List<Content> list3 = this.m_wiring == null ? null : this.m_wiring.getFragmentContents();
                int n2 = 0;
                while (bl && content2 == null && list3 != null && n2 < list3.size()) {
                    content2 = list3.get(n2).getEntryAsContent(list2.get(n));
                    ++n2;
                }
                if (content2 != null) {
                    arrayList.add(content2);
                } else {
                    ((BundleImpl)this.m_bundle).getFramework().getLogger().log(this.getBundle(), 3, "Class path entry not found: " + list2.get(n));
                }
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            arrayList.add(content);
        }
        list.addAll(arrayList);
        return list;
    }

    URL getResourceLocal(String string) {
        URL uRL = null;
        if (string.equals("/")) {
            uRL = this.createURL(1, string);
        } else if (string.startsWith("/")) {
            string = string.substring(1);
        }
        List<Content> list = this.getContentPath();
        int n = 0;
        while (uRL == null && n < list.size()) {
            if (list.get(n).hasEntry(string)) {
                uRL = this.createURL(n + 1, string);
            }
            ++n;
        }
        return uRL;
    }

    Enumeration getResourcesLocal(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        List<Content> list = this.getContentPath();
        if (list == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        if (string.equals("/")) {
            int n = 0;
            while (n < list.size()) {
                arrayList.add(this.createURL(n + 1, string));
                ++n;
            }
        } else {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            int n = 0;
            while (n < list.size()) {
                if (list.get(n).hasEntry(string)) {
                    arrayList.add(this.createURL(n + 1, string));
                }
                ++n;
            }
        }
        return Collections.enumeration(arrayList);
    }

    public URL getEntry(String string) {
        URL uRL = null;
        if (string.equals("/")) {
            uRL = this.createURL(0, "/");
        }
        if (uRL == null) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (this.getContent().hasEntry(string)) {
                uRL = this.createURL(0, string);
            }
        }
        return uRL;
    }

    public boolean hasInputStream(int n, String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (n == 0) {
            return this.getContent().hasEntry(string);
        }
        return this.getContentPath().get(n - 1).hasEntry(string);
    }

    public InputStream getInputStream(int n, String string) throws IOException {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (n == 0) {
            return this.getContent().getEntryAsStream(string);
        }
        return this.getContentPath().get(n - 1).getEntryAsStream(string);
    }

    public URL getLocalURL(int n, String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (n == 0) {
            return this.getContent().getEntryAsURL(string);
        }
        return this.getContentPath().get(n - 1).getEntryAsURL(string);
    }

    private URL createURL(int n, String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        try {
            return m_secureAction.createURL(null, "bundle://" + this.m_id + ":" + n + string, ((BundleImpl)this.getBundle()).getFramework().getBundleStreamHandler());
        }
        catch (MalformedURLException malformedURLException) {
            ((BundleImpl)this.m_bundle).getFramework().getLogger().log(this.m_bundle, 1, "Unable to create resource URL.", (Throwable)malformedURLException);
            return null;
        }
    }

    synchronized void close() {
        try {
            this.resolve(null);
        }
        catch (Exception exception) {
            ((BundleImpl)this.m_bundle).getFramework().getLogger().log(1, "Error releasing revision: " + exception.getMessage(), exception);
        }
        this.m_content.close();
        this.m_content = null;
        int n = 0;
        while (this.m_contentPath != null && n < this.m_contentPath.size()) {
            this.m_contentPath.get(n).close();
            ++n;
        }
        this.m_contentPath = null;
    }

    public String toString() {
        return String.valueOf(this.m_bundle.toString()) + "(R " + this.m_id + ")";
    }
}

