/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.wiring.BundleWireImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

class BundleRevisionDependencies {
    private final Map<BundleRevision, Map<BundleCapability, Set<BundleWire>>> m_dependentsMap = new HashMap<BundleRevision, Map<BundleCapability, Set<BundleWire>>>();

    BundleRevisionDependencies() {
    }

    public synchronized void addDependent(BundleWire bundleWire) {
        Set<BundleWire> set;
        BundleRevision bundleRevision = bundleWire.getProvider();
        Map<BundleCapability, Set<BundleWire>> map = this.m_dependentsMap.get(bundleRevision);
        if (map == null) {
            map = new HashMap<BundleCapability, Set<BundleWire>>();
            this.m_dependentsMap.put(bundleRevision, map);
        }
        if ((set = map.get(bundleWire.getCapability())) == null) {
            set = new HashSet<BundleWire>();
            map.put(bundleWire.getCapability(), set);
        }
        set.add(bundleWire);
    }

    public synchronized void removeDependents(BundleRevision bundleRevision) {
        this.m_dependentsMap.remove(bundleRevision);
    }

    public synchronized Map<BundleCapability, Set<BundleWire>> getDependents(BundleRevision bundleRevision) {
        return this.m_dependentsMap.get(bundleRevision);
    }

    public synchronized boolean hasDependents(BundleRevision bundleRevision) {
        if (Util.isFragment(bundleRevision) && bundleRevision.getWiring() != null && !bundleRevision.getWiring().getRequiredWires(null).isEmpty()) {
            return true;
        }
        return this.m_dependentsMap.containsKey(bundleRevision);
    }

    public synchronized boolean hasDependents(Bundle bundle) {
        List<BundleRevision> list = bundle.adapt(BundleRevisions.class).getRevisions();
        for (BundleRevision bundleRevision : list) {
            if (!this.hasDependents(bundleRevision)) continue;
            return true;
        }
        return false;
    }

    public synchronized List<BundleWire> getProvidedWires(BundleRevision bundleRevision, String string) {
        BundleWiring bundleWiring;
        ArrayList<BundleWire> arrayList = new ArrayList<BundleWire>();
        Map<BundleCapability, Set<BundleWire>> map = this.m_dependentsMap.get(bundleRevision);
        if (map != null && (bundleWiring = bundleRevision.getWiring()) != null) {
            List<BundleCapability> list = bundleWiring.getCapabilities(string);
            for (BundleCapability bundleCapability : list) {
                Set<BundleWire> set = map.get(bundleCapability);
                if (set == null) continue;
                arrayList.addAll(set);
            }
        }
        return arrayList;
    }

    public synchronized Set<Bundle> getDependentBundles(Bundle bundle) {
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        List<BundleRevision> list = bundle.adapt(BundleRevisions.class).getRevisions();
        for (BundleRevision bundleRevision : list) {
            Map<BundleCapability, Set<BundleWire>> map;
            if (Util.isFragment(bundleRevision)) {
                map = bundleRevision.getWiring();
                if (map == null) continue;
                for (BundleWire bundleWire : map.getRequiredWires(null)) {
                    hashSet.add(((BundleWireImpl)bundleWire).getProvider().getBundle());
                }
                continue;
            }
            map = this.m_dependentsMap.get(bundleRevision);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                for (BundleWire bundleWire : (Set)entry.getValue()) {
                    hashSet.add(bundleWire.getRequirer().getBundle());
                }
            }
        }
        return hashSet;
    }

    public synchronized Set<Bundle> getImportingBundles(Bundle bundle, BundleCapability bundleCapability) {
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        String string = (String)bundleCapability.getAttributes().get("osgi.wiring.package");
        for (BundleRevision bundleRevision : bundle.adapt(BundleRevisions.class).getRevisions()) {
            Map<BundleCapability, Set<BundleWire>> map = this.m_dependentsMap.get(bundleRevision);
            if (map == null) continue;
            for (Map.Entry<BundleCapability, Set<BundleWire>> entry : map.entrySet()) {
                BundleCapability bundleCapability2 = entry.getKey();
                if ((!bundleCapability2.getNamespace().equals("osgi.wiring.package") || !bundleCapability2.getAttributes().get("osgi.wiring.package").equals(string)) && !bundleCapability2.getNamespace().equals("osgi.wiring.bundle")) continue;
                for (BundleWire bundleWire : entry.getValue()) {
                    hashSet.add(bundleWire.getRequirer().getBundle());
                }
            }
        }
        return hashSet;
    }

    public synchronized Set<Bundle> getRequiringBundles(Bundle bundle) {
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        for (BundleRevision bundleRevision : bundle.adapt(BundleRevisions.class).getRevisions()) {
            Map<BundleCapability, Set<BundleWire>> map = this.m_dependentsMap.get(bundleRevision);
            if (map == null) continue;
            for (Map.Entry<BundleCapability, Set<BundleWire>> entry : map.entrySet()) {
                if (!entry.getKey().getNamespace().equals("osgi.wiring.bundle")) continue;
                for (BundleWire bundleWire : entry.getValue()) {
                    hashSet.add(bundleWire.getRequirer().getBundle());
                }
            }
        }
        return hashSet;
    }

    public synchronized void removeDependencies(Bundle bundle) {
        List<BundleRevision> list = bundle.adapt(BundleRevisions.class).getRevisions();
        for (BundleRevision bundleRevision : list) {
            BundleWiring bundleWiring = bundleRevision.getWiring();
            if (bundleWiring == null) continue;
            for (BundleWire bundleWire : bundleWiring.getRequiredWires(null)) {
                Map<BundleCapability, Set<BundleWire>> map = this.m_dependentsMap.get(bundleWire.getProvider());
                if (map == null) continue;
                ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
                for (Map.Entry<BundleCapability, Set<BundleWire>> entry : map.entrySet()) {
                    entry.getValue().remove(bundleWire);
                    if (!entry.getValue().isEmpty()) continue;
                    arrayList.add(entry.getKey());
                }
                for (BundleCapability bundleCapability : arrayList) {
                    map.remove(bundleCapability);
                }
                if (!map.isEmpty()) continue;
                this.m_dependentsMap.remove(bundleWire.getProvider());
            }
        }
    }

    public synchronized void dump() {
    }
}

