/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.cache.JarContent;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.wiring.BundleRevision;

public class BundleProtectionDomain
extends ProtectionDomain {
    private final WeakReference m_felix;
    private final WeakReference m_bundle;
    private final int m_hashCode;
    private final String m_toString;
    private final WeakReference m_revision;
    private volatile PermissionCollection m_woven;

    BundleProtectionDomain(Felix felix, BundleImpl bundleImpl, Object object) throws MalformedURLException {
        super(new CodeSource(RevisionAsJarURL.create(bundleImpl), (Certificate[])object), null, null, null);
        this.m_felix = new WeakReference<Felix>(felix);
        this.m_bundle = new WeakReference<BundleImpl>(bundleImpl);
        this.m_revision = new WeakReference<BundleRevisionImpl>(bundleImpl.adapt(BundleRevisionImpl.class));
        this.m_hashCode = bundleImpl.hashCode();
        this.m_toString = "[" + bundleImpl + "]";
    }

    BundleRevision getRevision() {
        return (BundleRevision)this.m_revision.get();
    }

    @Override
    public boolean implies(Permission permission) {
        Felix felix = (Felix)this.m_felix.get();
        return felix != null ? felix.impliesBundlePermission(this, permission, false) : false;
    }

    boolean superImplies(Permission permission) {
        return super.implies(permission);
    }

    public boolean impliesDirect(Permission permission) {
        Felix felix = (Felix)this.m_felix.get();
        return felix != null ? felix.impliesBundlePermission(this, permission, true) : false;
    }

    boolean impliesWoven(Permission permission) {
        return this.m_woven != null && this.m_woven.implies(permission);
    }

    synchronized void addWoven(String string) {
        if (this.m_woven == null) {
            this.m_woven = new Permissions();
        }
        this.m_woven.add(new PackagePermission(string, "import"));
    }

    BundleImpl getBundle() {
        return (BundleImpl)this.m_bundle.get();
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != BundleProtectionDomain.class) {
            return false;
        }
        if (this.m_hashCode != object.hashCode()) {
            return false;
        }
        return this.m_bundle.get() == ((BundleProtectionDomain)object).m_bundle.get();
    }

    @Override
    public String toString() {
        return this.m_toString;
    }

    private static final class BundleInputStream
    extends InputStream {
        private final Content m_root;
        private final Enumeration m_content;
        private final OutputStreamBuffer m_outputBuffer = new OutputStreamBuffer();
        private ByteArrayInputStream m_buffer = null;
        private JarOutputStream m_output = null;
        private static final String DUMMY_ENTRY = "__DUMMY-ENTRY__/";

        public BundleInputStream(Content content) throws IOException {
            this.m_root = content;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            String string = null;
            Enumeration<String> enumeration = this.m_root.getEntries();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                if (string2.endsWith("/")) continue;
                if (string2.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                    if (string != null) continue;
                    string = string2;
                    continue;
                }
                if (string2.toUpperCase().startsWith("META-INF/") && string2.indexOf(47, "META-INF/".length()) < 0) {
                    arrayList.add(n++, string2);
                    continue;
                }
                arrayList.add(string2);
            }
            arrayList.add(n++, DUMMY_ENTRY);
            if (string == null) {
                string = "META-INF/MANIFEST.MF";
            }
            this.m_content = Collections.enumeration(arrayList);
            this.m_output = new JarOutputStream(this.m_outputBuffer);
            this.readNext(string);
            this.m_buffer = new ByteArrayInputStream(this.m_outputBuffer.m_outBuffer.toByteArray());
            this.m_outputBuffer.m_outBuffer = null;
        }

        @Override
        public int read() throws IOException {
            if (this.m_output == null && this.m_buffer == null) {
                return -1;
            }
            if (this.m_buffer != null) {
                int n = this.m_buffer.read();
                if (n == -1) {
                    this.m_buffer = null;
                    return this.read();
                }
                return n;
            }
            if (this.m_content.hasMoreElements()) {
                String string = (String)this.m_content.nextElement();
                this.readNext(string);
                if (!this.m_content.hasMoreElements()) {
                    this.m_output.close();
                    this.m_output = null;
                }
                this.m_buffer = new ByteArrayInputStream(this.m_outputBuffer.m_outBuffer.toByteArray());
                this.m_outputBuffer.m_outBuffer = null;
            } else {
                this.m_output.close();
                this.m_output = null;
            }
            return this.read();
        }

        private void readNext(String string) throws IOException {
            this.m_outputBuffer.m_outBuffer = new ByteArrayOutputStream();
            if (string == DUMMY_ENTRY) {
                JarEntry jarEntry = new JarEntry(string);
                this.m_output.putNextEntry(jarEntry);
            } else {
                InputStream inputStream = null;
                try {
                    inputStream = this.m_root.getEntryAsStream(string);
                    if (inputStream == null) {
                        throw new IOException("Missing entry");
                    }
                    JarEntry jarEntry = new JarEntry(string);
                    this.m_output.putNextEntry(jarEntry);
                    byte[] byArray = new byte[4096];
                    int n = inputStream.read(byArray);
                    while (n != -1) {
                        this.m_output.write(byArray, 0, n);
                        n = inputStream.read(byArray);
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_output.closeEntry();
            this.m_output.flush();
        }
    }

    private static final class OutputStreamBuffer
    extends OutputStream {
        ByteArrayOutputStream m_outBuffer = null;

        private OutputStreamBuffer() {
        }

        @Override
        public void write(int n) {
            this.m_outBuffer.write(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.m_outBuffer.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            this.m_outBuffer.write(byArray, n, n2);
        }
    }

    private static final class RevisionAsJarURL
    extends URLStreamHandler {
        private final WeakReference m_revision;

        private RevisionAsJarURL(BundleRevisionImpl bundleRevisionImpl) {
            this.m_revision = new WeakReference<BundleRevisionImpl>(bundleRevisionImpl);
        }

        @Override
        protected URLConnection openConnection(URL uRL) throws IOException {
            return new JarURLConnection(uRL){

                @Override
                public JarFile getJarFile() throws IOException {
                    BundleRevisionImpl bundleRevisionImpl = (BundleRevisionImpl)RevisionAsJarURL.this.m_revision.get();
                    if (bundleRevisionImpl != null) {
                        File file;
                        block31: {
                            IOException iOException;
                            block35: {
                                InputStream inputStream;
                                block34: {
                                    Content content = ((BundleRevisionImpl)RevisionAsJarURL.this.m_revision.get()).getContent();
                                    if (content instanceof JarContent) {
                                        return Felix.m_secureAction.openJarFile(((JarContent)content).getFile());
                                    }
                                    file = Felix.m_secureAction.createTempFile("jar", null, null);
                                    Felix.m_secureAction.deleteFileOnExit(file);
                                    FileOutputStream fileOutputStream = null;
                                    inputStream = null;
                                    iOException = null;
                                    try {
                                        try {
                                            fileOutputStream = new FileOutputStream(file);
                                            inputStream = new BundleInputStream(bundleRevisionImpl.getContent());
                                            byte[] byArray = new byte[65536];
                                            int n = inputStream.read(byArray);
                                            while (n != -1) {
                                                fileOutputStream.write(byArray, 0, n);
                                                n = inputStream.read(byArray);
                                            }
                                        }
                                        catch (IOException iOException2) {
                                            block30: {
                                                block29: {
                                                    iOException = iOException2;
                                                    if (fileOutputStream != null) {
                                                        try {
                                                            fileOutputStream.close();
                                                        }
                                                        catch (IOException iOException3) {
                                                            if (iOException != null) break block29;
                                                            iOException = iOException3;
                                                        }
                                                    }
                                                }
                                                if (inputStream != null) {
                                                    try {
                                                        inputStream.close();
                                                    }
                                                    catch (IOException iOException4) {
                                                        if (iOException != null) break block30;
                                                        iOException = iOException4;
                                                    }
                                                }
                                            }
                                            if (iOException != null) {
                                                throw iOException;
                                            }
                                            break block31;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        block33: {
                                            block32: {
                                                if (fileOutputStream != null) {
                                                    try {
                                                        fileOutputStream.close();
                                                    }
                                                    catch (IOException iOException5) {
                                                        if (iOException != null) break block32;
                                                        iOException = iOException5;
                                                    }
                                                }
                                            }
                                            if (inputStream != null) {
                                                try {
                                                    inputStream.close();
                                                }
                                                catch (IOException iOException6) {
                                                    if (iOException != null) break block33;
                                                    iOException = iOException6;
                                                }
                                            }
                                        }
                                        if (iOException != null) {
                                            throw iOException;
                                        }
                                        throw throwable;
                                    }
                                    if (fileOutputStream != null) {
                                        try {
                                            fileOutputStream.close();
                                        }
                                        catch (IOException iOException7) {
                                            if (iOException != null) break block34;
                                            iOException = iOException7;
                                        }
                                    }
                                }
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException iOException8) {
                                        if (iOException != null) break block35;
                                        iOException = iOException8;
                                    }
                                }
                            }
                            if (iOException != null) {
                                throw iOException;
                            }
                        }
                        return Felix.m_secureAction.openJarFile(file);
                    }
                    throw new IOException("Unable to access bundle revision.");
                }

                @Override
                public void connect() throws IOException {
                }
            };
        }

        private static URL create(BundleImpl bundleImpl) throws MalformedURLException {
            URL uRL;
            String string = bundleImpl._getLocation();
            if (string.startsWith("reference:")) {
                string = string.substring("reference:".length());
            }
            BundleRevisionImpl bundleRevisionImpl = bundleImpl.adapt(BundleRevisionImpl.class);
            RevisionAsJarURL revisionAsJarURL = new RevisionAsJarURL(bundleRevisionImpl);
            try {
                uRL = Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "jar:", revisionAsJarURL), string, null);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
            if (uRL != null && !uRL.getProtocol().equalsIgnoreCase("jar")) {
                return uRL;
            }
            if (uRL == null) {
                string = "jar:" + bundleRevisionImpl.getEntry("/") + "!/";
            }
            return Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "jar:", revisionAsJarURL), string, revisionAsJarURL);
        }
    }
}

