/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.DTOFactory;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FrameworkStartLevelImpl;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.apache.felix.framework.util.ShrinkableCollection;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.osgi.dto.DTO;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

class BundleImpl
implements Bundle,
BundleRevisions {
    private final Felix __m_felix;
    private final BundleArchive m_archive;
    private final List<BundleRevision> m_revisions = new ArrayList<BundleRevision>(0);
    private volatile int m_state;
    private boolean m_useDeclaredActivationPolicy;
    private BundleActivator m_activator = null;
    private volatile BundleContext m_context = null;
    private final Map m_cachedHeaders = new HashMap();
    private Map m_uninstalledHeaders = null;
    private long m_cachedHeadersTimestamp;
    private final Bundle m_installingBundle;
    private boolean m_stale = false;
    private int m_lockCount = 0;
    private Thread m_lockThread = null;
    private static final SecurityManagerEx m_smEx = new SecurityManagerEx();
    private static final ClassLoader m_classloader = Felix.class.getClassLoader();

    BundleImpl() {
        this.__m_felix = null;
        this.m_archive = null;
        this.m_state = 2;
        this.m_useDeclaredActivationPolicy = false;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
        this.m_installingBundle = null;
    }

    BundleImpl(Felix felix, Bundle bundle, BundleArchive bundleArchive) throws Exception {
        this.__m_felix = felix;
        this.m_archive = bundleArchive;
        this.m_state = 2;
        this.m_useDeclaredActivationPolicy = false;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
        this.m_installingBundle = bundle;
        BundleRevision bundleRevision = this.createRevision(false);
        this.addRevision(bundleRevision);
    }

    Felix getFramework() {
        return this.__m_felix;
    }

    BundleArchive getArchive() {
        return this.m_archive;
    }

    synchronized void close() {
        this.closeRevisions();
        try {
            this.m_archive.close();
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Unable to close archive revisions.", (Throwable)exception);
        }
    }

    synchronized void closeAndDelete() throws Exception {
        if (!this.m_stale) {
            this.m_stale = true;
            this.closeRevisions();
            this.m_archive.closeAndDelete();
        }
    }

    private void closeRevisions() {
        for (BundleRevision bundleRevision : this.m_revisions) {
            this.getFramework().getResolver().removeRevision(bundleRevision);
            ((BundleRevisionImpl)bundleRevision).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void refresh() throws Exception {
        if (this.isExtension() && this.getFramework().getState() != 16) {
            this.getFramework().getLogger().log(this, 2, "Framework restart on extension bundle refresh not implemented.");
        } else {
            BundleRevisionImpl bundleRevisionImpl = this.adapt(BundleRevisionImpl.class);
            this.closeRevisions();
            this.m_revisions.clear();
            this.m_archive.purge();
            bundleRevisionImpl.resetContent(this.m_archive.getCurrentRevision().getContent());
            this.addRevision(bundleRevisionImpl);
            this.m_state = 2;
            this.m_stale = false;
            Map map = this.m_cachedHeaders;
            synchronized (map) {
                this.m_cachedHeaders.clear();
                this.m_cachedHeadersTimestamp = 0L;
            }
        }
    }

    synchronized boolean isDeclaredActivationPolicyUsed() {
        return this.m_useDeclaredActivationPolicy;
    }

    synchronized void setDeclaredActivationPolicyUsed(boolean bl) {
        this.m_useDeclaredActivationPolicy = bl;
    }

    synchronized BundleActivator getActivator() {
        return this.m_activator;
    }

    synchronized void setActivator(BundleActivator bundleActivator) {
        this.m_activator = bundleActivator;
    }

    @Override
    public BundleContext getBundleContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, "context"));
        }
        return this.m_context;
    }

    void setBundleContext(BundleContext bundleContext) {
        this.m_context = bundleContext;
    }

    @Override
    public long getBundleId() {
        try {
            return this.m_archive.getId();
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error getting the identifier from bundle archive.", (Throwable)exception);
            return -1L;
        }
    }

    @Override
    public URL getEntry(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.getFramework().getBundleEntry(this, string);
    }

    public Enumeration getEntryPaths(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.getFramework().getBundleEntryPaths(this, string);
    }

    public Enumeration findEntries(String string, String string2, boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.getFramework().findBundleEntries(this, string, string2, bl);
    }

    public Dictionary getHeaders() {
        return this.getHeaders(Locale.getDefault().toString());
    }

    public Dictionary getHeaders(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, "metadata"));
        }
        if (string == null) {
            string = Locale.getDefault().toString();
        }
        return this.getFramework().getBundleHeaders(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getCurrentLocalizedHeader(String string) {
        Map map;
        Map<String, Object> map2 = null;
        if (string.length() == 0) {
            map2 = new StringMap((Map<?, ?>)this.adapt(BundleRevisionImpl.class).getHeaders());
        }
        if (map2 == null) {
            map = this.m_cachedHeaders;
            synchronized (map) {
                if (this.m_uninstalledHeaders != null) {
                    map2 = this.m_uninstalledHeaders;
                } else if (this.getLastModified() > this.m_cachedHeadersTimestamp) {
                    this.m_cachedHeaders.clear();
                } else if (this.m_cachedHeaders.containsKey(string)) {
                    map2 = (Map)this.m_cachedHeaders.get(string);
                }
            }
        }
        if (map2 == null) {
            map = new StringMap((Map<?, ?>)this.adapt(BundleRevisionImpl.class).getHeaders());
            map2 = map;
            boolean bl = false;
            Object object = map.values().iterator();
            while (!bl && object.hasNext()) {
                if (!((String)object.next()).startsWith("%")) continue;
                bl = true;
            }
            if (!bl) {
                this.updateHeaderCache(string, map);
            } else {
                Object object2;
                object = (String)map.get("Bundle-Localization");
                if (object == null) {
                    object = "OSGI-INF/l10n/bundle";
                }
                List<BundleRevision> list = BundleImpl.createLocalizationRevisionList(this.adapt(BundleRevisionImpl.class));
                List<String> list2 = BundleImpl.createLocalizationResourceList((String)object, string);
                boolean bl2 = false;
                Properties properties = new Properties();
                for (BundleRevision bundleRevision : list) {
                    for (String string2 : list2) {
                        object2 = ((BundleRevisionImpl)bundleRevision).getEntry(String.valueOf(string2) + ".properties");
                        if (object2 == null) continue;
                        bl2 = true;
                        try {
                            properties.load(((URL)object2).openConnection().getInputStream());
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (!bl2 && !string.equals(Locale.getDefault().toString())) {
                    map2 = this.getCurrentLocalizedHeader(Locale.getDefault().toString());
                } else {
                    for (Map.Entry entry : map.entrySet()) {
                        String string2;
                        string2 = (String)entry.getValue();
                        if (!string2.startsWith("%")) continue;
                        object2 = string2.substring(string2.indexOf("%") + 1);
                        Object object3 = properties.getProperty((String)object2);
                        if (object3 == null) {
                            object3 = object2;
                        }
                        entry.setValue(object3);
                    }
                    this.updateHeaderCache(string, map);
                }
            }
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHeaderCache(String string, Map map) {
        Map map2 = this.m_cachedHeaders;
        synchronized (map2) {
            if (this.m_uninstalledHeaders == null) {
                this.m_cachedHeaders.put(string, map);
                this.m_cachedHeadersTimestamp = System.currentTimeMillis();
            }
        }
    }

    private static List<BundleRevision> createLocalizationRevisionList(BundleRevision bundleRevision) {
        List<BundleRevision> list;
        List<Object> list2;
        if (Util.isFragment(bundleRevision) && bundleRevision.getWiring() != null && (list2 = bundleRevision.getWiring().getRequiredWires(null)) != null && list2.size() > 0) {
            bundleRevision = ((BundleWire)list2.get(0)).getProviderWiring().getRevision();
            int n = 1;
            while (n < list2.size()) {
                if (bundleRevision.getVersion().compareTo(((BundleWire)list2.get(n)).getProviderWiring().getRevision().getVersion()) < 0) {
                    bundleRevision = ((BundleWire)list2.get(n)).getProviderWiring().getRevision();
                }
                ++n;
            }
        }
        list2 = new ArrayList<BundleRevision>();
        list2.add(bundleRevision);
        BundleWiring bundleWiring = bundleRevision.getWiring();
        if (bundleWiring != null && (list = Util.getFragments(bundleWiring)) != null) {
            list2.addAll(list);
        }
        return list2;
    }

    private static List<String> createLocalizationResourceList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        StringBuffer stringBuffer = new StringBuffer(string);
        arrayList.add(stringBuffer.toString());
        if (string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("_").append(stringTokenizer.nextToken());
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList;
    }

    @Override
    public long getLastModified() {
        try {
            return this.m_archive.getLastModified();
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error reading last modification time from bundle archive.", (Throwable)exception);
            return 0L;
        }
    }

    void setLastModified(long l) {
        try {
            this.m_archive.setLastModified(l);
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error writing last modification time to bundle archive.", (Throwable)exception);
        }
    }

    @Override
    public String getLocation() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, "metadata"));
        }
        return this._getLocation();
    }

    String _getLocation() {
        try {
            return this.m_archive.getLocation();
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error getting location from bundle archive.", (Throwable)exception);
            return null;
        }
    }

    @Override
    public URL getResource(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.getFramework().getBundleResource(this, string);
    }

    public Enumeration getResources(String string) throws IOException {
        Enumeration enumeration;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return (enumeration = this.getFramework().getBundleResources(this, string)) == null || !enumeration.hasMoreElements() ? null : enumeration;
    }

    public ServiceReference[] getRegisteredServices() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ServiceReference[] serviceReferenceArray = this.getFramework().getBundleRegisteredServices(this);
            if (serviceReferenceArray == null) {
                return serviceReferenceArray;
            }
            ArrayList<ServiceReference> arrayList = new ArrayList<ServiceReference>();
            int n = 0;
            while (n < serviceReferenceArray.length) {
                try {
                    securityManager.checkPermission(new ServicePermission(serviceReferenceArray[n], "get"));
                    arrayList.add(serviceReferenceArray[n]);
                }
                catch (Exception exception) {}
                ++n;
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            return arrayList.toArray(new ServiceReference[arrayList.size()]);
        }
        return this.getFramework().getBundleRegisteredServices(this);
    }

    public ServiceReference[] getServicesInUse() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ServiceReference[] serviceReferenceArray = this.getFramework().getBundleServicesInUse(this);
            if (serviceReferenceArray == null) {
                return serviceReferenceArray;
            }
            ArrayList<ServiceReference> arrayList = new ArrayList<ServiceReference>();
            int n = 0;
            while (n < serviceReferenceArray.length) {
                try {
                    securityManager.checkPermission(new ServicePermission(serviceReferenceArray[n], "get"));
                    arrayList.add(serviceReferenceArray[n]);
                }
                catch (Exception exception) {}
                ++n;
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            return arrayList.toArray(new ServiceReference[arrayList.size()]);
        }
        return this.getFramework().getBundleServicesInUse(this);
    }

    @Override
    public int getState() {
        return this.m_state;
    }

    void __setState(int n) {
        this.m_state = n;
    }

    int getPersistentState() {
        try {
            return this.m_archive.getPersistentState();
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error reading persistent state from bundle archive.", (Throwable)exception);
            return 2;
        }
    }

    void setPersistentStateInactive() {
        try {
            this.m_archive.setPersistentState(2);
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error writing persistent state to bundle archive.", (Throwable)exception);
        }
    }

    void setPersistentStateActive() {
        try {
            this.m_archive.setPersistentState(32);
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error writing persistent state to bundle archive.", (Throwable)exception);
        }
    }

    void setPersistentStateStarting() {
        try {
            this.m_archive.setPersistentState(8);
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error writing persistent state to bundle archive.", (Throwable)exception);
        }
    }

    void setPersistentStateUninstalled() {
        try {
            this.m_archive.setPersistentState(1);
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error writing persistent state to bundle archive.", (Throwable)exception);
        }
    }

    int getStartLevel(int n) {
        try {
            int n2 = this.m_archive.getStartLevel();
            if (n2 == -1) {
                n2 = n;
            }
            return n2;
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error reading start level from bundle archive.", (Throwable)exception);
            return n;
        }
    }

    void setStartLevel(int n) {
        try {
            this.m_archive.setStartLevel(n);
        }
        catch (Exception exception) {
            this.getFramework().getLogger().log(this, 1, "Error writing start level to bundle archive.", (Throwable)exception);
        }
    }

    synchronized boolean isStale() {
        return this.m_stale;
    }

    synchronized boolean isExtension() {
        for (BundleRevision bundleRevision : this.m_revisions) {
            if (!((BundleRevisionImpl)bundleRevision).isExtension()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSymbolicName() {
        return this.adapt(BundleRevisionImpl.class).getSymbolicName();
    }

    @Override
    public Version getVersion() {
        return this.adapt(BundleRevisionImpl.class).getVersion();
    }

    @Override
    public boolean hasPermission(Object object) {
        return this.getFramework().bundleHasPermission(this, object);
    }

    public Map getSignerCertificates(int n) {
        return (Map)this.getFramework().getSignerMatcher(this, n);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (this.isExtension()) {
            throw new ClassNotFoundException("Extension bundles cannot load classes.");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new AdminPermission(this, "class"));
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("No permission.", exception);
            }
        }
        return this.getFramework().loadBundleClass(this, string);
    }

    @Override
    public void start() throws BundleException {
        this.start(0);
    }

    @Override
    public void start(int n) throws BundleException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, "execute"));
        }
        this.getFramework().startBundle(this, n);
    }

    @Override
    public void update() throws BundleException {
        this.update(null);
    }

    @Override
    public void update(InputStream inputStream) throws BundleException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        this.getFramework().updateBundle(this, inputStream);
    }

    @Override
    public void stop() throws BundleException {
        this.stop(0);
    }

    @Override
    public void stop(int n) throws BundleException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, "execute"));
        }
        this.getFramework().stopBundle(this, (n & 1) == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() throws BundleException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        Map map = this.getCurrentLocalizedHeader(Locale.getDefault().toString());
        this.getFramework().uninstallBundle(this);
        Map map2 = this.m_cachedHeaders;
        synchronized (map2) {
            if (this.m_uninstalledHeaders == null) {
                this.m_uninstalledHeaders = map;
                this.m_cachedHeaders.clear();
            }
        }
    }

    <A> void checkAdapt(Class<A> clazz) {
        Class clazz2;
        SecurityManager securityManager = System.getSecurityManager();
        if (!(securityManager == null || this.getFramework().getSecurityProvider() == null || Felix.m_secureAction.getClassLoader(clazz2 = m_smEx.getClassContext()[3]) == m_classloader && clazz2.getName().startsWith("org.apache.felix.framework."))) {
            securityManager.checkPermission(new AdaptPermission(clazz.getName(), this, "adapt"));
        }
    }

    @Override
    public synchronized <A> A adapt(Class<A> clazz) {
        this.checkAdapt(clazz);
        if (clazz == BundleContext.class) {
            return (A)this.m_context;
        }
        if (clazz == BundleStartLevel.class) {
            return (A)this.getFramework().adapt(FrameworkStartLevelImpl.class).createBundleStartLevel(this);
        }
        if (clazz == BundleRevision.class) {
            if (this.m_state == 1) {
                return null;
            }
            return (A)this.m_revisions.get(0);
        }
        if (clazz == BundleRevisionImpl.class) {
            return (A)this.m_revisions.get(0);
        }
        if (clazz == BundleRevisions.class) {
            return (A)this;
        }
        if (clazz == BundleWiring.class) {
            if (this.m_state == 1) {
                return null;
            }
            return (A)this.m_revisions.get(0).getWiring();
        }
        if (clazz == AccessControlContext.class) {
            if (this.m_state == 1) {
                return null;
            }
            ProtectionDomain protectionDomain = this.getProtectionDomain();
            if (protectionDomain == null) {
                return null;
            }
            return (A)new AccessControlContext(new ProtectionDomain[]{protectionDomain});
        }
        if (DTO.class.isAssignableFrom(clazz) || DTO[].class.isAssignableFrom(clazz)) {
            return DTOFactory.createDTO(this, clazz);
        }
        return null;
    }

    @Override
    public File getDataFile(String string) {
        return this.getFramework().getDataFile(this, string);
    }

    @Override
    public int compareTo(Bundle bundle) {
        long l;
        long l2 = this.getBundleId();
        return l2 < (l = bundle.getBundleId()) ? -1 : (l2 == l ? 0 : 1);
    }

    public String toString() {
        String string = this.getSymbolicName();
        if (string != null) {
            return String.valueOf(string) + " [" + this.getBundleId() + "]";
        }
        return "[" + this.getBundleId() + "]";
    }

    synchronized boolean isRemovalPending() {
        return this.m_state == 1 || this.m_revisions.size() > 1 || this.m_stale;
    }

    @Override
    public Bundle getBundle() {
        return this;
    }

    @Override
    public synchronized List<BundleRevision> getRevisions() {
        return new ArrayList<BundleRevision>(this.m_revisions);
    }

    synchronized boolean hasRevision(BundleRevision bundleRevision) {
        return this.m_revisions.contains(bundleRevision);
    }

    synchronized void revise(String string, InputStream inputStream) throws Exception {
        this.m_archive.revise(string, inputStream);
        try {
            BundleRevision bundleRevision = this.createRevision(true);
            this.addRevision(bundleRevision);
        }
        catch (Exception exception) {
            this.m_archive.rollbackRevise();
            throw exception;
        }
    }

    synchronized boolean rollbackRevise() throws Exception {
        boolean bl = this.isExtension();
        BundleRevision bundleRevision = this.m_revisions.remove(0);
        if (!bl) {
            this.getFramework().getResolver().removeRevision(bundleRevision);
        }
        return this.m_archive.rollbackRevise();
    }

    synchronized void addRevision(BundleRevision bundleRevision) throws Exception {
        this.m_revisions.add(0, bundleRevision);
        try {
            this.getFramework().setBundleProtectionDomain(this, (BundleRevisionImpl)bundleRevision);
        }
        catch (Exception exception) {
            this.m_revisions.remove(0);
            throw exception;
        }
        if (!this.isExtension()) {
            this.getFramework().getResolver().addRevision(bundleRevision);
        }
    }

    private BundleRevision createRevision(boolean bl) throws Exception {
        Map map = this.m_archive.getCurrentRevision().getManifestHeader();
        BundleRevisionImpl bundleRevisionImpl = new BundleRevisionImpl(this, String.valueOf(Long.toString(this.getBundleId())) + "." + this.m_archive.getCurrentRevisionNumber().toString(), map, this.m_archive.getCurrentRevision().getContent());
        String string = (String)this.getFramework().getConfig().get("org.osgi.framework.bsnversion");
        String string2 = string = string == null ? "managed" : string;
        if (bundleRevisionImpl.getManifestVersion().equals("2") && !string.equals("multiple")) {
            Set<ServiceReference<CollisionHook>> set;
            Version version = bundleRevisionImpl.getVersion();
            version = version == null ? Version.emptyVersion : version;
            String string3 = bundleRevisionImpl.getSymbolicName();
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
            Bundle[] bundleArray = this.getFramework().getBundles();
            int n = 0;
            while (bundleArray != null && n < bundleArray.length) {
                long l = ((BundleImpl)bundleArray[n]).getBundleId();
                if (l != this.getBundleId() && string3.equals(bundleArray[n].getSymbolicName()) && version.equals(bundleArray[n].getVersion())) {
                    arrayList.add(bundleArray[n]);
                }
                ++n;
            }
            if (!arrayList.isEmpty() && string.equals("managed") && !(set = this.getFramework().getHookRegistry().getHooks(CollisionHook.class)).isEmpty()) {
                ShrinkableCollection<Bundle> shrinkableCollection = new ShrinkableCollection<Bundle>(arrayList);
                for (ServiceReference<CollisionHook> serviceReference : set) {
                    BundleImpl bundleImpl;
                    int n2;
                    CollisionHook collisionHook = this.getFramework().getService(this.getFramework(), serviceReference, false);
                    if (collisionHook == null) continue;
                    if (bl) {
                        n2 = 2;
                        bundleImpl = this;
                    } else {
                        n2 = 1;
                        bundleImpl = this.m_installingBundle == null ? this : this.m_installingBundle;
                    }
                    Felix.m_secureAction.invokeBundleCollisionHook(collisionHook, n2, bundleImpl, shrinkableCollection);
                }
            }
            if (!arrayList.isEmpty()) {
                throw new BundleException("Bundle symbolic name and version are not unique: " + string3 + ':' + version, 9);
            }
        }
        return bundleRevisionImpl;
    }

    synchronized ProtectionDomain getProtectionDomain() {
        ProtectionDomain protectionDomain = null;
        int n = this.m_revisions.size() - 1;
        while (n >= 0 && protectionDomain == null) {
            protectionDomain = ((BundleRevisionImpl)this.m_revisions.get(n)).getProtectionDomain();
            --n;
        }
        return protectionDomain;
    }

    synchronized boolean isLockable() {
        return this.m_lockCount == 0 || this.m_lockThread == Thread.currentThread();
    }

    synchronized Thread getLockingThread() {
        return this.m_lockThread;
    }

    synchronized void lock() {
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        ++this.m_lockCount;
        this.m_lockThread = Thread.currentThread();
    }

    synchronized void unlock() {
        if (this.m_lockCount == 0) {
            throw new IllegalStateException("Bundle is not locked.");
        }
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        --this.m_lockCount;
        if (this.m_lockCount == 0) {
            this.m_lockThread = null;
        }
    }

    BundleContext _getBundleContext() {
        return this.m_context;
    }
}

