/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.PropertyPermission;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FilterImpl;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceRegistrationImpl;
import org.apache.felix.framework.ext.FelixBundleContext;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

class BundleContextImpl
implements FelixBundleContext {
    private Logger m_logger = null;
    private Felix m_felix = null;
    private BundleImpl m_bundle = null;
    private boolean m_valid = true;

    protected BundleContextImpl(Logger logger, Felix felix, BundleImpl bundleImpl) {
        this.m_logger = logger;
        this.m_felix = felix;
        this.m_bundle = bundleImpl;
    }

    protected void invalidate() {
        this.m_valid = false;
    }

    @Override
    public void addRequirement(String string) throws BundleException {
        throw new BundleException("Not implemented yet.");
    }

    @Override
    public void removeRequirement() throws BundleException {
        throw new BundleException("Not implemented yet.");
    }

    @Override
    public void addCapability() throws BundleException {
        throw new BundleException("Not implemented yet.");
    }

    @Override
    public void removeCapability() throws BundleException {
        throw new BundleException("Not implemented yet.");
    }

    @Override
    public String getProperty(String string) {
        this.checkValidity();
        SecurityManager securityManager = System.getSecurityManager();
        if (!(securityManager == null || "org.osgi.framework.version".equals(string) || "org.osgi.framework.vendor".equals(string) || "org.osgi.framework.language".equals(string) || "org.osgi.framework.os.name".equals(string) || "org.osgi.framework.os.version".equals(string) || "org.osgi.framework.processor".equals(string))) {
            securityManager.checkPermission(new PropertyPermission(string, "read"));
        }
        return this.m_felix.getProperty(string);
    }

    @Override
    public Bundle getBundle() {
        this.checkValidity();
        return this.m_bundle;
    }

    @Override
    public Filter createFilter(String string) throws InvalidSyntaxException {
        this.checkValidity();
        return new FilterImpl(string);
    }

    @Override
    public Bundle installBundle(String string) throws BundleException {
        return this.installBundle(string, null);
    }

    @Override
    public Bundle installBundle(String string, InputStream inputStream) throws BundleException {
        this.checkValidity();
        Bundle bundle = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            bundle = this.m_felix.installBundle(this.m_bundle, string, inputStream);
            securityManager.checkPermission(new AdminPermission(bundle, "lifecycle"));
        } else {
            bundle = this.m_felix.installBundle(this.m_bundle, string, inputStream);
        }
        return bundle;
    }

    @Override
    public Bundle getBundle(long l) {
        this.checkValidity();
        return this.m_felix.getBundle(this, l);
    }

    @Override
    public Bundle getBundle(String string) {
        this.checkValidity();
        return this.m_felix.getBundle(string);
    }

    @Override
    public Bundle[] getBundles() {
        this.checkValidity();
        return this.m_felix.getBundles(this);
    }

    @Override
    public void addBundleListener(BundleListener bundleListener) {
        this.checkValidity();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && bundleListener instanceof SynchronousBundleListener) {
            securityManager.checkPermission(new AdminPermission(this.m_bundle, "listener"));
        }
        this.m_felix.addBundleListener(this.m_bundle, bundleListener);
    }

    @Override
    public void removeBundleListener(BundleListener bundleListener) {
        this.checkValidity();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && bundleListener instanceof SynchronousBundleListener) {
            securityManager.checkPermission(new AdminPermission(this.m_bundle, "listener"));
        }
        this.m_felix.removeBundleListener(this.m_bundle, bundleListener);
    }

    @Override
    public void addServiceListener(ServiceListener serviceListener) {
        try {
            this.addServiceListener(serviceListener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    @Override
    public void addServiceListener(ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        this.checkValidity();
        this.m_felix.addServiceListener(this.m_bundle, serviceListener, string);
    }

    @Override
    public void removeServiceListener(ServiceListener serviceListener) {
        this.checkValidity();
        this.m_felix.removeServiceListener(this.m_bundle, serviceListener);
    }

    @Override
    public void addFrameworkListener(FrameworkListener frameworkListener) {
        this.checkValidity();
        this.m_felix.addFrameworkListener(this.m_bundle, frameworkListener);
    }

    @Override
    public void removeFrameworkListener(FrameworkListener frameworkListener) {
        this.checkValidity();
        this.m_felix.removeFrameworkListener(this.m_bundle, frameworkListener);
    }

    @Override
    public ServiceRegistration<?> registerService(String string, Object object, Dictionary<String, ?> dictionary) {
        return this.registerService(new String[]{string}, object, dictionary);
    }

    @Override
    public ServiceRegistration<?> registerService(String[] stringArray, Object object, Dictionary<String, ?> dictionary) {
        this.checkValidity();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                securityManager.checkPermission(new ServicePermission(stringArray[n], "register"));
                ++n;
            }
        }
        return this.m_felix.registerService(this, stringArray, object, dictionary);
    }

    @Override
    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S s, Dictionary<String, ?> dictionary) {
        return this.registerService(new String[]{clazz.getName()}, s, dictionary);
    }

    @Override
    public ServiceReference<?> getServiceReference(String string) {
        this.checkValidity();
        try {
            ServiceReference[] serviceReferenceArray = this.getServiceReferences(string, null);
            return this.getBestServiceReference(serviceReferenceArray);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            this.m_logger.log(this.m_bundle, 1, "BundleContextImpl: " + invalidSyntaxException);
            return null;
        }
    }

    @Override
    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        return this.getServiceReference(clazz.getName());
    }

    private ServiceReference getBestServiceReference(ServiceReference[] serviceReferenceArray) {
        if (serviceReferenceArray == null) {
            return null;
        }
        if (serviceReferenceArray.length == 1) {
            return serviceReferenceArray[0];
        }
        ServiceReference serviceReference = serviceReferenceArray[0];
        int n = 1;
        while (n < serviceReferenceArray.length) {
            if (serviceReference.compareTo(serviceReferenceArray[n]) < 0) {
                serviceReference = serviceReferenceArray[n];
            }
            ++n;
        }
        return serviceReference;
    }

    @Override
    public ServiceReference<?>[] getAllServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValidity();
        return this.m_felix.getAllowedServiceReferences(this.m_bundle, string, string2, false);
    }

    @Override
    public ServiceReference<?>[] getServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValidity();
        return this.m_felix.getAllowedServiceReferences(this.m_bundle, string, string2, true);
    }

    @Override
    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String string) throws InvalidSyntaxException {
        ServiceReference<?>[] serviceReferenceArray = this.getServiceReferences(clazz.getName(), string);
        return serviceReferenceArray == null ? Collections.EMPTY_LIST : Arrays.asList(serviceReferenceArray);
    }

    @Override
    public <S> S getService(ServiceReference<S> serviceReference) {
        this.checkValidity();
        if (serviceReference == null) {
            throw new NullPointerException("Specified service reference cannot be null.");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ServicePermission(serviceReference, "get"));
        }
        return this.m_felix.getService(this.m_bundle, serviceReference, false);
    }

    @Override
    public boolean ungetService(ServiceReference<?> serviceReference) {
        this.checkValidity();
        if (serviceReference == null) {
            throw new NullPointerException("Specified service reference cannot be null.");
        }
        return this.m_felix.ungetService(this.m_bundle, serviceReference, null);
    }

    @Override
    public File getDataFile(String string) {
        this.checkValidity();
        return this.m_felix.getDataFile(this.m_bundle, string);
    }

    private void checkValidity() {
        if (this.m_valid) {
            switch (this.m_bundle.getState()) {
                case 8: 
                case 16: 
                case 32: {
                    return;
                }
            }
        }
        throw new IllegalStateException("Invalid BundleContext.");
    }

    @Override
    public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> serviceFactory, Dictionary<String, ?> dictionary) {
        return this.registerService(new String[]{clazz.getName()}, serviceFactory, dictionary);
    }

    @Override
    public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> serviceReference) {
        ServiceRegistrationImpl serviceRegistrationImpl;
        this.checkValidity();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ServicePermission(serviceReference, "get"));
        }
        if ((serviceRegistrationImpl = ((ServiceRegistrationImpl.ServiceReferenceImpl)serviceReference).getRegistration()).isValid()) {
            return new ServiceObjectsImpl<S>(serviceReference);
        }
        return null;
    }

    class ServiceObjectsImpl<S>
    implements ServiceObjects<S> {
        private final ServiceReference<S> m_ref;

        public ServiceObjectsImpl(ServiceReference<S> serviceReference) {
            this.m_ref = serviceReference;
        }

        @Override
        public S getService() {
            BundleContextImpl.this.checkValidity();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new ServicePermission(this.m_ref, "get"));
            }
            return BundleContextImpl.this.m_felix.getService(BundleContextImpl.this.m_bundle, this.m_ref, true);
        }

        @Override
        public void ungetService(S s) {
            BundleContextImpl.this.checkValidity();
            if (!BundleContextImpl.this.m_felix.ungetService(BundleContextImpl.this.m_bundle, this.m_ref, s)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public ServiceReference<S> getServiceReference() {
            return this.m_ref;
        }
    }
}

