/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.log.LogService;

public class UpdateCommand
extends Command {
    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        Object object;
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getSourceAbstractDeploymentPackage();
        AbstractDeploymentPackage abstractDeploymentPackage2 = deploymentSessionImpl.getTargetAbstractDeploymentPackage();
        BundleContext bundleContext = deploymentSessionImpl.getBundleContext();
        LogService logService = deploymentSessionImpl.getLog();
        HashMap<String, AbstractInfo> hashMap = new HashMap<String, AbstractInfo>();
        AbstractInfo[] abstractInfoArray = (AbstractInfo[])abstractDeploymentPackage.getBundleInfos();
        int n = 0;
        while (n < abstractInfoArray.length) {
            object = abstractInfoArray[n];
            if (!((AbstractInfo)object).isMissing()) {
                hashMap.put(((AbstractInfo)object).getPath(), (AbstractInfo)object);
            }
            ++n;
        }
        try {
            while (!hashMap.isEmpty()) {
                Version version;
                AbstractInfo abstractInfo = abstractDeploymentPackage.getNextEntry();
                if (abstractInfo == null) {
                    throw new DeploymentException(463, "Expected more bundles in the stream: " + hashMap.keySet());
                }
                object = abstractInfo.getPath();
                BundleInfoImpl bundleInfoImpl = (BundleInfoImpl)hashMap.remove(object);
                if (bundleInfoImpl == null) {
                    if (this.isLocalizationFile((String)object)) continue;
                    throw new DeploymentException(463, "Resource '" + (String)object + "' is not described in the manifest.");
                }
                String string = bundleInfoImpl.getSymbolicName();
                Version version2 = bundleInfoImpl.getVersion();
                Bundle bundle = abstractDeploymentPackage2.getBundle(string);
                try {
                    if (bundle == null) {
                        bundle = bundleContext.installBundle("osgi-dp:" + string, new BundleInputStream(abstractDeploymentPackage.getCurrentEntryStream()));
                        this.addRollback(new UninstallBundleRunnable(bundle, logService));
                    } else {
                        version = this.getVersion(bundle);
                        if (!version2.equals(version)) {
                            bundle.update(new BundleInputStream(abstractDeploymentPackage.getCurrentEntryStream()));
                            this.addRollback(new UpdateBundleRunnable(bundle, abstractDeploymentPackage2, logService));
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.isCancelled()) {
                        return;
                    }
                    throw new DeploymentException(463, "Could not install new bundle '" + (String)object + "' (" + string + ")", exception);
                }
                if (!bundle.getSymbolicName().equals(string)) {
                    throw new DeploymentException(457, "Installed/updated bundle symbolicname (" + bundle.getSymbolicName() + ") do not match what was installed/updated: " + string);
                }
                version = this.getVersion(bundle);
                if (version2.equals(version)) continue;
                throw new DeploymentException(463, "Installed/updated bundle version (" + version + ") do not match what was installed/updated: " + version2 + ", offending bundle = " + string);
            }
        }
        catch (IOException iOException) {
            throw new DeploymentException(463, "Problem while reading stream", iOException);
        }
    }

    private Version getVersion(Bundle bundle) {
        return Version.parseVersion(bundle.getHeaders().get("Bundle-Version"));
    }

    private boolean isLocalizationFile(String string) {
        return string.startsWith("OSGI-INF/l10n/");
    }

    private final class BundleInputStream
    extends InputStream {
        private final InputStream m_inputStream;

        private BundleInputStream(InputStream inputStream) {
            this.m_inputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            this.checkCancel();
            return this.m_inputStream.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            this.checkCancel();
            return this.m_inputStream.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.checkCancel();
            return this.m_inputStream.read(byArray, n, n2);
        }

        private void checkCancel() throws IOException {
            if (UpdateCommand.this.isCancelled()) {
                throw new IOException("Stream was cancelled");
            }
        }
    }

    private static class UninstallBundleRunnable
    extends AbstractAction {
        private final Bundle m_bundle;
        private final LogService m_log;

        public UninstallBundleRunnable(Bundle bundle, LogService logService) {
            this.m_bundle = bundle;
            this.m_log = logService;
        }

        @Override
        protected void doRun() throws Exception {
            this.m_bundle.uninstall();
        }

        @Override
        protected void onFailure(Exception exception) {
            this.m_log.log(2, "Could not rollback update of bundle '" + this.m_bundle.getSymbolicName() + "'", exception);
        }
    }

    private static class UpdateBundleRunnable
    extends AbstractAction {
        private final AbstractDeploymentPackage m_targetPackage;
        private final Bundle m_bundle;
        private final LogService m_log;

        public UpdateBundleRunnable(Bundle bundle, AbstractDeploymentPackage abstractDeploymentPackage, LogService logService) {
            this.m_bundle = bundle;
            this.m_targetPackage = abstractDeploymentPackage;
            this.m_log = logService;
        }

        @Override
        protected void doRun() throws Exception {
            InputStream inputStream = null;
            try {
                inputStream = this.m_targetPackage.getBundleStream(this.m_bundle.getSymbolicName());
                if (inputStream == null) {
                    throw new RuntimeException("Unable to get inputstream for bundle " + this.m_bundle.getSymbolicName());
                }
                this.m_bundle.update(inputStream);
            }
            catch (Throwable throwable) {
                UpdateCommand.closeSilently(inputStream);
                throw throwable;
            }
            UpdateCommand.closeSilently(inputStream);
        }

        @Override
        protected void onFailure(Exception exception) {
            this.m_log.log(2, "Could not rollback update of bundle '" + this.m_bundle.getSymbolicName() + "'", exception);
        }
    }
}

