/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.log.LogService;

public class StopBundleCommand
extends Command {
    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        LogService logService = deploymentSessionImpl.getLog();
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getTargetAbstractDeploymentPackage();
        BundleInfoImpl[] bundleInfoImplArray = abstractDeploymentPackage.getOrderedBundleInfos();
        int n = 0;
        while (n < bundleInfoImplArray.length) {
            if (this.isCancelled()) {
                throw new DeploymentException(401);
            }
            String string = bundleInfoImplArray[n].getSymbolicName();
            Bundle bundle = abstractDeploymentPackage.getBundle(string);
            if (bundle != null) {
                if (!this.omitBundleStop(deploymentSessionImpl, string)) {
                    if (StopBundleCommand.isFragmentBundle(bundle)) {
                        logService.log(3, "Skipping fragment bundle '" + string + "'");
                    } else {
                        this.addRollback(new StartBundleRunnable(deploymentSessionImpl, bundle));
                        try {
                            bundle.stop();
                        }
                        catch (Exception exception) {
                            logService.log(2, "Could not stop bundle '" + string + "'", exception);
                        }
                    }
                }
            } else {
                logService.log(2, "Could not stop bundle '" + string + "' because it was not present in the framework");
            }
            ++n;
        }
    }

    private boolean omitBundleStop(DeploymentSessionImpl deploymentSessionImpl, String string) {
        boolean bl;
        boolean bl2 = deploymentSessionImpl.getConfiguration().isStopUnaffectedBundles();
        if (bl2) {
            return false;
        }
        BundleInfoImpl bundleInfoImpl = deploymentSessionImpl.getSourceAbstractDeploymentPackage().getBundleInfoByName(string);
        BundleInfoImpl bundleInfoImpl2 = deploymentSessionImpl.getTargetAbstractDeploymentPackage().getBundleInfoByName(string);
        boolean bl3 = bundleInfoImpl != null && bundleInfoImpl.isMissing();
        boolean bl4 = bl = bundleInfoImpl2 != null && bundleInfoImpl != null && bundleInfoImpl2.getVersion().equals(bundleInfoImpl.getVersion());
        return bl3 || bl;
    }

    private static class StartBundleRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final Bundle m_bundle;

        public StartBundleRunnable(DeploymentSessionImpl deploymentSessionImpl, Bundle bundle) {
            this.m_session = deploymentSessionImpl;
            this.m_bundle = bundle;
        }

        @Override
        protected void doRun() throws Exception {
            this.m_bundle.start();
        }

        @Override
        protected void onFailure(Exception exception) {
            this.m_session.getLog().log(2, "Failed to start bundle '" + this.m_bundle.getSymbolicName() + "'", exception);
        }
    }
}

