/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.util.HashSet;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.deploymentadmin.DeploymentException;

public class StartCustomizerCommand
extends Command {
    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        Bundle bundle2;
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getTargetAbstractDeploymentPackage();
        AbstractDeploymentPackage abstractDeploymentPackage2 = deploymentSessionImpl.getSourceAbstractDeploymentPackage();
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        HashSet<String> hashSet2 = new HashSet<String>();
        BundleInfoImpl[] bundleInfoImplArray = abstractDeploymentPackage.getBundleInfoImpls();
        BundleInfoImpl[] bundleInfoImplArray2 = abstractDeploymentPackage2.getBundleInfoImpls();
        int n = 0;
        while (n < bundleInfoImplArray2.length) {
            if (bundleInfoImplArray2[n].isCustomizer()) {
                hashSet2.add(bundleInfoImplArray2[n].getPath());
                bundle2 = abstractDeploymentPackage2.getBundle(bundleInfoImplArray2[n].getSymbolicName());
                if (bundle2 != null) {
                    hashSet.add(bundle2);
                }
            }
            ++n;
        }
        n = 0;
        while (n < bundleInfoImplArray.length) {
            if (bundleInfoImplArray[n].isCustomizer() && !hashSet2.contains(bundleInfoImplArray[n].getPath()) && (bundle2 = abstractDeploymentPackage.getBundle(bundleInfoImplArray[n].getSymbolicName())) != null) {
                hashSet.add(bundle2);
            }
            ++n;
        }
        for (Bundle bundle2 : hashSet) {
            try {
                bundle2.start();
            }
            catch (Exception exception) {
                throw new DeploymentException(463, "Could not start customizer bundle '" + bundle2.getSymbolicName() + "'", exception);
            }
            this.addRollback(new StopCustomizerRunnable(deploymentSessionImpl, bundle2));
        }
    }

    private static class StopCustomizerRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final Bundle m_bundle;

        public StopCustomizerRunnable(DeploymentSessionImpl deploymentSessionImpl, Bundle bundle) {
            this.m_session = deploymentSessionImpl;
            this.m_bundle = bundle;
        }

        @Override
        protected void doRun() throws Exception {
            this.m_bundle.stop();
        }

        @Override
        protected void onFailure(Exception exception) {
            this.m_session.getLog().log(2, "Failed to stop bundle '" + this.m_bundle.getSymbolicName() + "'", exception);
        }
    }
}

