/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class StartBundleCommand
extends Command {
    private final RefreshPackagesMonitor m_refreshMonitor = new RefreshPackagesMonitor();

    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getSourceAbstractDeploymentPackage();
        PackageAdmin packageAdmin = deploymentSessionImpl.getPackageAdmin();
        RefreshPackagesListener refreshPackagesListener = new RefreshPackagesListener();
        LogService logService = deploymentSessionImpl.getLog();
        deploymentSessionImpl.getBundleContext().addFrameworkListener(refreshPackagesListener);
        packageAdmin.refreshPackages(null);
        this.m_refreshMonitor.waitForRefresh();
        deploymentSessionImpl.getBundleContext().removeFrameworkListener(refreshPackagesListener);
        BundleInfoImpl[] bundleInfoImplArray = abstractDeploymentPackage.getOrderedBundleInfos();
        int n = 0;
        while (n < bundleInfoImplArray.length) {
            BundleInfoImpl bundleInfoImpl = bundleInfoImplArray[n];
            if (!bundleInfoImpl.isCustomizer()) {
                String string = bundleInfoImpl.getSymbolicName();
                Bundle bundle = abstractDeploymentPackage.getBundle(string);
                if (bundle != null) {
                    if (StartBundleCommand.isFragmentBundle(bundle)) {
                        logService.log(3, "Skipping fragment bundle '" + string + "'");
                    } else {
                        try {
                            bundle.start();
                        }
                        catch (Exception exception) {
                            logService.log(2, "Could not start bundle '" + string + "'", exception);
                        }
                    }
                } else {
                    logService.log(2, "Could not start bundle '" + string + "' because it is not present in the framework");
                }
            }
            ++n;
        }
    }

    private class RefreshPackagesListener
    implements FrameworkListener {
        private RefreshPackagesListener() {
        }

        @Override
        public void frameworkEvent(FrameworkEvent frameworkEvent) {
            if (frameworkEvent.getType() == 4) {
                StartBundleCommand.this.m_refreshMonitor.proceed();
            }
        }
    }

    private static class RefreshPackagesMonitor {
        private static final int REFRESH_TIMEOUT = 10000;
        private volatile boolean m_alreadyNotified = false;

        private RefreshPackagesMonitor() {
        }

        public synchronized void waitForRefresh() {
            if (!this.m_alreadyNotified) {
                try {
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.m_alreadyNotified = false;
                    }
                }
                finally {
                    this.m_alreadyNotified = false;
                }
            } else {
                this.m_alreadyNotified = false;
            }
        }

        public synchronized void proceed() {
            this.m_alreadyNotified = true;
            this.notifyAll();
        }
    }
}

