/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.Utils;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.apache.felix.deploymentadmin.spi.GetStorageAreaCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;

public class SnapshotCommand
extends Command {
    static final String FORWARD_SLASH = "/";
    private final GetStorageAreaCommand m_getStorageAreaCommand;

    public SnapshotCommand(GetStorageAreaCommand getStorageAreaCommand) {
        this.m_getStorageAreaCommand = getStorageAreaCommand;
    }

    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getTargetAbstractDeploymentPackage();
        BundleContext bundleContext = deploymentSessionImpl.getBundleContext();
        BundleInfo[] bundleInfoArray = abstractDeploymentPackage.getBundleInfos();
        Map map = this.m_getStorageAreaCommand.getStorageAreas();
        int n = 0;
        while (n < bundleInfoArray.length) {
            File file;
            if (this.isCancelled()) {
                throw new DeploymentException(401);
            }
            String string = bundleInfoArray[n].getSymbolicName();
            Bundle bundle = abstractDeploymentPackage.getBundle(string);
            if (bundle != null && (file = (File)map.get(string)) != null) {
                File file2 = bundleContext.getDataFile("snapshots");
                file2.mkdirs();
                file2 = new File(file2, bundleInfoArray[n].getSymbolicName());
                try {
                    file2.createNewFile();
                    SnapshotCommand.store(file, file2);
                    this.addRollback(new RestoreSnapshotRunnable(deploymentSessionImpl, file2, file));
                    this.addCommit(new DeleteSnapshotRunnable(deploymentSessionImpl, file2));
                }
                catch (Exception exception) {
                    file2.delete();
                }
            }
            ++n;
        }
    }

    protected static void restore(File file, File file2) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file3 = new File(file2, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (!file3.mkdirs()) {
                        throw new IOException("Failed to create one or more sub-directories!");
                    }
                } else {
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file3);
                        SnapshotCommand.copy(zipInputStream, fileOutputStream);
                    }
                    catch (Throwable throwable) {
                        SnapshotCommand.closeSilently(fileOutputStream);
                        throw throwable;
                    }
                    SnapshotCommand.closeSilently(fileOutputStream);
                }
                zipInputStream.closeEntry();
            }
        }
        catch (Throwable throwable) {
            SnapshotCommand.closeSilently(zipInputStream);
            throw throwable;
        }
        SnapshotCommand.closeSilently(zipInputStream);
    }

    protected static void store(File file, File file2) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            SnapshotCommand.store(zipOutputStream, file, "");
        }
        catch (Throwable throwable) {
            SnapshotCommand.closeSilently(zipOutputStream);
            throw throwable;
        }
        SnapshotCommand.closeSilently(zipOutputStream);
    }

    protected static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            outputStream.flush();
        }
    }

    private static void store(ZipOutputStream zipOutputStream, File file, String string) throws IOException {
        File file2 = new File(file, string);
        if (file2.isFile()) {
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setSize(file2.length());
            zipEntry.setTime(file2.lastModified());
            zipOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                SnapshotCommand.copy(fileInputStream, zipOutputStream);
            }
            catch (Throwable throwable) {
                SnapshotCommand.closeSilently(fileInputStream);
                zipOutputStream.closeEntry();
                throw throwable;
            }
            SnapshotCommand.closeSilently(fileInputStream);
            zipOutputStream.closeEntry();
        } else if (file2.isDirectory()) {
            String string2 = "";
            if (!"".equals(string)) {
                string2 = string;
                if (!string2.endsWith(FORWARD_SLASH)) {
                    string2 = string2.concat(FORWARD_SLASH);
                }
                zipOutputStream.putNextEntry(new ZipEntry(string2));
                zipOutputStream.closeEntry();
            }
            String[] stringArray = file2.list();
            int n = 0;
            while (n < stringArray.length) {
                SnapshotCommand.store(zipOutputStream, file, string2.concat(stringArray[n]));
                ++n;
            }
        }
    }

    private static class DeleteSnapshotRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final File m_snapshot;

        private DeleteSnapshotRunnable(DeploymentSessionImpl deploymentSessionImpl, File file) {
            this.m_session = deploymentSessionImpl;
            this.m_snapshot = file;
        }

        @Override
        protected void doRun() {
            if (!this.m_snapshot.delete()) {
                this.m_session.getLog().log(2, "Failed to delete snapshot in " + this.m_snapshot + "!");
            }
        }
    }

    private static class RestoreSnapshotRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final File m_snapshot;
        private final File m_root;

        private RestoreSnapshotRunnable(DeploymentSessionImpl deploymentSessionImpl, File file, File file2) {
            this.m_session = deploymentSessionImpl;
            this.m_snapshot = file;
            this.m_root = file2;
        }

        @Override
        protected void doRun() throws Exception {
            try {
                Utils.delete(this.m_root, false);
                SnapshotCommand.restore(this.m_snapshot, this.m_root);
            }
            finally {
                this.m_snapshot.delete();
            }
        }

        @Override
        protected void onFailure(Exception exception) {
            this.m_session.getLog().log(2, "Failed to restore snapshot!", exception);
        }
    }
}

