/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.IOException;
import java.util.HashMap;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;

public class ProcessResourceCommand
extends Command {
    private final CommitResourceCommand m_commitCommand;

    public ProcessResourceCommand(CommitResourceCommand commitResourceCommand) {
        this.m_commitCommand = commitResourceCommand;
    }

    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        Object object;
        this.addRollback(new RollbackCommitAction(deploymentSessionImpl));
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getSourceAbstractDeploymentPackage();
        BundleContext bundleContext = deploymentSessionImpl.getBundleContext();
        HashMap<String, ResourceInfoImpl> hashMap = new HashMap<String, ResourceInfoImpl>();
        ResourceInfoImpl[] resourceInfoImplArray = abstractDeploymentPackage.getResourceInfos();
        int n = 0;
        while (n < resourceInfoImplArray.length) {
            object = resourceInfoImplArray[n];
            if (!((AbstractInfo)object).isMissing()) {
                hashMap.put(((AbstractInfo)object).getPath(), (ResourceInfoImpl)object);
            }
            ++n;
        }
        block5: while (true) {
            try {
                while (!hashMap.isEmpty()) {
                    AbstractInfo abstractInfo = abstractDeploymentPackage.getNextEntry();
                    if (abstractInfo == null) {
                        throw new DeploymentException(463, "Expected more resources in the stream: " + hashMap.keySet());
                    }
                    object = abstractInfo.getPath();
                    ResourceInfoImpl resourceInfoImpl = (ResourceInfoImpl)hashMap.remove(object);
                    if (resourceInfoImpl == null) {
                        throw new DeploymentException(463, "Resource '" + (String)object + "' is not described in the manifest.");
                    }
                    if (!resourceInfoImpl.isProcessedResource()) {
                        deploymentSessionImpl.getLog().log(3, "Ignoring non-processed resource: " + resourceInfoImpl.getPath());
                        continue;
                    }
                    ServiceReference serviceReference = abstractDeploymentPackage.getResourceProcessor((String)object);
                    if (serviceReference == null) {
                        throw new DeploymentException(464, "No resource processor for resource: '" + (String)object + "'");
                    }
                    if (!this.isValidCustomizer(deploymentSessionImpl, serviceReference)) {
                        throw new DeploymentException(458, "Resource processor for resource '" + (String)object + "' belongs to foreign deployment package");
                    }
                    ResourceProcessor resourceProcessor = (ResourceProcessor)bundleContext.getService(serviceReference);
                    if (resourceProcessor == null) {
                        throw new DeploymentException(464, "No resource processor for resource: '" + (String)object + "'");
                    }
                    try {
                        if (this.m_commitCommand.addResourceProcessor(resourceProcessor)) {
                            resourceProcessor.begin(deploymentSessionImpl);
                        }
                        resourceProcessor.process((String)object, abstractDeploymentPackage.getCurrentEntryStream());
                        continue block5;
                    }
                    catch (ResourceProcessorException resourceProcessorException) {
                        if (resourceProcessorException.getCode() == 461) {
                            throw new DeploymentException(461, "Sharing violation while processing resource '" + (String)object + "'", resourceProcessorException);
                        }
                        throw new DeploymentException(463, "Error while processing resource '" + (String)object + "'", resourceProcessorException);
                    }
                }
                break;
            }
            catch (IOException iOException) {
                throw new DeploymentException(463, "Problem while reading stream", iOException);
            }
        }
    }

    private boolean isValidCustomizer(DeploymentSessionImpl deploymentSessionImpl, ServiceReference serviceReference) {
        String string;
        if (deploymentSessionImpl.getConfiguration().isAllowForeignCustomizers()) {
            return serviceReference != null;
        }
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getSourceAbstractDeploymentPackage();
        return abstractDeploymentPackage.getBundleInfoByName(string = serviceReference.getBundle().getSymbolicName()) != null;
    }

    private class RollbackCommitAction
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;

        public RollbackCommitAction(DeploymentSessionImpl deploymentSessionImpl) {
            this.m_session = deploymentSessionImpl;
        }

        @Override
        protected void doRun() {
            ProcessResourceCommand.this.m_commitCommand.rollback(this.m_session);
        }
    }
}

