/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;

public class GetStorageAreaCommand
extends Command {
    private final Map m_storageAreas = new HashMap();

    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        DeploymentPackage deploymentPackage = deploymentSessionImpl.getTargetDeploymentPackage();
        BundleInfo[] bundleInfoArray = deploymentPackage.getBundleInfos();
        int n = 0;
        while (n < bundleInfoArray.length) {
            if (this.isCancelled()) {
                throw new DeploymentException(401);
            }
            Bundle bundle = deploymentPackage.getBundle(bundleInfoArray[n].getSymbolicName());
            if (bundle != null) {
                try {
                    File file = deploymentSessionImpl.getDataFile(bundle);
                    this.m_storageAreas.put(bundle.getSymbolicName(), file);
                }
                catch (IllegalStateException illegalStateException) {}
            }
            ++n;
        }
    }

    public Map getStorageAreas() {
        return this.m_storageAreas;
    }
}

