/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.log.LogService;

public class DropResourceCommand
extends Command {
    private final CommitResourceCommand m_commitCommand;

    public DropResourceCommand(CommitResourceCommand commitResourceCommand) {
        this.m_commitCommand = commitResourceCommand;
    }

    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        this.addRollback(new RollbackCommitAction(deploymentSessionImpl));
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getTargetAbstractDeploymentPackage();
        AbstractDeploymentPackage abstractDeploymentPackage2 = deploymentSessionImpl.getSourceAbstractDeploymentPackage();
        BundleContext bundleContext = deploymentSessionImpl.getBundleContext();
        LogService logService = deploymentSessionImpl.getLog();
        ResourceInfoImpl[] resourceInfoImplArray = abstractDeploymentPackage.getOrderedResourceInfos();
        int n = resourceInfoImplArray.length - 1;
        while (n >= 0) {
            ResourceInfoImpl resourceInfoImpl = resourceInfoImplArray[n];
            if (!resourceInfoImpl.isProcessedResource()) {
                deploymentSessionImpl.getLog().log(3, "Ignoring non-processed resource: " + resourceInfoImpl.getPath());
            } else {
                ResourceProcessor resourceProcessor;
                ServiceReference serviceReference;
                String string = resourceInfoImpl.getPath();
                if (abstractDeploymentPackage2.getResourceInfoByPath(string) == null && (serviceReference = abstractDeploymentPackage.getResourceProcessor(string)) != null && (resourceProcessor = (ResourceProcessor)bundleContext.getService(serviceReference)) != null) {
                    try {
                        if (this.m_commitCommand.addResourceProcessor(resourceProcessor)) {
                            resourceProcessor.begin(deploymentSessionImpl);
                        }
                        resourceProcessor.dropped(string);
                    }
                    catch (Exception exception) {
                        logService.log(2, "Not allowed to drop resource '" + string + "'", exception);
                    }
                }
            }
            --n;
        }
    }

    private class RollbackCommitAction
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;

        public RollbackCommitAction(DeploymentSessionImpl deploymentSessionImpl) {
            this.m_session = deploymentSessionImpl;
        }

        @Override
        protected void doRun() {
            DropResourceCommand.this.m_commitCommand.rollback(this.m_session);
        }
    }
}

