/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.util.HashSet;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.log.LogService;

public class DropAllResourcesCommand
extends Command {
    private final CommitResourceCommand m_commitCommand;

    public DropAllResourcesCommand(CommitResourceCommand commitResourceCommand) {
        this.m_commitCommand = commitResourceCommand;
    }

    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        this.addRollback(new RollbackCommitAction(deploymentSessionImpl));
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getTargetAbstractDeploymentPackage();
        BundleContext bundleContext = deploymentSessionImpl.getBundleContext();
        LogService logService = deploymentSessionImpl.getLog();
        HashSet<String> hashSet = new HashSet<String>();
        ResourceInfoImpl[] resourceInfoImplArray = abstractDeploymentPackage.getOrderedResourceInfos();
        int n = resourceInfoImplArray.length - 1;
        while (n >= 0) {
            ResourceInfoImpl resourceInfoImpl = resourceInfoImplArray[n];
            if (!resourceInfoImpl.isProcessedResource()) {
                deploymentSessionImpl.getLog().log(3, "Ignoring non-processed resource: " + resourceInfoImpl.getPath());
            } else {
                String string = resourceInfoImpl.getResourceProcessor();
                String string2 = resourceInfoImpl.getPath();
                if (hashSet.add(string)) {
                    ServiceReference serviceReference = abstractDeploymentPackage.getResourceProcessor(string2);
                    if (serviceReference == null) {
                        logService.log(1, "Failed to find resource processor for '" + string + "'!");
                        throw new DeploymentException(464, "Failed to find resource processor '" + string + "'!");
                    }
                    ResourceProcessor resourceProcessor = (ResourceProcessor)bundleContext.getService(serviceReference);
                    if (resourceProcessor == null) {
                        logService.log(1, "Failed to find resource processor for '" + string + "'!");
                        throw new DeploymentException(464, "Failed to find resource processor '" + string + "'!");
                    }
                    try {
                        if (this.m_commitCommand.addResourceProcessor(resourceProcessor)) {
                            resourceProcessor.begin(deploymentSessionImpl);
                        }
                        resourceProcessor.dropAllResources();
                    }
                    catch (Exception exception) {
                        logService.log(1, "Failed to drop all resources for resource processor '" + string + "'!", exception);
                        throw new DeploymentException(463, "Failed to drop all resources for resource processor '" + string + "'!", exception);
                    }
                }
            }
            --n;
        }
    }

    private class RollbackCommitAction
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;

        public RollbackCommitAction(DeploymentSessionImpl deploymentSessionImpl) {
            this.m_session = deploymentSessionImpl;
        }

        @Override
        protected void doRun() {
            DropAllResourcesCommand.this.m_commitCommand.rollback(this.m_session);
        }
    }
}

