/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.InputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;

public class DropAllBundlesCommand
extends Command {
    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        AbstractDeploymentPackage abstractDeploymentPackage = deploymentSessionImpl.getTargetAbstractDeploymentPackage();
        LogService logService = deploymentSessionImpl.getLog();
        BundleInfoImpl[] bundleInfoImplArray = abstractDeploymentPackage.getOrderedBundleInfos();
        int n = bundleInfoImplArray.length - 1;
        while (n >= 0) {
            BundleInfoImpl bundleInfoImpl = bundleInfoImplArray[n];
            String string = bundleInfoImpl.getSymbolicName();
            try {
                Bundle bundle = abstractDeploymentPackage.getBundle(string);
                if (bundle != null) {
                    bundle.uninstall();
                    this.addRollback(new InstallBundleRunnable(bundle, abstractDeploymentPackage, logService));
                }
            }
            catch (Exception exception) {
                logService.log(2, "Bundle '" + string + "' could not be uninstalled", exception);
            }
            --n;
        }
    }

    private static class InstallBundleRunnable
    extends AbstractAction {
        private final AbstractDeploymentPackage m_target;
        private final Bundle m_bundle;
        private final LogService m_log;

        public InstallBundleRunnable(Bundle bundle, AbstractDeploymentPackage abstractDeploymentPackage, LogService logService) {
            this.m_bundle = bundle;
            this.m_target = abstractDeploymentPackage;
            this.m_log = logService;
        }

        @Override
        protected void doRun() throws Exception {
            InputStream inputStream = null;
            try {
                inputStream = this.m_target.getBundleStream(this.m_bundle.getSymbolicName());
                if (inputStream == null) {
                    throw new RuntimeException("Unable to get inputstream for bundle '" + this.m_bundle.getSymbolicName() + "'");
                }
                this.m_bundle.update(inputStream);
            }
            catch (Throwable throwable) {
                DropAllBundlesCommand.closeSilently(inputStream);
                throw throwable;
            }
            DropAllBundlesCommand.closeSilently(inputStream);
        }

        @Override
        protected void onFailure(Exception exception) {
            this.m_log.log(2, "Could not rollback uninstallation of bundle '" + this.m_bundle.getSymbolicName() + "'", exception);
        }
    }
}

