/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.Constants;
import org.apache.felix.deploymentadmin.DeploymentAdminConfig;
import org.apache.felix.deploymentadmin.DeploymentAdminImpl;
import org.apache.felix.deploymentadmin.spi.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.deploymentadmin.spi.DeploymentSession;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class DeploymentSessionImpl
implements DeploymentSession,
Constants {
    private final AbstractDeploymentPackage m_target;
    private final AbstractDeploymentPackage m_source;
    private final List m_commands;
    private final DeploymentAdminImpl m_admin;
    private final DeploymentAdminConfig m_config;
    private volatile Command m_currentCommand = null;
    private volatile boolean m_cancelled;

    public DeploymentSessionImpl(AbstractDeploymentPackage abstractDeploymentPackage, AbstractDeploymentPackage abstractDeploymentPackage2, List list, DeploymentAdminImpl deploymentAdminImpl, DeploymentAdminConfig deploymentAdminConfig) {
        this.m_source = abstractDeploymentPackage;
        this.m_target = abstractDeploymentPackage2;
        this.m_commands = list;
        this.m_admin = deploymentAdminImpl;
        this.m_config = deploymentAdminConfig;
    }

    public void call(boolean bl) throws DeploymentException {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        Iterator iterator = this.m_commands.iterator();
        while (iterator.hasNext()) {
            if (this.m_cancelled) {
                this.rollback(arrayList);
                throw new DeploymentException(401);
            }
            this.m_currentCommand = (Command)iterator.next();
            try {
                arrayList.add(this.m_currentCommand);
                this.m_currentCommand.execute(this);
            }
            catch (DeploymentException deploymentException) {
                if (!bl) {
                    this.rollback(arrayList);
                    throw deploymentException;
                }
                this.m_admin.getLog().log(4, "Ignoring exception as requested!", deploymentException);
            }
        }
        iterator = this.m_commands.iterator();
        while (iterator.hasNext()) {
            ((Command)iterator.next()).commit(this);
        }
        this.m_currentCommand = null;
    }

    public boolean cancel() {
        this.m_cancelled = true;
        Command command = this.m_currentCommand;
        if (command != null) {
            command.cancel();
            return true;
        }
        return false;
    }

    public BundleContext getBundleContext() {
        return this.m_admin.getBundleContext();
    }

    public DeploymentAdminConfig getConfiguration() {
        return this.m_config;
    }

    @Override
    public File getDataFile(Bundle bundle) {
        File file = null;
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            throw new IllegalStateException("Could not retrieve valid bundle context from bundle " + bundle.getSymbolicName());
        }
        file = bundleContext.getDataFile("");
        if (file == null) {
            throw new IllegalStateException("Could not retrieve base directory for bundle " + bundle.getSymbolicName());
        }
        return file;
    }

    public LogService getLog() {
        return this.m_admin.getLog();
    }

    public PackageAdmin getPackageAdmin() {
        return this.m_admin.getPackageAdmin();
    }

    public AbstractDeploymentPackage getSourceAbstractDeploymentPackage() {
        return this.m_source;
    }

    @Override
    public DeploymentPackage getSourceDeploymentPackage() {
        return this.m_source;
    }

    public AbstractDeploymentPackage getTargetAbstractDeploymentPackage() {
        return this.m_target;
    }

    @Override
    public DeploymentPackage getTargetDeploymentPackage() {
        return this.m_target;
    }

    private void rollback(List list) {
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            Command command = (Command)listIterator.previous();
            command.rollback(this);
        }
    }
}

