/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;

public class CommitResourceCommand
extends Command {
    private final List m_processors = new ArrayList();

    @Override
    protected void doExecute(DeploymentSessionImpl deploymentSessionImpl) throws Exception {
        ResourceProcessor resourceProcessor;
        ListIterator listIterator = this.m_processors.listIterator(this.m_processors.size());
        while (listIterator.hasPrevious()) {
            resourceProcessor = (ResourceProcessor)listIterator.previous();
            try {
                resourceProcessor.prepare();
            }
            catch (ResourceProcessorException resourceProcessorException) {
                deploymentSessionImpl.getLog().log(1, "Preparing commit for resource processor failed", resourceProcessorException);
                if (resourceProcessorException.getCode() == 1) {
                    throw new DeploymentException(462, "Preparing commit for resource processor failed!", resourceProcessorException);
                }
                throw new DeploymentException(resourceProcessorException.getCode(), "Preparing commit for resource processor failed!", resourceProcessorException);
            }
            catch (Exception exception) {
                deploymentSessionImpl.getLog().log(1, "Preparing commit for resource processor failed", exception);
                throw new DeploymentException(463, "Preparing commit for resource processor failed", exception);
            }
        }
        listIterator = this.m_processors.listIterator(this.m_processors.size());
        while (listIterator.hasPrevious()) {
            resourceProcessor = (ResourceProcessor)listIterator.previous();
            try {
                resourceProcessor.commit();
            }
            catch (Exception exception) {
                deploymentSessionImpl.getLog().log(1, "Committing resource processor '" + resourceProcessor + "' failed", exception);
            }
        }
        this.m_processors.clear();
    }

    @Override
    protected void rollback(DeploymentSessionImpl deploymentSessionImpl) {
        ListIterator listIterator = this.m_processors.listIterator(this.m_processors.size());
        while (listIterator.hasPrevious()) {
            ResourceProcessor resourceProcessor = (ResourceProcessor)listIterator.previous();
            try {
                try {
                    resourceProcessor.rollback();
                }
                catch (Exception exception) {
                    deploymentSessionImpl.getLog().log(1, "Rollback of resource processor '" + resourceProcessor + "' failed", exception);
                    listIterator.remove();
                    continue;
                }
            }
            catch (Throwable throwable) {
                listIterator.remove();
                throw throwable;
            }
            listIterator.remove();
        }
    }

    public boolean addResourceProcessor(ResourceProcessor resourceProcessor) {
        for (ResourceProcessor resourceProcessor2 : this.m_processors) {
            if (resourceProcessor2 != resourceProcessor) continue;
            return false;
        }
        this.m_processors.add(resourceProcessor);
        return true;
    }
}

