/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.deploymentadmin.Constants;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.deploymentadmin.DeploymentException;

public abstract class Command
implements Constants {
    private final List m_rollback = new ArrayList();
    private final List m_commit = new ArrayList();
    private volatile boolean m_cancelled;

    public final void execute(DeploymentSessionImpl deploymentSessionImpl) throws DeploymentException {
        try {
            this.doExecute(deploymentSessionImpl);
        }
        catch (Exception exception) {
            if (exception instanceof DeploymentException) {
                throw (DeploymentException)exception;
            }
            throw new DeploymentException(463, "Command failed!", exception);
        }
    }

    protected abstract void doExecute(DeploymentSessionImpl var1) throws Exception;

    protected void rollback(DeploymentSessionImpl deploymentSessionImpl) {
        try {
            ListIterator listIterator = this.m_rollback.listIterator(this.m_rollback.size());
            while (listIterator.hasPrevious()) {
                Runnable runnable = (Runnable)listIterator.previous();
                runnable.run();
            }
        }
        finally {
            this.cleanUp();
        }
    }

    protected final void commit(DeploymentSessionImpl deploymentSessionImpl) {
        try {
            ListIterator listIterator = this.m_commit.listIterator();
            while (listIterator.hasNext()) {
                Runnable runnable = (Runnable)listIterator.next();
                runnable.run();
            }
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        this.m_rollback.clear();
        this.m_commit.clear();
        this.m_cancelled = false;
    }

    protected boolean isCancelled() {
        return this.m_cancelled;
    }

    protected void addRollback(AbstractAction abstractAction) {
        this.m_rollback.add(abstractAction);
    }

    protected void addCommit(AbstractAction abstractAction) {
        this.m_commit.add(abstractAction);
    }

    public void cancel() {
        this.m_cancelled = true;
    }

    static final boolean isFragmentBundle(Bundle bundle) {
        String string = bundle.getHeaders().get("Fragment-Host");
        return string != null;
    }

    static final void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {}
        }
    }
}

