/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import org.osgi.framework.Version;

public class VersionRange {
    public static final VersionRange infiniteRange = new VersionRange(Version.emptyVersion, true, null, true);
    private Version m_low = null;
    private boolean m_isLowInclusive = false;
    private Version m_high = null;
    private boolean m_isHighInclusive = false;
    private String m_toString = null;

    public VersionRange(Version version, boolean bl, Version version2, boolean bl2) {
        this.m_low = version;
        this.m_isLowInclusive = bl;
        this.m_high = version2;
        this.m_isHighInclusive = bl2;
    }

    public VersionRange(Version version) {
        this(version, true, null, false);
    }

    public Version getLow() {
        return this.m_low;
    }

    public boolean isLowInclusive() {
        return this.m_isLowInclusive;
    }

    public Version getHigh() {
        return this.m_high;
    }

    public boolean isHighInclusive() {
        return this.m_isHighInclusive;
    }

    public boolean isInRange(Version version) {
        if (this.m_high == null) {
            return version.compareTo(this.m_low) >= 0;
        }
        if (this.isLowInclusive() && this.isHighInclusive()) {
            return version.compareTo(this.m_low) >= 0 && version.compareTo(this.m_high) <= 0;
        }
        if (this.isHighInclusive()) {
            return version.compareTo(this.m_low) > 0 && version.compareTo(this.m_high) <= 0;
        }
        if (this.isLowInclusive()) {
            return version.compareTo(this.m_low) >= 0 && version.compareTo(this.m_high) < 0;
        }
        return version.compareTo(this.m_low) > 0 && version.compareTo(this.m_high) < 0;
    }

    public static VersionRange parse(String string) throws IllegalArgumentException {
        if (string.indexOf(44) >= 0) {
            String string2 = string.substring(1, string.length() - 1);
            String string3 = string2.substring(0, string2.indexOf(44)).trim();
            String string4 = string2.substring(string2.indexOf(44) + 1, string2.length()).trim();
            return new VersionRange(new Version(string3), string.charAt(0) == '[', new Version(string4), string.charAt(string.length() - 1) == ']');
        }
        return new VersionRange(new Version(string), true, null, false);
    }

    public String toString() {
        if (this.m_toString == null) {
            if (this.m_high != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.m_isLowInclusive ? (char)'[' : '(');
                stringBuffer.append(this.m_low.toString());
                stringBuffer.append(',');
                stringBuffer.append(this.m_high.toString());
                stringBuffer.append(this.m_isHighInclusive ? (char)']' : ')');
                this.m_toString = stringBuffer.toString();
            } else {
                this.m_toString = this.m_low.toString();
            }
        }
        return this.m_toString;
    }
}

