/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Utils {
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";

    public static Manifest readManifest(File file) throws IOException {
        GZIPInputStream gZIPInputStream = null;
        Manifest manifest = null;
        try {
            gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
            manifest = new Manifest(gZIPInputStream);
        }
        catch (Throwable throwable) {
            Utils.closeSilently(gZIPInputStream);
            throw throwable;
        }
        Utils.closeSilently(gZIPInputStream);
        return manifest;
    }

    public static boolean replace(File file, File file2) {
        return Utils.delete(file, true) && Utils.rename(file2, file);
    }

    public static boolean copy(File file, File file2) {
        boolean bl = true;
        if (file.isDirectory()) {
            if (!file2.isDirectory()) {
                if (!file2.mkdirs()) {
                    return false;
                }
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    return false;
                }
                int n = 0;
                while (n < fileArray.length) {
                    bl &= Utils.copy(fileArray[n], new File(file2, fileArray[n].getName()));
                    ++n;
                }
            }
        } else {
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                    byte[] byArray = new byte[4096];
                    int n = ((InputStream)fileInputStream).read(byArray);
                    while (n > -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        n = ((InputStream)fileInputStream).read(byArray);
                    }
                }
                catch (IOException iOException) {
                    if (!Utils.closeSilently(fileOutputStream)) {
                        bl = false;
                    }
                    if (!Utils.closeSilently(fileInputStream)) {
                        bl = false;
                    }
                    return false;
                }
            }
            finally {
                if (!Utils.closeSilently(fileOutputStream)) {
                    bl = false;
                }
                if (!Utils.closeSilently(fileInputStream)) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static boolean rename(File file, File file2) {
        if (!file.renameTo(file2)) {
            if (Utils.copy(file, file2)) {
                if (!Utils.delete(file, true)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean delete(File file, boolean bl) {
        boolean bl2 = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                bl2 = fileArray[n].isDirectory() ? (bl2 &= Utils.delete(fileArray[n], true)) : (bl2 &= fileArray[n].delete());
                ++n;
            }
        }
        if (bl && file.exists()) {
            bl2 &= file.delete();
        }
        return bl2;
    }

    public static void merge(File file, File file2, File file3, File file4) throws IOException {
        Object object;
        List list = Utils.readIndex(file);
        List list2 = Utils.readIndex(file3);
        ArrayList<String> arrayList = new ArrayList<String>(list);
        File file5 = new File(file4, (String)list2.remove(0));
        Manifest manifest = Utils.readManifest(file5);
        manifest.getMainAttributes().remove(new Attributes.Name("DeploymentPackage-FixPack"));
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            if (MANIFEST_NAME.equals(string) || manifest.getEntries().containsKey(string)) continue;
            object2.remove();
        }
        for (String string : list2) {
            object = new File(file4, string);
            File file6 = new File(file2, string);
            if (list.contains(string)) {
                if (!file6.delete()) {
                    throw new IOException("Could not delete " + file6);
                }
            } else {
                arrayList.add(string);
            }
            if (Utils.rename((File)object, file6)) continue;
            throw new IOException("Could not rename " + object + " to " + file6);
        }
        list.removeAll(list2);
        for (String string : manifest.getEntries().keySet()) {
            object = manifest.getEntries().get(string);
            if (!"true".equals(((Attributes)object).remove(new Attributes.Name("DeploymentPackage-Missing")))) continue;
            list.remove(string);
        }
        for (String string : list) {
            object = new File(file2, string);
            if (((File)object).delete()) continue;
            throw new IOException("Could not delete " + object);
        }
        object2 = new GZIPOutputStream(new FileOutputStream(new File(file2, MANIFEST_NAME)));
        try {
            manifest.write((OutputStream)object2);
        }
        finally {
            ((DeflaterOutputStream)object2).close();
        }
        Utils.writeIndex(file, arrayList);
    }

    public static List readIndex(File file) throws IOException {
        ArrayList<String> arrayList;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string = bufferedReader.readLine();
            while (string != null) {
                arrayList2.add(string);
                string = bufferedReader.readLine();
            }
            arrayList = arrayList2;
        }
        catch (Throwable throwable) {
            Utils.closeSilently(bufferedReader);
            throw throwable;
        }
        Utils.closeSilently(bufferedReader);
        return arrayList;
    }

    static boolean closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    private static void writeIndex(File file, List list) throws IOException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                printWriter.println(iterator.next());
            }
        }
        catch (Throwable throwable) {
            Utils.closeSilently(printWriter);
            throw throwable;
        }
        Utils.closeSilently(printWriter);
    }
}

