/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.DeploymentAdminImpl;
import org.apache.felix.deploymentadmin.NonCloseableStream;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.DeploymentException;

public class StreamDeploymentPackage
extends AbstractDeploymentPackage {
    private final JarInputStream m_input;
    private final List m_names = new ArrayList();
    private boolean m_inMetaInf = true;

    public StreamDeploymentPackage(JarInputStream jarInputStream, BundleContext bundleContext, DeploymentAdminImpl deploymentAdminImpl) throws DeploymentException {
        super(jarInputStream.getManifest(), bundleContext, deploymentAdminImpl);
        this.m_input = jarInputStream;
    }

    @Override
    public InputStream getBundleStream(String string) {
        throw new UnsupportedOperationException("Not applicable for stream-based deployment package");
    }

    @Override
    public InputStream getCurrentEntryStream() {
        return new NonCloseableStream(this.m_input);
    }

    @Override
    public AbstractInfo getNextEntry() throws IOException {
        String string;
        boolean bl = true;
        do {
            JarEntry jarEntry;
            if ((jarEntry = this.m_input.getNextJarEntry()) == null) {
                return null;
            }
            string = jarEntry.getName();
            bl = this.isMetaInfFile(string);
            if (!bl || this.m_inMetaInf) continue;
            throw new IOException("Unexpected signature file found after manifest files: " + string);
        } while (bl);
        this.m_inMetaInf = false;
        this.m_names.add(string);
        return this.getAbstractInfoByPath(string);
    }

    @Override
    public BundleInfoImpl[] getOrderedBundleInfos() {
        ArrayList<BundleInfoImpl> arrayList = new ArrayList<BundleInfoImpl>();
        for (String string : this.m_names) {
            BundleInfoImpl bundleInfoImpl = this.getBundleInfoByPath(string);
            if (bundleInfoImpl == null) continue;
            arrayList.add(bundleInfoImpl);
        }
        BundleInfoImpl[] bundleInfoImplArray = this.getBundleInfoImpls();
        int n = 0;
        while (n < bundleInfoImplArray.length) {
            if (bundleInfoImplArray[n].isMissing()) {
                arrayList.add(bundleInfoImplArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new BundleInfoImpl[arrayList.size()]);
    }

    @Override
    public ResourceInfoImpl[] getOrderedResourceInfos() {
        throw new UnsupportedOperationException("Not applicable for stream-based deployment package");
    }
}

