/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

public class Semaphore {
    private boolean m_available;

    public Semaphore() {
        this.m_available = true;
    }

    public Semaphore(boolean bl) {
        this.m_available = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                if (!this.m_available) {
                    this.wait();
                }
                this.m_available = false;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryAcquire(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.m_available) {
                this.m_available = false;
                return true;
            }
            if (l <= 0L) {
                return false;
            }
            long l2 = System.currentTimeMillis();
            try {}
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
            do {
                this.wait(l);
                if (!this.m_available) continue;
                this.m_available = false;
                return true;
            } while ((l -= System.currentTimeMillis() - l2) > 0L);
            return false;
        }
    }

    public synchronized void release() {
        this.m_available = true;
        this.notify();
    }
}

