/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.IOException;
import java.io.InputStream;

public class NonCloseableStream
extends InputStream {
    private final InputStream m_input;
    private volatile boolean m_closed;

    public NonCloseableStream(InputStream inputStream) {
        this.m_input = inputStream;
    }

    @Override
    public int available() throws IOException {
        return this.m_input.available();
    }

    @Override
    public void close() throws IOException {
        this.assertOpen();
        this.m_closed = true;
    }

    public boolean equals(Object object) {
        return this.m_input.equals(object);
    }

    public int hashCode() {
        return this.m_input.hashCode();
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return this.m_input.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.assertOpen();
        return this.m_input.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.assertOpen();
        return this.m_input.read(byArray, n, n2);
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark and reset are not available on this type of stream.");
    }

    @Override
    public long skip(long l) throws IOException {
        return this.m_input.skip(l);
    }

    public String toString() {
        return this.m_input.toString();
    }

    private void assertOpen() throws IOException {
        if (this.m_closed) {
            throw new IOException("Unable to read, stream is closed.");
        }
    }
}

