/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.DeploymentAdminImpl;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.DeploymentException;

public class FileDeploymentPackage
extends AbstractDeploymentPackage {
    private final List m_index;
    private final File m_contentsDir;

    public FileDeploymentPackage(File file, File file2, BundleContext bundleContext, DeploymentAdminImpl deploymentAdminImpl) throws DeploymentException, IOException {
        this(Utils.readIndex(file), file2, bundleContext, deploymentAdminImpl);
    }

    private FileDeploymentPackage(List list, File file, BundleContext bundleContext, DeploymentAdminImpl deploymentAdminImpl) throws DeploymentException, IOException {
        super(Utils.readManifest(new File(file, (String)list.remove(0))), bundleContext, deploymentAdminImpl);
        this.m_index = list;
        this.m_contentsDir = file;
    }

    @Override
    public InputStream getBundleStream(String string) throws IOException {
        BundleInfoImpl bundleInfoImpl = this.getBundleInfoByName(string);
        if (bundleInfoImpl != null) {
            return new GZIPInputStream(new FileInputStream(new File(this.m_contentsDir, bundleInfoImpl.getPath())));
        }
        return null;
    }

    @Override
    public InputStream getCurrentEntryStream() {
        throw new UnsupportedOperationException("Not implemented for file-based deployment package");
    }

    @Override
    public AbstractInfo getNextEntry() throws IOException {
        throw new UnsupportedOperationException("Not implemented for file-based deployment package");
    }

    @Override
    public BundleInfoImpl[] getOrderedBundleInfos() {
        ArrayList<BundleInfoImpl> arrayList = new ArrayList<BundleInfoImpl>();
        Iterator iterator = this.m_index.iterator();
        while (iterator.hasNext()) {
            BundleInfoImpl bundleInfoImpl = this.getBundleInfoByPath((String)iterator.next());
            if (bundleInfoImpl == null) continue;
            arrayList.add(bundleInfoImpl);
        }
        return arrayList.toArray(new BundleInfoImpl[arrayList.size()]);
    }

    @Override
    public ResourceInfoImpl[] getOrderedResourceInfos() {
        ArrayList<ResourceInfoImpl> arrayList = new ArrayList<ResourceInfoImpl>();
        Iterator iterator = this.m_index.iterator();
        while (iterator.hasNext()) {
            ResourceInfoImpl resourceInfoImpl = this.getResourceInfoByPath((String)iterator.next());
            if (resourceInfoImpl == null) continue;
            arrayList.add(resourceInfoImpl);
        }
        return arrayList.toArray(new ResourceInfoImpl[arrayList.size()]);
    }
}

