/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.Constants;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.VersionRange;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.DeploymentException;

public class DeploymentPackageManifest
implements Constants {
    private final Manifest m_manifest;
    private final Version m_version;
    private final List m_bundleInfos = new ArrayList();
    private final List m_resourceInfos = new ArrayList();
    private final String m_symbolicName;
    private final VersionRange m_fixPackage;

    public DeploymentPackageManifest(Manifest manifest) throws DeploymentException {
        if (manifest == null || manifest.getMainAttributes() == null) {
            throw new DeploymentException(452);
        }
        this.m_manifest = manifest;
        Attributes attributes = this.m_manifest.getMainAttributes();
        this.m_symbolicName = this.getNonNullHeader(attributes.getValue("DeploymentPackage-SymbolicName"));
        String string = this.getNonNullHeader(attributes.getValue("DeploymentPackage-Version"));
        try {
            this.m_version = new Version(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DeploymentException(452);
        }
        String string2 = attributes.getValue("DeploymentPackage-FixPack");
        if (string2 != null) {
            try {
                this.m_fixPackage = VersionRange.parse(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DeploymentException(452, "Invalid version range for header: DeploymentPackage-FixPack");
            }
        } else {
            this.m_fixPackage = null;
        }
        Map<String, Attributes> map = this.m_manifest.getEntries();
        for (String string3 : map.keySet()) {
            this.processEntry(string3, map.get(string3), this.m_fixPackage != null);
        }
    }

    public String getHeader(String string) {
        return this.m_manifest.getMainAttributes().getValue(string);
    }

    public VersionRange getFixPackage() {
        return this.m_fixPackage;
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public List getBundleInfos() {
        return this.m_bundleInfos;
    }

    public List getResourceInfos() {
        return this.m_resourceInfos;
    }

    private void processEntry(String string, Attributes attributes, boolean bl) throws DeploymentException {
        if (BundleInfoImpl.isBundleResource(attributes)) {
            BundleInfoImpl bundleInfoImpl = new BundleInfoImpl(string, attributes);
            if (bundleInfoImpl.isMissing() && !bl) {
                throw new DeploymentException(452, "Header 'DeploymentPackage-Missing' for manifest entry '" + string + "' may only be 'true' if " + "DeploymentPackage-FixPack" + " manifest header is 'true'");
            }
            this.m_bundleInfos.add(bundleInfoImpl);
        } else {
            this.m_resourceInfos.add(new ResourceInfoImpl(string, attributes));
        }
    }

    private String getNonNullHeader(String string) throws DeploymentException {
        if (string == null) {
            throw new DeploymentException(451);
        }
        if ("".equals(string.trim())) {
            throw new DeploymentException(452);
        }
        return string;
    }
}

