/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.Constants;
import org.apache.felix.deploymentadmin.ContentCopyingJarInputStream;
import org.apache.felix.deploymentadmin.DeploymentAdminConfig;
import org.apache.felix.deploymentadmin.FileDeploymentPackage;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.Semaphore;
import org.apache.felix.deploymentadmin.StreamDeploymentPackage;
import org.apache.felix.deploymentadmin.Utils;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.apache.felix.deploymentadmin.spi.DropAllBundlesCommand;
import org.apache.felix.deploymentadmin.spi.DropAllResourcesCommand;
import org.apache.felix.deploymentadmin.spi.DropBundleCommand;
import org.apache.felix.deploymentadmin.spi.DropResourceCommand;
import org.apache.felix.deploymentadmin.spi.GetStorageAreaCommand;
import org.apache.felix.deploymentadmin.spi.ProcessResourceCommand;
import org.apache.felix.deploymentadmin.spi.SnapshotCommand;
import org.apache.felix.deploymentadmin.spi.StartBundleCommand;
import org.apache.felix.deploymentadmin.spi.StartCustomizerCommand;
import org.apache.felix.deploymentadmin.spi.StopBundleCommand;
import org.apache.felix.deploymentadmin.spi.UpdateCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class DeploymentAdminImpl
implements DeploymentAdmin,
Constants {
    public static final String PACKAGE_DIR = "packages";
    public static final String TEMP_DIR = "temp";
    public static final String PACKAGECONTENTS_DIR = "contents";
    public static final String PACKAGEINDEX_FILE = "index.txt";
    public static final String TEMP_PREFIX = "pkg";
    public static final String TEMP_POSTFIX = "";
    private static final long TIMEOUT = 10000L;
    private volatile BundleContext m_context;
    private volatile PackageAdmin m_packageAdmin;
    private volatile LogService m_log;
    private volatile DeploymentSessionImpl m_session;
    private final Map m_packages = new HashMap();
    private final Semaphore m_semaphore = new Semaphore();

    public DeploymentAdminImpl() {
    }

    DeploymentAdminImpl(BundleContext bundleContext) {
        this.m_context = bundleContext;
    }

    @Override
    public boolean cancel() {
        DeploymentSessionImpl deploymentSessionImpl = this.m_session;
        if (deploymentSessionImpl != null) {
            deploymentSessionImpl.cancel();
            return true;
        }
        return false;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    @Override
    public DeploymentPackage getDeploymentPackage(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle can not be null");
        }
        return this.getDeploymentPackageContainingBundleWithSymbolicName(bundle.getSymbolicName());
    }

    @Override
    public DeploymentPackage getDeploymentPackage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Symbolic name may not be null");
        }
        return (DeploymentPackage)this.m_packages.get(string);
    }

    public LogService getLog() {
        return this.m_log;
    }

    public PackageAdmin getPackageAdmin() {
        return this.m_packageAdmin;
    }

    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.m_packageAdmin = packageAdmin;
    }

    @Override
    public DeploymentPackage installDeploymentPackage(InputStream inputStream) throws DeploymentException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Inputstream may not be null");
        }
        try {
            if (!this.m_semaphore.tryAcquire(10000L)) {
                throw new DeploymentException(465, "Timeout exceeded while waiting to install deployment package (10000 ms)");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DeploymentException(465, "Thread interrupted");
        }
        File file = null;
        StreamDeploymentPackage streamDeploymentPackage = null;
        AbstractDeploymentPackage abstractDeploymentPackage = null;
        try {
            Object object;
            Object object2;
            ContentCopyingJarInputStream contentCopyingJarInputStream = null;
            File file2 = null;
            File file3 = null;
            try {
                object2 = this.m_context.getDataFile(TEMP_DIR);
                ((File)object2).mkdirs();
                file = File.createTempFile(TEMP_PREFIX, TEMP_POSTFIX, (File)object2);
                file.delete();
                file.mkdirs();
                file2 = new File(file, PACKAGEINDEX_FILE);
                file3 = new File(file, PACKAGECONTENTS_DIR);
                file3.mkdirs();
            }
            catch (IOException iOException) {
                throw new DeploymentException(463, "Error writing package to disk", iOException);
            }
            try {
                contentCopyingJarInputStream = new ContentCopyingJarInputStream(inputStream, file2, file3);
                if (contentCopyingJarInputStream.getManifest() == null) {
                    Utils.closeSilently(contentCopyingJarInputStream);
                    System.err.println("Stream does not contain a valid deployment package: missing manifest!");
                    throw new DeploymentException(451, "No manifest present in deployment package!");
                }
            }
            catch (IOException iOException) {
                throw new DeploymentException(404, "Stream does not contain a valid Jar", iOException);
            }
            streamDeploymentPackage = new StreamDeploymentPackage(contentCopyingJarInputStream, this.m_context, this);
            object2 = streamDeploymentPackage.getName();
            abstractDeploymentPackage = this.getExistingOrEmptyDeploymentPackage((String)object2);
            this.verifyNoResourcesShared(streamDeploymentPackage, abstractDeploymentPackage);
            if (streamDeploymentPackage.isFixPackage()) {
                this.verifyFixPackage(streamDeploymentPackage, abstractDeploymentPackage);
            } else {
                this.verifySourcePackage(streamDeploymentPackage);
            }
            try {
                this.m_session = new DeploymentSessionImpl(streamDeploymentPackage, abstractDeploymentPackage, this.createInstallCommandChain(), this, new DeploymentAdminConfig(this.m_context));
                this.m_session.call(false);
            }
            finally {
                Utils.closeSilently(contentCopyingJarInputStream);
            }
            String string = PACKAGE_DIR + File.separator + (String)object2;
            File file4 = this.m_context.getDataFile(String.valueOf(string) + File.separator + PACKAGECONTENTS_DIR);
            File file5 = this.m_context.getDataFile(String.valueOf(string) + File.separator + PACKAGEINDEX_FILE);
            if (streamDeploymentPackage.isFixPackage()) {
                try {
                    Utils.merge(file5, file4, file2, file3);
                }
                catch (IOException iOException) {
                    throw new DeploymentException(463, "Could not merge source fix package with target deployment package", iOException);
                }
            } else {
                object = this.m_context.getDataFile(string);
                ((File)object).mkdirs();
                if (!Utils.replace((File)object, file)) {
                    throw new DeploymentException(463, "Could not replace " + object + " with " + file);
                }
            }
            object = null;
            try {
                object = new FileDeploymentPackage(file5, file4, this.m_context, this);
                this.m_packages.put(object2, object);
            }
            catch (IOException iOException) {
                throw new DeploymentException(463, "Could not create installed deployment package from disk", iOException);
            }
            Object object3 = object;
            return object3;
        }
        finally {
            if (file != null && !Utils.delete(file, true)) {
                System.err.println("Could not delete temporary deployment package from disk");
            }
            this.m_semaphore.release();
        }
    }

    @Override
    public DeploymentPackage[] listDeploymentPackages() {
        Collection collection = this.m_packages.values();
        return collection.toArray(new DeploymentPackage[collection.size()]);
    }

    public void start() throws DeploymentException {
        File file = this.m_context.getDataFile(PACKAGE_DIR);
        if (file == null) {
            throw new DeploymentException(463, "Could not create directories needed for deployment package persistence");
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                if (file2.isDirectory()) {
                    try {
                        File file3 = new File(file2, PACKAGEINDEX_FILE);
                        File file4 = new File(file2, PACKAGECONTENTS_DIR);
                        FileDeploymentPackage fileDeploymentPackage = new FileDeploymentPackage(file3, file4, this.m_context, this);
                        this.m_packages.put(fileDeploymentPackage.getName(), fileDeploymentPackage);
                    }
                    catch (IOException iOException) {}
                }
                ++n;
            }
        }
    }

    public void stop() {
        this.cancel();
    }

    public void uninstallDeploymentPackage(DeploymentPackage deploymentPackage, boolean bl) throws DeploymentException {
        try {
            if (!this.m_semaphore.tryAcquire(10000L)) {
                throw new DeploymentException(465, "Timeout exceeded while waiting to uninstall deployment package (10000 ms)");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DeploymentException(465, "Thread interrupted");
        }
        AbstractDeploymentPackage abstractDeploymentPackage = AbstractDeploymentPackage.EMPTY_PACKAGE;
        AbstractDeploymentPackage abstractDeploymentPackage2 = (AbstractDeploymentPackage)deploymentPackage;
        try {
            this.m_session = new DeploymentSessionImpl(abstractDeploymentPackage, abstractDeploymentPackage2, this.createUninstallCommandChain(), this, new DeploymentAdminConfig(this.m_context));
            this.m_session.call(bl);
            File file = this.m_context.getDataFile(PACKAGE_DIR + File.separator + abstractDeploymentPackage.getName());
            if (!Utils.delete(file, true)) {
                throw new DeploymentException(463, "Could not delete deployment package from disk");
            }
            this.m_packages.remove(deploymentPackage.getName());
        }
        finally {
            this.m_semaphore.release();
        }
    }

    private Dictionary createEventProperties(AbstractDeploymentPackage abstractDeploymentPackage, AbstractDeploymentPackage abstractDeploymentPackage2) {
        Properties properties = new Properties();
        if (abstractDeploymentPackage != null) {
            String string = abstractDeploymentPackage.getDisplayName();
            if (string == null) {
                string = abstractDeploymentPackage.getName();
            }
            ((Dictionary)properties).put("deploymentpackage.name", abstractDeploymentPackage.getName());
            ((Dictionary)properties).put("deploymentpackage.readablename", string);
            if (!abstractDeploymentPackage.isNew()) {
                ((Dictionary)properties).put("deploymentpackage.nextversion", abstractDeploymentPackage.getVersion());
            }
        }
        if (abstractDeploymentPackage2 != null && !abstractDeploymentPackage2.isNew()) {
            ((Dictionary)properties).put("deploymentpackage.currentversion", abstractDeploymentPackage2.getVersion());
        }
        return properties;
    }

    private List createInstallCommandChain() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        GetStorageAreaCommand getStorageAreaCommand = new GetStorageAreaCommand();
        arrayList.add(getStorageAreaCommand);
        arrayList.add(new StopBundleCommand());
        arrayList.add(new SnapshotCommand(getStorageAreaCommand));
        arrayList.add(new UpdateCommand());
        arrayList.add(new StartCustomizerCommand());
        CommitResourceCommand commitResourceCommand = new CommitResourceCommand();
        arrayList.add(new ProcessResourceCommand(commitResourceCommand));
        arrayList.add(new DropResourceCommand(commitResourceCommand));
        arrayList.add(new DropBundleCommand());
        arrayList.add(commitResourceCommand);
        arrayList.add(new StartBundleCommand());
        return arrayList;
    }

    private List createUninstallCommandChain() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        GetStorageAreaCommand getStorageAreaCommand = new GetStorageAreaCommand();
        arrayList.add(getStorageAreaCommand);
        arrayList.add(new StopBundleCommand());
        arrayList.add(new SnapshotCommand(getStorageAreaCommand));
        arrayList.add(new StartCustomizerCommand());
        CommitResourceCommand commitResourceCommand = new CommitResourceCommand();
        arrayList.add(new DropAllResourcesCommand(commitResourceCommand));
        arrayList.add(commitResourceCommand);
        arrayList.add(new DropAllBundlesCommand());
        return arrayList;
    }

    private AbstractDeploymentPackage getDeploymentPackageContainingBundleWithSymbolicName(String string) {
        for (AbstractDeploymentPackage abstractDeploymentPackage : this.m_packages.values()) {
            if (abstractDeploymentPackage.getBundle(string) == null) continue;
            return abstractDeploymentPackage;
        }
        return null;
    }

    private AbstractDeploymentPackage getExistingOrEmptyDeploymentPackage(String string) {
        AbstractDeploymentPackage abstractDeploymentPackage = (AbstractDeploymentPackage)this.m_packages.get(string);
        if (abstractDeploymentPackage == null) {
            abstractDeploymentPackage = AbstractDeploymentPackage.EMPTY_PACKAGE;
        }
        return abstractDeploymentPackage;
    }

    private Bundle[] getNonDeploymentPackagedBundles() {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(Arrays.asList(this.m_context.getBundles()));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = (Bundle)iterator.next();
            if (!bundle.getLocation().startsWith("osgi-dp:")) continue;
            iterator.remove();
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    private void verifyFixPackage(AbstractDeploymentPackage abstractDeploymentPackage, AbstractDeploymentPackage abstractDeploymentPackage2) throws DeploymentException {
        boolean bl = abstractDeploymentPackage2.isNew();
        if (bl || !abstractDeploymentPackage.getVersionRange().isInRange(abstractDeploymentPackage2.getVersion())) {
            throw new DeploymentException(453, "Target package version '" + abstractDeploymentPackage2.getVersion() + "' is not in source range '" + abstractDeploymentPackage.getVersionRange() + "'");
        }
        BundleInfoImpl[] bundleInfoImplArray = abstractDeploymentPackage.getBundleInfoImpls();
        int n = 0;
        while (n < bundleInfoImplArray.length) {
            BundleInfoImpl bundleInfoImpl;
            if (bundleInfoImplArray[n].isMissing() && (bundleInfoImpl = abstractDeploymentPackage2.getBundleInfoByPath(bundleInfoImplArray[n].getPath())) == null) {
                throw new DeploymentException(454, "Missing bundle '" + bundleInfoImplArray[n].getSymbolicName() + "/" + bundleInfoImplArray[n].getVersion() + " does not exist in target package!");
            }
            ++n;
        }
        ResourceInfoImpl[] resourceInfoImplArray = abstractDeploymentPackage.getResourceInfos();
        int n2 = 0;
        while (n2 < resourceInfoImplArray.length) {
            ResourceInfoImpl resourceInfoImpl;
            if (resourceInfoImplArray[n2].isMissing() && (resourceInfoImpl = abstractDeploymentPackage2.getResourceInfoByPath(resourceInfoImplArray[n2].getPath())) == null) {
                throw new DeploymentException(455, "Missing resource '" + resourceInfoImplArray[n2].getPath() + " does not exist in target package!");
            }
            ++n2;
        }
    }

    private void verifyNoResourcesShared(AbstractDeploymentPackage abstractDeploymentPackage, AbstractDeploymentPackage abstractDeploymentPackage2) throws DeploymentException {
        Bundle[] bundleArray = this.getNonDeploymentPackagedBundles();
        BundleInfoImpl[] bundleInfoImplArray = abstractDeploymentPackage.getBundleInfoImpls();
        int n = 0;
        while (n < bundleInfoImplArray.length) {
            String string = bundleInfoImplArray[n].getSymbolicName();
            Version version = bundleInfoImplArray[n].getVersion();
            AbstractDeploymentPackage abstractDeploymentPackage3 = this.getDeploymentPackageContainingBundleWithSymbolicName(string);
            if (abstractDeploymentPackage3 != null && !abstractDeploymentPackage3.equals(abstractDeploymentPackage2)) {
                throw new DeploymentException(460, "Bundle '" + string + "/" + version + " already present in other deployment packages!");
            }
            if (abstractDeploymentPackage3 == null) {
                int n2 = 0;
                while (n2 < bundleArray.length) {
                    if (string.equals(bundleArray[n2].getSymbolicName()) && version.equals(bundleArray[n2].getVersion())) {
                        throw new DeploymentException(460, "Bundle '" + string + "/" + version + " already present!");
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void verifySourcePackage(AbstractDeploymentPackage abstractDeploymentPackage) throws DeploymentException {
    }
}

