/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import org.osgi.framework.BundleContext;

public class DeploymentAdminConfig {
    private static final String PREFIX = "org.apache.felix.deploymentadmin.";
    static final String KEY_STOP_UNAFFECTED_BUNDLE = "org.apache.felix.deploymentadmin.".concat("stopUnaffectedBundle");
    static final String KEY_STOP_UNAFFECTED_BUNDLES = "org.apache.felix.deploymentadmin.".concat("stopUnaffectedBundles");
    static final String KEY_ALLOW_FOREIGN_CUSTOMIZERS = "org.apache.felix.deploymentadmin.".concat("allowForeignCustomizers");
    static final boolean DEFAULT_STOP_UNAFFECTED_BUNDLES = true;
    static final boolean DEFAULT_ALLOW_FOREIGN_CUSTOMIZERS = false;
    private final boolean m_stopUnaffectedBundles;
    private final boolean m_allowForeignCustomizers;

    public DeploymentAdminConfig(BundleContext bundleContext) {
        String string = DeploymentAdminConfig.getFrameworkProperty(bundleContext, KEY_STOP_UNAFFECTED_BUNDLE);
        if (string == null) {
            string = DeploymentAdminConfig.getFrameworkProperty(bundleContext, KEY_STOP_UNAFFECTED_BUNDLES);
        }
        this.m_stopUnaffectedBundles = DeploymentAdminConfig.parseBoolean(string, true);
        string = DeploymentAdminConfig.getFrameworkProperty(bundleContext, KEY_ALLOW_FOREIGN_CUSTOMIZERS);
        this.m_allowForeignCustomizers = DeploymentAdminConfig.parseBoolean(string, false);
    }

    public boolean isAllowForeignCustomizers() {
        return this.m_allowForeignCustomizers;
    }

    public boolean isStopUnaffectedBundles() {
        return this.m_stopUnaffectedBundles;
    }

    private static boolean parseBoolean(String string, boolean bl) {
        if (string == null || "".equals(string.trim())) {
            return bl;
        }
        return Boolean.parseBoolean(string);
    }

    private static String getFrameworkProperty(BundleContext bundleContext, String string) {
        String string2 = bundleContext.getProperty(string);
        if (string2 == null) {
            string2 = bundleContext.getProperty(string.toLowerCase());
        }
        return string2;
    }
}

