/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import org.apache.felix.deploymentadmin.Utils;

class ContentCopyingJarInputStream
extends JarInputStream {
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private final File m_contentDir;
    private PrintWriter m_indexFileWriter;
    private OutputStream m_entryOS;

    public ContentCopyingJarInputStream(InputStream inputStream, File file, File file2) throws IOException {
        super(inputStream, true);
        this.m_contentDir = file2;
        this.m_indexFileWriter = new PrintWriter(new FileWriter(file));
        this.m_entryOS = null;
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            this.copyManifest(manifest);
        }
    }

    @Override
    public void close() throws IOException {
        this.closeCopy();
        this.closeIndex();
    }

    @Override
    public void closeEntry() throws IOException {
        this.closeCopy();
        super.closeEntry();
    }

    @Override
    public ZipEntry getNextEntry() throws IOException {
        this.closeCopy();
        ZipEntry zipEntry = super.getNextEntry();
        if (zipEntry != null) {
            File file = new File(this.m_contentDir, zipEntry.getName());
            if (!zipEntry.isDirectory()) {
                this.addToIndex(zipEntry.getName());
                this.m_entryOS = this.createOutputStream(file);
            }
        }
        return zipEntry;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (this.m_entryOS != null) {
            if (n3 > 0) {
                this.m_entryOS.write(byArray, n, n3);
            } else {
                this.closeCopy();
            }
        }
        return n3;
    }

    private void addToIndex(String string) throws IOException {
        this.m_indexFileWriter.println(string);
        this.m_indexFileWriter.flush();
    }

    private void closeCopy() {
        Utils.closeSilently(this.m_entryOS);
        this.m_entryOS = null;
    }

    private void closeIndex() {
        Utils.closeSilently(this.m_indexFileWriter);
        this.m_indexFileWriter = null;
    }

    private void copyManifest(Manifest manifest) throws IOException {
        this.addToIndex(MANIFEST_FILE);
        OutputStream outputStream = this.createOutputStream(new File(this.m_contentDir, MANIFEST_FILE));
        try {
            manifest.write(outputStream);
        }
        finally {
            Utils.closeSilently(outputStream);
        }
    }

    private OutputStream createOutputStream(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        if (!file.createNewFile()) {
            throw new IOException("Attempt to overwrite file: " + file);
        }
        return new GZIPOutputStream(new FileOutputStream(file));
    }
}

