/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;

public class BundleInfoImpl
extends AbstractInfo
implements BundleInfo {
    private final Version m_version;
    private final String m_symbolicName;
    private final boolean m_customizer;

    public BundleInfoImpl(String string, Attributes attributes) throws DeploymentException {
        super(string, attributes);
        String string2 = attributes.getValue("Bundle-SymbolicName");
        if (string2 == null) {
            throw new DeploymentException(451, "Missing 'Bundle-SymbolicName' header for manifest entry '" + this.getPath() + "'");
        }
        if (string2.trim().equals("")) {
            throw new DeploymentException(452, "Invalid 'Bundle-SymbolicName' header for manifest entry '" + this.getPath() + "'");
        }
        this.m_symbolicName = this.parseSymbolicName(string2);
        String string3 = attributes.getValue("Bundle-Version");
        if (string3 == null || string3 == "") {
            throw new DeploymentException(452, "Invalid 'Bundle-Version' header for manifest entry '" + this.getPath() + "'");
        }
        try {
            this.m_version = Version.parseVersion(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DeploymentException(452, "Invalid 'Bundle-Version' header for manifest entry '" + this.getPath() + "'");
        }
        this.m_customizer = this.parseBooleanHeader(attributes, "DeploymentPackage-Customizer");
    }

    private String parseSymbolicName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        return stringTokenizer.nextToken();
    }

    @Override
    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.m_version;
    }

    public boolean isCustomizer() {
        return this.m_customizer;
    }

    public static boolean isBundleResource(Attributes attributes) {
        return attributes.getValue("Bundle-SymbolicName") != null;
    }
}

