/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.util.BitSet;
import java.util.jar.Attributes;
import org.apache.felix.deploymentadmin.Constants;
import org.osgi.service.deploymentadmin.DeploymentException;

public class AbstractInfo
implements Constants {
    private static final BitSet VALID_RESOURCE_PATH_CHARS = new BitSet();
    private final String m_path;
    private final Attributes m_attributes;
    private final boolean m_missing;

    static {
        int n = 97;
        while (n <= 122) {
            VALID_RESOURCE_PATH_CHARS.set(n);
            ++n;
        }
        n = 65;
        while (n <= 90) {
            VALID_RESOURCE_PATH_CHARS.set(n);
            ++n;
        }
        n = 48;
        while (n <= 57) {
            VALID_RESOURCE_PATH_CHARS.set(n);
            ++n;
        }
        VALID_RESOURCE_PATH_CHARS.set(46);
        VALID_RESOURCE_PATH_CHARS.set(45);
        VALID_RESOURCE_PATH_CHARS.set(95);
        VALID_RESOURCE_PATH_CHARS.set(47);
    }

    public AbstractInfo(String string, Attributes attributes) throws DeploymentException {
        this.verifyEntryName(string);
        this.m_path = string;
        this.m_attributes = attributes;
        this.m_missing = this.parseBooleanHeader(attributes, "DeploymentPackage-Missing");
    }

    public String getPath() {
        return this.m_path;
    }

    public String getHeader(String string) {
        return this.m_attributes.getValue(string);
    }

    private void verifyEntryName(String string) throws DeploymentException {
        byte[] byArray = string.getBytes();
        boolean bl = false;
        int n = 0;
        while (n < byArray.length) {
            if (!VALID_RESOURCE_PATH_CHARS.get(byArray[n])) {
                throw new DeploymentException(452, "Resource ID '" + string + "' contains invalid character(s)");
            }
            if (byArray[n] == 47) {
                if (bl) {
                    throw new DeploymentException(452, "Resource ID '" + string + "' contains multiple consequetive path seperators");
                }
                bl = true;
            } else {
                bl = false;
            }
            ++n;
        }
    }

    public boolean isMissing() {
        return this.m_missing;
    }

    protected boolean parseBooleanHeader(Attributes attributes, String string) throws DeploymentException {
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            if ("true".equals(string2)) {
                return true;
            }
            if ("false".equals(string2)) {
                return false;
            }
            throw new DeploymentException(452, "Invalid '" + string + "' header for manifest " + "entry '" + this.getPath() + "' header, should be either 'true' or 'false' or not present");
        }
        return false;
    }
}

