/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.Constants;
import org.apache.felix.deploymentadmin.DeploymentAdminImpl;
import org.apache.felix.deploymentadmin.DeploymentPackageManifest;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;

public abstract class AbstractDeploymentPackage
implements DeploymentPackage,
Constants {
    protected static final AbstractDeploymentPackage EMPTY_PACKAGE = new EmptyDeploymentPackage();
    private final BundleContext m_bundleContext;
    private final DeploymentAdminImpl m_deploymentAdmin;
    private final DeploymentPackageManifest m_manifest;
    private final Map m_nameToBundleInfo = new HashMap();
    private final Map m_pathToEntry = new HashMap();
    private final BundleInfoImpl[] m_bundleInfos;
    private final ResourceInfoImpl[] m_resourceInfos;
    private final String[] m_resourcePaths;
    private final boolean m_isFixPackage;
    private boolean m_isStale;

    public AbstractDeploymentPackage(Manifest manifest, BundleContext bundleContext, DeploymentAdminImpl deploymentAdminImpl) throws DeploymentException {
        String string;
        this.m_manifest = new DeploymentPackageManifest(manifest);
        this.m_isFixPackage = this.m_manifest.getFixPackage() != null;
        this.m_bundleContext = bundleContext;
        this.m_deploymentAdmin = deploymentAdminImpl;
        List list = this.m_manifest.getBundleInfos();
        this.m_bundleInfos = list.toArray(new BundleInfoImpl[list.size()]);
        int n = 0;
        while (n < this.m_bundleInfos.length) {
            String string2 = this.m_bundleInfos[n].getSymbolicName();
            if (this.m_nameToBundleInfo.put(string2, this.m_bundleInfos[n]) != null) {
                throw new DeploymentException(463, "Duplicate bundle present in deployment package: " + string2);
            }
            string = this.m_bundleInfos[n].getPath();
            if (this.m_pathToEntry.put(string, this.m_bundleInfos[n]) != null) {
                throw new DeploymentException(463, "Non-unique path present in deployment package: " + string);
            }
            ++n;
        }
        List list2 = this.m_manifest.getResourceInfos();
        this.m_resourceInfos = list2.toArray(new ResourceInfoImpl[list2.size()]);
        int n2 = 0;
        while (n2 < this.m_resourceInfos.length) {
            string = this.m_resourceInfos[n2].getPath();
            if (this.m_pathToEntry.put(string, this.m_resourceInfos[n2]) != null) {
                throw new DeploymentException(463, "Non-unique path present in deployment package: " + string);
            }
            ++n2;
        }
        this.m_resourcePaths = this.m_pathToEntry.keySet().toArray(new String[this.m_pathToEntry.size()]);
    }

    private AbstractDeploymentPackage() {
        this.m_bundleContext = null;
        this.m_manifest = null;
        this.m_bundleInfos = null;
        this.m_resourceInfos = null;
        this.m_resourcePaths = null;
        this.m_isFixPackage = false;
        this.m_deploymentAdmin = null;
    }

    @Override
    public Bundle getBundle(String string) {
        if (this.isStale()) {
            throw new IllegalStateException("Can not get bundle from stale deployment package.");
        }
        BundleInfo bundleInfo = (BundleInfo)this.m_nameToBundleInfo.get(string);
        if (bundleInfo != null) {
            Version version = bundleInfo.getVersion();
            Bundle[] bundleArray = this.m_bundleContext.getBundles();
            int n = 0;
            while (n < bundleArray.length) {
                if (string.equals(bundleArray[n].getSymbolicName()) && version.equals(bundleArray[n].getVersion())) {
                    return bundleArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public BundleInfoImpl getBundleInfoByName(String string) {
        return (BundleInfoImpl)this.m_nameToBundleInfo.get(string);
    }

    public BundleInfoImpl getBundleInfoByPath(String string) {
        AbstractInfo abstractInfo = (AbstractInfo)this.m_pathToEntry.get(string);
        if (abstractInfo instanceof BundleInfoImpl) {
            return (BundleInfoImpl)abstractInfo;
        }
        return null;
    }

    public BundleInfoImpl[] getBundleInfoImpls() {
        return (BundleInfoImpl[])this.m_bundleInfos.clone();
    }

    @Override
    public BundleInfo[] getBundleInfos() {
        return (BundleInfo[])this.m_bundleInfos.clone();
    }

    public abstract InputStream getBundleStream(String var1) throws IOException;

    public abstract InputStream getCurrentEntryStream();

    @Override
    public String getDisplayName() {
        return this.getHeader("DeploymentPackage-Name");
    }

    @Override
    public String getHeader(String string) {
        return this.m_manifest.getHeader(string);
    }

    @Override
    public URL getIcon() {
        String string = this.getHeader("DeploymentPackage-Icon");
        if (string == null) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.m_manifest.getSymbolicName();
    }

    public abstract AbstractInfo getNextEntry() throws IOException;

    public abstract BundleInfoImpl[] getOrderedBundleInfos();

    public abstract ResourceInfoImpl[] getOrderedResourceInfos();

    @Override
    public String getResourceHeader(String string, String string2) {
        AbstractInfo abstractInfo = (AbstractInfo)this.m_pathToEntry.get(string);
        if (abstractInfo != null) {
            return abstractInfo.getHeader(string2);
        }
        return null;
    }

    public ResourceInfoImpl getResourceInfoByPath(String string) {
        AbstractInfo abstractInfo = (AbstractInfo)this.m_pathToEntry.get(string);
        if (abstractInfo instanceof ResourceInfoImpl) {
            return (ResourceInfoImpl)abstractInfo;
        }
        return null;
    }

    public ResourceInfoImpl[] getResourceInfos() {
        return (ResourceInfoImpl[])this.m_resourceInfos.clone();
    }

    @Override
    public ServiceReference getResourceProcessor(String string) {
        String string2;
        if (this.isStale()) {
            throw new IllegalStateException("Can not get bundle from stale deployment package.");
        }
        AbstractInfo abstractInfo = (AbstractInfo)this.m_pathToEntry.get(string);
        if (abstractInfo instanceof ResourceInfoImpl && (string2 = ((ResourceInfoImpl)abstractInfo).getResourceProcessor()) != null) {
            try {
                ServiceReference<?>[] serviceReferenceArray = this.m_bundleContext.getServiceReferences(ResourceProcessor.class.getName(), "(service.pid=" + string2 + ")");
                if (serviceReferenceArray != null && serviceReferenceArray.length > 0) {
                    return serviceReferenceArray[0];
                }
                return null;
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                this.m_deploymentAdmin.getLog().log(2, "Invalid resource processor name: " + string2, invalidSyntaxException);
                return null;
            }
        }
        return null;
    }

    @Override
    public String[] getResources() {
        return (String[])this.m_resourcePaths.clone();
    }

    @Override
    public Version getVersion() {
        return this.m_manifest.getVersion();
    }

    public VersionRange getVersionRange() {
        return this.m_manifest.getFixPackage();
    }

    public boolean isFixPackage() {
        return this.m_isFixPackage;
    }

    public boolean isNew() {
        return this == EMPTY_PACKAGE;
    }

    @Override
    public boolean isStale() {
        return this.m_isStale;
    }

    public void setStale(boolean bl) {
        this.m_isStale = bl;
    }

    @Override
    public void uninstall() throws DeploymentException {
        if (this.isStale()) {
            throw new IllegalStateException("Deployment package is stale, cannot uninstall!");
        }
        this.m_deploymentAdmin.uninstallDeploymentPackage(this, false);
        this.setStale(true);
    }

    @Override
    public boolean uninstallForced() throws DeploymentException {
        if (this.isStale()) {
            throw new IllegalStateException("Deployment package is stale, cannot force uninstallation!");
        }
        try {
            this.m_deploymentAdmin.uninstallDeploymentPackage(this, true);
        }
        finally {
            this.setStale(true);
        }
        return true;
    }

    protected AbstractInfo getAbstractInfoByPath(String string) {
        return (AbstractInfo)this.m_pathToEntry.get(string);
    }

    protected boolean isMetaInfFile(String string) {
        return (string = string.toUpperCase(Locale.US)).startsWith("META-INF/") && (string.endsWith("/INDEX.LIST") || string.endsWith(".SF") || string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".EC"));
    }

    /* synthetic */ AbstractDeploymentPackage(AbstractDeploymentPackage abstractDeploymentPackage) {
        this();
    }

    private static final class EmptyDeploymentPackage
    extends AbstractDeploymentPackage {
        private static final String[] STRINGS = new String[0];
        private static final ResourceInfoImpl[] RESOURCE_INFO_IMPLS = new ResourceInfoImpl[0];
        private static final BundleInfoImpl[] BUNDLE_INFO_IMPLS = new BundleInfoImpl[0];

        private EmptyDeploymentPackage() {
            super(null);
        }

        @Override
        public Bundle getBundle(String string) {
            return null;
        }

        @Override
        public BundleInfoImpl[] getBundleInfoImpls() {
            return BUNDLE_INFO_IMPLS;
        }

        @Override
        public BundleInfo[] getBundleInfos() {
            return BUNDLE_INFO_IMPLS;
        }

        @Override
        public InputStream getBundleStream(String string) throws IOException {
            return null;
        }

        @Override
        public InputStream getCurrentEntryStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDisplayName() {
            return "";
        }

        @Override
        public String getHeader(String string) {
            if ("DeploymentPackage-SymbolicName".equals(string)) {
                return "";
            }
            if ("DeploymentPackage-Version".equals(string)) {
                return Version.emptyVersion.toString();
            }
            return null;
        }

        @Override
        public URL getIcon() {
            return null;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public AbstractInfo getNextEntry() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BundleInfoImpl[] getOrderedBundleInfos() {
            return BUNDLE_INFO_IMPLS;
        }

        @Override
        public ResourceInfoImpl[] getOrderedResourceInfos() {
            return RESOURCE_INFO_IMPLS;
        }

        @Override
        public String getResourceHeader(String string, String string2) {
            return null;
        }

        @Override
        public ResourceInfoImpl[] getResourceInfos() {
            return RESOURCE_INFO_IMPLS;
        }

        @Override
        public ServiceReference getResourceProcessor(String string) {
            return null;
        }

        @Override
        public String[] getResources() {
            return STRINGS;
        }

        @Override
        public Version getVersion() {
            return Version.emptyVersion;
        }

        @Override
        public boolean isStale() {
            return true;
        }

        @Override
        public void uninstall() throws DeploymentException {
            throw new IllegalStateException("Can not uninstall stale DeploymentPackage");
        }

        @Override
        public boolean uninstallForced() throws DeploymentException {
            throw new IllegalStateException("Can not uninstall stale DeploymentPackage");
        }
    }
}

