/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.xml;

import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XIO {
    public static void write(XElement xElement, Appendable appendable) throws IOException {
        appendable.append("<?xml version='1.0'?>\n");
        XIO.write(xElement, 0, appendable);
    }

    public static void writeUTF(XElement xElement, OutputStream outputStream) throws IOException {
        XIO.write(xElement, outputStream, "UTF-8");
    }

    public static void write(XElement xElement, OutputStream outputStream, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string){

            @Override
            public void close() throws IOException {
            }
        };
        XIO.write(xElement, outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static XElement readUTF(InputStream inputStream) throws IOException {
        return XIO.read(inputStream, "UTF-8");
    }

    public static XElement read(InputStream inputStream, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string){

            @Override
            public void close() throws IOException {
            }
        };
        return XIO.read(new InputSource(inputStreamReader));
    }

    private static void write(XElement xElement, int n, Appendable appendable) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            appendable.append("  ");
            ++n2;
        }
        appendable.append("<");
        appendable.append(xElement.getName());
        XAttribute[] xAttributeArray = xElement.attributes();
        int n3 = xAttributeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            XAttribute xAttribute = xAttributeArray[n4];
            appendable.append(" ");
            appendable.append(xAttribute.getName());
            appendable.append("=\"");
            XIO.encode(xAttribute.getString(), appendable);
            appendable.append("\"");
            ++n4;
        }
        String string = xElement.getValue();
        XElement[] xElementArray = xElement.children();
        if (string.length() == 0 && xElementArray.length == 0) {
            appendable.append("/>");
        } else {
            appendable.append(">");
            if (string.length() > 0) {
                if (xElementArray.length > 0) {
                    appendable.append("\n  ");
                    n3 = 0;
                    while (n3 < n) {
                        appendable.append("  ");
                        ++n3;
                    }
                }
                XIO.encode(string, appendable);
            }
            if (xElementArray.length > 0) {
                appendable.append("\n");
                XElement[] xElementArray2 = xElementArray;
                int n5 = xElementArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    XElement xElement2 = xElementArray2[n6];
                    XIO.write(xElement2, n + 1, appendable);
                    appendable.append("\n");
                    ++n6;
                }
                int n7 = 0;
                while (n7 < n) {
                    appendable.append("  ");
                    ++n7;
                }
            }
            appendable.append("</");
            appendable.append(xElement.getName());
            appendable.append(">");
        }
    }

    private static void encode(String string, Appendable appendable) throws IOException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    appendable.append("&lt;");
                    break;
                }
                case '>': {
                    appendable.append("&gt;");
                    break;
                }
                case '\'': {
                    appendable.append("&apos;");
                    break;
                }
                case '\"': {
                    appendable.append("&quot;");
                    break;
                }
                case '&': {
                    appendable.append("&amp;");
                    break;
                }
                default: {
                    appendable.append(c);
                }
            }
            ++n;
        }
    }

    public static XElement read(CharSequence charSequence) throws IOException {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(charSequence.toString()));
        return XIO.read(inputSource);
    }

    public static XElement read(InputSource inputSource) throws IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            Handler handler = new Handler();
            sAXParser.parse(inputSource, (DefaultHandler)handler);
            return handler.getElement();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
    }

    public static XElement read(Reader reader) throws IOException {
        return XIO.read(new InputSource(reader));
    }

    private static class Handler
    extends DefaultHandler {
        private XElement element;
        private LinkedList<XElement> stack = new LinkedList();

        private Handler() {
        }

        public XElement getElement() {
            return this.element;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            XElement xElement = new XElement(string3);
            if (this.element == null) {
                this.element = xElement;
            } else {
                this.stack.getFirst().addElement(xElement);
            }
            this.stack.addFirst(xElement);
            int n = 0;
            int n2 = attributes.getLength();
            while (n < n2) {
                XAttribute xAttribute = new XAttribute(attributes.getQName(n));
                xAttribute.setString(attributes.getValue(n));
                xElement.addAttribute(xAttribute);
                ++n;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (n2 > 0) {
                String string = new String(cArray, n, n2);
                String string2 = this.stack.getFirst().getValue();
                if (string2 != null && string2.length() > 0) {
                    string = String.valueOf(string2) + string;
                }
                this.stack.getFirst().setValue(string);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            XElement xElement = this.stack.removeFirst();
            xElement.setValue(xElement.getString().trim());
        }
    }
}

