/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.xml;

import bibliothek.util.xml.XException;

public class XContainer {
    private String value = "";

    public XContainer copy() {
        XContainer xContainer = new XContainer();
        xContainer.copy(this);
        return xContainer;
    }

    protected void copy(XContainer xContainer) {
        this.value = xContainer.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setByte(byte by) {
        this.value = String.valueOf(by);
    }

    public void setShort(short s) {
        this.value = String.valueOf(s);
    }

    public void setInt(int n) {
        this.value = String.valueOf(n);
    }

    public void setLong(long l) {
        this.value = String.valueOf(l);
    }

    public void setBoolean(boolean bl) {
        this.value = String.valueOf(bl);
    }

    public void setChar(char c) {
        this.value = String.valueOf(c);
    }

    public void setString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.value = string;
    }

    public void setFloat(float f) {
        this.value = String.valueOf(f);
    }

    public void setDouble(double d) {
        this.value = String.valueOf(d);
    }

    public void setByteArray(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            stringBuilder.append(Integer.toHexString(by >> 4 & 0xF));
            stringBuilder.append(Integer.toHexString(by & 0xF));
            ++n2;
        }
        this.value = stringBuilder.toString();
    }

    public byte getByte() {
        try {
            return Byte.parseByte(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public short getShort() {
        try {
            return Short.parseShort(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public long getLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public float getFloat() {
        try {
            return Float.parseFloat(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public char getChar() {
        if (this.value.length() != 1) {
            throw new XException("not a character: " + this.value);
        }
        return this.value.charAt(0);
    }

    public String getString() {
        return this.value;
    }

    public boolean getBoolean() {
        String string = this.value.trim().toLowerCase();
        if ("true".equals(string)) {
            return true;
        }
        if ("on".equals(string)) {
            return true;
        }
        if ("1".equals(string)) {
            return true;
        }
        if ("yes".equals(string)) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        if ("off".equals(string)) {
            return false;
        }
        if ("0".equals(string)) {
            return false;
        }
        if ("no".equals(string)) {
            return false;
        }
        throw new XException("not a boolean: " + string);
    }

    public byte[] getByteArray() {
        if (this.value.length() % 2 != 0) {
            throw new XException("value is not a byte-array: " + this.value);
        }
        byte[] byArray = new byte[this.value.length() / 2];
        int n = 0;
        int n2 = this.value.length();
        while (n < n2) {
            char c = this.value.charAt(n);
            int n3 = 0;
            switch (c) {
                case '0': {
                    n3 = 0;
                    break;
                }
                case '1': {
                    n3 = 1;
                    break;
                }
                case '2': {
                    n3 = 2;
                    break;
                }
                case '3': {
                    n3 = 3;
                    break;
                }
                case '4': {
                    n3 = 4;
                    break;
                }
                case '5': {
                    n3 = 5;
                    break;
                }
                case '6': {
                    n3 = 6;
                    break;
                }
                case '7': {
                    n3 = 7;
                    break;
                }
                case '8': {
                    n3 = 8;
                    break;
                }
                case '9': {
                    n3 = 9;
                    break;
                }
                case 'a': {
                    n3 = 10;
                    break;
                }
                case 'b': {
                    n3 = 11;
                    break;
                }
                case 'c': {
                    n3 = 12;
                    break;
                }
                case 'd': {
                    n3 = 13;
                    break;
                }
                case 'e': {
                    n3 = 14;
                    break;
                }
                case 'f': {
                    n3 = 15;
                    break;
                }
                default: {
                    throw new XException("value is not a byte-array: " + n3);
                }
            }
            if (n % 2 == 0) {
                byArray[n / 2] = (byte)(n3 << 4);
            } else {
                int n4 = n / 2;
                byArray[n4] = (byte)(byArray[n4] | n3);
            }
            ++n;
        }
        return byArray;
    }
}

