/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util;

import bibliothek.gui.DockController;
import bibliothek.util.workarounds.Workaround;
import java.awt.Component;
import java.awt.Shape;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class Workarounds {
    private static Workarounds workarounds = new Workarounds();
    private List<Workaround> code = new ArrayList<Workaround>();

    static {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.6")) {
            Workarounds.tryAddWorkaround("bibliothek.util.workarounds.Java6Workaround");
        } else if (!string.startsWith("1.5")) {
            Workarounds.tryAddWorkaround("bibliothek.util.workarounds.Java7Workaround");
        }
    }

    public static Workarounds getDefault() {
        return workarounds;
    }

    public static boolean tryAddWorkaround(String string) {
        try {
            Class<?> clazz = Class.forName(string, true, Workarounds.class.getClassLoader());
            Object obj = clazz.newInstance();
            Workarounds.getDefault().addWorkaround((Workaround)obj);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static void setDefault(Workarounds workarounds) {
        if (workarounds == null) {
            throw new IllegalArgumentException("workarounds must not be null");
        }
        Workarounds.workarounds = workarounds;
    }

    public void addWorkaround(Workaround workaround) {
        this.code.add(workaround);
    }

    public void removeWorkaround(Workaround workaround) {
        this.code.remove(workaround);
    }

    public Workaround[] getWorkarounds() {
        return this.code.toArray(new Workaround[this.code.size()]);
    }

    public void markAsGlassPane(Component component) {
        Workaround[] workaroundArray = this.code.toArray(new Workaround[this.code.size()]);
        int n = workaroundArray.length;
        int n2 = 0;
        while (n2 < n) {
            Workaround workaround = workaroundArray[n2];
            workaround.markAsGlassPane(component);
            ++n2;
        }
    }

    public boolean supportsTransparency(Window window) {
        Workaround[] workaroundArray = this.code.toArray(new Workaround[this.code.size()]);
        int n = workaroundArray.length;
        int n2 = 0;
        while (n2 < n) {
            Workaround workaround = workaroundArray[n2];
            if (workaround.supportsPerpixelTransparency(window)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean setTransparent(Window window, Shape shape) {
        boolean bl = false;
        Workaround[] workaroundArray = this.code.toArray(new Workaround[this.code.size()]);
        int n = workaroundArray.length;
        int n2 = 0;
        while (n2 < n) {
            Workaround workaround = workaroundArray[n2];
            bl = workaround.setTransparent(window, shape) || bl;
            ++n2;
        }
        return bl;
    }

    public boolean supportsTranslucency(Window window) {
        Workaround[] workaroundArray = this.code.toArray(new Workaround[this.code.size()]);
        int n = workaroundArray.length;
        int n2 = 0;
        while (n2 < n) {
            Workaround workaround = workaroundArray[n2];
            if (workaround.supportsPerpixelTranslucency(window)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean setTranslucent(Window window) {
        boolean bl = false;
        Workaround[] workaroundArray = this.code.toArray(new Workaround[this.code.size()]);
        int n = workaroundArray.length;
        int n2 = 0;
        while (n2 < n) {
            Workaround workaround = workaroundArray[n2];
            bl = workaround.setTranslucent(window) || bl;
            ++n2;
        }
        return bl;
    }

    public void setup(DockController dockController) {
        Workaround[] workaroundArray = this.code.toArray(new Workaround[this.code.size()]);
        int n = workaroundArray.length;
        int n2 = 0;
        while (n2 < n) {
            Workaround workaround = workaroundArray[n2];
            workaround.setup(dockController);
            ++n2;
        }
    }
}

