/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util;

import java.awt.Color;

public final class Colors {
    private Colors() {
    }

    public static Color darker(Color color, double d) {
        if (color == null) {
            return null;
        }
        if (d < 0.0) {
            return Colors.brighter(color, -d);
        }
        if (d > 1.0) {
            d = 1.0;
        }
        d = 1.0 - d;
        return new Color((int)((double)color.getRed() * d), (int)((double)color.getGreen() * d), (int)((double)color.getBlue() * d));
    }

    public static Color brighter(Color color, double d) {
        if (color == null) {
            return null;
        }
        if (d < 0.0) {
            return Colors.darker(color, -d);
        }
        if (d > 1.0) {
            d = 1.0;
        }
        int n = 255 - color.getRed();
        int n2 = 255 - color.getGreen();
        int n3 = 255 - color.getBlue();
        Color color2 = new Color(color.getRed() + (int)((double)n * d), color.getGreen() + (int)((double)n2 * d), color.getBlue() + (int)((double)n3 * d));
        return color2;
    }

    public static Color deltaBrightness(Color color, double d) {
        if (color == null) {
            return null;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getBlue(), color.getGreen(), null);
        fArray[2] = (float)((double)fArray[2] + d);
        fArray[2] = Math.max(0.0f, Math.min(1.0f, fArray[2]));
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    public static Color between(Color color, Color color2, double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        int n = (int)((double)color.getRed() + d * (double)(color2.getRed() - color.getRed()));
        int n2 = (int)((double)color.getGreen() + d * (double)(color2.getGreen() - color.getGreen()));
        int n3 = (int)((double)color.getBlue() + d * (double)(color2.getBlue() - color.getBlue()));
        return new Color(n, n2, n3);
    }

    public static Color between(Color color, double d, Color color2, double d2, Color color3, double d3) {
        double d4 = d + d2 + d3;
        double d5 = (double)color.getRed() * (d /= d4) + (double)color2.getRed() * (d2 /= d4) + (double)color3.getRed() * (d3 /= d4);
        double d6 = (double)color.getGreen() * d + (double)color2.getGreen() * d2 + (double)color3.getGreen() * d3;
        double d7 = (double)color.getBlue() * d + (double)color2.getBlue() * d2 + (double)color3.getBlue() * d3;
        return new Color(Math.max(0, Math.min((int)d5, 255)), Math.max(0, Math.min((int)d6, 255)), Math.max(0, Math.min((int)d7, 255)));
    }

    public static Color middle(Color color, Color color2) {
        return Colors.between(color, color2, 0.5);
    }

    public static Color fuller(Color color, double d) {
        int n;
        int n2;
        int n3;
        if (color == null) {
            return null;
        }
        int n4 = color.getRed();
        n4 = n4 < (n3 = Math.max(n4, Math.max(n2 = color.getGreen(), n = color.getBlue()))) ? (int)((double)n4 * (1.0 - d)) : (int)((double)n4 + (double)n4 * d);
        n2 = n2 < n3 ? (int)((double)n2 * (1.0 - d)) : (int)((double)n2 + (double)n2 * d);
        n = n < n3 ? (int)((double)n * (1.0 - d)) : (int)((double)n + (double)n * d);
        return new Color(Math.max(0, Math.min(255, n4)), Math.max(0, Math.min(255, n2)), Math.max(0, Math.min(255, n)));
    }

    public static Color undiffMirror(Color color, double d) {
        if (color == null) {
            return null;
        }
        int n = color.getRed() + color.getGreen() + color.getBlue();
        if ((double)n > 382.5) {
            return Colors.brighter(color, d);
        }
        return Colors.darker(color, d);
    }

    public static Color diffMirror(Color color, double d) {
        if (color == null) {
            return null;
        }
        int n = color.getRed() + color.getGreen() + color.getBlue();
        if ((double)n < 382.5) {
            return Colors.brighter(color, d);
        }
        return Colors.darker(color, d);
    }

    public static Color darker(Color color) {
        if (color == null) {
            return null;
        }
        return color.darker();
    }

    public static Color brighter(Color color) {
        if (color == null) {
            return null;
        }
        return color.brighter();
    }
}

