/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.swing;

import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.swing.Rotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class OrientedLabel
extends ConfiguredBackgroundPanel {
    private JLabel label = new JLabel();
    private Font originalFont;
    private Icon icon;
    private Icon disabledIcon;
    private int iconOffset = 2;
    private int iconTextDistance = 2;
    private boolean originalFontSet = false;
    private String text;
    private Rotation rotation = Rotation.DEGREE_0;
    private boolean hideIcon = false;

    public OrientedLabel() {
        super(Transparency.DEFAULT);
        this.label.setOpaque(false);
        this.label.setAlignmentX(0.0f);
        this.label.setBorder(new EmptyBorder(0, 5, 0, 0));
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.disabledIcon = null;
        this.revalidate();
        this.repaint();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIconOffset(int n) {
        this.iconOffset = n;
        this.revalidate();
        this.repaint();
    }

    public int getIconOffset() {
        return this.iconOffset;
    }

    public void setIconTextDistance(int n) {
        this.iconTextDistance = n;
        this.revalidate();
        this.repaint();
    }

    public int getIconTextDistance() {
        return this.iconTextDistance;
    }

    public void setRotation(Rotation rotation) {
        if (rotation == null) {
            throw new IllegalArgumentException("rotation must not be null");
        }
        this.rotation = rotation;
        this.revalidate();
    }

    public void setHorizontal(boolean bl) {
        if (bl) {
            this.setRotation(Rotation.DEGREE_0);
        } else {
            this.setRotation(Rotation.DEGREE_90);
        }
    }

    public boolean isHorizontal() {
        return this.rotation == Rotation.DEGREE_0 || this.rotation == Rotation.DEGREE_180;
    }

    public boolean isVertical() {
        return !this.isHorizontal();
    }

    public void setText(String string) {
        this.text = string;
        this.label.setText(string == null || string.length() == 0 ? null : string);
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.label != null) {
            this.label.setEnabled(bl);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    @Override
    public Color getForeground() {
        if (this.label == null) {
            return null;
        }
        return this.label.getForeground();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.label != null) {
            this.label.setBackground(color);
        }
    }

    @Override
    public Color getBackground() {
        if (this.label == null) {
            return null;
        }
        return this.label.getBackground();
    }

    public boolean isIconHidden() {
        return this.hideIcon;
    }

    public void setIconHidden(boolean bl) {
        if (this.hideIcon != bl) {
            this.hideIcon = bl;
            this.repaint();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.label != null) {
            this.originalFontSet = false;
            this.originalFont = null;
            this.label.setFont(null);
            this.label.updateUI();
            this.updateFonts();
        }
    }

    protected void updateFonts() {
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            if (!this.originalFontSet) {
                this.originalFontSet = true;
                this.originalFont = this.label.getFont();
            }
            if (font != null) {
                this.label.setFont(font);
            } else {
                this.label.setFont(this.originalFont);
                this.originalFont = null;
                this.originalFontSet = false;
            }
            this.revalidate();
            this.repaint();
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.label.getPreferredSize();
        String string = this.getText();
        if ((string == null || string.length() == 0) && this.icon != null) {
            return new Dimension(this.icon.getIconWidth() + 2 * this.iconOffset, this.icon.getIconHeight() + 2 * this.iconOffset);
        }
        if (this.isHorizontal()) {
            if (this.icon == null) {
                return new Dimension(dimension.width + 5, dimension.height);
            }
            return new Dimension(dimension.width + 5 + this.iconOffset + this.iconTextDistance + this.icon.getIconWidth(), Math.max(dimension.height, this.icon.getIconHeight() + 2 * this.iconOffset));
        }
        if (this.icon == null) {
            return new Dimension(dimension.height, dimension.width + 5);
        }
        return new Dimension(Math.max(dimension.height, this.icon.getIconWidth() + 2 * this.iconOffset), dimension.width + 5 + this.iconOffset + this.iconTextDistance + this.icon.getIconHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintComponent(graphics);
    }

    @Override
    public void paintForeground(Graphics graphics) {
        if (this.rotation == Rotation.DEGREE_0) {
            if (this.icon == null || this.isIconHidden()) {
                this.label.paint(graphics);
            } else {
                Icon icon = this.icon;
                if (!this.isEnabled()) {
                    if (this.disabledIcon == null) {
                        this.disabledIcon = DockUtilities.disabledIcon(this, icon);
                    }
                    icon = this.disabledIcon;
                }
                int n = this.getWidth();
                int n2 = this.getHeight();
                int n3 = icon.getIconWidth();
                int n4 = icon.getIconHeight();
                icon.paintIcon(this, graphics, this.iconOffset, (n2 - n4) / 2);
                int n5 = n3 + this.iconOffset + this.iconTextDistance;
                if (n5 < n) {
                    graphics = graphics.create(n5, 0, n - n5, n2);
                    this.label.paint(graphics);
                    graphics.dispose();
                }
            }
        } else if (this.rotation == Rotation.DEGREE_90) {
            double d = 1.5707963267948966;
            if (this.icon == null || this.isIconHidden()) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.rotate(d, 0.0, 0.0);
                graphics2D.translate(0, -this.getWidth());
                this.label.paint(graphics2D);
                graphics2D.dispose();
            } else {
                int n = this.getWidth();
                int n6 = this.getHeight();
                int n7 = this.icon.getIconWidth();
                int n8 = this.icon.getIconHeight();
                this.icon.paintIcon(this, graphics, (n - n7) / 2, this.iconOffset);
                int n9 = n8 + this.iconOffset + this.iconTextDistance;
                if (n9 < n6) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create(0, n9, n, n6 - n9);
                    graphics2D.rotate(d, 0.0, 0.0);
                    graphics2D.translate(0, -this.getWidth());
                    this.label.paint(graphics2D);
                    graphics2D.dispose();
                }
            }
        } else if (this.rotation == Rotation.DEGREE_180) {
            double d = Math.PI;
            if (this.icon == null || this.isIconHidden()) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.rotate(d, 0.0, 0.0);
                graphics2D.translate(-this.getWidth(), -this.getHeight());
                this.label.paint(graphics2D);
                graphics2D.dispose();
            } else {
                int n = this.getWidth();
                int n10 = this.getHeight();
                int n11 = this.icon.getIconWidth();
                int n12 = this.icon.getIconHeight();
                this.icon.paintIcon(this, graphics, this.iconOffset, (n10 - n12) / 2);
                int n13 = n11 + this.iconOffset + this.iconTextDistance;
                if (n13 < n) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create(n13, 0, n - n13, n10);
                    graphics2D.rotate(d, 0.0, 0.0);
                    graphics2D.translate(-n + n13, n10);
                    this.label.paint(graphics2D);
                    graphics2D.dispose();
                }
            }
        } else {
            double d = 4.71238898038469;
            if (this.icon == null || this.isIconHidden()) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.rotate(d, 0.0, 0.0);
                graphics2D.translate(-this.getHeight(), 0);
                this.label.paint(graphics2D);
                graphics2D.dispose();
            } else {
                int n = this.getWidth();
                int n14 = this.getHeight();
                int n15 = this.icon.getIconWidth();
                int n16 = this.icon.getIconHeight();
                this.icon.paintIcon(this, graphics, (n - n15) / 2, this.iconOffset);
                int n17 = n16 + this.iconOffset + this.iconTextDistance;
                if (n17 < n14) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create(0, n17, n, n14 - n17);
                    graphics2D.rotate(d, 0.0, 0.0);
                    graphics2D.translate(-n14, 0);
                    this.label.paint(graphics2D);
                    graphics2D.dispose();
                }
            }
        }
    }

    @Override
    public void update(Graphics graphics) {
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.isHorizontal()) {
            this.label.setBounds(0, 0, n3 + 30, n4);
        } else {
            this.label.setBounds(0, 0, n4 + 30, n3);
        }
    }
}

