/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.icon;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.stack.tab.TabMenuDockIcon;
import bibliothek.gui.dock.themes.icon.TabMenuOverflowIconBridge;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.icon.AbstractIconScheme;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.icon.DockIconBridge;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class DefaultIconScheme
extends AbstractIconScheme {
    private Map<String, Icon> icons = new HashMap<String, Icon>();
    private Map<Path, DockIconBridge> bridges = new HashMap<Path, DockIconBridge>();

    public DefaultIconScheme(String string, DockController dockController) {
        this(string, DefaultIconScheme.class.getClassLoader(), dockController);
    }

    public DefaultIconScheme(String string, ClassLoader classLoader, DockController dockController) {
        this(dockController, new IconResource(string, null, classLoader));
    }

    public DefaultIconScheme(DockController dockController, IconResource ... iconResourceArray) {
        super(dockController);
        this.initHardcoded();
        int n = iconResourceArray.length - 1;
        while (n >= 0) {
            this.icons.putAll(DockUtilities.loadIcons(iconResourceArray[n].getFileName(), iconResourceArray[n].getPath(), this.icons.keySet(), iconResourceArray[n].getLoader()));
            --n;
        }
    }

    protected void initHardcoded() {
        this.setBridge(TabMenuDockIcon.KIND_TAB_MENU, new TabMenuOverflowIconBridge());
        this.setIcon("overflow.menu", new Icon(){

            @Override
            public int getIconHeight() {
                return 7;
            }

            @Override
            public int getIconWidth() {
                return 9;
            }

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics = graphics.create();
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setColor(component.getForeground());
                graphics.fillPolygon(new int[]{n + 1, n + 8, n + 4}, new int[]{n2 + 1, n2 + 1, n2 + 6}, 3);
                graphics.dispose();
            }
        });
    }

    @Override
    public DockIconBridge getBridge(Path path, UIProperties<Icon, DockIcon, DockIconBridge> uIProperties) {
        return this.bridges.get(path);
    }

    @Override
    public Icon getResource(String string, UIProperties<Icon, DockIcon, DockIconBridge> uIProperties) {
        return this.icons.get(string);
    }

    public void setIcon(String string, Icon icon) {
        this.changed(string, icon);
    }

    public void setBridge(final Path path, DockIconBridge dockIconBridge) {
        if (dockIconBridge == null) {
            this.bridges.remove(path);
        } else {
            this.bridges.put(path, dockIconBridge);
        }
        this.fire(new UISchemeEvent<Icon, DockIcon, DockIconBridge>(){

            @Override
            public Collection<Path> changedBridges(Set<Path> set) {
                ArrayList<Path> arrayList = new ArrayList<Path>();
                if (set == null || set.contains(path)) {
                    arrayList.add(path);
                }
                return arrayList;
            }

            @Override
            public Collection<String> changedResources(Set<String> set) {
                return Collections.emptySet();
            }

            @Override
            public UIScheme<Icon, DockIcon, DockIconBridge> getScheme() {
                return DefaultIconScheme.this;
            }
        });
    }

    @Override
    protected void changed(final String string, Icon icon) {
        if (icon == null) {
            this.icons.remove(string);
        } else {
            this.icons.put(string, icon);
        }
        this.fire(new UISchemeEvent<Icon, DockIcon, DockIconBridge>(){

            @Override
            public UIScheme<Icon, DockIcon, DockIconBridge> getScheme() {
                return DefaultIconScheme.this;
            }

            @Override
            public Collection<String> changedResources(Set<String> set) {
                ArrayList<String> arrayList = new ArrayList<String>(1);
                if (set == null || set.contains(string)) {
                    arrayList.add(string);
                }
                return arrayList;
            }

            @Override
            public Collection<Path> changedBridges(Set<Path> set) {
                return Collections.emptySet();
            }
        });
    }

    public static class IconResource {
        private String fileName;
        private String path;
        private ClassLoader loader;

        public IconResource(String string, String string2, ClassLoader classLoader) {
            if (string == null) {
                throw new IllegalArgumentException("fileName must not be null");
            }
            this.fileName = string;
            this.path = string2;
            if (classLoader == null) {
                classLoader = DefaultIconScheme.class.getClassLoader();
            }
            this.loader = classLoader;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getPath() {
            return this.path;
        }

        public ClassLoader getLoader() {
            return this.loader;
        }
    }
}

