/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.icon;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.AbstractUIScheme;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.icon.DockIconBridge;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public abstract class AbstractIconScheme
extends AbstractUIScheme<Icon, DockIcon, DockIconBridge> {
    private DockController controller;
    private int bound = 0;
    private Map<String, Link> links;

    public AbstractIconScheme(DockController dockController) {
        this.controller = dockController;
    }

    public void link(PropertyKey<Icon> propertyKey, String string) {
        Link link;
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        if ((link = this.links.get(string)) != null) {
            link.setKey(propertyKey);
        } else {
            link = new Link(propertyKey, string);
            this.links.put(string, link);
            if (this.bound > 0) {
                link.setProperties(this.controller);
            }
        }
    }

    public void unlink(String string) {
        if (this.links != null) {
            Link link = this.links.remove(string);
            if (this.links.isEmpty()) {
                this.links = null;
            }
            if (link != null) {
                link.setProperties((DockProperties)null);
            }
        }
    }

    protected abstract void changed(String var1, Icon var2);

    @Override
    public void install(UIProperties<Icon, DockIcon, DockIconBridge> uIProperties) {
        if (this.bound == 0 && this.links != null) {
            for (Link link : this.links.values()) {
                link.setProperties(this.controller);
            }
        }
        ++this.bound;
    }

    @Override
    public void uninstall(UIProperties<Icon, DockIcon, DockIconBridge> uIProperties) {
        --this.bound;
        if (this.bound == 0 && this.links != null) {
            for (Link link : this.links.values()) {
                link.setProperties((DockProperties)null);
            }
        }
    }

    private class Link
    extends PropertyValue<Icon> {
        private String id;

        public Link(PropertyKey<Icon> propertyKey, String string) {
            super(propertyKey);
            this.id = string;
        }

        @Override
        protected void valueChanged(Icon icon, Icon icon2) {
            AbstractIconScheme.this.changed(this.id, icon2);
        }
    }
}

