/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class WindowProviderWrapper
implements WindowProvider {
    private WindowProvider delegate;
    private List<WindowProviderListener> listeners = new ArrayList<WindowProviderListener>();
    private boolean showing = false;
    private WindowProviderListener listener = new WindowProviderListener(){

        @Override
        public void windowChanged(WindowProvider windowProvider, Window window) {
            WindowProviderWrapper.this.fireWindowChanged(window);
        }

        @Override
        public void visibilityChanged(WindowProvider windowProvider, boolean bl) {
            WindowProviderWrapper.this.showing = bl;
            WindowProviderWrapper.this.fireVisibilityChanged(bl);
        }
    };

    @Override
    public void addWindowProviderListener(WindowProviderListener windowProviderListener) {
        int n = this.listeners.size();
        this.listeners.add(windowProviderListener);
        if (n == 0 && this.listeners.size() > 0 && this.delegate != null) {
            this.delegate.addWindowProviderListener(this.listener);
        }
    }

    @Override
    public void removeWindowProviderListener(WindowProviderListener windowProviderListener) {
        int n = this.listeners.size();
        this.listeners.remove(windowProviderListener);
        if (n > 0 && this.listeners.size() == 0 && this.delegate != null) {
            this.delegate.removeWindowProviderListener(this.listener);
        }
    }

    protected WindowProviderListener[] listeners() {
        return this.listeners.toArray(new WindowProviderListener[this.listeners.size()]);
    }

    protected void fireWindowChanged(Window window) {
        WindowProviderListener[] windowProviderListenerArray = this.listeners();
        int n = windowProviderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowProviderListener windowProviderListener = windowProviderListenerArray[n2];
            windowProviderListener.windowChanged(this, window);
            ++n2;
        }
    }

    protected void fireVisibilityChanged(boolean bl) {
        WindowProviderListener[] windowProviderListenerArray = this.listeners();
        int n = windowProviderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowProviderListener windowProviderListener = windowProviderListenerArray[n2];
            windowProviderListener.visibilityChanged(this, bl);
            ++n2;
        }
    }

    public void setDelegate(WindowProvider windowProvider) {
        if (this.listeners.size() == 0) {
            this.delegate = windowProvider;
        } else {
            Window window = this.searchWindow();
            boolean bl = this.isShowing();
            if (this.delegate != null) {
                this.delegate.removeWindowProviderListener(this.listener);
            }
            this.delegate = windowProvider;
            if (this.delegate != null) {
                this.delegate.addWindowProviderListener(this.listener);
            }
            Window window2 = this.searchWindow();
            boolean bl2 = this.isShowing();
            if (window != window2) {
                this.fireWindowChanged(window2);
            }
            if (bl != bl2 || this.showing != bl2) {
                this.fireVisibilityChanged(bl2);
                this.showing = bl2;
            }
        }
    }

    public WindowProvider getDelegate() {
        return this.delegate;
    }

    @Override
    public Window searchWindow() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.searchWindow();
    }

    @Override
    public boolean isShowing() {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.isShowing();
    }
}

