/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PriorityValue;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIPriorityValue;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.UISchemeListener;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class UIProperties<V, U extends UIValue<V>, B extends UIBridge<V, U>> {
    private Map<Path, UIPriorityValue<B>> bridges = new HashMap<Path, UIPriorityValue<B>>();
    private Map<Path, Integer> bridgesAccess = new HashMap<Path, Integer>();
    private Map<String, UIPriorityValue<V>> resources = new HashMap<String, UIPriorityValue<V>>();
    private Map<String, Integer> resourcesAccess = new HashMap<String, Integer>();
    private PriorityValue<UIScheme<V, U, B>> schemes = new PriorityValue();
    private PriorityValue<UISchemeListener<V, U, B>> schemeListeners = new PriorityValue();
    private List<Observer> observers = new LinkedList<Observer>();
    private int updateLock = 0;
    private DockController controller;

    public UIProperties(DockController dockController) {
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    public void lockUpdate() {
        ++this.updateLock;
    }

    public void unlockUpdate() {
        --this.updateLock;
        if (this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetAll();
            }
        }
    }

    public UIScheme<V, U, B> getScheme(Priority priority) {
        return this.schemes.get(priority);
    }

    public void setScheme(final Priority priority, UIScheme<V, U, B> uIScheme) {
        UIScheme<V, U, B> uIScheme2 = this.schemes.get(priority);
        this.schemes.set(priority, uIScheme);
        if (uIScheme2 != uIScheme) {
            Priority priority2;
            int n;
            int n2;
            Priority[] priorityArray;
            int n3;
            if (uIScheme2 != null) {
                uIScheme2.removeListener(this.schemeListeners.get(priority));
                n3 = 0;
                priorityArray = Priority.values();
                n2 = priorityArray.length;
                n = 0;
                while (n < n2) {
                    priority2 = priorityArray[n];
                    if (this.schemes.get(priority2) == uIScheme2) {
                        ++n3;
                    }
                    ++n;
                }
                if (n3 == 0) {
                    uIScheme2.uninstall(this);
                }
            }
            if (uIScheme != null) {
                n3 = 0;
                priorityArray = Priority.values();
                n2 = priorityArray.length;
                n = 0;
                while (n < n2) {
                    priority2 = priorityArray[n];
                    if (this.schemes.get(priority2) == uIScheme) {
                        ++n3;
                    }
                    ++n;
                }
                if (n3 == 1) {
                    uIScheme.install(this);
                }
                if (this.schemeListeners.get(priority) == null) {
                    this.schemeListeners.set(priority, new UISchemeListener<V, U, B>(){

                        @Override
                        public void changed(UISchemeEvent<V, U, B> uISchemeEvent) {
                            UIProperties.this.schemeUpdate(priority, uISchemeEvent);
                        }
                    });
                }
                uIScheme.addListener(this.schemeListeners.get(priority));
            }
            this.fullSchemeUpdate(priority);
        }
    }

    private void fullSchemeUpdate(Priority priority) {
        this.schemeUpdate(priority, new UISchemeEvent<V, U, B>(){

            @Override
            public Collection<Path> changedBridges(Set<Path> set) {
                return null;
            }

            @Override
            public Collection<String> changedResources(Set<String> set) {
                return null;
            }

            @Override
            public UIScheme<V, U, B> getScheme() {
                return null;
            }
        });
    }

    private void schemeUpdate(Priority priority, UISchemeEvent<V, U, B> uISchemeEvent) {
        try {
            Object t;
            UIPriorityValue<Object> uIPriorityValue;
            Set<Path> set;
            Collection<Path> collection;
            this.lockUpdate();
            Set<String> set2 = this.getAllUsedResources();
            Collection<String> collection2 = uISchemeEvent.changedResources(set2);
            if (collection2 == null) {
                collection2 = set2;
            }
            if ((collection = uISchemeEvent.changedBridges(set = this.getAllUsedBridges())) == null) {
                collection = set;
            }
            UIScheme<V, U, B> uIScheme = this.schemes.get(priority);
            for (String object : collection2) {
                uIPriorityValue = this.resources.get(object);
                t = null;
                if (uIScheme != null) {
                    t = uIScheme.getResource(object, this);
                }
                if (uIPriorityValue == null) {
                    if (t == null) continue;
                    uIPriorityValue = new UIPriorityValue();
                    uIPriorityValue.set(priority, t, uIScheme);
                    if (this.isRemoveable(object, uIPriorityValue)) continue;
                    this.resources.put(object, uIPriorityValue);
                    continue;
                }
                if (uIPriorityValue.getScheme(priority) == null) {
                    if (uIPriorityValue.get(priority) == null) {
                        uIPriorityValue.set(priority, t, uIScheme);
                    }
                } else {
                    uIPriorityValue.set(priority, t, uIScheme);
                }
                if (!this.isRemoveable(object, uIPriorityValue)) continue;
                this.resources.remove(object);
            }
            for (Path path : collection) {
                uIPriorityValue = this.bridges.get(path);
                t = null;
                if (uIScheme != null) {
                    t = uIScheme.getBridge(path, this);
                }
                if (uIPriorityValue == null) {
                    if (t == null) continue;
                    uIPriorityValue = new UIPriorityValue();
                    uIPriorityValue.set(priority, t, uIScheme);
                    if (this.isRemoveable(path, uIPriorityValue)) continue;
                    this.bridges.put(path, uIPriorityValue);
                    continue;
                }
                if (uIPriorityValue.getScheme(priority) == null) {
                    if (uIPriorityValue.get(priority) == null) {
                        uIPriorityValue.set(priority, t, uIScheme);
                    }
                } else {
                    uIPriorityValue.set(priority, t, uIScheme);
                }
                if (!this.isRemoveable(path, uIPriorityValue)) continue;
                this.bridges.remove(path);
            }
        }
        finally {
            this.unlockUpdate();
        }
    }

    private Set<String> getAllUsedResources() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Observer observer : this.observers) {
            hashSet.add(observer.id);
        }
        return hashSet;
    }

    private Set<Path> getAllUsedBridges() {
        HashSet<Path> hashSet = new HashSet<Path>();
        for (Observer observer : this.observers) {
            hashSet.add(observer.path);
        }
        return hashSet;
    }

    public void publish(Priority priority, Path path, B b) {
        if (priority == null) {
            throw new IllegalArgumentException("priority must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("bridge must not be null");
        }
        UIPriorityValue<B> uIPriorityValue = this.bridges.get(path);
        if (uIPriorityValue == null) {
            uIPriorityValue = this.createBridge(path);
            this.bridges.put(path, uIPriorityValue);
        }
        if (uIPriorityValue.set(priority, b, null) && this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetBridge();
            }
        }
    }

    public void unpublish(Priority priority, Path path) {
        UIPriorityValue<B> uIPriorityValue = this.bridges.get(path);
        if (uIPriorityValue != null && uIPriorityValue.getScheme(priority) == null) {
            UIScheme<V, U, B> uIScheme = this.schemes.get(priority);
            Object t = null;
            if (uIScheme != null) {
                t = uIScheme.getBridge(path, this);
            }
            boolean bl = uIPriorityValue.set(priority, t, uIScheme);
            if (this.isRemoveable(path, uIPriorityValue)) {
                this.bridges.remove(path);
            }
            if (bl && this.updateLock == 0) {
                for (Observer observer : this.observers) {
                    observer.resetBridge();
                }
            }
        }
    }

    public void unpublish(Priority priority, B b) {
        Iterator<Map.Entry<Path, UIPriorityValue<B>>> iterator = this.bridges.entrySet().iterator();
        boolean bl = false;
        UIScheme<V, U, B> uIScheme = this.schemes.get(priority);
        while (iterator.hasNext()) {
            Map.Entry<Path, UIPriorityValue<B>> entry = iterator.next();
            UIPriorityValue<B> uIPriorityValue = entry.getValue();
            if (uIPriorityValue.get(priority) != b || uIPriorityValue.getScheme(priority) != null) continue;
            Object t = null;
            if (uIScheme != null) {
                t = uIScheme.getBridge(entry.getKey(), this);
            }
            boolean bl2 = bl = uIPriorityValue.set(priority, t, uIScheme) || bl;
            if (!this.isRemoveable(entry.getKey(), uIPriorityValue)) continue;
            iterator.remove();
        }
        if (bl && this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetBridge();
            }
        }
    }

    public B getBridge(Priority priority, Path path) {
        UIPriorityValue.Value value;
        UIPriorityValue<B> uIPriorityValue = this.bridges.get(path);
        if (uIPriorityValue == null && !this.isRemoveable(path, uIPriorityValue = this.createBridge(path))) {
            this.bridges.put(path, uIPriorityValue);
        }
        if (uIPriorityValue != null && (value = (UIPriorityValue.Value)uIPriorityValue.get(priority)) != null) {
            return (B)((UIBridge)value.getValue());
        }
        return null;
    }

    public boolean isStored(B b) {
        for (UIPriorityValue<B> uIPriorityValue : this.bridges.values()) {
            Priority[] priorityArray = Priority.values();
            int n = priorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Priority priority = priorityArray[n2];
                if (uIPriorityValue.getValue(priority) == b) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isObserved(Path path) {
        return this.bridgesAccess.containsKey(path);
    }

    private boolean isRemoveable(Path path, UIPriorityValue<B> uIPriorityValue) {
        if (uIPriorityValue.getValue() == null) {
            return true;
        }
        return uIPriorityValue.isAllScheme() && !this.isObserved(path);
    }

    private void checkRemove(Path path) {
        UIPriorityValue<B> uIPriorityValue = this.bridges.get(path);
        if (uIPriorityValue != null && this.isRemoveable(path, uIPriorityValue)) {
            this.bridges.remove(path);
        }
    }

    public void add(String string, Path path, U u) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (u == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        Observer observer = new Observer(this, string, path, u);
        this.observers.add(observer);
        observer.resetAll();
    }

    public void remove(U u) {
        ListIterator<Observer> listIterator = this.observers.listIterator();
        while (listIterator.hasNext()) {
            Observer observer = listIterator.next();
            if (observer.getValue() != u) continue;
            listIterator.remove();
            observer.destroy();
            return;
        }
    }

    public boolean isObserved(String string) {
        return this.resourcesAccess.containsKey(string);
    }

    private boolean isRemoveable(String string, UIPriorityValue<V> uIPriorityValue) {
        if (uIPriorityValue.getValue() == null) {
            return true;
        }
        return uIPriorityValue.isAllScheme() && !this.isObserved(string);
    }

    private void checkRemove(String string) {
        UIPriorityValue<V> uIPriorityValue = this.resources.get(string);
        if (uIPriorityValue != null && this.isRemoveable(string, uIPriorityValue)) {
            this.resources.remove(string);
        }
    }

    protected B getBridgeFor(Path path) {
        while (path != null) {
            UIBridge uIBridge;
            UIPriorityValue<B> uIPriorityValue = this.bridges.get(path);
            if (uIPriorityValue == null && !this.isRemoveable(path, uIPriorityValue = this.createBridge(path))) {
                this.bridges.put(path, uIPriorityValue);
            }
            if (uIPriorityValue != null && (uIBridge = (UIBridge)uIPriorityValue.getValue()) != null) {
                return (B)uIBridge;
            }
            path = path.getParent();
        }
        return null;
    }

    public void put(Priority priority, String string, V v) {
        UIPriorityValue<V> uIPriorityValue = this.resources.get(string);
        if (uIPriorityValue == null && v != null) {
            uIPriorityValue = this.createResource(string);
            this.resources.put(string, uIPriorityValue);
        }
        if (uIPriorityValue != null) {
            UIScheme<V, U, B> uIScheme = null;
            if (v == null && (uIScheme = this.schemes.get(priority)) != null) {
                v = uIScheme.getResource(string, this);
            }
            if (uIPriorityValue.set(priority, v, uIScheme) && this.updateLock == 0) {
                for (Observer observer : this.observers) {
                    if (!observer.id.equals(string)) continue;
                    observer.update(v);
                }
            }
            if (this.isRemoveable(string, uIPriorityValue)) {
                this.resources.remove(string);
            }
        }
    }

    public V get(String string) {
        UIPriorityValue<V> uIPriorityValue = this.resources.get(string);
        if (uIPriorityValue == null && !this.isRemoveable(string, uIPriorityValue = this.createResource(string))) {
            this.resources.put(string, uIPriorityValue);
        }
        return uIPriorityValue == null ? null : (V)uIPriorityValue.getValue();
    }

    public void get(String string, Path path, U u) {
        V v = this.get(string);
        B b = this.getBridgeFor(path);
        if (b != null) {
            b.set(string, v, u);
        } else {
            u.set(v);
        }
    }

    public void clear(Priority priority) {
        Object object;
        Map.Entry<String, UIPriorityValue<V>> entry;
        UIScheme<V, U, B> uIScheme = this.schemes.get(priority);
        Iterator<Map.Entry<String, UIPriorityValue<V>>> iterator = this.resources.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            UIPriorityValue object22 = (UIPriorityValue)entry.getValue();
            if (object22.getScheme(priority) != null) continue;
            object = null;
            if (uIScheme != null) {
                object = uIScheme.getResource((String)entry.getKey(), this);
            }
            object22.set(priority, object, uIScheme);
            if (!this.isRemoveable((String)entry.getKey(), object22)) continue;
            iterator.remove();
        }
        entry = this.bridges.entrySet().iterator();
        while (entry.hasNext()) {
            Map.Entry entry2 = (Map.Entry)entry.next();
            object = (UIPriorityValue)entry2.getValue();
            if (((UIPriorityValue)object).getScheme(priority) != null) continue;
            Object t = null;
            if (uIScheme != null) {
                t = uIScheme.getBridge((Path)entry2.getKey(), this);
            }
            ((UIPriorityValue)object).set(priority, t, uIScheme);
            if (!this.isRemoveable((Path)entry2.getKey(), (UIPriorityValue<B>)object)) continue;
            entry.remove();
        }
        if (this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetAll();
            }
        }
    }

    private UIPriorityValue<B> createBridge(Path path) {
        UIPriorityValue<B> uIPriorityValue = new UIPriorityValue<B>();
        Priority[] priorityArray = Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            B b;
            Priority priority = priorityArray[n2];
            UIScheme<V, U, B> uIScheme = this.schemes.get(priority);
            if (uIScheme != null && (b = uIScheme.getBridge(path, this)) != null) {
                uIPriorityValue.set(priority, b, uIScheme);
            }
            ++n2;
        }
        return uIPriorityValue;
    }

    private UIPriorityValue<V> createResource(String string) {
        UIPriorityValue<V> uIPriorityValue = new UIPriorityValue<V>();
        Priority[] priorityArray = Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            V v;
            Priority priority = priorityArray[n2];
            UIScheme<V, U, B> uIScheme = this.schemes.get(priority);
            if (uIScheme != null && (v = uIScheme.getResource(string, this)) != null) {
                uIPriorityValue.set(priority, v, uIScheme);
            }
            ++n2;
        }
        return uIPriorityValue;
    }

    private static class Observer {
        private String id;
        private Path path;
        private U value;
        private B bridge;
        final /* synthetic */ UIProperties this$0;

        public Observer(String string, Path path, U u) {
            this.this$0 = var1_1;
            this.id = string;
            this.path = path;
            this.value = u;
            Integer n = (Integer)((UIProperties)var1_1).bridgesAccess.get(path);
            n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
            ((UIProperties)var1_1).bridgesAccess.put(path, n);
            n = (Integer)((UIProperties)var1_1).resourcesAccess.get(string);
            n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
            ((UIProperties)var1_1).resourcesAccess.put(string, n);
        }

        public void destroy() {
            this.setBridge(null, false);
            Integer n = (Integer)this.this$0.bridgesAccess.get(this.path);
            if (n == 1) {
                this.this$0.bridgesAccess.remove(this.path);
                this.this$0.checkRemove(this.path);
            } else {
                this.this$0.bridgesAccess.put(this.path, n - 1);
            }
            n = (Integer)this.this$0.resourcesAccess.get(this.id);
            if (n == 1) {
                this.this$0.resourcesAccess.remove(this.id);
                this.this$0.checkRemove(this.id);
            } else {
                this.this$0.resourcesAccess.put(this.id, n - 1);
            }
        }

        public U getValue() {
            return this.value;
        }

        public void resetAll() {
            Object b = this.this$0.getBridgeFor(this.path);
            if (b == null) {
                this.update(this.this$0.get(this.id));
            } else {
                this.setBridge(b, true);
            }
        }

        public void resetBridge() {
            this.setBridge(this.this$0.getBridgeFor(this.path), false);
        }

        public void setBridge(B b, boolean bl) {
            if (this.bridge != b) {
                if (this.bridge != null) {
                    this.bridge.remove(this.id, this.value);
                }
                this.bridge = b;
                if (this.bridge != null) {
                    this.bridge.add(this.id, this.value);
                }
                this.update(this.this$0.get(this.id));
            } else if (bl) {
                this.update(this.this$0.get(this.id));
            }
        }

        public void update(V v) {
            if (this.bridge == null) {
                this.value.set(v);
            } else {
                this.bridge.set(this.id, v, this.value);
            }
        }
    }
}

